Imports System.Drawing

Partial Class UTable
    Public FocusGrid As New CGrid.CPoint

    Private _FocusField As CField = Nothing
    Private _FocusRecord As CRecord = Nothing

    Public Property FocusField() As CField
        Get
            Return Me._FocusField
        End Get
        Set(ByVal value As CField)
            Using Me.UpdateBufferBlock
                Me.setFocusField(value)
                If Me.FocusField IsNot Nothing Then
                    Me.FocusGrid.Row = Me.FocusField.Desc.Layout.Row
                    Me.FocusGrid.Col = Me.FocusField.Desc.Layout.Col
                End If
            End Using
        End Set
    End Property

    Public Sub MoveFocusField(ByVal field As CField)
        Using Me.UpdateBufferBlock
            Me.setFocusField(field)
            If Me.FocusField IsNot Nothing Then
                With Me.FocusField.Desc
                    If Me.FocusGrid.Row < .Layout.Row Then
                        Me.FocusGrid.Row = .Layout.Row
                    ElseIf Me.FocusGrid.Row >= .Layout.EndRow Then
                        Me.FocusGrid.Row = .Layout.EndRow
                    End If
                    If Me.FocusGrid.Col < .Layout.Col Then
                        Me.FocusGrid.Col = .Layout.Col
                    ElseIf Me.FocusGrid.Col >= .Layout.EndCol Then
                        Me.FocusGrid.Col = .Layout.EndCol
                    End If
                End With
            End If
        End Using
    End Sub

    Private Sub setFocusField(ByVal field As CField)
        If Me.Editor IsNot Nothing Then
            If Not Me.Editor.RaiseValidate Then
                Exit Sub
            End If
        End If
        Dim _focusField_bak As CField = Me.FocusField
        Dim cancel As Boolean = False
        RaiseEvent FieldEntering(field, cancel)
        If Not cancel Then
            Me.ime_AssociateContext(field)
            Me._FocusField = field
            If Me.FocusField IsNot Nothing Then
                Me._FocusRecord = field.Record
                Me.ScrollTo(Me.FocusField)
                field.RaiseEnter()
                RaiseEvent FieldEnter(field)
                If Not Me.Focused OrElse _focusField_bak Is Nothing OrElse _focusField_bak.Record IsNot field.Record Then
                    RaiseEvent RecordEnter(field.Record)
                End If
            Else
                Me._FocusRecord = Nothing
            End If
        End If
    End Sub

    Public Sub ScrollTo(ByVal field As CField)
        If Me.FocusField IsNot Nothing Then

            Dim top_row As Integer
            Dim size_row As Integer
            top_row = field.Record.LayoutCache.Top + field.Record.Rows.GetLocation(field.Desc.Layout.Row)
            size_row = field.Record.Rows.GetSize(field.Desc.Layout.Row, field.Desc.Layout.Rows)
            If top_row - Me.VScrollBar.Value < 0 Then
                Me.SetScrollValue(Me.VScrollBar, top_row)
            ElseIf top_row + size_row - Me.VScrollBar.Value > Me.ContentRowSize Then
                If Me.ContentRowSize >= size_row Then
                    Me.SetScrollValue(Me.VScrollBar, top_row + size_row - Me.ContentRowSize + 1)
                Else
                    Me.SetScrollValue(Me.VScrollBar, top_row)
                End If
            End If

            If field.Desc.Layout.Col >= Me.FixedCols Then
                Dim top_col As Integer
                Dim size_col As Integer
                top_col = Me.Cols.GetLocation(field.Desc.Layout.Col) - Me.LayoutCache.FixedColsSize
                size_col = Me.Cols.GetSize(field.Desc.Layout.Col, field.Desc.Layout.Cols)
                If top_col - Me.HScrollBar.Value < 0 Then
                    Me.SetScrollValue(Me.HScrollBar, top_col)
                ElseIf top_col + size_col - Me.HScrollBar.Value > Me.ContentColSize Then
                    If Me.ContentColSize >= size_col Then
                        Me.SetScrollValue(Me.HScrollBar, top_col + size_col - Me.ContentColSize + 1)
                    Else
                        Me.SetScrollValue(Me.HScrollBar, top_col)
                    End If
                End If
            End If

        End If
    End Sub

    Public ReadOnly Property FocusRecord() As CRecord
        Get
            Return Me._FocusRecord
        End Get
    End Property

    Private Function focus_MouseDown(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If e.Button = Windows.Forms.MouseButtons.Left And _
           e.Location.Y > Me.HeaderContent.LayoutCache.RowsSize And _
           e.Location.Y < Me.Height - Me.FooterContent.LayoutCache.RowsSize Then
            Dim field As UTable.CRenderCache.CField = Me.RenderCache.FindField(e.Location)
            If field IsNot Nothing AndAlso field.Field.Desc.Provider.Enabled Then
                Me.FocusField = field.Field
            End If
        End If
        Return False
    End Function

    Protected Overrides Function ProcessDialogKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        If Me.KeyboardOperation.ProcessDialogKey(keyData, Me) Then
            Return True
        Else
            Return MyBase.ProcessDialogKey(keyData)
        End If
    End Function

    Public Shared Function GetNextColField(ByVal point As UTable.CGrid.CPoint, ByVal record As UTable.CRecord) As UTable.CField
        Dim p As New UTable.CGrid.CPoint(point.Row, point.Col + 1)
        Do While p.Col < record.Table.Cols.Count
            Dim field As UTable.CField = UTable.FindFocusableField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            p.Col += 1
        Loop
        Return Nothing
    End Function

    Public Shared Function GetPrevColField(ByVal point As UTable.CGrid.CPoint, ByVal record As UTable.CRecord) As UTable.CField
        Dim p As New UTable.CGrid.CPoint(point.Row, point.Col - 1)
        Do While p.Col >= 0
            Dim field As UTable.CField = UTable.FindFocusableField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            p.Col -= 1
        Loop
        Return Nothing
    End Function

    Public Shared Function GetNextRowField(ByVal point As UTable.CGrid.CPoint, ByVal record As UTable.CRecord) As UTable.CField
        Dim p As New UTable.CGrid.CPoint(point.Row + 1, point.Col)
        Do While p.Row < record.Rows.Count
            Dim field As UTable.CField = UTable.FindFocusableField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            field = UTable.GetNextColField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            field = UTable.GetPrevColField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            p.Row += 1
        Loop
        If record.LayoutCache.NextRecord IsNot Nothing Then
            Dim r As UTable.CRecord = record.LayoutCache.NextRecord
            Return UTable.GetNextRowField(New UTable.CGrid.CPoint(-1, point.Col), r)
        Else
            Return Nothing
        End If
    End Function

    Public Shared Function GetPrevRowField(ByVal point As UTable.CGrid.CPoint, ByVal record As UTable.CRecord) As UTable.CField
        Dim p As New UTable.CGrid.CPoint(point.Row - 1, point.Col)
        Do While p.Row >= 0
            Dim field As UTable.CField = UTable.FindFocusableField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            field = UTable.GetNextColField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            field = UTable.GetPrevColField(p, record)
            If field IsNot Nothing Then
                Return field
            End If
            p.Row -= 1
        Loop
        If record.LayoutCache.PrevRecord IsNot Nothing Then
            Dim r As UTable.CRecord = record.LayoutCache.PrevRecord
            Return UTable.GetPrevRowField(New UTable.CGrid.CPoint(r.Rows.Count, point.Col), r)
        Else
            Return Nothing
        End If
    End Function

    Public Shared Function FindFocusableField(ByVal point As UTable.CGrid.CPoint, ByVal record As UTable.CRecord) As UTable.CField
        If (point.Row >= 0 And point.Row < record.Rows.Count And _
            point.Col >= 0 And point.Col < record.Table.Cols.Count) AndAlso _
           (record.LayoutCache.Visible And _
            record.Rows(point.Row).Visible And _
            record.Table.Cols(point.Col).Visible) Then
            Dim field As UTable.CField = record.FindField(point)
            If field IsNot Nothing AndAlso field.Desc.Provider.Enabled Then
                Return field
            End If
        End If
        Return Nothing
    End Function

    Public Shared Function FindEditableField(ByVal point As UTable.CGrid.CPoint, ByVal record As UTable.CRecord) As UTable.CField
        If (point.Row >= 0 And point.Row < record.Rows.Count And _
            point.Col >= 0 And point.Col < record.Table.Cols.Count) AndAlso _
           (record.LayoutCache.Visible And _
            record.Rows(point.Row).Visible And _
            record.Table.Cols(point.Col).Visible) Then
            Dim field As UTable.CField = record.FindField(point)
            If field IsNot Nothing AndAlso _
               (field.Desc.Layout.Row = point.Row And field.Desc.Layout.Col = point.Col) AndAlso _
               field.Desc.Provider.Enabled AndAlso _
               field.DynamicSetting.Editable = UTable.CSetting.EEditable.ALLOW AndAlso _
               field.DynamicSetting.FocusStop = CSetting.EFocusStop.STOP Then
                Return field
            End If
        End If
        Return Nothing
    End Function

    Public Sub EntryFocus()
        If Me.FocusField IsNot Nothing Then
            Exit Sub
        End If
        If Me.Content.Records.Count > 0 Then
            If Me.Setting.EntryFocusKey IsNot Nothing Then
                Me.FocusField = Me.Content.Records(0).Fields(Me.Setting.EntryFocusKey)
            Else
                For Each field As UTable.CField In Me.Content.Records(0).Fields.Values
                    If field.Desc.Layout IsNot Nothing AndAlso field.Desc.Provider.Enabled Then
                        Me.FocusField = field
                        Exit Sub
                    End If
                Next
            End If
        End If
    End Sub

End Class