Imports System.Drawing

Public Class CFieldBuilder

    Public Enum EOrientation
        COL
        ROW
    End Enum

    Public Orientation As EOrientation
    Public Row As Integer = 0
    Public Col As Integer = 0

    Public Sub New(Optional ByVal orientation As EOrientation = EOrientation.COL)
        Me.Orientation = orientation
    End Sub

    Public Function [Next](Optional ByVal [step] As Integer = 1, Optional ByVal dig As Integer = 1) As UTable.CGrid.CRegion
        Dim ret As UTable.CGrid.CRegion = Nothing
        Select Case Me.Orientation
            Case EOrientation.COL
                ret = New UTable.CGrid.CRegion(Row, Col, dig, [step])
            Case EOrientation.ROW
                ret = New UTable.CGrid.CRegion(Row, Col, [step], dig)
        End Select
        Me.Skip([step])
        Return ret
    End Function

    Public Function Skip(Optional ByVal [step] As Integer = 1) As CFieldBuilder
        Select Case Me.Orientation
            Case EOrientation.COL
                Me.Col += [step]
            Case EOrientation.ROW
                Me.Row += [step]
        End Select
        Return Me
    End Function

    Public Function Break() As CFieldBuilder
        Select Case Me.Orientation
            Case EOrientation.COL
                Me.Col = 0
                Me.Row += 1
            Case EOrientation.ROW
                Me.Row = 0
                Me.Col += 1
        End Select
        Return Me
    End Function

    Public Function Region(Optional ByVal row As Integer = 0, _
                           Optional ByVal col As Integer = 0, _
                           Optional ByVal rows As Integer = 1, _
                           Optional ByVal cols As Integer = 1)
        Return New UTable.CGrid.CRegion(row, col, rows, cols)
    End Function

    Public Function Field(Optional ByVal caption As String = Nothing) As IFieldProvider
        Return New CFieldProvider(caption)
    End Function

    Public Function [Const](Optional ByVal caption As String = Nothing, Optional ByVal value As String = Nothing) As IFieldProvider
        Return New CConstFieldProvider(caption, value)
    End Function

    Public Function Text(Optional ByVal caption As String = Nothing) As IFieldProvider
        Return New CTextFieldProvider(caption)
    End Function

    Public Function Check(Optional ByVal caption As String = Nothing) As IFieldProvider
        Return New CCheckFieldProvider(caption)
    End Function

    Public Function NarrowChild(Optional ByVal caption As String = Nothing) As IFieldProvider
        Return New CNarrowChildFieldProvider(caption)
    End Function

    Public Function Caption(Optional ByVal _caption As String = Nothing, Optional ByVal userSortable As UTable.CGlobalSetting.ESortable = UTable.CGlobalSetting.ESortable.DEFAULT, Optional ByVal draggable As Boolean = False) As IFieldProvider
        Return New CCaptionFieldProvider(_caption, userSortable, draggable)
    End Function

    Public Function Button(Optional ByVal caption As String = Nothing, Optional ByVal defaultValue As String = Nothing) As IFieldProvider
        Return New CButtonFieldProvider(caption, defaultValue)
    End Function

End Class
