Imports System.Drawing

Partial Class UTable

    Public Class CField
        Public Key As Object
        Public Desc As CRecordProvider.CFieldDesc
        Public Record As CRecord
        Public Event Validating(ByVal field As CField, ByVal e As System.ComponentModel.CancelEventArgs)
        Public Event Enter(ByVal field As CField)
        Public Event MouseDown(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event MouseMove(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event MouseUp(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event Click(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event DoubleClick(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event KeyDown(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
        Public Event KeyUp(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
        Public Event EditorValueChanged(ByVal field As CField)
        Public Event EditStarting(ByVal field As CField, ByRef editable As CSetting.EEditable)
        Public Event EditFinished(ByVal field As CField)
        Public Event ButtonClick(ByVal field As CField)

        Private _Value As Object
        Private _Setting As UTable.CSetting = Nothing

        Public Sub New(ByVal key As Object, _
                       ByVal parent As CRecord, _
                       ByVal fieldDesc As CRecordProvider.CFieldDesc)
            Me._init(key, parent, fieldDesc)
        End Sub

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Overridable Property Value() As Object
            Get
                If Me.Editor IsNot Nothing Then
                    Return Me.Editor.Value
                ElseIf Me.ValueBuffer IsNot Nothing Then
                    Return Me.ValueBuffer.Value
                Else
                    Return Me._Value
                End If
            End Get
            Set(ByVal value As Object)
                Using Me.Table.UpdateBufferBlock
                    If Me.Editor IsNot Nothing Then
                        Me.Editor.Value = value
                    ElseIf Me.ValueBuffer IsNot Nothing Then
                        Me.ValueBuffer.Value = value
                    Else
                        Me.ValueCommit(value)
                    End If
                    Me.adjust_on_setValue()
                End Using
            End Set
        End Property

        Public Overridable Sub ValueCommit(ByVal v As Object)
            Me._Value = v
        End Sub

        Public Function CommittedValue() As Object
            Return Me._Value
        End Function

        Private Sub _init(ByVal key As Object, _
                          ByVal record As CRecord, _
                          ByVal fieldDesc As CRecordProvider.CFieldDesc)
            Me.Key = key
            Me.Record = record
            Me.Desc = fieldDesc
        End Sub

        Public Function Col() As CGrid
            Return Me.Content.Table.Cols(Me.Desc.Layout.EndCol)
        End Function

        Public Function Row() As CGrid
            Return Me.Record.Rows(Me.Desc.Layout.EndRow)
        End Function

        Public Function Content() As UTable.CContent
            Return Record.Content
        End Function

        Public Function Table() As UTable
            Return Me.Record.Table
        End Function

        Public Function TopLevelContent() As CContent
            Return Me.Record.TopLevelContent
        End Function

        Public Function TopLevelRecord() As CRecord
            Return Me.Record.TopLevelRecord
        End Function

        Public Function Focused() As Boolean
            Return Me Is Me.Table.FocusField
        End Function

        Public Function Editor() As IEditor
            If Me.Focused Then
                Return Me.Table.Editor
            Else
                Return Nothing
            End If
        End Function

        Public Function DynamicSetting() As CDynamicSetting
            Return New CDynamicSetting(Me)
        End Function

        Public Sub RaiseValidating(ByVal e As System.ComponentModel.CancelEventArgs)
            RaiseEvent Validating(Me, e)
        End Sub

        Public Sub RaiseEditorValueChanged()
            RaiseEvent EditorValueChanged(Me)
        End Sub

        Public Sub RaiseEnter()
            RaiseEvent Enter(Me)
        End Sub

        Public Sub RaiseEditStarting(ByRef editable As UTable.CSetting.EEditable)
            RaiseEvent EditStarting(Me, editable)
        End Sub

        Public Sub RaiseEditFinished()
            RaiseEvent EditFinished(Me)
        End Sub

        Public Sub RaiseMouseDown(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent MouseDown(Me, location, e)
        End Sub

        Public Sub RaiseMouseUp(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent MouseUp(Me, location, e)
        End Sub

        Public Sub RaiseMouseMove(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent MouseMove(Me, location, e)
        End Sub

        Public Sub RaiseClick(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent Click(Me, location, e)
        End Sub

        Public Sub RaiseDoubleClick(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent DoubleClick(Me, location, e)
        End Sub

        Public Sub RaiseKeyDown(ByVal e As System.Windows.Forms.KeyEventArgs)
            RaiseEvent KeyDown(Me, e)
        End Sub

        Public Sub RaiseKeyUp(ByVal e As System.Windows.Forms.KeyEventArgs)
            RaiseEvent KeyUp(Me, e)
        End Sub

        Public Sub RaiseButtonClick()
            RaiseEvent ButtonClick(Me)
        End Sub

        Public Class CValueBuffer
            Implements IDisposable

            Public field As CField
            Public Value As Object
            Public Cancel As Boolean = False

            Public Sub New(ByVal field As CField, ByVal value As Object)
                Me.field = field
                Me.Value = value
            End Sub

            Private disposedValue As Boolean = False
            Protected Overridable Sub Dispose(ByVal disposing As Boolean)
                If Not Me.disposedValue Then
                    Me.field.ValueBuffer = Nothing
                    If Not Cancel Then
                        Me.field.ValueCommit(Me.Value)                        
                    End If
                End If
                Me.disposedValue = True
            End Sub

#Region " IDisposable Support "
            ' ̃R[h́Aj\ȃp^[𐳂ł悤 Visual Basic ɂĒǉ܂B
            Public Sub Dispose() Implements IDisposable.Dispose
                ' ̃R[hύXȂłBN[Abv R[h Dispose(ByVal disposing As Boolean) ɋLq܂B
                Dispose(True)
                GC.SuppressFinalize(Me)
            End Sub
#End Region

        End Class

        Public ValueBuffer As CValueBuffer = Nothing

        Public Function ValueBufferBlock(ByVal value As Object) As CValueBuffer
            Me.ValueBuffer = New CValueBuffer(Me, value)
            Return Me.ValueBuffer
        End Function

        Public Overridable Sub Clear()
            Me.Value = Nothing
        End Sub

    End Class

End Class