Imports System.Drawing

Partial Class UTable

    Public Class CContent

        Public Class CLayoutCache            
            Public RowsSize As Integer
            Public ColsSize As Integer
        End Class

        Public Name As String
        Public RecordProvider As CRecordProvider
        Public Records As New List(Of CRecord)
        Public ParentRecord As CRecord = Nothing
        Public Table As UTable
        Public NeedUpdateCache As Boolean = False
        Public LayoutCache As New CLayoutCache
        Public LastAddedRecord As CRecord = Nothing

        Private _Setting As UTable.CSetting = Nothing
        Private _Visible As Boolean = True

        Public Function TopLevelContent() As CContent
            Dim c As CContent = Me
            Do While c.ParentRecord IsNot Nothing
                c = c.ParentRecord.Content
            Loop
            Return c
        End Function

        Public Function TopLevelRecord() As CRecord
            If Me.ParentRecord IsNot Nothing Then
                Dim r As CRecord = Me.ParentRecord
                Do While r.Content.ParentRecord IsNot Nothing
                    r = r.Content.ParentRecord
                Loop
                Return r
            Else
                Return Nothing
            End If
        End Function

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Property Visible() As Boolean
            Get
                Return Me._Visible
            End Get
            Set(ByVal value As Boolean)
                Using Me.Table.UpdateBufferBlock
                    Me._Visible = value
                    Me.TopLevelContent.NeedUpdateCache = True
                End Using                
            End Set
        End Property

        Public Sub SetRecordProvider(ByVal recordProvider As CRecordProvider)
            Me.RecordProvider = recordProvider
            Dim r As CRecordProvider = Me.RecordProvider
            Do While r IsNot Nothing
                For Each f As CRecordProvider.CFieldDesc In r.FieldDescs.Values
                    f.Provider.ApplyTable(Me.Table)
                Next
                r = r.ChildRecordProvider
            Loop
            Me.Table.PrepareCols(Me.RecordProvider.ColsCount)
        End Sub

        Public Function CreateRecord() As CRecord
            Dim record As New CRecord
            record.Initialize(Me)
            Return record
        End Function

        Public Function AddRecord(ByVal record As CRecord) As CRecord
            Using Me.Table.UpdateBufferBlock                
                Me.Records.Add(record)
                Me._afterAddRecord(record)
                Return record
            End Using
            Return record
        End Function

        Public Function AddRecord() As CRecord
            Return Me.AddRecord(Me.CreateRecord)
        End Function

        Public Function InsertRecord(ByVal record As CRecord) As CRecord
            Dim i As Integer = Me.Records.IndexOf(record)
            If i >= 0 Then
                Return Me.InsertRecord(i)
            End If
            Return Nothing
        End Function

        Public Function InsertRecord(ByVal i As Integer) As CRecord
            Using Me.Table.UpdateBufferBlock
                Dim record As CRecord = Me.CreateRecord
                Me.Records.Insert(i, record)
                Me._afterAddRecord(record)
                Return record
            End Using
        End Function

        Private Sub _afterAddRecord(ByVal record As CRecord)            
            Me.TopLevelContent.NeedUpdateCache = True
            Me.Table.RaiseRecordAdded(record)
            Me.LastAddedRecord = record            
        End Sub

        Public Sub RemoveRecord(ByVal record As CRecord)
            Using Me.Table.UpdateBufferBlock
                Me._beforeRemoveRecord(record)
                Me.Records.Remove(record)
                Me._afterRemoveRecord(record)
            End Using
        End Sub

        Public Sub RemoveRecord(ByVal i As Integer)
            Using Me.Table.UpdateBufferBlock
                Dim r As CRecord = Me.Records(i)
                Me._beforeRemoveRecord(r)
                Me.Records.RemoveAt(i)
                Me._afterRemoveRecord(r)
            End Using
        End Sub

        Private Sub _beforeRemoveRecord(ByVal record As CRecord)
            If Me.Table.Editor IsNot Nothing Then
                Me.Table.FinishEditing()
            End If
            If Me.Table.FocusRecord Is record Then
                Dim f As CField = Nothing
                f = UTable.GetNextRowField(Me.Table.FocusGrid, Me.Table.FocusRecord)
                If f Is Nothing Then
                    f = UTable.GetPrevRowField(Me.Table.FocusGrid, Me.Table.FocusRecord)
                End If
                If f IsNot Nothing Then
                    Me.Table.MoveFocusField(f)
                Else
                    Me.Table.FocusField = Nothing
                End If
            End If
        End Sub

        Private Sub _afterRemoveRecord(ByVal record As CRecord)
            Me.TopLevelContent.NeedUpdateCache = True
            Me.Table.RaiseRecordRemoved(record)
        End Sub

        Public Sub Render(ByVal g As Graphics, _
                          ByVal top_row As Integer, _
                          ByVal top_col As Integer, _
                          ByVal max_row As Integer, _
                          ByVal fixed As Boolean)
            If Me.Visible Then
                Dim record As Integer = 0
                Do While top_row < max_row And record < Me.Records.Count
                    Dim t As Integer = top_row + Me.Records(record).LayoutCache.EntireRowsSize
                    If t > 0 Then
                        Me.Records(record).Render(g, top_row, top_col, max_row, (record Mod 2 = 1), fixed)
                    End If
                    top_row = t
                    record += 1
                Loop
            End If
        End Sub

        Public Function UpdateCache(Optional ByRef top As Integer = 0, Optional ByVal init_prevRecord As CRecord = Nothing, Optional ByVal visible As Boolean = True) As CRecord
            Me.LayoutCache.RowsSize = 0
            Dim prevRecord As CRecord = init_prevRecord
            Dim v As Boolean = visible
            If Not Me.Visible Then
                v = False
            End If
            For Each record As CRecord In Me.Records
                prevRecord = record.UpdateCache(top, prevRecord, v)
                Me.LayoutCache.RowsSize += record.LayoutCache.EntireRowsSize
            Next
            Return prevRecord
        End Function

        Public Sub SetFixedCols(ByVal key As Object)
            With Me.RecordProvider.FieldDescs(key).Layout
                Me.Table.FixedCols = .Col + .Cols
            End With
        End Sub

        Public Function Col(ByVal key As Object) As CGrid
            Return Me.Table.Cols(Me.RecordProvider.FieldDescs(key).Layout.EndCol)
        End Function

        Public Function ParentContent() As CContent
            If Me.ParentRecord IsNot Nothing Then
                Return Me.ParentRecord.Content
            Else
                Return Nothing
            End If
        End Function

        Public Sub ClearRecord()
            Using Me.Table.UpdateBufferBlock
                If Me.Table.Editor IsNot Nothing Then
                    Me.Table.FinishEditing()
                End If
                If Me.Table.FocusField IsNot Nothing AndAlso Me.IsChild(Me.Table.FocusField) Then
                    Me.Table.FocusField = Nothing
                End If
                Me.LastAddedRecord = Nothing
                Me.Records.Clear()
                If Me.Table.Content Is Me Then
                    Me.Table.SortState.Field = Nothing
                End If
                Me.TopLevelContent.NeedUpdateCache = True
            End Using
        End Sub

        Public Sub MoveRecord(ByVal i1 As Integer, ByVal i2 As Integer)
            Me.MoveRecord(Me.Records(i1), i2)
        End Sub

        Public Sub MoveRecord(ByVal r As CRecord, ByVal i As Integer)
            Using Me.Table.UpdateBufferBlock
                If i < Me.Records.Count Then
                    Me.Records.Remove(r)
                    Me.Records.Insert(i, r)
                Else
                    Me.Records.Remove(r)
                    Me.Records.Add(r)
                End If                
                Me.TopLevelContent.NeedUpdateCache = True
                Me.Table.RaiseRecordMoved(r)
            End Using
        End Sub

        Public Function IsChild(ByVal field As CField) As Boolean
            Return Me.IsChild(field.Record)
        End Function

        Public Function IsChild(ByVal record As CRecord) As Boolean
            If record.Content Is Me Then
                Return True
            Else
                Return Me.IsChild(record.Content)
            End If
        End Function

        Public Function IsChild(ByVal content As CContent) As Boolean
            Dim parent As CContent = content.ParentContent
            Do While parent IsNot Nothing
                If parent Is Me Then
                    Return True
                End If
                parent = parent.ParentContent
            Loop
            Return False
        End Function

        Public Function FieldList(ByVal key As Object) As List(Of CField)
            Dim ret As New List(Of CField)
            For Each record As CRecord In Me.Records
                If record.Fields.ContainsKey(key) Then
                    ret.Add(record.Fields(key))
                End If
            Next
            Return ret
        End Function

        Public Function FieldMultiList(ByVal ParamArray keys() As Object) As List(Of List(Of CField))
            Dim ret As New List(Of List(Of CField))
            For Each record As CRecord In Me.Records
                Dim l As New List(Of CField)
                For Each key As Object In keys
                    If record.Fields.ContainsKey(key) Then
                        l.Add(record.Fields(key))
                    End If
                Next
                ret.Add(l)
            Next
            Return ret
        End Function

        Public Sub Sort(ByVal key As Object, Optional ByVal Order As CSortState.EOrder = CSortState.EOrder.ASCEND, Optional ByVal comparer As CComparer = Nothing)
            Dim _l As New List(Of Integer)(Me.Records.Count)
            For i As Integer = 0 To Me.Records.Count - 1
                _l.Add(i)
            Next
            If comparer Is Nothing Then
                comparer = New CComparer
            End If
            comparer.Init(Me.Records, key, Order)
            _l.Sort(comparer)
            Using Me.Table.UpdateBufferBlock
                Dim records_bak As List(Of CRecord) = Me.Records
                Me.Records = New List(Of CRecord)
                For i As Integer = 0 To _l.Count - 1
                    Me.Records.Add(records_bak(_l(i)))
                Next
                Me.NeedUpdateCache = True
                Me.Table.RaiseSorted(Me, key)
            End Using
        End Sub

        Public Class CComparer
            Implements IComparer(Of Integer)
            Public records As List(Of CRecord)
            Public key As Object
            Public order As CSortState.EOrder
            Public Sub Init(ByVal records As System.Collections.Generic.List(Of CRecord), ByVal key As Object, ByVal order As CSortState.EOrder)
                Me.records = records
                Me.key = key
                Me.order = order
            End Sub
            Public Overridable Function Compare(ByVal x As Integer, ByVal y As Integer) As Integer Implements System.Collections.Generic.IComparer(Of Integer).Compare
                If records(x).Fields(key).Value = records(y).Fields(key).Value Then
                    Return x < y
                ElseIf TypeOf records(x).Fields(key).Value Is String Then
                    Select Case order
                        Case CSortState.EOrder.ASCEND
                            Return CType(records(x).Fields(key).Value, String).CompareTo(records(y).Fields(key).Value)
                        Case CSortState.EOrder.DESCEND
                            Return -CType(records(x).Fields(key).Value, String).CompareTo(records(y).Fields(key).Value)
                    End Select
                Else
                    Select Case order
                        Case CSortState.EOrder.ASCEND
                            Return records(x).Fields(key).Value < records(y).Fields(key).Value
                        Case CSortState.EOrder.DESCEND
                            Return records(x).Fields(key).Value > records(y).Fields(key).Value
                    End Select
                End If
            End Function
        End Class

    End Class

End Class
