Imports systembase.table

Public Class KeyboardOperation1

    Private Sub KeyboardOperation1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        Dim rp As New UTable.CRecordProvider
        With New CFieldBuilder
            rp.AddField(0, .Text("1"), .Next())
            rp.AddField(1, .Text("2"), .Next())
            rp.AddField(2, .Text("3"), .Next())
            rp.AddField(3, .Text("4"), .Next())
            rp.AddField(4, .Text("5"), .Next())
        End With

        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()

        Dim order As New List(Of Object)
        order.Add(0)
        order.Add(2)
        order.Add(4)
        Me.Table.KeyboardOperation = New COrderKeyboardOperation(order)

        Using Me.Table.UpdateBufferBlock
            For i As Integer = 1 To 10
                Me.Table.Content.AddRecord()
            Next
        End Using        

    End Sub

    Class COrderKeyboardOperation
        Inherits CDefaultKeyboardOperation

        Public Order As List(Of Object)

        Public Sub New(ByVal order As List(Of Object))
            Me.Order = order
        End Sub

        Protected Overrides Sub [next](ByVal table As systembase.table.UTable)
            If table.FocusField IsNot Nothing Then
                Dim i As Integer = Me.Order.IndexOf(table.FocusField.Key)
                If i >= 0 Then
                    If i = Me.Order.Count - 1 Then
                        Dim r_i As Integer = table.FocusField.Content.Records.IndexOf(table.FocusField.Record)
                        If r_i < table.FocusField.Content.Records.Count - 1 Then
                            table.FocusField = table.FocusField.Content.Records(r_i + 1).Fields(Me.Order(0))
                            Exit Sub
                        End If
                    Else
                        table.FocusField = table.FocusField.Record.Fields(Me.Order(i + 1))
                        Exit Sub
                    End If
                End If
            End If
            MyBase.[next](table)
        End Sub
    End Class

End Class