#include<windowsx.h>
#include"common.h"
#include"resource.h"

extern Data main_data;

namespace Automatic
{
	extern int ClockInLabel;
	extern int BreakOutLabel;
	extern unsigned int half_cycle;
}


BOOL CALLBACK AutoDlgProc(HWND hDlg,UINT msg,WPARAM wp,LPARAM lp)
{
	static HWND hListIn;
	static HWND hListOut;
	static HWND hCycle;
	BOOL bSuccess;

	switch(msg)
	{
	case WM_INITDIALOG:
		hListIn=GetDlgItem(hDlg,IDC_CLOCK_LIST);
		hListOut=GetDlgItem(hDlg,IDC_BREAK_LIST);
		hCycle=GetDlgItem(hDlg,IDC_CYCLE);

		for(unsigned int i=0;i<main_data.nInput();i++)
			ListBox_AddString(hListIn,main_data.GetInput(i).name());
		for(unsigned int i=0;i<main_data.nOutput();i++)
			ListBox_AddString(hListOut,main_data.GetOutput(i).name());
		Edit_SetText(hCycle,"100");
		return true;
	case WM_COMMAND:
		switch(LOWORD(wp))
		{
			int tmp;
		case IDOK:
			tmp=SendMessage(hListIn,LB_GETCURSEL,0,0);
			if(tmp==LB_ERR)
				Automatic::ClockInLabel=-1;
			else
				Automatic::ClockInLabel=tmp;

			tmp=SendMessage(hListOut,LB_GETCURSEL,0,0);
			if(tmp==LB_ERR)
				Automatic::BreakOutLabel=-1;
			else
				Automatic::BreakOutLabel=tmp;

			tmp=GetDlgItemInt(hDlg,IDC_CYCLE,&bSuccess,false);
			if(bSuccess && tmp>=USER_TIMER_MINIMUM)
				Automatic::half_cycle=tmp;
			else
				Automatic::half_cycle=USER_TIMER_MINIMUM;

			EndDialog(hDlg,IDOK);
			return true;
		case IDCANCEL:
			EndDialog(hDlg,IDCANCEL);
			return true;
		}
		return false;
	}
	return false;
}