#include<vector>
#include<windows.h>

using namespace std;

//
enum State{scroll,placegate,placemodule,expandmodule,placewire,placein,placeout,erase};

//8ʂƕ
enum Direction{UP,UP_RIGHT,RIGHT,DOWN_RIGHT,DOWN,DOWN_LEFT,LEFT,UP_LEFT,NO_DIRECTION};

//̔΂̕^
inline Direction ReverseDirection(Direction d)
{
	return Direction((d+4)%8);
}


//GDIPOINT\̂̓sNZP
//vector2DGridInterval|POINT\̂ɂȂ
class vector2D
{
	int x;
	int y;
public:
	vector2D(){x=0,y=0;}
	vector2D(int a,int b){x=a,y=b;}

	//GridInterval|POINTɕϊ
	POINT MulGridInterval();
	POINT toPOINT();
	bool operator==(vector2D a);
	bool operator!=(vector2D a);
	void operator+=(vector2D a);
	vector2D operator+(vector2D a);
	vector2D operator-(vector2D a);
	friend vector2D operator*(const vector2D v,int n);
	friend Direction AlignedDirection(vector2D center,vector2D end);
	friend vector2D AlignAngle(vector2D center,vector2D end);

	friend int CompareX(vector2D v1,vector2D v2){return v1.x-v2.x;}
	friend int CompareY(vector2D v1,vector2D v2){return v1.y-v2.y;}

	friend istream &operator>>(istream &stream,vector2D &v);
	friend ostream &operator<<(ostream &stream,vector2D v);
};

//8ʂ֌xNgƗxNg
const vector2D DirectionVector[9]=
{vector2D(0,-1),vector2D(1,-1),vector2D(1,0),vector2D(1,1)
,vector2D(0,1),vector2D(-1,1),vector2D(-1,0),vector2D(-1,-1)
,vector2D(0,0)};

//_Z
enum Operation{NOT,OR,AND,NOR,NAND};

//xi[z̃TCY
const int SIZE_OF_LABEL_NAME=32;

class Label
{
	Direction d;	//
	int node_index;		//[qWێm[h̃CfbNX
	char nam[SIZE_OF_LABEL_NAME];			//O;
protected:
	Label(Direction dir,int n,char *nm);
public:
	Direction ReverseDirection(){return Direction((d+4)%8);}
	Direction direction(){return d;}
	char *name(){return nam;}
	int nodeindex(){return node_index;}
	void dec_node_index(){node_index--;}

	friend istream &operator>>(istream &stream,Label &l);
	friend ostream &operator<<(ostream &stream,Label l);
};

class LabelIn :public Label
{
	bool state;		//Ԃ̐^Ul
public:
	LabelIn(Direction dir,int n,char *nm):Label(dir,n,nm){state=false;}
	bool GetState(){return state;}
	void SetState(bool b){state=b;}

	friend istream &operator>>(istream &stream,LabelIn &l);
	friend ostream &operator<<(ostream &stream,LabelIn l);
};

//foCX̕
enum DeviceClassification{no_device,label_input,label_output,lead_wire,gate_out,gate_in,module_out,module_in};

class DeviceIndex
{
	DeviceClassification ConnectedDevClass;	//foCX̕
	int Index;		//foCX̔z̓Y
	int SubIndex;
public:
	DeviceIndex(){ConnectedDevClass=no_device,Index=-1,SubIndex=-1;}

	DeviceClassification GetDeviceClass(){return ConnectedDevClass;}
	int GetDeviceIndex(){return Index;}
	int GetDeviceSubIndex(){return SubIndex;}

	void SetDeviceClass(DeviceClassification devcls){ConnectedDevClass=devcls;}
	void SetIndexAndSubIndex(int idx,int sidx){Index=idx,SubIndex=sidx;}

	void DecIndex(){Index--;}

	friend istream &operator>>(istream &stream,DeviceIndex &sd);
	friend ostream &operator<<(ostream &stream,DeviceIndex sd);
};

class LabelOut :public Label
{
	DeviceIndex sd;
public:
	LabelOut(Direction dir,int n,char *nm):Label(dir,n,nm){;}
	DeviceClassification GetSourceDevClass(){return sd.GetDeviceClass();}
	DeviceIndex GetSourceDev(){return sd;}
	int GetSourceDevIndex(){return sd.GetDeviceIndex();}
	int GetSourceDevSubIndex(){return sd.GetDeviceSubIndex();}
	void SetSourceDev(DeviceIndex di){sd=di;}
	void SetSourceDevClass(DeviceClassification d){sd.SetDeviceClass(d);}
	void SetSourceDevIndex(int idx,int sidx){sd.SetIndexAndSubIndex(idx,sidx);}

	friend istream &operator>>(istream &stream,LabelOut &l);
	friend ostream &operator<<(ostream &stream,LabelOut l);
};

class Node	//
{
	bool path;	//̐߂͒ʉߍς
	bool Multipath;		//}`pX
	bool Short;		//Z
	bool AllRight;	//
	vector2D pos;	//ʒu
	DeviceIndex branch[8];	//8ʂ̃foCX
public:
	Node();
	vector2D position(){return pos;}
	void setposition(vector2D v){pos=v;}
	void write_branch(Direction d,DeviceClassification dclass,int idx,int sidx);//dɎ}ǉ
	void initbranch(Direction d){write_branch(d,no_device,-1,-1);}
	bool isBranchExist(Direction d){return branch[d].GetDeviceClass()!=no_device;}	//dɎ}true
	DeviceClassification dClass(Direction d){return branch[d].GetDeviceClass();}
	int index(Direction d){return branch[d].GetDeviceIndex();}
	int subindex(Direction d){return branch[d].GetDeviceSubIndex();}
	void SetIndexAndSubIndex(Direction d,int idx,int sidx){branch[d].SetIndexAndSubIndex(idx,sidx);}
	int nBranch();
	void dec_index(int i){branch[i].DecIndex();}

	bool GetPathFlag(){return path;}
	void SetPathFlag(){path=true;}
	void ResetPathFlag(){path=false;}

	void SetMultipath(bool b){Multipath=b;}
	bool isMultipath(){return Multipath;}

	void SetShort(bool b){Short=b;}
	bool isShort(){return Short;}

	void SetAllRight(bool b){AllRight=b;}
	bool isAllRight(){return AllRight;}

	friend istream &operator>>(istream &stream,Node &n);
	friend ostream &operator<<(ostream &stream,Node n);
};

class SourceData
{
	int node_in;	//͂m[h̃CfbNX
	DeviceIndex sd;
public:
	SourceData(){node_in=-1;}

	DeviceIndex& SourceDevice(){return sd;}

	int NodeInIndex(){return node_in;}
	void SetNodeInIndex(int i){node_in=i;}
	void DecNodeInIndex(){node_in--;}

	friend istream &operator>>(istream &stream,SourceData &in);
	friend ostream &operator<<(ostream &stream,SourceData in);
};

class Gate
{
	bool state;		//Ԃ̐^Ul
	Operation op;//Z̎
	Direction d;//o͂
	int node_out;			//o͒[qWێm[h̃CfbNX
	vector<SourceData> array_in;	//͒[qWێm[h̃CfbNX̔z
public:
	Gate(Operation ope,Direction dir,vector2D center,int out,vector<SourceData> &in);
	Operation operation(){return op;}
	Direction ReverseDirection(){return Direction((d+4)%8);}
	Direction direction(){return d;}
	int nIn(){return array_in.size();}
	int NodeOutIndex(){return node_out;}
	void dec_out_index(){node_out--;}
	int NodeInIndex(int i){return array_in[i].NodeInIndex();}
	void dec_in_index(int i){array_in[i].DecNodeInIndex();}

	bool GetState(){return state;}
	void SetState(bool b){state=b;}

	void SetSourceDev(int subindex,DeviceIndex di){array_in[subindex].SourceDevice()=di;}
	void SetSourceDevClass(int subindex,DeviceClassification d){array_in[subindex].SourceDevice().SetDeviceClass(d);}
	void SetSourceDevIndex(int subindex,int idx,int sidx){array_in[subindex].SourceDevice().SetIndexAndSubIndex(idx,sidx);}

	DeviceClassification GetSourceDevClass(int subindex){return array_in[subindex].SourceDevice().GetDeviceClass();}
	DeviceIndex GetSourceDev(int subindex){return array_in[subindex].SourceDevice();}
	int GetSourceDevIndex(int subindex){return array_in[subindex].SourceDevice().GetDeviceIndex();}
	int GetSourceDevSubIndex(int subindex){return array_in[subindex].SourceDevice().GetDeviceSubIndex();}

	friend istream &operator>>(istream &stream,Gate &g);
	friend ostream &operator<<(ostream &stream,Gate g);
};

class Conductor
{
	bool Multipath;
	bool Short;
	Direction d;
	int nod[2];	//n_ƏI_̍Wێm[h̃CfbNX
public:
	Conductor(int n0,int n1,Direction di);
	int nodeindex0(){return nod[0];}
	int nodeindex1(){return nod[1];}
	Direction ReverseDirection(){return Direction((d+4)%8);}
	Direction direction(){return d;}	//01ւ̕
	void dec_node0(){nod[0]--;}
	void dec_node1(){nod[1]--;}

	void SetMultipath(bool b){Multipath=b;}
	bool isMultipath(){return Multipath;}

	void SetShort(bool b){Short=b;}
	bool isShort(){return Short;}

	friend istream &operator>>(istream &stream,Conductor &c);
	friend ostream &operator<<(ostream &stream,Conductor c);
};

class Module;

class Data
{
	vector<Node> node_data;			//
protected:
	vector<LabelIn> input;		//
	vector<LabelOut> output;		//o
	vector<Gate> gate;				//Q[g
	vector<Module> module; //W[
private:
	vector<Conductor> conductor;	//

	template <class X> void Delete(vector<X> &ar,unsigned int n);

	void InitModuleParentPointer();
protected:
	vector2D GetNodeCoordinate(int nodeindex){return node(nodeindex).position();}
private:

	RECT SpanRect();		//SĂ̕`vf܂͈

	void MoveOver(DeviceClassification dev,int n);

	bool EraseBranch(int index,Direction d);	//}܂}cĂfalse

	void EraseInputLabel(unsigned int n);
	void EraseOutputLabel(unsigned int n);
	void EraseGate(unsigned int n);
	void EraseConductor(unsigned int n);
	void EraseModule(unsigned int n);

	void DrawGate(HDC hdc);
	void DrawModule(HDC hdc);
	void DrawNode(HDC hdc);
	void DrawConductor(HDC hdc);
	void DrawInputLabel(HDC hdc);
	void DrawOutputLabel(HDC hdc);

	void DrawGate(ofstream &f);
	void DrawModule(ofstream &f);
	void DrawNode(ofstream &f);
	void DrawConductor(ofstream &f);
	void DrawInputLabel(ofstream &f);
	void DrawOutputLabel(ofstream &f);

	void SetMultipathFlag(int i,int n,Direction d,bool flag);
	void SetMultipathFlagNode(int n,Direction d,bool flag);
	void SetMultipathFlagWire(int c,Direction d,bool flag);	//cɌqĂSĂ̓MultipathtOɏ
	bool SearchMultipathNode(int n,Direction d);
	bool SearchMultipathWire(int c,Direction d);

	void SetShortFlagNode(int n,Direction d,bool flag);
	void SetShortFlagWire(int c,Direction d,bool flag);
	int SearchNumberOfOutputNode(int n,Direction d);
	int SearchNumberOfOutputWire(int c,Direction d);

	DeviceIndex GetSource(int i,int n,Direction d);
	DeviceIndex GetSourceNode(int n,Direction d);
	DeviceIndex GetSourceWire(int c,Direction d);

	void SetSource(int n,DeviceIndex sd,int i);
	void SetSourceNode(int n,Direction d,DeviceIndex sd);
	void SetSourceWire(int c,Direction d,DeviceIndex sd);
	void Operate(int n,DeviceIndex sd);	//UȂtrue

	void DetectErrorAndConnect(unsigned int n);	//G[`FbNƃRlNV
public:
	void DrawInputState(HDC hdc);
	void DrawOutputState(HDC hdc);

	void SetSourceModule(int n,bool newstate);

	bool AbleToPlaceLabel();	//xݒu\
	void PlaceInLabel();	//̓xݒu
	void PlaceOutLabel();	//o̓xݒu
	bool AbleToPlaceGate();	//Q[gݒu\
	void PlaceGate();		//Q[gݒu
	bool AbleToPlaceConductor();	//ݒu\
	void PlaceConductor();	//ݒu
	bool AbleToPlaceModule();	//W[ݒu\
	void PlaceModule();//W[ݒu
	bool ExpandModule(HWND hwnd);	//W[̓WJ

	bool EraseDevice();	//xAQ[gAAW[폜

	void Draw(HDC hdc); //`
	void Draw(ofstream &f);

	Node node(int i){return node_data[i];} //iԖڂ̐߂Ԃ

	unsigned int nInput(){return input.size();}
	unsigned int nOutput(){return output.size();}
	LabelIn GetInput(int i){return input[i];}
	LabelOut GetOutput(int i){return output[i];}

	void NegateInIndex(int i);		//͂̏Ԃ𔽓]
	void NegateInCoordinate();

	bool GetOutState(int i);		//o͂̏Ԃ擾

	void JumpToSource();//̓d肵ĂfoCX֔

	void Clear();

//Ԃ\
	void status(char *s);

	friend istream &operator>>(istream &stream,Data &d);
	friend ostream &operator<<(ostream &stream,Data d);

};



class Module:public Data
{
	vector2D center;	//ƂȂʒu
	Data* parent;		//KwData

//e풷
	int internal_half_width;
	int internal_half_height;
	int up_margin;
	int right_margin;
	int down_margin;
	int left_margin;

//e̒[q̔z
	vector<DeviceIndex> up;
	vector<DeviceIndex> right;
	vector<DeviceIndex> down;
	vector<DeviceIndex> left;

	vector<SourceData> array_in;	//̓m[h̃CfbNX̔z
	vector<int> node_out;	//o̓m[h̃CfbNX̔z


public:
	void SetParent(Data* p){parent=p;}
	Data* GetParent(){return parent;}

	bool GetState(int i);
	
	void SetSourceDev(int subindex,DeviceIndex di){array_in[subindex].SourceDevice()=di;}
	DeviceIndex InArray(int i){return array_in[i].SourceDevice();}
	
	int NodeIn(int i){return array_in[i].NodeInIndex();}
	void dec_NodeIn(int i){array_in[i].DecNodeInIndex();}
	int NodeOut(int i){return node_out[i];}
	void dec_NodeOut(int i){node_out[i]--;}

	void SetCenter(vector2D v){center=v;}
	vector2D Center(){return center;}

	void LetNodeIn(vector<SourceData> &in){array_in=in;}
	void LetNodeOut(vector<int> &out){node_out=out;}

	Direction GetInputDirection(int i){return input[i].direction();}
	Direction GetOutputDirection(int i){return output[i].direction();}

	void AddLeft(DeviceIndex di);
	void AddUp(DeviceIndex di);
	void AddRight(DeviceIndex di);
	void AddDown(DeviceIndex di);

	int GetUpSize(){return up.size();}
	int GetRightSize(){return right.size();}
	int GetDownSize(){return down.size();}
	int GetLeftSize(){return left.size();}

	DeviceIndex GetLeft(int i){return left[i];}
	DeviceIndex GetUp(int i){return up[i];}
	DeviceIndex GetRight(int i){return right[i];}
	DeviceIndex GetDown(int i){return down[i];}

	void Set_internal_half_length(int width,int height){internal_half_width=width,internal_half_height=height;}
	void Set_margin(int up,int right,int down,int left){up_margin=up,right_margin=right,down_margin=down,left_margin=left;}

	int InternalHalfWidth(){return internal_half_width;}
	int InternalHalfHeight(){return internal_half_height;}
	int UpMargin(){return up_margin;}
	int RightMargin(){return right_margin;}
	int DownMargin(){return down_margin;}
	int LeftMargin(){return left_margin;}

	void Clear();

	friend istream &operator>>(istream &stream,Module &d);
	friend ostream &operator<<(ostream &stream,Module d);
};