/*
 * Polygon_RayTrace
 * Copylight (C) 2013 mocchi
 * mocchi_2003@yahoo.co.jp
 * License: Boost ver.1
 */

#ifndef RJ_WRAPPER_H_
#define RJ_WRAPPER_H_

#include "rapidjson/rapidjson.h"
#include "rapidjson/document.h"

namespace rj = rapidjson;

const char * rj_getstring (rj::Value &val, const char *default_ = "");
int          rj_getint    (rj::Value &val, int default_ = 0);
unsigned int rj_getuint   (rj::Value &val, unsigned int default_ = 0U);
int64_t      rj_getint64  (rj::Value &val, int64_t default_ = 0);
uint64_t     rj_getuint64 (rj::Value &val, uint64_t default_ = 0);
double       rj_getdouble (rj::Value &val, double default_ = 0);
rj::Value &  rj_getmember (rj::Value &obj, const char *memname);

struct rj_creator{
	rj::Value *val;
	rj::Value::AllocatorType &alc;
	rj_creator(rj::Document &doc);
	rj_creator(rj::Value &val, rj::Value::AllocatorType &alc);
	void ChangeTarget(rj::Value &val); ///< Allocator ͕ςȂ
	rj_creator &AddMember(const char *key, int val);
	rj_creator &AddMember(const char *key, int64_t val);
	rj_creator &AddMember(const char *key, unsigned int val);
	rj_creator &AddMember(const char *key, uint64_t val);
	rj_creator &AddMember(const char *key, double val);
	rj_creator &AddMember(const char *key, const char *u8val);
	rj_creator &AddMember(const char *key, rj::Value &val);
	rj_creator &PushBack(int val);
	rj_creator &PushBack(int64_t val);
	rj_creator &PushBack(unsigned int val);
	rj_creator &PushBack(uint64_t val);
	rj_creator &PushBack(double val);
	rj_creator &PushBack(const char *u8val);
	rj_creator &PushBack(rj::Value &val);
};

#endif // RJ_WRAPPER_H_
