/*
 * Decompiled with CFR 0.152.
 */
package mirrg.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import mirrg.util.NonnullIterator;

public interface NonnullIterable<T>
extends Iterable<T> {
    public NonnullIterator<T> nonnullIterator();

    public static <T> NonnullIterable<T> empty() {
        return () -> () -> null;
    }

    public static <T> NonnullIterable<T> ofIterable(final Iterable<T> iterable) {
        return () -> new NonnullIterator<T>(){
            private boolean finished;
            private Iterator iterator;
            {
                this.iterator = iterable.iterator();
                this.finished = false;
            }

            @Override
            public T next() {
                if (this.finished) {
                    return null;
                }
                boolean hasNext = this.iterator.hasNext();
                if (!hasNext) {
                    this.finished = true;
                }
                return hasNext ? (Object)this.iterator.next() : null;
            }
        };
    }

    @Override
    default public Iterator<T> iterator() {
        return new Iterator<T>(){
            private NonnullIterator<T> iterator;
            private boolean finished;
            private T next;
            {
                this.iterator = NonnullIterable.this.nonnullIterator();
                this.finished = false;
            }

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.next == null) {
                    this.next = this.iterator.next();
                    if (this.next == null) {
                        this.finished = true;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    return null;
                }
                Object next2 = this.next;
                this.next = null;
                return next2;
            }
        };
    }

    public static <T> NonnullIterable<T> of(T t1) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(t1);
        return NonnullIterable.ofArrayList(list);
    }

    public static <T> NonnullIterable<T> of(T t1, T t2) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(t1);
        list.add(t2);
        return NonnullIterable.ofArrayList(list);
    }

    public static <T> NonnullIterable<T> of(T t1, T t2, T t3) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(t1);
        list.add(t2);
        list.add(t3);
        return NonnullIterable.ofArrayList(list);
    }

    public static <T> NonnullIterable<T> ofArrayList(final ArrayList<T> arrayList) {
        return () -> new NonnullIterator<T>(){
            private int i = 0;

            @Override
            public T next() {
                if (this.i >= arrayList.size()) {
                    return null;
                }
                Object next = arrayList.get(this.i);
                ++this.i;
                return next;
            }
        };
    }

    default public <T2> NonnullIterable<T2> map(final Function<T, T2> function) {
        return () -> new NonnullIterator<T2>(){
            private NonnullIterator iterator;
            {
                this.iterator = NonnullIterable.this.nonnullIterator();
            }

            @Override
            public T2 next() {
                Object next = this.iterator.next();
                if (next == null) {
                    return null;
                }
                return function.apply(next);
            }
        };
    }

    default public NonnullIterable<T> filter(final Predicate<T> predicate) {
        return () -> new NonnullIterator<T>(){
            private NonnullIterator iterator;
            {
                this.iterator = NonnullIterable.this.nonnullIterator();
            }

            @Override
            public T next() {
                Object item;
                do {
                    if ((item = this.iterator.next()) != null) continue;
                    return null;
                } while (!predicate.test(item));
                return item;
            }
        };
    }

    default public <T2> NonnullIterable<T2> flatMap(final Function<T, NonnullIterable<T2>> function) {
        return () -> new NonnullIterator<T2>(){
            private NonnullIterator iteratorOuter;
            private NonnullIterator iteratorInner;
            {
                this.iteratorOuter = NonnullIterable.this.nonnullIterator();
                this.iteratorInner = this.getNextIterator();
            }

            @Override
            public T2 next() {
                while (this.iteratorInner != null) {
                    Object next = this.iteratorInner.next();
                    if (next != null) {
                        return next;
                    }
                    this.iteratorInner = this.getNextIterator();
                }
                return null;
            }

            private NonnullIterator<T2> getNextIterator() {
                Object next = this.iteratorOuter.next();
                if (next == null) {
                    return null;
                }
                return ((NonnullIterable)function.apply(next)).nonnullIterator();
            }
        };
    }
}

