/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.math.wulfenite.v0_1.script2.stack;

import java.util.Hashtable;
import mirrg.game.math.wulfenite.v0_1.script2.stack.BufferSpec;
import mirrg.game.math.wulfenite.v0_1.script2.stack.FrameSpec;
import org.eclipse.jdt.annotation.Nullable;

public class ManagerVariable {
    private FrameSpec frameSpec;
    private FrameVariable frameVariableCurrent;

    public ManagerVariable(FrameSpec frameSpec) {
        this.frameSpec = frameSpec;
        this.push();
    }

    public FrameVariable getFrameVariableCurrent() {
        return this.frameVariableCurrent;
    }

    public FrameVariable push() {
        this.frameVariableCurrent = new FrameVariable(this.frameVariableCurrent);
        return this.frameVariableCurrent;
    }

    public FrameVariable pop() {
        FrameVariable tmp = this.frameVariableCurrent.parent;
        this.frameVariableCurrent = this.frameVariableCurrent.parent;
        return tmp;
    }

    public class FrameVariable {
        private @Nullable FrameVariable parent;
        private Hashtable<String, Integer> table = new Hashtable();

        public FrameVariable(FrameVariable parent) {
            this.parent = parent;
        }

        public boolean isDefined(String name) {
            if (this.table.containsKey(name)) {
                return true;
            }
            if (this.parent == null) {
                return false;
            }
            return this.parent.isDefined(name);
        }

        public int getIndex(String name) {
            if (this.table.containsKey(name)) {
                return this.table.get(name);
            }
            if (this.parent == null) {
                throw new RuntimeException("No such variable: " + name);
            }
            return this.parent.getIndex(name);
        }

        public BufferSpec getBufferSpec(String name) {
            return ManagerVariable.this.frameSpec.getBufferSpec(this.getIndex(name));
        }

        public int define(String name, Class<?> type) {
            int index = ManagerVariable.this.frameSpec.define(type);
            this.table.put(name, index);
            return index;
        }

        public void undefine(String name) {
            ManagerVariable.this.frameSpec.undefine(this.table.get(name));
            this.table.remove(name);
        }
    }
}

