/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen.v1_5.modules.threading;

import mirrg.applet.nitrogen.v1_5.AppletNitrogen;
import mirrg.applet.nitrogen.v1_5.Module;
import mirrg.applet.nitrogen.v1_5.modules.threading.ModuleGameThread;
import mirrg.applet.nitrogen.v1_5.modules.threading.NitrogenEventGameThread;

public class ModuleFPSAdjuster
extends Module {
    private long previousTimeMs = 0L;
    private double smoothedLoadFactor = 0.0;
    private double smoothedFPS = 0.0;
    private ModuleGameThread moduleGameThread;
    private static final double K = 0.1;

    public ModuleFPSAdjuster(AppletNitrogen applet, ModuleGameThread moduleGameThread) {
        super(applet);
        this.moduleGameThread = moduleGameThread;
        applet.getEventManager().register(NitrogenEventGameThread.Sleep.class, event -> {
            event.cancelled = true;
            try {
                this.waitForNextTick();
            }
            catch (Exception e) {
                event.interrupted = true;
            }
        });
    }

    private final void sleepForNextTickFirst() {
        this.smoothedFPS = this.getObjectiveFPS();
        this.smoothedLoadFactor = 1.0;
        this.previousTimeMs = System.currentTimeMillis();
    }

    public void waitForNextTick() throws InterruptedException {
        if (this.previousTimeMs == 0L) {
            this.sleepForNextTickFirst();
            return;
        }
        long ms = System.currentTimeMillis();
        long previousLoopTimeMs = ms - this.previousTimeMs;
        long dms = (long)(1000.0 / this.getObjectiveFPS());
        if (dms - previousLoopTimeMs - 2L >= 0L) {
            Thread.sleep(dms - previousLoopTimeMs - 2L);
        }
        while (System.currentTimeMillis() < this.previousTimeMs + dms) {
        }
        long ms2 = System.currentTimeMillis();
        double fps = ms2 - this.previousTimeMs == 0L ? 1000.0 : 1000.0 / (double)(ms2 - this.previousTimeMs);
        this.smoothedFPS = 0.9 * this.smoothedFPS + 0.1 * fps;
        double loadFactor = (double)previousLoopTimeMs / (double)dms;
        this.smoothedLoadFactor = 0.9 * this.smoothedLoadFactor + 0.1 * loadFactor;
        this.previousTimeMs = ms2;
    }

    public double getLoadFactor() {
        if (this.smoothedLoadFactor == 0.0) {
            return 1.0;
        }
        return this.smoothedLoadFactor;
    }

    public double getFPS() {
        if (this.smoothedFPS == 0.0) {
            return this.getObjectiveFPS();
        }
        return this.smoothedFPS;
    }

    public double getObjectiveFPS() {
        return this.moduleGameThread.objectiveFPS;
    }
}

