/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.mathematics.zinc.v1_0.gadgets;

import mirrg.applet.mathematics.zinc.v1_0.core.IBuffer;
import mirrg.applet.mathematics.zinc.v1_0.core.IColorProvider;
import mirrg.applet.mathematics.zinc.v1_0.core.IZincCanvas;
import mirrg.applet.mathematics.zinc.v1_0.events.NitrogenEventZinc;
import mirrg.applet.mathematics.zinc.v1_0.events.NitrogenEventZincRender;
import mirrg.applet.mathematics.zinc.v1_0.gadgets.ZincGadget;

public abstract class ZincGadgetPainterBase
extends ZincGadget
implements IBuffer {
    protected int y = 0;
    protected int clearStart = 0;
    protected boolean inited = false;
    protected boolean dirty = false;

    public ZincGadgetPainterBase(IZincCanvas zincCanvas) {
        super(zincCanvas);
        zincCanvas.getEventManager().register(NitrogenEventZinc.Dirty.class, event -> this.dirty());
    }

    protected void dirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.zincCanvas.getEventManager().post(new NitrogenEventZincRender.Start());
        }
        this.clearStart = this.y;
    }

    @Override
    public void renderMathematical(IColorProvider colorProvider) {
        if (!this.inited) {
            this.inited = true;
            this.dirty();
        }
        if (this.dirty) {
            this.preTick();
            long startTime = System.currentTimeMillis();
            do {
                if (colorProvider != null) {
                    this.paintLine(colorProvider);
                }
                ++this.y;
                if (this.y >= this.zincCanvas.getHeight()) {
                    this.y = 0;
                }
                if (this.clearStart != this.y) continue;
                this.dirty = false;
                this.zincCanvas.getEventManager().post(new NitrogenEventZincRender.Finish());
                break;
            } while (startTime + 20L > System.currentTimeMillis());
            this.postTick();
        }
    }

    protected void preTick() {
    }

    protected void postTick() {
    }

    protected abstract void paintLine(IColorProvider var1);
}

