/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.math.wulfenite.v0_1.script2.tnode;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mirrg.complex.hydrogen.v1_0.StructureComplex;
import mirrg.complex.hydrogen.v1_0.functions.Exponential;
import mirrg.complex.hydrogen.v1_0.functions.Trigonometry;
import mirrg.game.math.wulfenite.v0_1.script2.ArgumentsInvoke;
import mirrg.game.math.wulfenite.v0_1.script2.ArgumentsValidate;
import mirrg.game.math.wulfenite.v0_1.script2.Type;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ITNodeExpression;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ToolsVariable;
import org.apache.commons.math3.util.FastMath;
import org.eclipse.jdt.annotation.Nullable;

public class ToolsFunction {
    private static final Class<Type.StructureBoolean> BOOLEAN = Type.StructureBoolean.class;
    private static final Class<Type.StructureInteger> INT = Type.StructureInteger.class;
    private static final Class<Type.StructureDouble> REAL = Type.StructureDouble.class;
    private static final Class<StructureComplex> COMPLEX = StructureComplex.class;
    public static ArrayList<EntryFunction> entriesFunction = new ArrayList();

    private static <R> void f(IF0<R> f, Class<R> type, String name) {
        entriesFunction.add(new EntryFunction((argumentsInvoke, dest, src) -> f.calculate(dest), type, name, new Class[0]));
    }

    private static <R, A> void f(IF1<R, A> f, Class<R> type, String name, Class<A> type0) {
        entriesFunction.add(new EntryFunction((argumentsInvoke, dest, src) -> f.calculate(dest, argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[0]]), type, name, type0));
    }

    private static <R, A, B> void f(IF2<R, A, B> f, Class<R> type, String name, Class<A> type0, Class<B> type1) {
        entriesFunction.add(new EntryFunction((argumentsInvoke, dest, src) -> f.calculate(dest, argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[0]], argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[1]]), type, name, type0, type1));
    }

    private static <R, A, B, C> void f(IF3<R, A, B, C> f, Class<R> type, String name, Class<A> type0, Class<B> type1, Class<C> type2) {
        entriesFunction.add(new EntryFunction((argumentsInvoke, dest, src) -> f.calculate(dest, argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[0]], argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[1]], argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[2]]), type, name, type0, type1, type2));
    }

    private static void registerFunctionsTime() {
        ToolsFunction.f(dest -> {
            dest.value = Instant.now().toEpochMilli();
        }, REAL, "time");
    }

    private static void registerFunctionsCast() {
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.re;
        }, REAL, "re", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.im;
        }, REAL, "im", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.getArgument();
        }, REAL, "arg", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.abs(src0.value);
        }, INT, "abs", INT);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.abs(src0.value);
        }, REAL, "abs", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.getAbstract();
        }, REAL, "abs", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.getAbstract2();
        }, REAL, "abs2", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = (int)FastMath.floor(src0.value);
        }, INT, "floor", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = (int)FastMath.ceil(src0.value);
        }, INT, "ceil", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = (int)src0.value;
        }, INT, "toInt", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = (int)FastMath.signum(src0.value);
        }, INT, "sign", REAL);
    }

    private static void registerFunctionsSin() {
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.sin(src0.value);
        }, REAL, "sin", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.cos(src0.value);
        }, REAL, "cos", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.tan(src0.value);
        }, REAL, "tan", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.sinh(src0.value);
        }, REAL, "sinh", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.cosh(src0.value);
        }, REAL, "cosh", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.tanh(src0.value);
        }, REAL, "tanh", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Trigonometry.sin(dest);
        }, COMPLEX, "sin", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Trigonometry.cos(dest);
        }, COMPLEX, "cos", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Trigonometry.tan(dest);
        }, COMPLEX, "tan", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Trigonometry.sinh(dest);
        }, COMPLEX, "sinh", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Trigonometry.cosh(dest);
        }, COMPLEX, "cosh", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Trigonometry.tanh(dest);
        }, COMPLEX, "tanh", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.asin(src0.value);
        }, REAL, "asin", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.acos(src0.value);
        }, REAL, "acos", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.atan(src0.value);
        }, REAL, "atan", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.asinh(src0.value);
        }, REAL, "asinh", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.acosh(src0.value);
        }, REAL, "acosh", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.atanh(src0.value);
        }, REAL, "atanh", REAL);
    }

    private static void registerFunctionsPow() {
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = FastMath.pow(src0.value, src1.value);
        }, REAL, "pow", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            Exponential.pow(dest, src1);
        }, COMPLEX, "pow", COMPLEX, COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.exp(src0.value);
        }, REAL, "exp", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Exponential.exp(dest);
        }, COMPLEX, "exp", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = FastMath.log(src0.value);
        }, REAL, "log", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            Exponential.log(dest);
        }, COMPLEX, "log", COMPLEX);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = FastMath.log(src0.value, src1.value);
        }, REAL, "log", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            Exponential.log(dest, src1);
        }, COMPLEX, "log", COMPLEX, COMPLEX);
    }

    private static void registerOperationLogic() {
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value && src1.value;
        }, BOOLEAN, "&&", BOOLEAN, BOOLEAN);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value || src1.value;
        }, BOOLEAN, "||", BOOLEAN, BOOLEAN);
    }

    private static void registerOperationEquation() {
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value == src1.value;
        }, BOOLEAN, "==", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value != src1.value;
        }, BOOLEAN, "!=", INT, INT);
    }

    private static void registerOperationCompare() {
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value < src1.value;
        }, BOOLEAN, "<", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value <= src1.value;
        }, BOOLEAN, "<=", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value > src1.value;
        }, BOOLEAN, ">", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value >= src1.value;
        }, BOOLEAN, ">=", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value < src1.value;
        }, BOOLEAN, "<", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value <= src1.value;
        }, BOOLEAN, "<=", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value > src1.value;
        }, BOOLEAN, ">", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value >= src1.value;
        }, BOOLEAN, ">=", REAL, REAL);
    }

    private static void registerOperationArith() {
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value + src1.value;
        }, INT, "+", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value - src1.value;
        }, INT, "-", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value * src1.value;
        }, INT, "*", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value / src1.value;
        }, INT, "/", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value % src1.value;
        }, INT, "%", INT, INT);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value + src1.value;
        }, REAL, "+", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value - src1.value;
        }, REAL, "-", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value * src1.value;
        }, REAL, "*", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.value = src0.value / src1.value;
        }, REAL, "/", REAL, REAL);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            dest.add((StructureComplex)src1);
        }, COMPLEX, "+", COMPLEX, COMPLEX);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            dest.sub((StructureComplex)src1);
        }, COMPLEX, "-", COMPLEX, COMPLEX);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            dest.mul((StructureComplex)src1);
        }, COMPLEX, "*", COMPLEX, COMPLEX);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            dest.div((StructureComplex)src1);
        }, COMPLEX, "/", COMPLEX, COMPLEX);
        ToolsFunction.f((dest, src0, src1) -> {
            dest.set((StructureComplex)src0);
            Exponential.pow(dest, src1);
        }, COMPLEX, "^", COMPLEX, COMPLEX);
    }

    private static void registerOperationSingle() {
        ToolsFunction.f((dest, src0) -> {
            dest.value = !src0.value;
        }, BOOLEAN, "!", BOOLEAN);
        ToolsFunction.f((dest, src0) -> {
            dest.value = -src0.value;
        }, INT, "-", INT);
        ToolsFunction.f((dest, src0) -> {
            dest.value = -src0.value;
        }, REAL, "-", REAL);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            dest.neg();
        }, COMPLEX, "-", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.value;
        }, INT, "+", INT);
        ToolsFunction.f((dest, src0) -> {
            dest.value = src0.value;
        }, REAL, "+", REAL);
        ToolsFunction.f((dest, src0) -> dest.set((StructureComplex)src0), COMPLEX, "+", COMPLEX);
        ToolsFunction.f((dest, src0) -> {
            dest.set((StructureComplex)src0);
            dest.con();
        }, COMPLEX, "~", COMPLEX);
    }

    private static void registerOperationTriple() {
        ToolsFunction.f((dest, src0, src1, src2) -> {
            dest.value = (src0.value ? src1 : src2).value;
        }, BOOLEAN, "?:", BOOLEAN, BOOLEAN, BOOLEAN);
        ToolsFunction.f((dest, src0, src1, src2) -> {
            dest.value = (src0.value ? src1 : src2).value;
        }, INT, "?:", BOOLEAN, INT, INT);
        ToolsFunction.f((dest, src0, src1, src2) -> {
            dest.value = (src0.value ? src1 : src2).value;
        }, REAL, "?:", BOOLEAN, REAL, REAL);
        ToolsFunction.f((dest, src0, src1, src2) -> dest.set(src0.value ? src1 : src2), COMPLEX, "?:", BOOLEAN, COMPLEX, COMPLEX);
    }

    public static @Nullable EntryFunction findEntryFunction(String name, Class<?>[] typesArgument) {
        for (EntryFunction entryFunction : entriesFunction) {
            if (!entryFunction.matchesJust(name, typesArgument)) continue;
            return entryFunction;
        }
        for (EntryFunction entryFunction : entriesFunction) {
            if (!entryFunction.matches(name, typesArgument)) continue;
            return entryFunction;
        }
        return null;
    }

    static {
        ToolsFunction.registerOperationSingle();
        ToolsFunction.registerOperationArith();
        ToolsFunction.registerOperationCompare();
        ToolsFunction.registerOperationEquation();
        ToolsFunction.registerOperationLogic();
        ToolsFunction.registerOperationTriple();
        ToolsFunction.registerFunctionsTime();
        ToolsFunction.registerFunctionsSin();
        ToolsFunction.registerFunctionsPow();
        ToolsFunction.registerFunctionsCast();
        entriesFunction.add(new EntryFunction((argumentsInvoke, dest, src) -> {
            Type.StructureInteger dest2 = (Type.StructureInteger)dest;
            Type.StructureInteger src0 = (Type.StructureInteger)argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[0]];
            StructureComplex src1 = (StructureComplex)argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[1]];
            StructureComplex src2 = (StructureComplex)argumentsInvoke.vm.stack.getFrameCurrent().buffers[src[2]];
            StructureComplex c = src1.copy();
            dest2.value = 0;
            while (dest2.value < src0.value) {
                c.add(src2);
                Exponential.pow2(c);
                if (c.getAbstract2() > 4.0) break;
                ++dest2.value;
            }
        }, INT, "mand", INT, COMPLEX, COMPLEX));
    }

    public static class Call
    implements ITNodeExpression {
        public ArrayList<?> nodes;
        public String name;
        public ITNodeExpression[] expressions;
        public int[] indexesRegisterArgument;
        public EntryFunction entryFunction;
        public int indexRegisterResponse;

        public Call(ArrayList<?> nodes, String name, ITNodeExpression ... expressions) {
            this.nodes = nodes;
            this.name = name;
            this.expressions = expressions;
            this.indexesRegisterArgument = new int[expressions.length];
        }

        public Call(ArrayList<?> nodes, String name, List<ITNodeExpression> expressions) {
            this(nodes, name, expressions.toArray(new ITNodeExpression[0]));
        }

        @Override
        public boolean validate(ArgumentsValidate argumentsValidate) {
            int i;
            Class[] typesArgument = new Class[this.expressions.length];
            for (i = 0; i < this.expressions.length; ++i) {
                ITNodeExpression expression = this.expressions[i];
                if (!expression.validate(argumentsValidate)) {
                    return false;
                }
                typesArgument[i] = expression.getType(argumentsValidate);
            }
            this.entryFunction = ToolsFunction.findEntryFunction(this.name, typesArgument);
            if (this.entryFunction == null) {
                argumentsValidate.addMessage(ToolsVariable.getTokenFirst(this.nodes), "\u95a2\u6570\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + this.name + "(" + Stream.of(typesArgument).map(type -> type.getSimpleName()).collect(Collectors.joining(", ")) + ")");
                return false;
            }
            for (i = 0; i < this.expressions.length; ++i) {
                this.indexesRegisterArgument[i] = argumentsValidate.frameSpec.define(this.entryFunction.typesArgument[i]);
            }
            this.indexRegisterResponse = argumentsValidate.frameSpec.define(this.entryFunction.typeResponse);
            return true;
        }

        @Override
        public void calculate(ArgumentsInvoke argumentsInvoke, Object buffer) {
            for (int i = 0; i < this.expressions.length; ++i) {
                ITNodeExpression expression = this.expressions[i];
                Object buffer2 = argumentsInvoke.vm.stack.getFrameCurrent().buffers[this.indexesRegisterArgument[i]];
                expression.calculate(argumentsInvoke, buffer2);
            }
            Object buffer2 = argumentsInvoke.vm.stack.getFrameCurrent().buffers[this.indexRegisterResponse];
            this.entryFunction.operator.apply(argumentsInvoke, buffer2, this.indexesRegisterArgument);
            Type.assign(buffer, buffer2);
        }

        @Override
        public Class<?> getType(ArgumentsValidate argumentsValidate) {
            return this.entryFunction.typeResponse;
        }
    }

    public static interface IEntryFunction {
        public void apply(ArgumentsInvoke var1, Object var2, int[] var3);
    }

    public static class EntryFunction {
        public Class<?> typeResponse;
        public String name;
        public Class<?>[] typesArgument;
        public IEntryFunction operator;

        public EntryFunction(IEntryFunction operator, Class<?> typeResponse, String name, Class<?> ... typesArgument) {
            this.typeResponse = typeResponse;
            this.name = name;
            this.typesArgument = typesArgument;
            this.operator = operator;
        }

        public boolean matchesJust(String name, Class<?>[] typesArgument) {
            if (!this.name.equals(name)) {
                return false;
            }
            if (this.typesArgument.length != typesArgument.length) {
                return false;
            }
            for (int i = 0; i < typesArgument.length; ++i) {
                if (typesArgument[i] == this.typesArgument[i]) continue;
                return false;
            }
            return true;
        }

        public boolean matches(String name, Class<?>[] typesArgument) {
            if (!this.name.equals(name)) {
                return false;
            }
            if (this.typesArgument.length != typesArgument.length) {
                return false;
            }
            for (int i = 0; i < typesArgument.length; ++i) {
                if (Type.isAssignable(typesArgument[i], this.typesArgument[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static interface IF3<R, A, B, C> {
        public void calculate(R var1, A var2, B var3, C var4);
    }

    public static interface IF2<R, A, B> {
        public void calculate(R var1, A var2, B var3);
    }

    public static interface IF1<R, A> {
        public void calculate(R var1, A var2);
    }

    public static interface IF0<R> {
        public void calculate(R var1);
    }
}

