/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.math.wulfenite.v0_1.script2;

import java.util.ArrayList;
import java.util.stream.Collectors;
import mirrg.compile.bromine.v1_8.syntaxes.TagString;
import mirrg.game.math.wulfenite.v0_1.script2.ResponseCompile;
import mirrg.game.math.wulfenite.v0_1.script2.stack.FrameSpec;
import mirrg.struct.hydrogen.v1_0.Tuple;
import mirrg.util.hydrogen.v1_0.HString;

public class ArgumentsValidate {
    public final ResponseCompile resultCompile;
    private ArrayList<Tuple<TagString, String>> messages = new ArrayList();
    public FrameSpec frameSpec = new FrameSpec();

    public ArgumentsValidate(ResponseCompile resultCompile) {
        this.resultCompile = resultCompile;
    }

    public void addMessage(TagString tag, String message) {
        this.messages.add(new Tuple<TagString, String>(tag, message));
    }

    public String getMessageString() {
        HString.LineProvider lineProvider = HString.getLineProvider(this.resultCompile.source);
        return this.messages.stream().map(message -> {
            TagString tag = (TagString)message.getX();
            int start = tag == null ? 0 : tag.start;
            Tuple<Integer, Integer> linePosition = this.resultCompile.getLinePosition(start);
            int row = linePosition.getX();
            int column = linePosition.getY();
            String line = lineProvider.getContent(row);
            String left = line.substring(Math.max(column - 20, 0), column);
            String right = line.substring(column, Math.min(column + 20, line.length()));
            return String.format("(L:%s, C:%s) '%s#%s' %s", row, column, left, right, message.getY());
        }).collect(Collectors.joining("\n"));
    }

    public static class RegisterFrame {
        private RegisterFrameRoot registerFrameRoot;
        public RegisterFrame parent;
        private int registerCount;

        public RegisterFrame(RegisterFrameRoot registerFrameRoot, RegisterFrame parent) {
            this.registerFrameRoot = registerFrameRoot;
            this.parent = parent;
        }

        public int defineRegister() {
            ++this.registerCount;
            int index = this.getRegisterCount();
            if (this.registerFrameRoot.maxRegisterCount < index) {
                this.registerFrameRoot.maxRegisterCount = index;
            }
            return index - 1;
        }

        public int getRegisterCount() {
            return this.registerCount + (this.parent == null ? 0 : this.parent.getRegisterCount());
        }
    }

    public static class RegisterFrameRoot {
        private RegisterFrame registerFrame = new RegisterFrame(this, null);
        public int maxRegisterCount = 0;

        public RegisterFrame getRegisterFrame() {
            return this.registerFrame;
        }

        public void pushRegisterFrame() {
            this.registerFrame = new RegisterFrame(this, this.registerFrame);
        }

        public void popRegisterFrame() {
            this.registerFrame = this.registerFrame.parent;
        }
    }

    public static class StackFrame {
        private StackFrameRoot stackFrameRoot;
        public StackFrame parent;
        private ArrayList<String> variables = new ArrayList();
        private ArrayList<Class<?>> types = new ArrayList();

        public StackFrame(StackFrameRoot stackFrameRoot, StackFrame parent) {
            this.stackFrameRoot = stackFrameRoot;
            this.parent = parent;
        }

        public boolean containsVariable(String name) {
            if (this.variables.contains(name)) {
                return true;
            }
            return this.parent == null ? false : this.parent.containsVariable(name);
        }

        public Integer defineVariable(String name, Class<?> type) {
            if (this.containsVariable(name)) {
                return null;
            }
            this.variables.add(name);
            this.types.add(type);
            int index = this.getVariablesCount();
            if (this.stackFrameRoot.maxVariableCount < index) {
                this.stackFrameRoot.maxVariableCount = index;
            }
            return index - 1;
        }

        public int getVariablesCount() {
            return this.variables.size() + (this.parent == null ? 0 : this.parent.getVariablesCount());
        }

        public Integer getVariableIndex(String name) {
            int index = this.variables.indexOf(name);
            if (index != -1) {
                return index + (this.parent == null ? 0 : this.parent.getVariablesCount());
            }
            return this.parent == null ? null : this.parent.getVariableIndex(name);
        }

        public Class<?> getType(String name) {
            return this.getType(this.getVariableIndex(name));
        }

        public Class<?> getType(int index) {
            return this.types.get(index);
        }
    }

    public static class StackFrameRoot {
        private StackFrame stackFrame = new StackFrame(this, null);
        public int maxVariableCount = 0;

        public StackFrame getStackFrame() {
            return this.stackFrame;
        }

        public void pushStackFrame() {
            this.stackFrame = new StackFrame(this, this.stackFrame);
        }

        public void popStackFrame() {
            this.stackFrame = this.stackFrame.parent;
        }
    }
}

