/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.bromine.v1_8.syntaxes.connection;

import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.UnaryOperator;
import mirrg.compile.bromine.v1_8.Syntax;
import mirrg.compile.bromine.v1_8.syntaxes.connection.IHandleDeleteNode;
import mirrg.compile.bromine.v1_8.syntaxes.connection.IHandleSetNode;
import mirrg.compile.bromine.v1_8.syntaxes.connection.SyntaxConnectionBase;
import mirrg.compile.bromine.v1_8.syntaxes.connection.TagConnection;

public class SyntaxLoop<N, C>
extends SyntaxConnectionBase<N> {
    private Function<TagConnection, N> functionNode;
    private IntPredicate predicateLength;
    private Syntax<C> syntax;
    private IHandleSetNode<N, C> handleSetNode;
    private IHandleDeleteNode<N> handleDeleteNode;

    public SyntaxLoop(UnaryOperator<N> cloner, Function<TagConnection, N> functionNode, IntPredicate predicateLength, Syntax<C> syntax, IHandleSetNode<N, C> handleSetNode, IHandleDeleteNode<N> handleDeleteNode) {
        super(cloner);
        this.functionNode = functionNode;
        this.predicateLength = predicateLength;
        this.syntax = syntax;
        this.handleSetNode = handleSetNode;
        this.handleDeleteNode = handleDeleteNode;
    }

    @Override
    protected boolean isLengthAllowed(int length) {
        return this.predicateLength.test(length);
    }

    @Override
    protected N getNode(TagConnection tag) {
        return this.functionNode.apply(tag);
    }

    @Override
    protected Syntax<?> getSyntax(int index) {
        return this.syntax;
    }

    @Override
    protected void setNode(N node, int index, Object nodeChild) {
        this.handleSetNode.setNode(node, index, nodeChild);
    }

    @Override
    protected void deleteNode(N node, int index) {
        this.handleDeleteNode.deleteNode(node, index);
    }
}

