/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.mathematics.zinc.v1_0;

import mirrg.complex.hydrogen.v1_0.StructureComplex;
import mirrg.complex.hydrogen.v1_0.functions.Exponential;
import mirrg.util.hydrogen.v1_0.HColor;
import mirrg.util.hydrogen.v1_0.HMath;

public class HAppletZinc {
    public static int getMandNumber(double x0, double y0, double re, double im, int limit) {
        double x = x0;
        double y = y0;
        for (int t = 0; t < limit; ++t) {
            double tmp_x = Math.pow(x, 2.0) - Math.pow(y, 2.0) + re;
            if (!(HMath.magnitude2(x = tmp_x, y = 2.0 * x * y + im) > 4.0)) continue;
            return t;
        }
        return limit;
    }

    public static StructureComplex getMandNumberEx(double x0, double y0, double re, double im, int limit) {
        double x = x0;
        double y = y0;
        StructureComplex z = new StructureComplex();
        StructureComplex a = new StructureComplex();
        int t = 0;
        while (true) {
            double tmp_x;
            if (HMath.magnitude2(x = (tmp_x = Math.pow(x, 2.0) - Math.pow(y, 2.0) + re), y = 2.0 * x * y + im) > 4.0 || t == limit) {
                a.set(x, y);
                z.set(Math.log(t), a.getArgument());
                Exponential.exp(z);
                return z;
            }
            ++t;
        }
    }

    public static int getBurningShipNumber(double x0, double y0, double r, double i, int limit) {
        double x = x0;
        double y = y0;
        for (int t = 0; t < limit; ++t) {
            double tmp_x;
            if (x < 0.0) {
                x = -x;
            }
            if (y < 0.0) {
                y = -y;
            }
            if (!(HMath.magnitude2(x = (tmp_x = Math.pow(x, 2.0) - Math.pow(y, 2.0) + r), y = 2.0 * x * y + i) > 4.0)) continue;
            return t;
        }
        return limit;
    }

    public static int getPow2ColorInt(double re, double im) {
        double _r = Math.pow(re, 2.0) - Math.pow(im, 2.0);
        double _i = 2.0 * re * im;
        return HAppletZinc.getColorInt(_r, _i);
    }

    public static int getColorInt(double re, double im) {
        double arg = Math.atan2(im, re);
        double abs = HMath.magnitude(re, im);
        return HAppletZinc.getColorIntFromPolar(abs, arg);
    }

    public static int getColorIntFromPolar(double abs, double arg) {
        double R = Math.cos(arg);
        double G = Math.cos(arg - 2.0943951023931953);
        double B = Math.cos(arg - 4.1887902047863905);
        double brightness = 0.5 - 0.5 * Math.cos(abs * 2.0 * Math.PI);
        brightness = 1.0 - Math.pow(brightness, 2.0);
        return HColor.getColorInt((int)((128.0 + 126.0 * R) * brightness), (int)((128.0 + 126.0 * G) * brightness), (int)((128.0 + 126.0 * B) * brightness));
    }

    public static int getColorIntFromTriangleNumber(int r, int g, int b, int limit) {
        return HColor.getColorInt(HAppletZinc.getTriangleNumber(r, limit), HAppletZinc.getTriangleNumber(g, limit), HAppletZinc.getTriangleNumber(b, limit));
    }

    public static long uramIndex(long x, long y) {
        long dist = Math.max(Math.abs(x), Math.abs(y));
        if (dist == 0L) {
            return 1L;
        }
        long length = dist * 2L + 1L;
        if (y > 0L && Math.abs(x) <= Math.abs(y)) {
            return length * length + (-y + x);
        }
        if (x < 0L && Math.abs(x) >= Math.abs(y)) {
            return length * length - (length - 1L) + (y + x);
        }
        if (y < 0L && Math.abs(x) <= Math.abs(y)) {
            return length * length - (length - 1L) * 2L + (y - x);
        }
        if (x > 0L && Math.abs(x) >= Math.abs(y)) {
            return length * length - (length - 1L) * 3L + (-y - x);
        }
        return 0L;
    }

    public static int getTriangleNumber(int n, int limit) {
        if (n == limit) {
            return 255;
        }
        if ((n %= 510) >= 255) {
            n = 510 - n;
        }
        return n;
    }
}

