/* 
 * Copyright (C) 2001-2006 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"
#include "../client/DCPlusPlus.h"
#include "Resource.h"

#include "MainFrm.h"
#include "AboutDlg.h"
#include "HubFrame.h"
#include "SearchFrm.h"
#include "PublicHubsFrm.h"
#include "PropertiesDlg.h"
#include "UsersFrame.h"
#include "DirectoryListingFrm.h"
#include "RecentsFrm.h"
#include "FavoritesFrm.h"
#include "NotepadFrame.h"
#include "Notepad2Frame.h"
#include "Notepad3Frame.h"
#include "Notepad4Frame.h"
#include "Notepad5Frame.h"
#include "QueueFrame.h"
#include "SpyFrame.h"
#include "FinishedFrame.h"
#include "ADLSearchFrame.h"
#include "FinishedULFrame.h"
#include "TextFrame.h"
#include "StatsFrame.h"
#include "WaitingUsersFrame.h"
#include "LineDlg.h"
#include "HashProgressDlg.h"
#include "UPnP.h"
#include "PrivateFrame.h"
#include "WinUtil.h"
#include "CDMDebugFrame.h"
#include "InputBox.h"
#include "PopupManager.h"
#include "Winamp.h"
#include "Players.h"
#include "iTunesCOMInterface.h"
#include "InstallDlg.h"

#include "../client/ConnectionManager.h"
#include "../client/DownloadManager.h"
#include "../client/HashManager.h"
#include "../client/UploadManager.h"
#include "../client/StringTokenizer.h"
#include "../client/SimpleXML.h"
#include "../client/ShareManager.h"
#include "../client/LogManager.h"
#include "../client/WebServerManager.h"
#include "../client/Thread.h"
//RSX++
#include "../rsx/RsxUtil.h"
#include "../rsx/UpdateManager.h"
#include "../rsx/HTTPDownloadManager.h"
#include "../client/ScriptManager.h" // Lua
#include "FileConverterDlg.h"
#include "../client/PluginsManager.h"
#include "UpdateDialog.h"
#include "PluginsListDlg.h"
#include "ScriptsList.h"
//END

MainFrame* MainFrame::anyMF = NULL;
bool MainFrame::bShutdown = false;
uint64_t MainFrame::iCurrentShutdownTime = 0;
bool MainFrame::isShutdownStatus = false;

MainFrame::MainFrame() : trayMessage(0), maximized(false), lastUpload(-1), lastUpdate(0), 
lastUp(0), lastDown(0), oldshutdown(false), stopperThread(NULL), 
closing(false), awaybyminimize(false), missedAutoConnect(false), lastTTHdir(Util::emptyStringT), tabsontop(false),
bTrayIcon(false), bAppMinimized(false), bIsPM(false), UPnP_TCPConnection(NULL), UPnP_UDPConnection(NULL),
QuickSearchBoxContainer(WC_COMBOBOX, this, QUICK_SEARCH_MAP), QuickSearchEditContainer(WC_EDIT ,this, QUICK_SEARCH_MAP),
m_bDisableAutoComplete(false)
{ 
		memzero(statusSizes, sizeof(statusSizes));
		anyMF = this;
}

MainFrame::~MainFrame() {
	m_CmdBar.m_hImageList = NULL;

	images.Destroy();
	largeImages.Destroy();
	largeImagesHot.Destroy();
	//special start
	smallbarImages.Destroy();
	//special end
	winampImages.Destroy();
	winampImagesHot.Destroy();

	WinUtil::uninit();
}

DWORD WINAPI MainFrame::stopper(void* p) {
	MainFrame* mf = (MainFrame*)p;
	HWND wnd, wnd2 = NULL;

	while( (wnd=::GetWindow(mf->m_hWndMDIClient, GW_CHILD)) != NULL) {
		if(wnd == wnd2)
			Sleep(100);
		else { 
			::PostMessage(wnd, WM_CLOSE, 0, 0);
			wnd2 = wnd;
		}
	}

	mf->PostMessage(WM_CLOSE);	
	return 0;
}

class ListMatcher : public Thread {
public:
	ListMatcher(StringList files_) : files(files_) {

	}
	int run() {
		for(StringIter i = files.begin(); i != files.end(); ++i) {
			UserPtr u = DirectoryListing::getUserFromFilename(*i);
			if(!u)
				continue;
			DirectoryListing dl(u);
			try {
				dl.loadFile(*i);
				string tmp;
				tmp.resize(STRING(MATCHED_FILES).size() + 16);
				tmp.resize(snprintf(&tmp[0], tmp.size(), CSTRING(MATCHED_FILES), QueueManager::getInstance()->matchListing(dl)));
				LogManager::getInstance()->message(Util::toString(ClientManager::getInstance()->getNicks(u->getCID())) + ": " + tmp);
			} catch(const Exception&) {

			}
		}
		delete this;
		return 0;
	}
	StringList files;
};

LRESULT MainFrame::onMatchAll(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	ListMatcher* matcher = new ListMatcher(File::findFiles(Util::getListPath(), "*.xml*"));
	try {
		matcher->start();
	} catch(const ThreadException&) {
		///@todo add error message
		delete matcher;
	}
	
	return 0;
}

LRESULT MainFrame::OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled) {
	TimerManager::getInstance()->addListener(this);
	QueueManager::getInstance()->addListener(this);
	LogManager::getInstance()->addListener(this);
	WebServerManager::getInstance()->addListener(this);
	
	if(BOOLSETTING(WEBSERVER)) {
		try {
			WebServerManager::getInstance()->Start();
		} catch(const Exception& e) {
			MessageBox(Text::toT(e.getError()).c_str(), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_ICONSTOP | MB_OK);
		}
	}
	
	switch(RSXSETTING(DEFAULT_PRIO)) {
		case 0:	RsxUtil::changeProcessPriority(RsxUtil::REALTIME);		break;
		case 1:	RsxUtil::changeProcessPriority(RsxUtil::HIGH);			break;
		case 2:	RsxUtil::changeProcessPriority(RsxUtil::ABOVE_NORMAL);	break;
		case 3:	RsxUtil::changeProcessPriority(RsxUtil::NORMAL);		break;
		case 4:	RsxUtil::changeProcessPriority(RsxUtil::BELOW_NORMAL);	break;
		case 5:	RsxUtil::changeProcessPriority(RsxUtil::IDLE);			break;
		default: break;
	}
	
	WinUtil::init(m_hWnd);

	trayMessage = RegisterWindowMessage(_T("TaskbarCreated"));

	TimerManager::getInstance()->start();

	// Set window name

	SetWindowText(RsxUtil::getWndTitle().c_str());
	//RSX++
	PluginsManager::getInstance()->startPlugins();
	ScriptManager::getInstance()->loadScripts();
	UpdateManager::getInstance()->addListener(this);
	//END

	// Load images
	// create command bar window
	HWND hWndCmdBar = m_CmdBar.Create(m_hWnd, rcDefault, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE);

	m_hMenu = WinUtil::mainMenu;

	hShutdownIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDB_SHUTDOWN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);

	// attach menu
	m_CmdBar.AttachMenu(m_hMenu);
	// load command bar images
	ResourceLoader::LoadImageList(IDP_TOOLBAR, images, 16, 16);
	m_CmdBar.m_hImageList = images;
	m_CmdBar.m_arrCommand.Add(IDC_CONVERT_FAV);
	m_CmdBar.m_arrCommand.Add(ID_GET_TTH);	
	m_CmdBar.m_arrCommand.Add(IDC_OPEN_MY_LIST);
	m_CmdBar.m_arrCommand.Add(IDC_OPEN_FILE_LIST);
	m_CmdBar.m_arrCommand.Add(IDC_MATCH_ALL);
	m_CmdBar.m_arrCommand.Add(IDC_OPEN_DOWNLOADS);
	m_CmdBar.m_arrCommand.Add(IDC_HASH_PROGRESS);
	m_CmdBar.m_arrCommand.Add(IDC_FAVORITES);
	m_CmdBar.m_arrCommand.Add(IDC_FAVUSERS);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_HUBBY);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_HOMEPAGE);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_DWIZ);
	m_CmdBar.m_arrCommand.Add(IDC_RECENTS);
	m_CmdBar.m_arrCommand.Add(ID_FILE_CONNECT);
	m_CmdBar.m_arrCommand.Add(ID_FILE_QUICK_CONNECT);
	m_CmdBar.m_arrCommand.Add(IDC_FOLLOW);
	m_CmdBar.m_arrCommand.Add(ID_FILE_RECONNECT);
	m_CmdBar.m_arrCommand.Add(IDC_RECONNECT_DISCONNECTED);
	m_CmdBar.m_arrCommand.Add(IDC_QUEUE);
	m_CmdBar.m_arrCommand.Add(IDC_FINISHED);
	m_CmdBar.m_arrCommand.Add(IDC_UPLOAD_QUEUE);
	m_CmdBar.m_arrCommand.Add(IDC_FINISHED_UL);
	m_CmdBar.m_arrCommand.Add(ID_FILE_SEARCH);
	m_CmdBar.m_arrCommand.Add(IDC_FILE_ADL_SEARCH);
	m_CmdBar.m_arrCommand.Add(IDC_SEARCH_SPY);
	m_CmdBar.m_arrCommand.Add(IDC_SONGR);
	m_CmdBar.m_arrCommand.Add(IDC_HOSTNAME);
	m_CmdBar.m_arrCommand.Add(IDC_SEARCH_IP);
	m_CmdBar.m_arrCommand.Add(IDC_DNS_INTERCEPTOR);
	m_CmdBar.m_arrCommand.Add(IDC_ALL_MUSIC);
	m_CmdBar.m_arrCommand.Add(IDC_MOVIE);
	m_CmdBar.m_arrCommand.Add(IDC_TV);
	m_CmdBar.m_arrCommand.Add(ID_FILE_SETTINGS);
	m_CmdBar.m_arrCommand.Add(IDC_TOOL_INSTALL);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGE_PRIO_ABOVE);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGE_PRIO_NORMAL);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGE_PRIO_BELOW);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGE_PRIO_IDLE);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGE_PRIO_HIGH);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGE_PRIO_REALTIME);
	m_CmdBar.m_arrCommand.Add(IDC_VIEW_SCRIPTS_LIST);
	m_CmdBar.m_arrCommand.Add(IDC_NOTEPAD);
	m_CmdBar.m_arrCommand.Add(IDC_NOTEPAD2);
	m_CmdBar.m_arrCommand.Add(IDC_NOTEPAD3);
	m_CmdBar.m_arrCommand.Add(IDC_NOTEPAD4);
	m_CmdBar.m_arrCommand.Add(IDC_NOTEPAD5);
	m_CmdBar.m_arrCommand.Add(IDC_UPDATE);	
	m_CmdBar.m_arrCommand.Add(IDC_HELP_GEOIPFILE);
	m_CmdBar.m_arrCommand.Add(IDC_LIMITER);
	m_CmdBar.m_arrCommand.Add(IDC_DISABLE_SOUNDS);
	m_CmdBar.m_arrCommand.Add(IDC_AWAY);
	m_CmdBar.m_arrCommand.Add(IDC_OPEN_CLONE);
	m_CmdBar.m_arrCommand.Add(ID_APP_EXIT);
	m_CmdBar.m_arrCommand.Add(IDC_SHUTDOWN);
	m_CmdBar.m_arrCommand.Add(IDC_CDMDEBUG_WINDOW);
	m_CmdBar.m_arrCommand.Add(IDC_NET_STATS);
	m_CmdBar.m_arrCommand.Add(IDC_CLEAR_ALL_HUB_MAINCHAT);
	m_CmdBar.m_arrCommand.Add(IDC_REFRESH_FILE_LIST);
	m_CmdBar.m_arrCommand.Add(IDC_REFRESH);
	m_CmdBar.m_arrCommand.Add(IDC_MASTER_BOT);
	m_CmdBar.m_arrCommand.Add(IDC_DARK_FIGHTER);
	m_CmdBar.m_arrCommand.Add(IDC_HUB_CHECK);
	m_CmdBar.m_arrCommand.Add(IDC_PROXY_CHECK);
	m_CmdBar.m_arrCommand.Add(IDC_LAG_WATCH);
	m_CmdBar.m_arrCommand.Add(IDC_NICK_CREATOR);
	m_CmdBar.m_arrCommand.Add(IDC_PASSWORD);
	m_CmdBar.m_arrCommand.Add(IDC_ASCII);
	m_CmdBar.m_arrCommand.Add(IDC_WINAMP_CLASSIC);
	m_CmdBar.m_arrCommand.Add(IDC_AUDIO_PLAYER);
	m_CmdBar.m_arrCommand.Add(IDC_MPLAYER_CLASSIC);
	m_CmdBar.m_arrCommand.Add(IDC_AVIPREVIEW);
	m_CmdBar.m_arrCommand.Add(ID_WINDOW_TILE_HORZ);
	m_CmdBar.m_arrCommand.Add(ID_WINDOW_TILE_VERT);
	m_CmdBar.m_arrCommand.Add(ID_WINDOW_CASCADE);
	m_CmdBar.m_arrCommand.Add(ID_WINDOW_ARRANGE);
	m_CmdBar.m_arrCommand.Add(ID_WINDOW_MINIMIZE_ALL);
	m_CmdBar.m_arrCommand.Add(ID_WINDOW_RESTORE_ALL);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_ALL_SEARCH_FRAME);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_ALL_DIR_LIST);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_ALL_OFFLINE_PM);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_ALL_PM);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_DISCONNECTED);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_NO_USR);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_X);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_L);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_C);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_CCL);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_D);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_M);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_MD);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_HUBS_BELOW_MM);
	m_CmdBar.m_arrCommand.Add(IDC_CLOSE_ALL_HUBS);
	m_CmdBar.m_arrCommand.Add(ID_APP_ABOUT);
	m_CmdBar.m_arrCommand.Add(IDC_CHANGELOG);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_HUBBY);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_HOMEPAGE);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_DISCUSS);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_SERVER_ONE);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_SERVER_TWO);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_SERVER_THREE);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_SERVER_FOUR);
	m_CmdBar.m_arrCommand.Add(IDC_FAQ_BASIC1);
	m_CmdBar.m_arrCommand.Add(IDC_FAQ_BASIC2);
	m_CmdBar.m_arrCommand.Add(IDC_FAQ_BASIC3);
	m_CmdBar.m_arrCommand.Add(IDC_HELP_DWIZ);

	// remove old menu
	SetMenu(NULL);

	tbarcreated = false;
	ptbarcreated = false;
	HWND hWndToolBar = createToolbar();
	//special start
	HWND hWndSmallbar = createSmallbar();
	//special end
	HWND hWndWinampBar = createWinampToolbar();
	HWND hWndQuickSearchBar = createQuickSearchBar();
	//HWND hWndPluginToolBar = createPluginsToolbar(); //RSX++

	CreateSimpleReBar(ATL_SIMPLE_REBAR_NOBORDER_STYLE);
	//special start
	AddSimpleReBarBand(hWndSmallbar, NULL, FALSE, 0, TRUE);
	//special end
	//AddSimpleReBarBand(hWndPluginToolBar, NULL, FALSE, 0, TRUE); 
	AddSimpleReBarBand(hWndCmdBar);
	AddSimpleReBarBand(hWndToolBar, NULL, TRUE);
	AddSimpleReBarBand(hWndWinampBar, NULL, TRUE);
	AddSimpleReBarBand(hWndQuickSearchBar, NULL, FALSE, 200, TRUE);
	CreateSimpleStatusBar();
	
	RECT toolRect = {0};
	::GetWindowRect(hWndToolBar, &toolRect);

	ctrlStatus.Attach(m_hWndStatusBar);
	ctrlStatus.SetSimple(FALSE);
	int w[10] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
	ctrlStatus.SetParts(10, w);
	statusSizes[0] = WinUtil::getTextWidth(TSTRING(AWAY), ::GetDC(ctrlStatus.m_hWnd)); // for "AWAY" segment
	CImageList StatImg;
	StatImg.CreateFromImage(IDB_ARROWS, 16, 0, CLR_DEFAULT, IMAGE_BITMAP, LR_CREATEDIBSECTION | LR_SHARED);
	hIconStatusDown = StatImg.GetIcon(0);
	ctrlStatus.SetIcon(7, hIconStatusDown);
	hIconStatusUp = StatImg.GetIcon(1);
	ctrlStatus.SetIcon(8, hIconStatusUp);
	StatImg.Destroy();

	CToolInfo ti(TTF_SUBCLASS, ctrlStatus.m_hWnd);

	ctrlLastLines.Create(ctrlStatus.m_hWnd, rcDefault, NULL, WS_POPUP | TTS_NOPREFIX | TTS_ALWAYSTIP /*| TTS_BALLOON*/, WS_EX_TOPMOST);
	ctrlLastLines.SetWindowPos(HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
	ctrlLastLines.AddTool(&ti);
	ctrlLastLines.SetDelayTime(TTDT_AUTOPOP, 15000);

	CreateMDIClient();
	m_CmdBar.SetMDIClient(m_hWndMDIClient);
	WinUtil::mdiClient = m_hWndMDIClient;

	ctrlTab.Create(m_hWnd, rcDefault);
	WinUtil::tabCtrl = &ctrlTab;
	tabsontop = BOOLSETTING(TABS_ON_TOP);

	transferView.Create(m_hWnd);

	SetSplitterPanes(m_hWndMDIClient, transferView.m_hWnd);
	SetSplitterExtendedStyle(SPLIT_PROPORTIONAL);
	m_nProportionalPos = SETTING(TRANSFER_SPLIT_SIZE);
	//UIAddToolBar(hWndPluginToolBar); //RSX++
	UIAddToolBar(hWndToolBar);
	UIAddToolBar(hWndWinampBar);
	UIAddToolBar(hWndQuickSearchBar);
	UISetCheck(ID_VIEW_TOOLBAR, 1);
	//special start
	UISetCheck(ID_VIEW_SMALLBAR, 1);
	//special end
	UISetCheck(ID_TOGGLE_TOOLBAR, 1);
	UISetCheck(ID_VIEW_STATUS_BAR, 1);
	UISetCheck(ID_VIEW_TRANSFER_VIEW, 1);
	UISetCheck(ID_TOGGLE_QSEARCH, 1);
	UISetCheck(IDC_LIMITER, BOOLSETTING(THROTTLE_ENABLE));
	UISetCheck(IDC_DISABLE_SOUNDS, BOOLSETTING(SOUNDS_DISABLED));
	UISetCheck(IDC_AWAY,BOOLSETTING(AWAY));
	UISetCheck(ID_VIEW_PLUGIN_TOOLBAR, 1);
	UISetCheck(IDC_LOCK_TOOLBARS, BOOLSETTING(LOCK_TOOLBARS));
	UISetCheck(IDC_TOPMOST, BOOLSETTING(TOPMOST));

	if(BOOLSETTING(LOCK_TOOLBARS)) toggleLockToolbars();
	if(BOOLSETTING(TOPMOST)) toggleTopmost();

	WinUtil::loadReBarSettings(m_hWndToolBar);	

	// register object for message filtering and idle updates
	CMessageLoop* pLoop = _Module.GetMessageLoop();
	ATLASSERT(pLoop != NULL);
	pLoop->AddMessageFilter(this);
	pLoop->AddIdleHandler(this);

	 //Process Priority
	prioMenu.CreatePopupMenu();
	prioMenu.AppendMenu(MF_STRING, IDC_CHANGE_PRIO_ABOVE,		CTSTRING(MENU_PRIO_ABOVE));
	prioMenu.AppendMenu(MF_STRING, IDC_CHANGE_PRIO_NORMAL,		CTSTRING(MENU_PRIO_NORMAL));
	prioMenu.AppendMenu(MF_STRING, IDC_CHANGE_PRIO_BELOW,		CTSTRING(MENU_PRIO_BELOW));
	prioMenu.AppendMenu(MF_SEPARATOR);
	prioMenu.AppendMenu(MF_STRING, IDC_CHANGE_PRIO_IDLE,		CTSTRING(MENU_PRIO_IDLE));
	prioMenu.AppendMenu(MF_STRING, IDC_CHANGE_PRIO_HIGH,		CTSTRING(MENU_PRIO_HIGH));
	prioMenu.AppendMenu(MF_STRING, IDC_CHANGE_PRIO_REALTIME,	CTSTRING(MENU_PRIO_REALTIME));
	
	tools.CreatePopupMenu();
	tools.AppendMenu(MF_STRING, IDC_MASTER_BOT,	CTSTRING(MENU_MASTER_BOT));
	tools.AppendMenu(MF_STRING, IDC_DARK_FIGHTER,	CTSTRING(MENU_DARK_FIGHTER));
	tools.AppendMenu(MF_SEPARATOR);
	tools.AppendMenu(MF_STRING, IDC_HUB_CHECK,	CTSTRING(MENU_HUB_CHECK));
	tools.AppendMenu(MF_STRING, IDC_PROXY_CHECK,	CTSTRING(MENU_PROXY_CHECK));
	tools.AppendMenu(MF_SEPARATOR);
	tools.AppendMenu(MF_STRING, IDC_LAG_WATCH,	CTSTRING(MENU_LAG_WATCH));
	tools.AppendMenu(MF_SEPARATOR);
	tools.AppendMenu(MF_STRING, IDC_NICK_CREATOR,	CTSTRING(MENU_NICK_CREATOR));
	tools.AppendMenu(MF_STRING, IDC_PASSWORD,	CTSTRING(MENU_PASSWORD));
	tools.AppendMenu(MF_SEPARATOR);
	tools.AppendMenu(MF_STRING, IDC_ASCII,	CTSTRING(MENU_ASCII));
	tools.AppendMenu(MF_SEPARATOR);
	tools.AppendMenu(MF_STRING, IDC_WINAMP_CLASSIC,	CTSTRING(MENU_WINAMP_CLASSIC));
	tools.AppendMenu(MF_STRING, IDC_AUDIO_PLAYER,	CTSTRING(MENU_AUDIO_PLAYER));
	tools.AppendMenu(MF_SEPARATOR);
	tools.AppendMenu(MF_STRING, IDC_MPLAYER_CLASSIC,	CTSTRING(MENU_MPLAYER_CLASSIC));
	tools.AppendMenu(MF_STRING, IDC_AVIPREVIEW,	CTSTRING(MENU_AVIPREVIEW));
	
	zKonline.CreatePopupMenu();
	zKonline.AppendMenu(MF_STRING, IDC_HELP_HOMEPAGE, CTSTRING(MENU_HOMEPAGE));
	zKonline.AppendMenu(MF_STRING, IDC_HELP_DISCUSS, CTSTRING(MENU_DISCUSS));
	zKonline.AppendMenu(MF_STRING, IDC_HELP_HUBBY, CTSTRING(MENU_HUBBY));
	zKonline.AppendMenu(MF_SEPARATOR);
	zKonline.AppendMenu(MF_STRING, IDC_UPDATE, CTSTRING(UPDATE_CHECK));
	
	trayMenu.CreatePopupMenu();
	trayMenu.AppendMenu(MF_STRING, IDC_TRAY_SHOW, CTSTRING(MENU_SHOW));
	trayMenu.AppendMenu(MF_STRING, ID_APP_ABOUT, CTSTRING(MENU_ABOUT));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_POPUP, (UINT)(HMENU)zKonline, CTSTRING(MENU_ZK_ONLINE));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_STRING, ID_FILE_SETTINGS, CTSTRING(MENU_SETTINGS));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_POPUP, (UINT)(HMENU)prioMenu, CTSTRING(MENU_CHANGE_PRIO));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_POPUP, (UINT)(HMENU)tools, CTSTRING(MENU_HOTTOOLS));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_STRING, IDC_CLEAR_ALL_HUB_MAINCHAT, CTSTRING(MENU_CLEAR_ALL_HUB_MAINCHAT));
	trayMenu.AppendMenu(MF_STRING, IDC_REFRESH_FILE_LIST, CTSTRING(MENU_REFRESH_FILE_LIST));
	trayMenu.AppendMenu(MF_STRING, IDC_REFRESH, CTSTRING(REFRESH_USER_LIST));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_STRING, IDC_LIMITER, CTSTRING(SETCZDC_ENABLE_LIMITING));
	trayMenu.AppendMenu(MF_STRING, IDC_DISABLE_SOUNDS, CTSTRING(DISABLE_SOUNDS));
	trayMenu.AppendMenu(MF_STRING, IDC_AWAY, CTSTRING(AWAY));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_STRING, IDC_OPEN_CLONE, CTSTRING(MENU_OPEN_CLONE));
	trayMenu.AppendMenu(MF_SEPARATOR);
	trayMenu.AppendMenu(MF_STRING, ID_APP_EXIT, CTSTRING(MENU_EXIT));
	trayMenu.SetMenuDefaultItem(IDC_TRAY_SHOW);

	tbMenu.CreatePopupMenu();
	tbMenu.AppendMenu(MF_STRING, ID_VIEW_TOOLBAR, CTSTRING(MENU_TOOLBAR));
	tbMenu.AppendMenu(MF_STRING, ID_VIEW_SMALLBAR, CTSTRING(VIEW_SMALL_TOOLBAR));
	tbMenu.AppendMenu(MF_STRING, ID_TOGGLE_TOOLBAR, CTSTRING(TOGGLE_TOOLBAR));
	tbMenu.AppendMenu(MF_SEPARATOR);
	tbMenu.AppendMenu(MF_STRING, ID_VIEW_STATUS_BAR, CTSTRING(MENU_STATUS_BAR));
	tbMenu.AppendMenu(MF_STRING, ID_VIEW_TRANSFER_VIEW, CTSTRING(MENU_TRANSFER_VIEW));
	tbMenu.AppendMenu(MF_SEPARATOR);
	tbMenu.AppendMenu(MF_STRING, ID_TOGGLE_QSEARCH, CTSTRING(TOGGLE_QSEARCH));
	tbMenu.AppendMenu(MF_SEPARATOR);
	tbMenu.AppendMenu(MF_STRING, IDC_LOCK_TOOLBARS, CTSTRING(LOCK_TOOLBARS));
	tbMenu.AppendMenu(MF_STRING, IDC_TOPMOST, CTSTRING(MENU_TOPMOST));

	if(!Util::fileExists(Util::getConfigPath() + "zK.xml") && !Util::fileExists(Util::getSystemPath() + "zKboot.xml")) {
		// Ugly, but we can blame nsis for that :P
		HKEY hk; bool isInstalled = false;
		if(::RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\zK++"), NULL, KEY_READ, &hk) == ERROR_SUCCESS) {
			TCHAR buf[512];
			DWORD bufLen = sizeof(buf) * sizeof(TCHAR);
			::RegQueryValueEx(hk, _T("NSIS"), NULL, NULL, (LPBYTE)buf, &bufLen);
			::RegCloseKey(hk);
			isInstalled = (buf[0] == '1');
		}

		if(!isInstalled) {
			InstallDlg dlg;
			dlg.DoModal(m_hWnd);
		} else {
			OSVERSIONINFOEX ver;
			WinUtil::getVersionInfo(ver);
			if(((ver.dwMajorVersion >= 5 && ver.dwMinorVersion >= 1 && ver.wServicePackMajor >= 2) || (ver.dwMajorVersion >= 6)) && WinUtil::isUserAdmin()) {
				if(MessageBox(CTSTRING(FIREWALL_QUESTION), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_YESNO | MB_ICONQUESTION) == IDYES) {
					WinUtil::alterWinFirewall(true);
				}
			}
		}
	}

	if(BOOLSETTING(OPEN_PUBLIC)) PostMessage(WM_COMMAND, ID_FILE_CONNECT);
	if(BOOLSETTING(OPEN_FAVORITE_HUBS)) PostMessage(WM_COMMAND, IDC_FAVORITES);
	if(BOOLSETTING(OPEN_FAVORITE_USERS)) PostMessage(WM_COMMAND, IDC_FAVUSERS);
	if(BOOLSETTING(OPEN_QUEUE)) PostMessage(WM_COMMAND, IDC_QUEUE);
	if(BOOLSETTING(OPEN_FINISHED_DOWNLOADS)) PostMessage(WM_COMMAND, IDC_FINISHED);
	if(BOOLSETTING(OPEN_WAITING_USERS)) PostMessage(WM_COMMAND, IDC_UPLOAD_QUEUE);
	if(BOOLSETTING(OPEN_FINISHED_UPLOADS)) PostMessage(WM_COMMAND, IDC_FINISHED_UL);
	if(BOOLSETTING(OPEN_SEARCH_SPY)) PostMessage(WM_COMMAND, IDC_SEARCH_SPY);
	if(BOOLSETTING(OPEN_NETWORK_STATISTICS)) PostMessage(WM_COMMAND, IDC_NET_STATS);
	if(BOOLSETTING(OPEN_NOTEPAD)) PostMessage(WM_COMMAND, IDC_NOTEPAD);
	if(BOOLSETTING(OPEN_NOTEPAD2)) PostMessage(WM_COMMAND, IDC_NOTEPAD2);
	if(BOOLSETTING(OPEN_NOTEPAD3)) PostMessage(WM_COMMAND, IDC_NOTEPAD3);
	if(BOOLSETTING(OPEN_NOTEPAD4)) PostMessage(WM_COMMAND, IDC_NOTEPAD4);	
	if(BOOLSETTING(OPEN_NOTEPAD5)) PostMessage(WM_COMMAND, IDC_NOTEPAD5);	

	if(!BOOLSETTING(SHOW_STATUSBAR)) PostMessage(WM_COMMAND, ID_VIEW_STATUS_BAR);
	if(!BOOLSETTING(SHOW_TOOLBAR)) PostMessage(WM_COMMAND, ID_VIEW_TOOLBAR);
	if(!BOOLSETTING(SHOW_TRANSFERVIEW))	PostMessage(WM_COMMAND, ID_VIEW_TRANSFER_VIEW);
	if(!BOOLSETTING(SHOW_WINAMP_CONTROL)) PostMessage(WM_COMMAND, ID_TOGGLE_TOOLBAR);
	if(!BOOLSETTING(SHOW_QUICK_SEARCH))	PostMessage(WM_COMMAND, ID_TOGGLE_QSEARCH);
	if(!BOOLSETTING(SHOW_PLUGIN_TOOLBAR)) PostMessage(WM_COMMAND, ID_VIEW_PLUGIN_TOOLBAR);
	if(!BOOLSETTING(VIEW_SMALL_TOOLBAR)) PostMessage(WM_COMMAND, ID_VIEW_SMALLBAR);

	if(!WinUtil::isShift())
		PostMessage(WM_SPEAKER, AUTO_CONNECT);

	PostMessage(WM_SPEAKER, PARSE_COMMAND_LINE);

	try {
		File::ensureDirectory(SETTING(LOG_DIRECTORY));
		
		//File::ensureDirectory(Util::getDataPath() + "Plugins" PATH_SEPARATOR_STR);
		File::ensureDirectory(Util::getDataPath() + "Scripts" PATH_SEPARATOR_STR);
		File::ensureDirectory(Util::getDataPath() + "EmoPacks" PATH_SEPARATOR_STR);
		
	} catch (const FileException) {	}

	startSocket();
	
SettingsManager::getInstance()->set(SettingsManager::BOSS_MODE, false);
	normalicon.hIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	pmicon.hIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_TRAY_PM), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);

	updateTray( BOOLSETTING( MINIMIZE_TRAY ) );

	Util::setAway(BOOLSETTING(AWAY));

	ctrlToolbar.CheckButton(IDC_AWAY,BOOLSETTING(AWAY));
	ctrlToolbar.CheckButton(IDC_LIMITER,BOOLSETTING(THROTTLE_ENABLE));
	ctrlToolbar.CheckButton(IDC_DISABLE_SOUNDS, BOOLSETTING(SOUNDS_DISABLED));
	ctrlToolbar.CheckButton(ID_TOGGLE_TOOLBAR, BOOLSETTING(SHOW_WINAMP_CONTROL));
#ifndef SVNBUILD
	if(SETTING(NICK).empty()) {
		PostMessage(WM_COMMAND, IDC_CHANGELOG);
		PostMessage(WM_COMMAND, ID_FILE_SETTINGS);
	}
#endif
	UpdateManager::getInstance()->runUpdate();

	m_PictureWindow.SubclassWindow(m_hWndMDIClient);
	m_PictureWindow.m_nMessageHandler = CPictureWindow::BackGroundPaint;
	currentPic = SETTING(BACKGROUND_IMAGE);
	m_PictureWindow.Load(Text::toT(currentPic).c_str());

	// We want to pass this one on to the splitter...hope it get's there...
	bHandled = FALSE;
	return 0;
}

HWND MainFrame::createWinampToolbar() {
	winampImages.CreateFromImage(IDB_WINAMP_CONTROL, 20, 20, CLR_DEFAULT, IMAGE_BITMAP, LR_CREATEDIBSECTION | LR_SHARED);
	winampImagesHot.CreateFromImage(IDB_WINAMP_CONTROL_HOT, 20, 20, CLR_DEFAULT, IMAGE_BITMAP, LR_CREATEDIBSECTION | LR_SHARED);
	
	ctrlWinampToolbar.Create(m_hWnd, NULL, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS, 0, ATL_IDW_TOOLBAR);
	ctrlWinampToolbar.SetImageList(winampImages);
	ctrlWinampToolbar.SetHotImageList(winampImagesHot);

	const int numButtons = 10;

	TBBUTTON tb[numButtons];
	memzero(&tb, sizeof(tb));
	int n = 0, bitmap = 0;

#define ADD_BUTTON(a) \
	tb[n].iBitmap = bitmap++; \
	tb[n].idCommand = a; \
	tb[n].fsState = TBSTATE_ENABLED; \
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE; \
	n++;

#define ADD_SEPERATOR() \
	tb[n].fsStyle = TBSTYLE_SEP; \
	n++;

	//Fix buttons
	// back / play / pause / next / stop / volume up / volume 50% / volume down
	ADD_BUTTON(IDC_WINAMP_SPAM)
	ADD_SEPERATOR()
	ADD_BUTTON(IDC_WINAMP_BACK)
	ADD_BUTTON(IDC_WINAMP_PLAY)	
	ADD_BUTTON(IDC_WINAMP_PAUSE)
	ADD_BUTTON(IDC_WINAMP_NEXT)
	ADD_BUTTON(IDC_WINAMP_STOP)
	ADD_BUTTON(IDC_WINAMP_VOL_UP)
	ADD_BUTTON(IDC_WINAMP_VOL_HALF)
	ADD_BUTTON(IDC_WINAMP_VOL_DOWN)

	//ADD_SEPERATOR()

	ctrlWinampToolbar.SetButtonStructSize();
	ctrlWinampToolbar.AddButtons(numButtons, tb);
	ctrlWinampToolbar.AutoSize();

	return ctrlWinampToolbar.m_hWnd;
}

HWND MainFrame::createQuickSearchBar() {
	ctrlQuickSearchBar.Create(m_hWnd, NULL, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS, 0, ATL_IDW_TOOLBAR);

	TBBUTTON tb[1];
	memzero(&tb, sizeof(tb));

	tb[0].iBitmap = 200;
	tb[0].fsStyle = TBSTYLE_SEP;

	ctrlQuickSearchBar.SetButtonStructSize();
	ctrlQuickSearchBar.AddButtons(1, tb);
	ctrlQuickSearchBar.AutoSize();

	CRect rect;
	ctrlQuickSearchBar.GetItemRect(0, &rect);
	rect.bottom += 100;
	rect.left += 2;

	QuickSearchBox.Create(ctrlQuickSearchBar.m_hWnd, rect , NULL, WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | 
		WS_VSCROLL | CBS_DROPDOWN | CBS_AUTOHSCROLL , 0);
	updateQuickSearches();
	QuickSearchBox.SetWindowText(CTSTRING(QSEARCH_STR));
	QuickSearchBoxContainer.SubclassWindow(QuickSearchBox.m_hWnd);
	QuickSearchBox.SetExtendedUI();

	QuickSearchBox.SetFont(WinUtil::systemFont, FALSE);

	POINT pt;
	pt.x = 10;
	pt.y = 10;
	HWND hWnd = QuickSearchBox.ChildWindowFromPoint(pt);
	if(hWnd != NULL && !QuickSearchEdit.IsWindow() && hWnd != QuickSearchBox.m_hWnd) {
		QuickSearchEdit.Attach(hWnd);
		QuickSearchEditContainer.SubclassWindow(QuickSearchEdit.m_hWnd);
	}

	return ctrlQuickSearchBar.m_hWnd;
}

LRESULT MainFrame::onWinampButton(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	if(SETTING(MEDIA_PLAYER) == 2) {
		HWND hwndWinamp = FindWindow(_T("Winamp v1.x"), NULL);
		if (::IsWindow(hwndWinamp)) {
			switch(wID) {
				case IDC_WINAMP_BACK: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_BUTTON1, 0); break;
				case IDC_WINAMP_PLAY: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_BUTTON2, 0); break;
				case IDC_WINAMP_STOP: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_BUTTON4, 0); break;
				case IDC_WINAMP_PAUSE: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_BUTTON3, 0); break;	
				case IDC_WINAMP_NEXT: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_BUTTON5, 0); break;
				case IDC_WINAMP_VOL_UP: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_VOLUMEUP, 0); break;
				case IDC_WINAMP_VOL_DOWN: SendMessage(hwndWinamp, WM_COMMAND, WINAMP_VOLUMEDOWN, 0); break;
				case IDC_WINAMP_VOL_HALF: SendMessage(hwndWinamp, WM_WA_IPC, 255/2, IPC_SETVOLUME); break;
			}
		}
	} else if(SETTING(MEDIA_PLAYER) == 0) {
		HWND hwndWMP = FindWindow(_T("WMPlayerApp"), NULL);
		if (::IsWindow(hwndWMP)) {
			switch(wID) {
				case IDC_WINAMP_BACK: SendMessage(hwndWMP, WM_COMMAND, WMP_PREV, 0); break;
				case IDC_WINAMP_PLAY: SendMessage(hwndWMP, WM_COMMAND, WMP_PLAY, 0); break;
				case IDC_WINAMP_STOP: SendMessage(hwndWMP, WM_COMMAND, WMP_STOP, 0); break;
				case IDC_WINAMP_PAUSE: SendMessage(hwndWMP, WM_COMMAND, WMP_PLAY, 0); break;	
				case IDC_WINAMP_NEXT: SendMessage(hwndWMP, WM_COMMAND, WMP_NEXT, 0); break;
				case IDC_WINAMP_VOL_UP: SendMessage(hwndWMP, WM_COMMAND, WMP_VOLUP, 0); break;
				case IDC_WINAMP_VOL_DOWN: SendMessage(hwndWMP, WM_COMMAND, WMP_VOLDOWN, 0); break;
				case IDC_WINAMP_VOL_HALF: SendMessage(hwndWMP, WM_COMMAND, WMP_MUTE, 0); break;
			}
		}
	} else if(SETTING(MEDIA_PLAYER) == 3) {
		// Since i couldn't find out the appropriate window messages, we doing this  la COM
		HWND hwndiTunes = FindWindow(_T("iTunes"), _T("iTunes"));
		if (::IsWindow(hwndiTunes)) {
			IiTunes *iITunes;
			CoInitialize(NULL);
			if (SUCCEEDED(::CoCreateInstance(CLSID_iTunesApp, NULL, CLSCTX_LOCAL_SERVER, IID_IiTunes, (PVOID *)&iITunes))) {
				long currVol;
				switch(wID) {
					case IDC_WINAMP_BACK: iITunes->PreviousTrack(); break;
					case IDC_WINAMP_PLAY: iITunes->Play(); break;
					case IDC_WINAMP_STOP: iITunes->Stop();  break;
					case IDC_WINAMP_PAUSE: iITunes->Pause(); break;	
					case IDC_WINAMP_NEXT: iITunes->NextTrack(); break;
					case IDC_WINAMP_VOL_UP: iITunes->get_SoundVolume(&currVol); iITunes->put_SoundVolume(currVol+10); break;
					case IDC_WINAMP_VOL_DOWN: iITunes->get_SoundVolume(&currVol); iITunes->put_SoundVolume(currVol-10); break;
					case IDC_WINAMP_VOL_HALF: iITunes->put_SoundVolume(50); break;
				}
			}
			iITunes->Release();
			CoUninitialize();
		}
	} else if(SETTING(MEDIA_PLAYER) == 1) {
		HWND hwndMPC = FindWindow(_T("MediaPlayerClassicW"), NULL);
		if (::IsWindow(hwndMPC)) {
			switch(wID) {
				case IDC_WINAMP_BACK: SendMessage(hwndMPC, WM_COMMAND, MPC_PREV, 0); break;
				case IDC_WINAMP_PLAY: SendMessage(hwndMPC, WM_COMMAND, MPC_PLAY, 0); break;
				case IDC_WINAMP_STOP: SendMessage(hwndMPC, WM_COMMAND, MPC_STOP, 0); break;
				case IDC_WINAMP_PAUSE: SendMessage(hwndMPC, WM_COMMAND, MPC_PAUSE, 0); break;	
				case IDC_WINAMP_NEXT: SendMessage(hwndMPC, WM_COMMAND, MPC_NEXT, 0); break;
				case IDC_WINAMP_VOL_UP: SendMessage(hwndMPC, WM_COMMAND, MPC_VOLUP, 0); break;
				case IDC_WINAMP_VOL_DOWN: SendMessage(hwndMPC, WM_COMMAND, MPC_VOLDOWN, 0); break;
				case IDC_WINAMP_VOL_HALF: SendMessage(hwndMPC, WM_COMMAND, MPC_MUTE, 0); break;
			}
		}
	}
       return 0;
}

LRESULT MainFrame::onQuickSearchChar(UINT uMsg, WPARAM wParam, LPARAM /*lParam*/, BOOL& bHandled){
	if(uMsg == WM_CHAR)
		if(wParam == VK_BACK)
			m_bDisableAutoComplete = true;
		else
			m_bDisableAutoComplete = false;

	switch(wParam) {
		case VK_DELETE:
			if(uMsg == WM_KEYDOWN) {
				m_bDisableAutoComplete = true;
			}
			bHandled = FALSE;
			break;
		case VK_RETURN:
			if( WinUtil::isShift() || WinUtil::isCtrl() || WinUtil::isAlt() ) {
				bHandled = FALSE;
			} else {
				if(uMsg == WM_KEYDOWN) {
					tstring s(QuickSearchEdit.GetWindowTextLength() + 1, _T('\0'));
					QuickSearchEdit.GetWindowText(&s[0], s.size());
					s.resize(s.size()-1);
					SearchFrame::openWindow(s);
					
					updateQuickSearches();
				}
			}
			break;
		default:
			bHandled = FALSE;
	}
	return 0;
}

LRESULT MainFrame::onQuickSearchColor(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
	HDC hDC = (HDC)wParam;
	::SetBkColor(hDC, WinUtil::bgColor);
	::SetTextColor(hDC, WinUtil::textColor);
	return (LRESULT)WinUtil::bgBrush;
}

LRESULT MainFrame::onQuickSearchEditChange(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& bHandled) {
	uint32_t nTextLen = 0, nMatchedTextLen = 0;
	HWND hWndCombo = QuickSearchBox.m_hWnd;
	_TCHAR *pStrMatchedText = NULL, *pEnteredText = NULL;
	DWORD dwStartSel = 0, dwEndSel = 0;

	// Get the text length from the combobox, then copy it into a newly allocated buffer.
	nTextLen = ::SendMessage(hWndCombo, WM_GETTEXTLENGTH, NULL, NULL);
	pEnteredText = new _TCHAR[nTextLen + 1];
	::SendMessage(hWndCombo, WM_GETTEXT, (WPARAM)nTextLen + 1, (LPARAM)pEnteredText);
	::SendMessage(hWndCombo, CB_GETEDITSEL, (WPARAM)&dwStartSel, (LPARAM)&dwEndSel);

	// Check to make sure autocompletion isn't disabled due to a backspace or delete
	// Also, the user must be typing at the end of the string, not somewhere in the middle.
	if (! m_bDisableAutoComplete && (dwStartSel == dwEndSel) && (dwStartSel == nTextLen)) {
		// Try and find a string that matches the typed substring.  If one is found,
		// set the text of the combobox to that string and set the selection to mask off
		// the end of the matched string.
		int nMatch = ::SendMessage(hWndCombo, CB_FINDSTRING, (WPARAM)-1, (LPARAM)pEnteredText);
		if (nMatch != CB_ERR) {
			nMatchedTextLen = ::SendMessage(hWndCombo, CB_GETLBTEXTLEN, (WPARAM)nMatch, 0);
			if (nMatchedTextLen != CB_ERR) {
				// Since the user may be typing in the same string, but with different case (e.g. "/port --> /PORT")
				// we copy whatever the user has already typed into the beginning of the matched string,
				// then copy the whole shebang into the combobox.  We then set the selection to mask off
				// the inferred portion.
				pStrMatchedText = new _TCHAR[nMatchedTextLen + 1];
				::SendMessage(hWndCombo, CB_GETLBTEXT, (WPARAM)nMatch, (LPARAM)pStrMatchedText);				
				memcpy((void*)pStrMatchedText, (void*)pEnteredText, nTextLen * sizeof(_TCHAR));
				::SendMessage(hWndCombo, WM_SETTEXT, 0, (WPARAM)pStrMatchedText);
				::SendMessage(hWndCombo, CB_SETEDITSEL, 0, MAKELPARAM(nTextLen, -1));
				delete[] pStrMatchedText;
			}
		}
	}

	delete[] pEnteredText;
	bHandled = TRUE;	

    return 0;
}

void MainFrame::updateQuickSearches() {
	QuickSearchBox.ResetContent();
	
	for(TStringList::const_iterator i = SearchFrame::getLastSearches().begin(); i != SearchFrame::getLastSearches().end(); ++i) {
		QuickSearchBox.InsertString(0, i->c_str());
	}	
	
	if(BOOLSETTING(CLEAR_SEARCH) && ::IsWindow(QuickSearchEdit.m_hWnd)) {
		QuickSearchBox.SetWindowText(CTSTRING(QSEARCH_STR));
	}
}

void MainFrame::startSocket() {
	SearchManager::getInstance()->disconnect();
	ConnectionManager::getInstance()->disconnect();

//	if(ClientManager::getInstance()->isActive()) {
		try {
			ConnectionManager::getInstance()->listen();
		} catch(const Exception&) {
			MessageBox(CTSTRING(TCP_PORT_BUSY), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_ICONSTOP | MB_OK);
		}
		try {
			SearchManager::getInstance()->listen();
		} catch(const Exception&) {
			MessageBox(CTSTRING(TCP_PORT_BUSY), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_ICONSTOP | MB_OK);
		}
//	}

	startUPnP();
}

void MainFrame::startUPnP() {
	stopUPnP();

	if( SETTING(INCOMING_CONNECTIONS) == SettingsManager::INCOMING_FIREWALL_UPNP ) {
		UPnP_TCPConnection = new UPnP( Util::getLocalIp(), "TCP", APPNAME " Download Port (" + Util::toString(ConnectionManager::getInstance()->getPort()) + " TCP)", ConnectionManager::getInstance()->getPort() );
		UPnP_UDPConnection = new UPnP( Util::getLocalIp(), "UDP", APPNAME " Search Port (" + Util::toString(SearchManager::getInstance()->getPort()) + " UDP)", SearchManager::getInstance()->getPort() );
		
		if ( FAILED(UPnP_UDPConnection->OpenPorts()) || FAILED(UPnP_TCPConnection->OpenPorts()) )
		{
			LogManager::getInstance()->message(STRING(UPNP_FAILED_TO_CREATE_MAPPINGS));
			MessageBox(CTSTRING(UPNP_FAILED_TO_CREATE_MAPPINGS), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_OK | MB_ICONWARNING);
				
			// We failed! thus reset the objects
			delete UPnP_TCPConnection;
			delete UPnP_UDPConnection;
			UPnP_TCPConnection = UPnP_UDPConnection = NULL;
		}
		else
		{
			if(!BOOLSETTING(NO_IP_OVERRIDE)) {
				// now lets configure the external IP (connect to me) address
				string ExternalIP = UPnP_TCPConnection->GetExternalIP();
				if ( !ExternalIP.empty() ) {
					// woohoo, we got the external IP from the UPnP framework
					SettingsManager::getInstance()->set(SettingsManager::EXTERNAL_IP, ExternalIP );
				} else {
					//:-(  Looks like we have to rely on the user setting the external IP manually
					// no need to do cleanup here because the mappings work
					LogManager::getInstance()->message(STRING(UPNP_FAILED_TO_GET_EXTERNAL_IP));
					MessageBox(CTSTRING(UPNP_FAILED_TO_GET_EXTERNAL_IP), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_OK | MB_ICONWARNING);
				}
			}
		}
	}
}

void MainFrame::stopUPnP() {
	// Just check if the port mapping objects are initialized (NOT NULL)
	if ( UPnP_TCPConnection != NULL )
	{
		if (FAILED(UPnP_TCPConnection->ClosePorts()) )
		{
			LogManager::getInstance()->message(STRING(UPNP_FAILED_TO_REMOVE_MAPPINGS));
		}
		delete UPnP_TCPConnection;
	}
	if ( UPnP_UDPConnection != NULL )
	{
		if (FAILED(UPnP_UDPConnection->ClosePorts()) )
		{
			LogManager::getInstance()->message(STRING(UPNP_FAILED_TO_REMOVE_MAPPINGS));
		}
		delete UPnP_UDPConnection;
	}
	// Not sure this is required (i.e. Objects are checked later in execution)
	// But its better being on the save side :P
	UPnP_TCPConnection = UPnP_UDPConnection = NULL;
}

HWND MainFrame::createToolbar() {
	if(!tbarcreated) {
		if(SETTING(TOOLBARIMAGE) == "") {
			ResourceLoader::LoadImageList(IDP_TOOLBAR20, largeImages, 32, 32);
		} else {
			ResourceLoader::LoadImageList(Text::toT(SETTING(TOOLBARIMAGE)).c_str(), largeImages, 32, 32);
		}

		if(SETTING(TOOLBARHOTIMAGE) == "") {
			ResourceLoader::LoadImageList(IDP_TOOLBAR20_HOT, largeImagesHot, 32, 32);
		} else {
			ResourceLoader::LoadImageList(Text::toT(SETTING(TOOLBARHOTIMAGE)).c_str(), largeImagesHot, 32, 32);
		}

		ctrlToolbar.Create(m_hWnd, NULL, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS | TBSTYLE_LIST, 0, ATL_IDW_TOOLBAR);
		ctrlToolbar.SetExtendedStyle(TBSTYLE_EX_MIXEDBUTTONS);
		ctrlToolbar.SetImageList(largeImages);
		ctrlToolbar.SetHotImageList(largeImagesHot);
		tbarcreated = true;
	}

	while(ctrlToolbar.GetButtonCount()>0)
		ctrlToolbar.DeleteButton(0);

	ctrlToolbar.SetButtonStructSize();
	StringTokenizer<string> t(SETTING(TOOLBAR), ',');
	StringList& l = t.getTokens();
	
	int buttonsCount = sizeof(ToolbarButtons) / sizeof(ToolbarButtons[0]);
	for(StringList::const_iterator k = l.begin(); k != l.end(); ++k) {
		int i = Util::toInt(*k);		
		
		TBBUTTON nTB;
		memzero(&nTB, sizeof(TBBUTTON));

		if(i == -1) {
			nTB.fsStyle = TBSTYLE_SEP;			
		} else if(i >= 0 && i < buttonsCount) {
			nTB.iBitmap = ToolbarButtons[i].image;
			nTB.idCommand = ToolbarButtons[i].id;
			nTB.fsState = TBSTATE_ENABLED;
			nTB.fsStyle = TBSTYLE_AUTOSIZE | ((ToolbarButtons[i].check == true)? TBSTYLE_CHECK : TBSTYLE_BUTTON);
			nTB.iString = ctrlToolbar.AddStrings(CTSTRING_I((ResourceManager::Strings)ToolbarButtons[i].tooltip));
		} else {
			continue;
		}

		ctrlToolbar.AddButtons(1, &nTB);
	}	

	ctrlToolbar.AutoSize();

	return ctrlToolbar.m_hWnd;
}

HWND MainFrame::createPluginsToolbar() {
	if(!ptbarcreated) {
		ctrlPluginToolbar.Create(m_hWnd, NULL, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE | TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_TOOLTIPS, 0, ATL_IDW_TOOLBAR);
		ctrlPluginToolbar.SetExtendedStyle(TBSTYLE_EX_MIXEDBUTTONS);
		ctrlPluginToolbar.SetBitmapSize(12, 12);
		ptbarcreated = true;
	}

	while(ctrlPluginToolbar.GetButtonCount() > 0) {
		ctrlPluginToolbar.DeleteButton(0);
	}

	ctrlPluginToolbar.SetButtonStructSize();
	int n = 0;
	const PluginsManager::Plugins& p = PluginsManager::getInstance()->getPlugins();
	for(PluginsManager::Plugins::const_iterator i = p.begin(); i != p.end(); ++i) {
		if((*i)->getIcon() > 0) {
			HBITMAP b = (HBITMAP)::LoadImage((*i)->getHandle(), MAKEINTRESOURCE((*i)->getIcon()), IMAGE_BITMAP, 12, 12, LR_SHARED);
			if(b == NULL)
				continue;

			ctrlPluginToolbar.AddBitmap(1, b);

			TBBUTTON nTB;
			memzero(&nTB, sizeof(TBBUTTON));
			nTB.iBitmap = n;
			nTB.idCommand = (*i)->getId();
			nTB.fsState = TBSTATE_ENABLED;
			nTB.fsStyle = TBSTYLE_AUTOSIZE | TBSTYLE_BUTTON;

			tstring pToolTip = (*i)->getName() + _T(" ") + (*i)->getVersion();
			nTB.iString = ctrlPluginToolbar.AddStrings(pToolTip.c_str());

			ctrlPluginToolbar.AddButtons(1, &nTB);
			n++;
		}
	}
	ctrlPluginToolbar.AutoSize();
	return ctrlPluginToolbar.m_hWnd;
}

LRESULT MainFrame::onBnClick(WORD /*wNotifyCode*/, WORD wID, HWND hWndCtl, BOOL& bHandled) {
	//maybe not the best way, but, at least, it does the job
	if(hWndCtl == ctrlPluginToolbar.m_hWnd) {
		PluginsManager::getInstance()->onToolbarClick(wID, hWndCtl);
		bHandled = TRUE;
		return 0;
	}
	bHandled = FALSE;
	return 0;
}


//special start
// Taken from zdmc++ light, that took it from zion++, who really cares...
HWND MainFrame::createSmallbar() {
	smallbarImages.CreateFromImage(IDB_SMALLBAR, 13, 2, CLR_DEFAULT, IMAGE_BITMAP, LR_CREATEDIBSECTION | LR_SHARED);

	ctrlSmallbar.Create(m_hWnd, NULL, NULL, ATL_SIMPLE_CMDBAR_PANE_STYLE | TBSTYLE_FLAT | TBSTYLE_TOOLTIPS, 0, ATL_IDW_TOOLBAR);
	ctrlSmallbar.SetImageList(smallbarImages);

	const int numButtons = 6;

	TBBUTTON tb[numButtons];
	memset(tb, 0, sizeof(tb));
	int n = 0, bitmap = 0;


	tb[n].iBitmap = bitmap++;
	tb[n].idCommand = ID_WINDOW_RESTORE_ALL;
	tb[n].fsState = TBSTATE_ENABLED;
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
	n++;
	tb[n].iBitmap = bitmap++;
	tb[n].idCommand = ID_WINDOW_MINIMIZE_ALL;
	tb[n].fsState = TBSTATE_ENABLED;
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
	n++;
	tb[n].fsStyle = TBSTYLE_SEP;
	n++;
	tb[n].iBitmap = bitmap++;
	tb[n].idCommand = IDC_CLOSE_DISCONNECTED;
	tb[n].fsState = TBSTATE_ENABLED;
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
	n++;
	tb[n].iBitmap = bitmap++;
	tb[n].idCommand = IDC_CLOSE_HUBS_NO_USR;
	tb[n].fsState = TBSTATE_ENABLED;
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
	n++;
	/*tb[n].iBitmap = bitmap++;
	tb[n].idCommand = IDC_CLOSE_HUBS_BELOW_C;
	tb[n].fsState = TBSTATE_ENABLED;
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
	n++;*/
	tb[n].iBitmap = bitmap++;
	tb[n].idCommand = IDC_CLOSE_HUBS_BELOW_X;
	tb[n].fsState = TBSTATE_ENABLED;
	tb[n].fsStyle = TBSTYLE_BUTTON | TBSTYLE_AUTOSIZE;
	n++;

	ctrlSmallbar.SetButtonStructSize();
	ctrlSmallbar.AddButtons(numButtons, tb);
	ctrlSmallbar.AutoSize();

	return ctrlSmallbar.m_hWnd;
}
//special end

LRESULT MainFrame::onSpeaker(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/) {
		
	if(wParam == DOWNLOAD_LISTING) {
		auto_ptr<DirectoryListInfo> i(reinterpret_cast<DirectoryListInfo*>(lParam));
		DirectoryListingFrame::openWindow(i->file, i->dir, i->user, i->speed);
	} else if(wParam == BROWSE_LISTING) {
		auto_ptr<DirectoryBrowseInfo> i(reinterpret_cast<DirectoryBrowseInfo*>(lParam));
		DirectoryListingFrame::openWindow(i->user, i->text, 0);
	} else if(wParam == VIEW_FILE_AND_DELETE) {
		auto_ptr<tstring> file(reinterpret_cast<tstring*>(lParam));
		TextFrame::openWindow(*file);
		File::deleteFile(Text::fromT(*file));
	} else if(wParam == STATS) {
		auto_ptr<TStringList> pstr(reinterpret_cast<TStringList*>(lParam));
		const TStringList& str = *pstr;
		if(ctrlStatus.IsWindow()) {
			HDC dc = ::GetDC(ctrlStatus.m_hWnd);
			bool u = false;
			ctrlStatus.SetText(1, str[0].c_str());
			for(int i = 1; i < 8; i++) {
				int w = WinUtil::getTextWidth(str[i], dc) + ((i >= 6) ? 16 : 0);
				
			if(statusSizes[i] < w) {
					statusSizes[i] = w;
						  u = true;
						}
					ctrlStatus.SetText(i+1, str[i].c_str());
				}
			::ReleaseDC(ctrlStatus.m_hWnd, dc);
			if(u)
				UpdateLayout(TRUE);
		}
		if (bShutdown) {
			uint64_t iSec = GET_TICK() / 1000;
			if (ctrlStatus.IsWindow()) {
				if(!isShutdownStatus) {
					ctrlStatus.SetIcon(9, hShutdownIcon);
					isShutdownStatus = true;
				}
				if (DownloadManager::getInstance()->getDownloadCount() > 0) {
					iCurrentShutdownTime = iSec;
					ctrlStatus.SetText(9, _T(""));
				} else {
					int64_t timeLeft = SETTING(SHUTDOWN_TIMEOUT) - (iSec - iCurrentShutdownTime);
					ctrlStatus.SetText(9, (_T(" ") + Util::formatSeconds(timeLeft, timeLeft < 3600)).c_str(), SBT_POPOUT);
					if (iCurrentShutdownTime + SETTING(SHUTDOWN_TIMEOUT) <= iSec) {
						bool bDidShutDown = false;
						bDidShutDown = WinUtil::shutDown(SETTING(SHUTDOWN_ACTION));
						if (bDidShutDown) {
							// Should we go faster here and force termination?
							// We "could" do a manual shutdown of this app...
						} else {
							ctrlStatus.SetText(0, CTSTRING(FAILED_TO_SHUTDOWN));
							ctrlStatus.SetText(9, _T(""));
						}
						// We better not try again. It WON'T work...
						bShutdown = false;
					}
				}
			}
		} else {
			if (ctrlStatus.IsWindow()) {
				if(isShutdownStatus) {
					ctrlStatus.SetText(9, _T(""));
					ctrlStatus.SetIcon(9, NULL);
					isShutdownStatus = false;
				}
			}
		}
	} else if(wParam == AUTO_CONNECT) {
		autoConnect(FavoriteManager::getInstance()->getFavoriteHubs());
	} else if(wParam == PARSE_COMMAND_LINE) {
		parseCommandLine(GetCommandLine());
	} else if(wParam == STATUS_MESSAGE) {
		tstring* msg = (tstring*)lParam;
		if(ctrlStatus.IsWindow()) {
			tstring line = Text::toT("[" + Util::getShortTimeString() + "] ") + *msg;

			ctrlStatus.SetText(0, line.c_str());
			while(lastLinesList.size() + 1 > MAX_CLIENT_LINES)
				lastLinesList.erase(lastLinesList.begin());
			if (line.find(_T('\r')) == tstring::npos) {
				lastLinesList.push_back(line);
			} else {
				lastLinesList.push_back(line.substr(0, line.find(_T('\r'))));
			}
		}
		delete msg;
	} else if(wParam == SHOW_POPUP) {
		Popup* msg = (Popup*)lParam;
		PopupManager::getInstance()->Show(msg->Message, msg->Title, msg->Icon);
		delete msg;
	} else if(wParam == WM_CLOSE) {
		PopupManager::getInstance()->Remove((int)lParam);
	} else if(wParam == REMOVE_POPUP){
		PopupManager::getInstance()->AutoRemove();
	} else if(wParam == SET_PM_TRAY_ICON) {
		if(bIsPM == false && (!WinUtil::isAppActive || bAppMinimized) && bTrayIcon == true) {
			NOTIFYICONDATA nid;
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = m_hWnd;
			nid.uID = 0;
			nid.uFlags = NIF_ICON;
			nid.hIcon = pmicon.hIcon;
			::Shell_NotifyIcon(NIM_MODIFY, &nid);
			bIsPM = true;
		}
    }

	return 0;
}

void MainFrame::parseCommandLine(const tstring& cmdLine)
{
	string::size_type i = 0;
	string::size_type j;

	if( (j = cmdLine.find(_T("dchub://"), i)) != string::npos) {
		WinUtil::parseDchubUrl(cmdLine.substr(j));
		}
	if( (j = cmdLine.find(_T("adc://"), i)) != string::npos) {
		WinUtil::parseADChubUrl(cmdLine.substr(j));
	}
	if( (j = cmdLine.find(_T("magnet:?"), i)) != string::npos) {
		WinUtil::parseMagnetUri(cmdLine.substr(j));
	}
	 // Lua
	if( (j = cmdLine.find(_T("lua "), i)) != string::npos) {
		ScriptManager::getInstance()->EvaluateChunk(Text::fromT(cmdLine.substr(j+4)));
	}
}

LRESULT MainFrame::onCopyData(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM lParam, BOOL& /*bHandled*/) {
	tstring cmdLine = (LPCTSTR) (((COPYDATASTRUCT *)lParam)->lpData);
	parseCommandLine(Text::toT(WinUtil::getAppName() + " ") + cmdLine);
	return true;
}

LRESULT MainFrame::onHashProgress(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	HashProgressDlg(false).DoModal(m_hWnd);
	return 0;
}

LRESULT MainFrame::OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	AboutDlg dlg;
	dlg.DoModal(m_hWnd);
	return 0;
}

LRESULT MainFrame::OnAppInstall(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	InstallDlg dlg(true);
	dlg.DoModal(m_hWnd);
	return 0;
}

LRESULT MainFrame::onNotepad(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	NotepadFrame::openWindow();
	return 0;
}
LRESULT MainFrame::onNotepad2(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	Notepad2Frame::openWindow();
	return 0;
}

LRESULT MainFrame::onNotepad3(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	Notepad3Frame::openWindow();
	return 0;
}

LRESULT MainFrame::onNotepad4(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	Notepad4Frame::openWindow();
	return 0;
}

LRESULT MainFrame::onNotepad5(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	Notepad5Frame::openWindow();
	return 0;
}

LRESULT MainFrame::onOpenWindows(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	switch(wID) {
		case ID_FILE_SEARCH: SearchFrame::openWindow(); break;
		case ID_FILE_CONNECT: PublicHubsFrame::openWindow(); break;
		case IDC_FAVORITES: FavoriteHubsFrame::openWindow(); break;
		case IDC_FAVUSERS: UsersFrame::openWindow(); break;
		case IDC_NOTEPAD: NotepadFrame::openWindow(); break;
		case IDC_NOTEPAD2: Notepad2Frame::openWindow(); break;
		case IDC_NOTEPAD3: Notepad3Frame::openWindow(); break;
		case IDC_NOTEPAD4: Notepad4Frame::openWindow(); break;
		case IDC_NOTEPAD5: Notepad5Frame::openWindow(); break;
		case IDC_QUEUE: QueueFrame::openWindow(); break;
		case IDC_SEARCH_SPY: SpyFrame::openWindow(); break;
		case IDC_FILE_ADL_SEARCH: ADLSearchFrame::openWindow(); break;
		case IDC_NET_STATS: StatsFrame::openWindow(); break; 
		case IDC_FINISHED: FinishedFrame::openWindow(); break;
		case IDC_FINISHED_UL: FinishedULFrame::openWindow(); break;
		case IDC_UPLOAD_QUEUE: WaitingUsersFrame::openWindow(); break;
		case IDC_CDMDEBUG_WINDOW: CDMDebugFrame::openWindow(); break;
		case IDC_RECENTS: RecentHubsFrame::openWindow(); break;
		default: dcassert(0); break;
	}
	return 0;
}

LRESULT MainFrame::OnFileSettings(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	PropertiesDlg dlg(m_hWnd, SettingsManager::getInstance());

	unsigned short lastTCP = static_cast<unsigned short>(SETTING(TCP_PORT));
	unsigned short lastUDP = static_cast<unsigned short>(SETTING(UDP_PORT));
	unsigned short lastTLS = static_cast<unsigned short>(SETTING(TLS_PORT));

	int lastConn = SETTING(INCOMING_CONNECTIONS);

	bool lastSortFavUsersFirst = BOOLSETTING(SORT_FAVUSERS_FIRST);

	if(dlg.DoModal(m_hWnd) == IDOK) 
	{
		SettingsManager::getInstance()->save();
		RSXSettingsManager::getInstance()->save(); 
		if(missedAutoConnect && !SETTING(NICK).empty()) {
			PostMessage(WM_SPEAKER, AUTO_CONNECT);
		}
		if(SETTING(INCOMING_CONNECTIONS) != lastConn || SETTING(TCP_PORT) != lastTCP || SETTING(UDP_PORT) != lastUDP || SETTING(TLS_PORT) != lastTLS) {
			startSocket();
		}
		ClientManager::getInstance()->infoUpdated();

		if(BOOLSETTING(SORT_FAVUSERS_FIRST) != lastSortFavUsersFirst)
			HubFrame::resortUsers();

		if(BOOLSETTING(URL_HANDLER)) {
			WinUtil::registerDchubHandler();
			WinUtil::registerADChubHandler();
			WinUtil::urlDcADCRegistered = true;
		} else if(WinUtil::urlDcADCRegistered) {
			WinUtil::unRegisterDchubHandler();
			WinUtil::unRegisterADChubHandler();
			WinUtil::urlDcADCRegistered = false;
		}
		if(BOOLSETTING(MAGNET_REGISTER)) {
			WinUtil::registerMagnetHandler();
			WinUtil::urlMagnetRegistered = true; 
		} else if(WinUtil::urlMagnetRegistered) {
			WinUtil::unRegisterMagnetHandler();
			WinUtil::urlMagnetRegistered = false;
		}

		UISetCheck(IDC_LIMITER, BOOLSETTING(THROTTLE_ENABLE));

		if(BOOLSETTING(SOUNDS_DISABLED)) ctrlToolbar.CheckButton(IDC_DISABLE_SOUNDS, true);
		else ctrlToolbar.CheckButton(IDC_DISABLE_SOUNDS, false);

		if(BOOLSETTING(THROTTLE_ENABLE)) ctrlToolbar.CheckButton(IDC_LIMITER, true);
		else ctrlToolbar.CheckButton(IDC_LIMITER, false);

		if(Util::getAway()) ctrlToolbar.CheckButton(IDC_AWAY, true);
		else ctrlToolbar.CheckButton(IDC_AWAY, false);

		if(getShutDown()) ctrlToolbar.CheckButton(IDC_SHUTDOWN, true);
		else ctrlToolbar.CheckButton(IDC_SHUTDOWN, false);
	
		updateTray(BOOLSETTING(MINIMIZE_TRAY));
		if(tabsontop != BOOLSETTING(TABS_ON_TOP)) {
			tabsontop = BOOLSETTING(TABS_ON_TOP);
			UpdateLayout();
		}
	}
	return 0;
}
//RSX++
void MainFrame::on(UpdateManagerListener::VersionUpdated, const VersionInfo::Client& client, const VersionInfo::Profiles& profiles) throw() {
	if(client.veryOldVersion >= SVN_REVISION) {
		string msg = "Your version of zK++ contains a serious bug that affects all users of the DC network or the security of your computer.";
		string url = client.url.empty() ? __HOMESITE : client.url;
		if(MessageBox(Text::toT(msg + "\r\nPlease get a new one at " + url).c_str(), _T("Old zK++ version"), MB_YESNO | MB_ICONEXCLAMATION) == IDYES)
			WinUtil::openLink(Text::toT(url));
		oldshutdown = true;
		PostMessage(WM_CLOSE);
		return;
	}

	for(vector<double>::const_iterator i = client.badVersions.begin(); i != client.badVersions.end(); ++i) {
		if(*i == SVN_REVISION) {
			string msg = "Your version of zK++ contains a serious bug that affects all users of the DC network or the security of your computer.";
			string url = client.url.empty() ? __HOMESITE : client.url;
			if(MessageBox(Text::toT(msg + "\r\nPlease get a new one at " + url).c_str(), _T("Old zK++ version"), MB_YESNO | MB_ICONEXCLAMATION) == IDYES)
				WinUtil::openLink(Text::toT(url));
			oldshutdown = true;
			PostMessage(WM_CLOSE);
			return;
		}
	}

	if(::IsWindow(GetDlgItem(IDD_UPDATE)))
		return;

	UpdateDialog dlg(client, profiles);
	if(dlg.isAnyNewVersion(true)) {
		dlg.DoModal();
	}
}

LRESULT MainFrame::onWebServerSocket(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
	WebServerManager::getInstance()->getServerSocket().incoming();
	return 0;
}

LRESULT MainFrame::onGetToolTip(int idCtrl, LPNMHDR pnmh, BOOL& /*bHandled*/) {
	LPNMTTDISPINFO pDispInfo = (LPNMTTDISPINFO)pnmh;
	pDispInfo->szText[0] = 0;

	if((idCtrl != 0) && !(pDispInfo->uFlags & TTF_IDISHWND))
	{
		int stringId = -1;
            switch(idCtrl) {
							 case IDC_CLEAR_ALL_HUB_MAINCHAT: stringId = ResourceManager::MENU_CLEAR_ALL_HUB_MAINCHAT; break;
  	                         case IDC_WINAMP_BACK: stringId = ResourceManager::WINAMP_BACK; break;
  	                         case IDC_WINAMP_PLAY: stringId = ResourceManager::WINAMP_PLAY; break;
  	                         case IDC_WINAMP_PAUSE: stringId = ResourceManager::WINAMP_PAUSE; break;
  	                         case IDC_WINAMP_NEXT: stringId = ResourceManager::WINAMP_NEXT; break;
  	                         case IDC_WINAMP_STOP: stringId = ResourceManager::WINAMP_STOP; break;
  	                         case IDC_WINAMP_VOL_UP: stringId = ResourceManager::WINAMP_VOL_UP; break;
  	                         case IDC_WINAMP_VOL_HALF: stringId = ResourceManager::WINAMP_VOL_HALF; break;
  	                         case IDC_WINAMP_VOL_DOWN: stringId = ResourceManager::WINAMP_VOL_DOWN; break;
  	                         case IDC_WINAMP_SPAM: stringId = ResourceManager::WINAMP_SPAM; break;
							 case IDC_NICK_CREATOR: stringId = ResourceManager::MENU_NICK_CREATOR; break;
							 case IDC_ASCII: stringId = ResourceManager::MENU_ASCII; break;
							 case IDC_ALL_MUSIC: stringId = ResourceManager::MENU_ALL_MUSIC; break;
							 case IDC_MOVIE: stringId = ResourceManager::MENU_MOVIE; break;
							 case IDC_TV: stringId = ResourceManager::MENU_TV; break;
							 case IDC_DNS_INTERCEPTOR: stringId = ResourceManager::MENU_DNS_INTERCEPTOR; break;
							 case IDC_FAQ_BASIC1: stringId = ResourceManager::MENU_FAQ_BASIC1; break;
							 case IDC_FAQ_BASIC2: stringId = ResourceManager::MENU_FAQ_BASIC2; break;
							 case IDC_FAQ_BASIC3: stringId = ResourceManager::MENU_FAQ_BASIC3; break;
							 case IDC_SEARCH_IP: stringId = ResourceManager::MENU_SEARCH_IP; break;
							 case IDC_AVIPREVIEW: stringId = ResourceManager::MENU_AVIPREVIEW; break;
							 case IDC_HUB_CHECK: stringId = ResourceManager::MENU_HUB_CHECK; break;
							 case IDC_PROXY_CHECK: stringId = ResourceManager::MENU_PROXY_CHECK; break;
							 case IDC_HOSTNAME: stringId = ResourceManager::MENU_HOSTNAME; break;
							 case IDC_LAG_WATCH: stringId = ResourceManager::MENU_LAG_WATCH; break;
							 case IDC_SONGR: stringId = ResourceManager::MENU_SONGR; break;
							 case IDC_AUDIO_PLAYER: stringId = ResourceManager::MENU_AUDIO_PLAYER; break;
							 case IDC_WINAMP_CLASSIC: stringId = ResourceManager::MENU_WINAMP_CLASSIC; break;
							 case IDC_MPLAYER_CLASSIC: stringId = ResourceManager::MENU_MPLAYER_CLASSIC; break;
							 case ID_WINDOW_RESTORE_ALL: stringId = ResourceManager::MENU_RESTORE_ALL; break;
							 case ID_WINDOW_MINIMIZE_ALL: stringId = ResourceManager::MENU_MINIMIZE_ALL; break;
							 case IDC_CLOSE_DISCONNECTED: stringId = ResourceManager::MENU_CLOSE_DISCONNECTED; break;
							 case IDC_CLOSE_HUBS_NO_USR: stringId = ResourceManager::MENU_CLOSE_HUBS_EMPTY; break;
							 case IDC_CLOSE_HUBS_BELOW_X: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_X; break;
							 case IDC_CLOSE_HUBS_BELOW_L: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_L; break;
							 case IDC_CLOSE_HUBS_BELOW_C: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_C; break;
							 case IDC_CLOSE_HUBS_BELOW_CCL: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_CCL; break;
							 case IDC_CLOSE_HUBS_BELOW_D: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_D; break;
							 case IDC_CLOSE_HUBS_BELOW_M: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_M; break;
							 case IDC_CLOSE_HUBS_BELOW_MD: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_MD; break;
							 case IDC_CLOSE_HUBS_BELOW_MM: stringId = ResourceManager::MENU_CLOSE_HUBS_BELOW_MM; break;
							 case IDC_CLOSE_ALL_HUBS: stringId = ResourceManager::MENU_CLOSE_ALL_HUBS; break;  	            			 
  	                 }

//		for(int i = 0; WinUtil::ToolbarButtons[i].id != 0; i++) {
//			if(WinUtil::ToolbarButtons[i].id == idCtrl) {
//				stringId = WinUtil::ToolbarButtons[i].tooltip;
//				break;
//			}
//		}
		if(stringId != -1) {
			_tcsncpy(pDispInfo->lpszText, CTSTRING_I((ResourceManager::Strings)stringId), 79);
			pDispInfo->uFlags |= TTF_DI_SETITEM;
		}
	} else { // if we're really in the status bar, this should be detected intelligently
		lastLines.clear();
		for(TStringIter i = lastLinesList.begin(); i != lastLinesList.end(); ++i) {
			lastLines += *i;
			lastLines += _T("\r\n");
		}
		if(lastLines.size() > 2) {
			lastLines.erase(lastLines.size() - 2);
		}
		pDispInfo->lpszText = const_cast<TCHAR*>(lastLines.c_str());
	}
	return 0;
}

void MainFrame::autoConnect(const FavoriteHubEntry::List& fl) {
	missedAutoConnect = false;
	for(FavoriteHubEntry::List::const_iterator i = fl.begin(); i != fl.end(); ++i) {
		FavoriteHubEntry* entry = *i;
		if(entry->getConnect()) {
 			if(!entry->getNick().empty() || !SETTING(NICK).empty()) {
				RecentHubEntry r;
				r.setName(entry->getName());
				r.setDescription(entry->getDescription());
				r.setUsers("*");
				r.setShared("*");
				r.setServer(entry->getServer());
				FavoriteManager::getInstance()->addRecent(r);
				HubFrame::openWindow(Text::toT(entry->getServer())
					, entry->getChatUserSplit(), entry->getUserListState());
 			} else
 				missedAutoConnect = true;
 		}				
	}
}

void MainFrame::updateTray(bool add /* = true */) {
	if(add) {
		if(bTrayIcon == false) {
			NOTIFYICONDATA nid;
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = m_hWnd;
			nid.uID = 0;
			nid.uFlags = NIF_ICON | NIF_TIP | NIF_MESSAGE;
			nid.uCallbackMessage = WM_APP + 242;
			nid.hIcon = normalicon.hIcon;
			_tcsncpy(nid.szTip, _T(APPNAME), 64);
			nid.szTip[63] = '\0';
			lastMove = GET_TICK() - 1000;
			::Shell_NotifyIcon(NIM_ADD, &nid);
			bTrayIcon = true;
		}
	} else {
		if(bTrayIcon) {
			NOTIFYICONDATA nid;
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = m_hWnd;
			nid.uID = 0;
			nid.uFlags = 0;
			::Shell_NotifyIcon(NIM_DELETE, &nid);
			ShowWindow(SW_SHOW);
			bTrayIcon = false;
		}
	}
}

LRESULT MainFrame::onSize(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& bHandled)
{
	if(wParam == SIZE_MINIMIZED) {
		SetProcessWorkingSetSize(GetCurrentProcess(), 0xffffffff, 0xffffffff);
		if(BOOLSETTING(AUTO_AWAY)) {
			if(bAppMinimized == false)
			if(Util::getAway() == true) {
				awaybyminimize = false;
			} else {
				awaybyminimize = true;
				Util::setAway(true);
				setAwayButton(true);
				ClientManager::getInstance()->infoUpdated();
			}
		}

		bAppMinimized = true;
		if(BOOLSETTING(MINIMIZE_TRAY) != WinUtil::isShift()) {
			updateTray(true);
			ShowWindow(SW_HIDE);
			//RsxUtil::changeProcessPriority(1);
		} else {
			updateTray(false);
		}
		maximized = IsZoomed() > 0;
	} else if( (wParam == SIZE_RESTORED || wParam == SIZE_MAXIMIZED) ) {
		//RsxUtil::changeProcessPriority(2);
		if(BOOLSETTING(AUTO_AWAY)) {
			if(awaybyminimize == true) {
				awaybyminimize = false;
				Util::setAway(false);
				setAwayButton(false);
				ClientManager::getInstance()->infoUpdated();
			}
		}
		if(bIsPM && bTrayIcon == true) {
			NOTIFYICONDATA nid;
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = m_hWnd;
			nid.uID = 0;
			nid.uFlags = NIF_ICON;
			nid.hIcon = normalicon.hIcon;
			::Shell_NotifyIcon(NIM_MODIFY, &nid);
			bIsPM = false;
		}
		bAppMinimized = false;
	}

	bHandled = FALSE;
	return 0;
}

LRESULT MainFrame::onEndSession(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/) {
	WINDOWPLACEMENT wp;
	wp.length = sizeof(wp);
	GetWindowPlacement(&wp);
	
	CRect rc;
	GetWindowRect(rc);
	
	if(wp.showCmd == SW_SHOW || wp.showCmd == SW_SHOWNORMAL) {
		SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_POS_X, rc.left);
		SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_POS_Y, rc.top);
		SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_SIZE_X, rc.Width());
		SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_SIZE_Y, rc.Height());
	}
	if(wp.showCmd == SW_SHOWNORMAL || wp.showCmd == SW_SHOW || wp.showCmd == SW_SHOWMAXIMIZED || wp.showCmd == SW_MAXIMIZE)
		SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_STATE, (int)wp.showCmd);
	
	QueueManager::getInstance()->saveQueue();
	SettingsManager::getInstance()->save();
	RSXSettingsManager::getInstance()->save(); 
	return 0;
}

LRESULT MainFrame::OnClose(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled) {
	if(!closing) {
		if( oldshutdown ||(!BOOLSETTING(CONFIRM_EXIT)) || (MessageBox(CTSTRING(REALLY_EXIT), _T(APPNAME) _T(" ") _T(VERSIONSTRING), MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2) == IDYES) ) {
			updateTray(false);
			string tmp1;
			string tmp2;

			WINDOWPLACEMENT wp;
			wp.length = sizeof(wp);
			GetWindowPlacement(&wp);

			CRect rc;
			GetWindowRect(rc);
			if(BOOLSETTING(SHOW_TRANSFERVIEW)) {
				SettingsManager::getInstance()->set(SettingsManager::TRANSFER_SPLIT_SIZE, m_nProportionalPos);
			}
			if(wp.showCmd == SW_SHOW || wp.showCmd == SW_SHOWNORMAL) {
				SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_POS_X, rc.left);
				SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_POS_Y, rc.top);
				SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_SIZE_X, rc.Width());
				SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_SIZE_Y, rc.Height());
			}
			if(wp.showCmd == SW_SHOWNORMAL || wp.showCmd == SW_SHOW || wp.showCmd == SW_SHOWMAXIMIZED || wp.showCmd == SW_MAXIMIZE)
				SettingsManager::getInstance()->set(SettingsManager::MAIN_WINDOW_STATE, (int)wp.showCmd);

			// save bars settings
			WinUtil::saveReBarSettings(m_hWndToolBar);
			
			ShowWindow(SW_HIDE);
			transferView.prepareClose();
			
			WebServerManager::getInstance()->removeListener(this);
			SearchManager::getInstance()->disconnect();
			ConnectionManager::getInstance()->disconnect();
			listQueue.shutdown();

			stopUPnP();

			DWORD id;
			stopperThread = CreateThread(NULL, 0, stopper, this, 0, &id);
			closing = true;
		}
		bHandled = TRUE;
	} else {
		// This should end immediately, as it only should be the stopper that sends another WM_CLOSE
		WaitForSingleObject(stopperThread, 60*1000);
		CloseHandle(stopperThread);
		stopperThread = NULL;
		DestroyIcon(normalicon.hIcon);
		DestroyIcon(hShutdownIcon); 	
		DestroyIcon(pmicon.hIcon);
		bHandled = FALSE;
	}

	return 0;
}

LRESULT MainFrame::onLink(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {

	tstring site;
	bool isFile = false;
	switch(wID) {
		case IDC_HELP_HOMEPAGE: site = _T(__HOMESITE); break;
		case IDC_HELP_GEOIPFILE: site = _T("http://www.maxmind.com/download/geoip/database/GeoIPCountryCSV.zip"); break;
		case IDC_HELP_TRANSLATIONS: site = _T(__HOMESITE); break;
		case IDC_HELP_SERVER_ONE: site = _T(__SERVER_ONE); break;
		case IDC_HELP_SERVER_TWO: site = _T("http://www.codeplex.com/zkpp"); break;
		case IDC_HELP_SERVER_THREE: site = _T(SERVER_THREE); break;
		case IDC_HELP_SERVER_FOUR: site = _T(SERVER_FOUR); break;
		case IDC_HELP_DISCUSS: site = _T(__FORUM); break;
		//case IDC_HELP_FEEDS: site = _T(FEEDS); break;
		case IDC_HELP_DWIZ: site = _T(DWIZ); break;
		case IDC_HELP_HUBBY: site = _T(HUBBY); break;
		case IDC_MOVIE: site = _T("http://www.imdb.com/"); break;
		case IDC_DNS_INTERCEPTOR: site = _T("http://www.dnsstuff.com/"); break;
		case IDC_ALL_MUSIC: site = _T("http://www.allmusic.com/"); break;
		case IDC_TV: site = _T("http://www.tv.com/"); break;
		case IDC_NICK_CREATOR: site = _T("Extras\\Tools\\NickName Creator\\NickNameCreator.exe"); isFile = true; break;
		case IDC_FAQ_BASIC1: site = _T("Extras\\Docs\\HelpzK1.chm"); isFile = true; break;
		case IDC_FAQ_BASIC2: site = _T("Extras\\Docs\\HelpzK2.chm"); isFile = true; break;
		case IDC_FAQ_BASIC3: site = _T("Extras\\Docs\\HelpDC.chm"); isFile = true; break;
		case IDC_OPEN_CLONE: site = _T("zK++.exe"); isFile = true; break;
		case IDC_HUB_CHECK: site = _T("Extras\\Tools\\Hublist Checker\\Hublist Checker.exe"); isFile = true; break;
		case IDC_PROXY_CHECK: site = _T("Extras\\Tools\\DC Proxy Checker\\DC Proxy Checker.exe"); isFile = true; break;
		case IDC_SEARCH_IP: site = _T("Extras\\Tools\\Apps\\Search IP 2.1.exe"); isFile = true; break;
		case IDC_AVIPREVIEW: site = _T("Extras\\Tools\\Apps\\AVIPreview.exe"); isFile = true; break;
		case IDC_CHANGELOG: site = _T("Extras\\Docs\\Changelog.txt"); isFile = true; break;
		case IDC_HOSTNAME: site = _T("Extras\\Tools\\Apps\\Hostname To IP.exe"); isFile = true; break;
		case IDC_SONGR: site = _T("Extras\\Tools\\Songr\\Songr.exe"); isFile = true; break;
		case IDC_LAG_WATCH: site = _T("Extras\\Tools\\Apps\\Lag Check Watch.exe"); isFile = true; break;
		case IDC_AUDIO_PLAYER: site = _T("Extras\\Tools\\Audio Player\\AudioPlayer.exe"); isFile = true; break;
		case IDC_WINAMP_CLASSIC: site = _T("Extras\\Tools\\Winamp Classic\\WINAMP.EXE"); isFile = true; break;
		case IDC_MPLAYER_CLASSIC: site = _T("Extras\\Tools\\Media Player Classic\\mplayerc.exe"); isFile = true; break;
		case IDC_MASTER_BOT: site = _T("Extras\\Tools\\Master Bot\\MasterBot.exe"); isFile = true; break;
		case IDC_DARK_FIGHTER: site = _T("Extras\\Tools\\Dark Fighter\\darkfighter.exe"); isFile = true; break;
		case IDC_PASSWORD: site = _T("Extras\\Tools\\Apps\\Password Generator.exe"); isFile = true; break;
		case IDC_ASCII: site = _T("Extras\\Tools\\Apps\\Ascgen2.exe"); isFile = true; break;
		default: dcassert(0);
	}

	if(isFile)
		WinUtil::openFile(site);
	else
		WinUtil::openLink(site);

	return 0;
}

int MainFrame::run() {
	tstring file;
	if(WinUtil::browseFile(file, m_hWnd, false, lastTTHdir) == IDOK) {
		WinUtil::mainMenu.EnableMenuItem(ID_GET_TTH, MF_GRAYED);
		Thread::setThreadPriority(Thread::LOW);
		lastTTHdir = Util::getFilePath(file);

		string TTH;
		TTH.resize(192*8/(5*8)+1);

		boost::scoped_array<char> buf(new char[512 * 1024]);

		try {
			File f(Text::fromT(file), File::READ, File::OPEN);
			TigerTree tth(TigerTree::calcBlockSize(f.getSize(), 1));

			if(f.getSize() > 0) {
				size_t n = 512*1024;
				while( (n = f.read(&buf[0], n)) > 0) {
					tth.update(&buf[0], n);
					n = 512*1024;
				}
			} else {
				tth.update("", 0);
			}
			tth.finalize();

			strcpy(&TTH[0], tth.getRoot().toBase32().c_str());

			CInputBox ibox(m_hWnd);

			string magnetlink = "magnet:?xt=urn:tree:tiger:"+ TTH +"&xl="+Util::toString(f.getSize())+"&dn="+Util::encodeURI(Text::fromT(Util::getFileName(file)));
			f.close();
			
			ibox.DoModal(_T("Tiger Tree Hash"), file.c_str(), Text::toT(TTH).c_str(), Text::toT(magnetlink).c_str());
		} catch(...) { }
		Thread::setThreadPriority(Thread::NORMAL);
		WinUtil::mainMenu.EnableMenuItem(ID_GET_TTH, MF_ENABLED);
	}
	return 0;
}

LRESULT MainFrame::onGetTTH(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	Thread::start();
	return 0;
}

void MainFrame::UpdateLayout(BOOL bResizeBars /* = TRUE */)
{
	RECT rect;
	GetClientRect(&rect);
	// position bars and offset their dimensions
	UpdateBarsPosition(rect, bResizeBars);
	
	if(ctrlStatus.IsWindow() && ctrlLastLines.IsWindow()) {
		CRect sr;
		int w[10];
		ctrlStatus.GetClientRect(sr);
		w[9] = sr.right - 20;
		w[8] = w[9] - 60;
#define setw(x) w[x] = max(w[x+1] - statusSizes[x], 0)
		setw(7); setw(6); setw(5); setw(4); setw(3); setw(2); setw(1); setw(0);

		ctrlStatus.SetParts(10, w);
		ctrlLastLines.SetMaxTipWidth(w[0]);
	}
	CRect rc = rect;
	if(tabsontop == false)
		rc.top = rc.bottom - ctrlTab.getHeight();
	else
		rc.bottom = rc.top + ctrlTab.getHeight();
	if(ctrlTab.IsWindow())
		ctrlTab.MoveWindow(rc);
	
	CRect rc2 = rect;
	if(tabsontop == false)
		rc2.bottom = rc.top;
	else
		rc2.top = rc.bottom;
	SetSplitterRect(rc2);
}

static const TCHAR types[] = _T("File Lists\0*.xml.bz2\0All Files\0*.*\0");

LRESULT MainFrame::onOpenFileList(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	tstring file;
	
	if(wID == IDC_OPEN_MY_LIST){
		if(!ShareManager::getInstance()->getOwnListFile().empty()){
			DirectoryListingFrame::openWindow(Text::toT(ShareManager::getInstance()->getOwnListFile()), Text::toT(Util::emptyString), ClientManager::getInstance()->getMe(), 0);
		}
		return 0;
	}

	if(WinUtil::browseFile(file, m_hWnd, false, Text::toT(Util::getListPath()), types)) {
		UserPtr u = DirectoryListing::getUserFromFilename(Text::fromT(file));
		if(u) {
			DirectoryListingFrame::openWindow(file, Text::toT(Util::emptyString), u, 0);
		} else {
			MessageBox(CTSTRING(INVALID_LISTNAME), _T(APPNAME) _T(" ") _T(VERSIONSTRING));
		}
	}
	return 0;
}

LRESULT MainFrame::onRefreshFileList(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	ShareManager::getInstance()->setDirty();
	ShareManager::getInstance()->refresh(true);
	return 0;
}
LRESULT MainFrame::onReconnectDisconnected(WORD , WORD , HWND , BOOL& ) {
	HubFrame::reconnectDisconnected();
	return 0;
}

LRESULT MainFrame::onTrayIcon(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM lParam, BOOL& /*bHandled*/) {
	if (lParam == WM_LBUTTONUP) {
		if(bAppMinimized) {
			ShowWindow(SW_SHOW);
			ShowWindow(maximized ? SW_MAXIMIZE : SW_RESTORE);
		} else {
			SetForegroundWindow(m_hWnd);
		}
	} else if(lParam == WM_MOUSEMOVE && ((lastMove + 1000) < GET_TICK()) ) {
		NOTIFYICONDATA nid;
		nid.cbSize = sizeof(NOTIFYICONDATA);
		nid.hWnd = m_hWnd;
		nid.uID = 0;
		nid.uFlags = NIF_TIP;
		tstring s_tip = _T(APPNAME) _T(VERSIONSTRING)	_T("\r\n\r\nD: ") + 
			Util::formatBytesW(DownloadManager::getInstance()->getRunningAverage()) + _T("/s (") + 
			Util::toStringW(DownloadManager::getInstance()->getDownloadCount()) + _T(")\r\nU: ") +
			Util::formatBytesW(UploadManager::getInstance()->getRunningAverage()) + _T("/s (") + 
			Util::toStringW(UploadManager::getInstance()->getUploadCount()) + _T(")") +
			_T("\r\nUptime: ") + Util::formatSeconds(Util::getUptime());
		_tcsncpy(nid.szTip, s_tip.c_str(), 80);
		
		::Shell_NotifyIcon(NIM_MODIFY, &nid);
		lastMove = GET_TICK();
	} else if (lParam == WM_RBUTTONUP) {
		CPoint pt(GetMessagePos());		
		SetForegroundWindow(m_hWnd);
		setDefPrioMenu(); 
		trayMenu.TrackPopupMenu(TPM_RIGHTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, m_hWnd);		
		PostMessage(WM_NULL, 0, 0);
	}
	return 0;
}

void MainFrame::ShowBalloonTip(tstring szMsg, tstring szTitle, DWORD dwInfoFlags) {
	Popup* p = new Popup;
	p->Title = szTitle;
	p->Message = szMsg;
	p->Icon = dwInfoFlags;

	PostMessage(WM_SPEAKER, SHOW_POPUP, (LPARAM)p);
}

LRESULT MainFrame::OnViewToolBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static BOOL bVisible = TRUE;	// initially visible
	bVisible = !bVisible;
	CReBarCtrl rebar = m_hWndToolBar;
	int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST + 2);	// toolbar is 3nd added band
	rebar.ShowBand(nBandIndex, bVisible);
	UISetCheck(ID_VIEW_TOOLBAR, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::SHOW_TOOLBAR, bVisible);
	return 0;
}

//special start
LRESULT MainFrame::OnViewSmallbar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static BOOL bVisible = TRUE;	// initially visible
	bVisible = !bVisible;
	CReBarCtrl rebar = m_hWndToolBar;
	int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST);	// plugin toolbar is 1nd added band
	rebar.ShowBand(nBandIndex, bVisible);
	UISetCheck(ID_VIEW_SMALLBAR, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::VIEW_SMALL_TOOLBAR, bVisible);
	return 0;
}
//special end

LRESULT MainFrame::OnViewWinampBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static BOOL bVisible = TRUE;	// initially visible
	bVisible = !bVisible;
	CReBarCtrl rebar = m_hWndToolBar;
	int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST + 3);	// toolbar is 3rd added band
	rebar.ShowBand(nBandIndex, bVisible);
	UISetCheck(ID_TOGGLE_TOOLBAR, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::SHOW_WINAMP_CONTROL, bVisible);
	anyMF->ctrlToolbar.CheckButton(ID_TOGGLE_TOOLBAR, bVisible);
	return 0;
}
LRESULT MainFrame::OnBossMode(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	if(!BOOLSETTING(BOSS_MODE)) {
		SettingsManager::getInstance()->set(SettingsManager::BOSS_MODE, true);
		normalicon.hIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_BOSS), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
		pmicon.hIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_BOSS_PM), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
		updateTray( BOOLSETTING( MINIMIZE_TRAY ) );
		ShowWindow(SW_SHOWMINIMIZED);
	} else {
		SettingsManager::getInstance()->set(SettingsManager::BOSS_MODE, false);
		normalicon.hIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
		pmicon.hIcon = (HICON)::LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDR_TRAY_PM), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
		updateTray( BOOLSETTING( MINIMIZE_TRAY ) );
	}

//	setNormTrayIcon();

	return 0;
}

LRESULT MainFrame::OnViewQuickSearchBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static BOOL bVisible = TRUE;	// initially visible
	bVisible = !bVisible;
	CReBarCtrl rebar = m_hWndToolBar;
	int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST + 4);	// toolbar is 4th added band
	rebar.ShowBand(nBandIndex, bVisible);
	UISetCheck(ID_TOGGLE_QSEARCH, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::SHOW_QUICK_SEARCH, bVisible);
	return 0;
}

LRESULT MainFrame::OnViewTopmost(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	UISetCheck(IDC_TOPMOST, !BOOLSETTING(TOPMOST));
	SettingsManager::getInstance()->set(SettingsManager::TOPMOST, !BOOLSETTING(TOPMOST));
	toggleTopmost();
	return 0;
}

LRESULT MainFrame::OnViewPluginToolBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	static BOOL bVisible = TRUE;	// initially visible
	bVisible = !bVisible;
	CReBarCtrl rebar = m_hWndToolBar;
	int nBandIndex = rebar.IdToIndex(ATL_IDW_BAND_FIRST); // plugin toolbar is 1st added band
	rebar.ShowBand(nBandIndex, bVisible);
	UISetCheck(ID_VIEW_PLUGIN_TOOLBAR, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::SHOW_PLUGIN_TOOLBAR, bVisible);
	return 0;
}

LRESULT MainFrame::onViewPluginsList(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	PluginsListDlg dlg;
	dlg.DoModal();
	return 0;
}

LRESULT MainFrame::onViewScriptsList(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	ScriptsListDlg dlg;
	dlg.DoModal();
	return 0;
}

LRESULT MainFrame::OnViewStatusBar(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	BOOL bVisible = !::IsWindowVisible(m_hWndStatusBar);
	::ShowWindow(m_hWndStatusBar, bVisible ? SW_SHOWNOACTIVATE : SW_HIDE);
	UISetCheck(ID_VIEW_STATUS_BAR, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::SHOW_STATUSBAR, bVisible);
	return 0;
}

LRESULT MainFrame::OnViewTransferView(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	BOOL bVisible = !transferView.IsWindowVisible();
	if(!bVisible) {	
		if(GetSinglePaneMode() == SPLIT_PANE_NONE)
			SetSinglePaneMode(SPLIT_PANE_TOP);
	} else { 
		if(GetSinglePaneMode() != SPLIT_PANE_NONE)
			SetSinglePaneMode(SPLIT_PANE_NONE);
	}
	UISetCheck(ID_VIEW_TRANSFER_VIEW, bVisible);
	UpdateLayout();
	SettingsManager::getInstance()->set(SettingsManager::SHOW_TRANSFERVIEW, bVisible);
	return 0;
}

LRESULT MainFrame::onCloseWindows(WORD , WORD wID, HWND , BOOL& ) {
	switch(wID) {
	case IDC_CLOSE_DISCONNECTED:		HubFrame::closeDisconnected();		break;
	case IDC_CLOSE_ALL_HUBS:			HubFrame::closeAll();				break;
    case IDC_CLOSE_HUBS_NO_USR:			HubFrame::closeAll(2);				break;
	case IDC_CLOSE_HUBS_BELOW_X:		HubFrame::closeAll(9);		        break;
	case IDC_CLOSE_HUBS_BELOW_L:		HubFrame::closeAll(49);		        break;
	case IDC_CLOSE_HUBS_BELOW_C:		HubFrame::closeAll(99);		        break;
	case IDC_CLOSE_HUBS_BELOW_CCL:		HubFrame::closeAll(249);	        break;
	case IDC_CLOSE_HUBS_BELOW_D:		HubFrame::closeAll(499);	        break;
	case IDC_CLOSE_HUBS_BELOW_M:		HubFrame::closeAll(999);	        break;
	case IDC_CLOSE_HUBS_BELOW_MD:		HubFrame::closeAll(1499);	        break;
	case IDC_CLOSE_HUBS_BELOW_MM:		HubFrame::closeAll(1999);	        break;
	case IDC_CLOSE_ALL_PM:				PrivateFrame::closeAll();			break;
	case IDC_CLOSE_ALL_OFFLINE_PM:		PrivateFrame::closeAllOffline();	break;
	case IDC_CLOSE_ALL_DIR_LIST:		DirectoryListingFrame::closeAll();	break;
	case IDC_CLOSE_ALL_SEARCH_FRAME:	SearchFrame::closeAll();			break;
	case IDC_RECONNECT_DISCONNECTED:	HubFrame::reconnectDisconnected();	break;
	}
	return 0;
}

LRESULT MainFrame::onClearAllMainChat(WORD , WORD , HWND , BOOL& ) {
	HubFrame::onClearAllMainChat();
	return 0;
}

LRESULT MainFrame::onLimiter(WORD , WORD , HWND, BOOL& ) {
	UISetCheck(IDC_LIMITER, !BOOLSETTING(THROTTLE_ENABLE));
	SettingsManager::getInstance()->set(SettingsManager::THROTTLE_ENABLE, !BOOLSETTING(THROTTLE_ENABLE));
	return 0;
}

LRESULT MainFrame::onQuickConnect(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/){
	LineDlg dlg;
	dlg.description = TSTRING(HUB_ADDRESS);
	dlg.title = TSTRING(QUICK_CONNECT);
	if(dlg.DoModal(m_hWnd) == IDOK){
		if(SETTING(NICK).empty())
			return 0;

		tstring tmp = dlg.line;
		// Strip out all the spaces
		string::size_type i;
		while((i = tmp.find(' ')) != string::npos)
			tmp.erase(i, 1);

		RecentHubEntry r;
		r.setName("*");
		r.setDescription("*");
		r.setUsers("*");
		r.setShared("*");
		r.setServer(Text::fromT(tmp));
		FavoriteManager::getInstance()->addRecent(r);
		HubFrame::openWindow(tmp);
	}
	return 0;
}

void MainFrame::on(TimerManagerListener::Second, uint64_t aTick) throw() {
		Util::increaseUptime();
		int64_t diff = (int64_t)((lastUpdate == 0) ? aTick - 1000 : aTick - lastUpdate);
		int64_t updiff = Socket::getTotalUp() - lastUp;
		int64_t downdiff = Socket::getTotalDown() - lastDown;

		TStringList* str = new TStringList();
		str->push_back(Util::getAway() ? TSTRING(AWAY) : _T(""));
		str->push_back(TSTRING(SHARED) + _T(": ") + Util::formatBytesW(ShareManager::getInstance()->getSharedSize()));
		str->push_back(_T("H: ") + Text::toT(Client::getCounts()));
		str->push_back(TSTRING(SLOTS) + _T(": ") + Util::toStringW(UploadManager::getInstance()->getFreeSlots()) + _T('/') + Util::toStringW(UploadManager::getInstance()->getSlots()) + _T(" (") + Util::toStringW(UploadManager::getInstance()->getFreeExtraSlots()) + _T('/') + Util::toStringW(SETTING(EXTRA_SLOTS)) + _T(")"));
		str->push_back(_T("D: ") + Util::formatBytesW(Socket::getTotalDown()));
		str->push_back(_T("U: ") + Util::formatBytesW(Socket::getTotalUp()));
		str->push_back(_T("D: [") + Util::toStringW(DownloadManager::getInstance()->getDownloadCount()) + _T("][") + (SETTING(MAX_DOWNLOAD_SPEED_LIMIT) == 0 ? (tstring)_T("N") : Util::toStringW((int)SETTING(MAX_DOWNLOAD_SPEED_LIMIT)) + _T("k")) + _T("] ") + Util::formatBytesW(downdiff*1000I64/diff) + _T("/s"));
		str->push_back(_T("U: [") + Util::toStringW(UploadManager::getInstance()->getUploadCount()) + _T("][") + (SETTING(MAX_UPLOAD_SPEED_LIMIT) == 0 ? (tstring)_T("N") : Util::toStringW((int)SETTING(MAX_UPLOAD_SPEED_LIMIT)) + _T("k")) + _T("] ") + Util::formatBytesW(updiff*1000I64/diff) + _T("/s"));
		PostMessage(WM_SPEAKER, STATS, (LPARAM)str);

		SettingsManager::getInstance()->set(SettingsManager::TOTAL_UPLOAD, SETTING(TOTAL_UPLOAD) + updiff);
		SettingsManager::getInstance()->set(SettingsManager::TOTAL_DOWNLOAD, SETTING(TOTAL_DOWNLOAD) + downdiff);
		lastUpdate = aTick;
		lastUp = Socket::getTotalUp();
		lastDown = Socket::getTotalDown();
		if(currentPic != SETTING(BACKGROUND_IMAGE)) {
			currentPic = SETTING(BACKGROUND_IMAGE);
			m_PictureWindow.Load(Text::toT(currentPic).c_str());
		}

		if(BOOLSETTING(THROTTLE_ENABLE)) {
			// Limitery sem a tam, vsude kam se podivam :o)
			if( SETTING(MAX_UPLOAD_SPEED_LIMIT_NORMAL) > 0) {
				if( SETTING(MAX_UPLOAD_SPEED_LIMIT_NORMAL) < (1 * UploadManager::getInstance()->getSlots()) ) {
					SettingsManager::getInstance()->set(SettingsManager::MAX_UPLOAD_SPEED_LIMIT_NORMAL, (1 * UploadManager::getInstance()->getSlots()) );
				}
				if ( (SETTING(MAX_DOWNLOAD_SPEED_LIMIT_NORMAL) > ( SETTING(MAX_UPLOAD_SPEED_LIMIT_NORMAL) * 9999)) || ( SETTING(MAX_DOWNLOAD_SPEED_LIMIT_NORMAL) == 0) ) {
					SettingsManager::getInstance()->set(SettingsManager::MAX_DOWNLOAD_SPEED_LIMIT_NORMAL, (SETTING(MAX_UPLOAD_SPEED_LIMIT_NORMAL)*9999) );
				}
			}

			if( SETTING(MAX_UPLOAD_SPEED_LIMIT_TIME) > 0) {
				if( SETTING(MAX_UPLOAD_SPEED_LIMIT_TIME) < (1 * UploadManager::getInstance()->getSlots()) ) {
					SettingsManager::getInstance()->set(SettingsManager::MAX_UPLOAD_SPEED_LIMIT_TIME, (1 * UploadManager::getInstance()->getSlots()) );
				}
				if ( (SETTING(MAX_DOWNLOAD_SPEED_LIMIT_TIME) > ( SETTING(MAX_UPLOAD_SPEED_LIMIT_TIME) * 9999)) || ( SETTING(MAX_DOWNLOAD_SPEED_LIMIT_TIME) == 0) ) {
					SettingsManager::getInstance()->set(SettingsManager::MAX_DOWNLOAD_SPEED_LIMIT_TIME, (SETTING(MAX_UPLOAD_SPEED_LIMIT_TIME)*9999) );
				}
			}

			time_t currentTime;
			time(&currentTime);
			int currentHour = localtime(&currentTime)->tm_hour;
			if (SETTING(TIME_DEPENDENT_THROTTLE) &&
				((SETTING(BANDWIDTH_LIMIT_START) < SETTING(BANDWIDTH_LIMIT_END) &&
					currentHour >= SETTING(BANDWIDTH_LIMIT_START) && currentHour < SETTING(BANDWIDTH_LIMIT_END)) ||
				(SETTING(BANDWIDTH_LIMIT_START) > SETTING(BANDWIDTH_LIMIT_END) &&
					(currentHour >= SETTING(BANDWIDTH_LIMIT_START) || currentHour < SETTING(BANDWIDTH_LIMIT_END)))))
			{
				//want to keep this out of the upload limiting code proper, where it might otherwise work more naturally
				SettingsManager::getInstance()->set(SettingsManager::MAX_UPLOAD_SPEED_LIMIT, SETTING(MAX_UPLOAD_SPEED_LIMIT_TIME));
				SettingsManager::getInstance()->set(SettingsManager::MAX_DOWNLOAD_SPEED_LIMIT, SETTING(MAX_DOWNLOAD_SPEED_LIMIT_TIME));
			} else {
				SettingsManager::getInstance()->set(SettingsManager::MAX_UPLOAD_SPEED_LIMIT, SETTING(MAX_UPLOAD_SPEED_LIMIT_NORMAL));
				SettingsManager::getInstance()->set(SettingsManager::MAX_DOWNLOAD_SPEED_LIMIT, SETTING(MAX_DOWNLOAD_SPEED_LIMIT_NORMAL));
			}
		} else {
			SettingsManager::getInstance()->set(SettingsManager::MAX_UPLOAD_SPEED_LIMIT, 0);
			SettingsManager::getInstance()->set(SettingsManager::MAX_DOWNLOAD_SPEED_LIMIT, 0);
		}		
	}

void MainFrame::on(PartialList, const UserPtr& aUser, const string& text) throw() {
	PostMessage(WM_SPEAKER, BROWSE_LISTING, (LPARAM)new DirectoryBrowseInfo(aUser, text));
}

void MainFrame::on(QueueManagerListener::Finished, const QueueItem* qi, const string& dir, const Download* download) throw() {
	if(qi->isSet(QueueItem::FLAG_CLIENT_VIEW)) {
		if(qi->isSet(QueueItem::FLAG_USER_LIST)) {
			// This is a file listing, show it...
			DirectoryListInfo* i = new DirectoryListInfo(qi->getDownloads()[0]->getUser(), Text::toT(qi->getListName()), Text::toT(dir), download->getAverageSpeed());

			PostMessage(WM_SPEAKER, DOWNLOAD_LISTING, (LPARAM)i);
		} else if(qi->isSet(QueueItem::FLAG_TEXT)) {
                        if (BOOLSETTING(EXTERNAL_PREVIEW)) // !SMT!-UI
                                ShellExecute(NULL, NULL, Text::toT(qi->getTarget()).c_str(), NULL, NULL, SW_SHOW); // !SMT!-UI
                        else
			PostMessage(WM_SPEAKER, VIEW_FILE_AND_DELETE, (LPARAM) new tstring(Text::toT(qi->getTarget())));
		}
	} else if(qi->isSet(QueueItem::FLAG_USER_LIST) && qi->isSet(QueueItem::FLAG_CHECK_FILE_LIST)) {
		DirectoryListInfo* i = new DirectoryListInfo(qi->getDownloads()[0]->getUser(), Text::toT(qi->getListName()), Text::toT(dir), download->getAverageSpeed());
		
		if(listQueue.stop) {
			listQueue.stop = false;
			listQueue.start();
		}
		{
			Lock l(listQueue.cs);
			listQueue.fileLists.push_back(i);
		}
		listQueue.s.signal();
	}	
}

LRESULT MainFrame::onActivateApp(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& bHandled) {
	bHandled = FALSE;
	WinUtil::isAppActive = (wParam == 1);	//wParam == TRUE if window is activated, FALSE if deactivated
	if(wParam == 1) {
		if(bIsPM && bTrayIcon == true) {
			NOTIFYICONDATA nid;
			nid.cbSize = sizeof(NOTIFYICONDATA);
			nid.hWnd = m_hWnd;
			nid.uID = 0;
			nid.uFlags = NIF_ICON;
			nid.hIcon = normalicon.hIcon;
			::Shell_NotifyIcon(NIM_MODIFY, &nid);
			bIsPM = false;
		}
	}
	return 0;
}

LRESULT MainFrame::onAppCommand(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM lParam, BOOL& /*bHandled*/) {
		if(GET_APPCOMMAND_LPARAM(lParam) == APPCOMMAND_BROWSER_FORWARD)
		ctrlTab.SwitchTo();
	if(GET_APPCOMMAND_LPARAM(lParam) == APPCOMMAND_BROWSER_BACKWARD)
		ctrlTab.SwitchTo(false);
	
	return TRUE;
}

LRESULT MainFrame::onAway(WORD , WORD , HWND, BOOL& ) {
	if(Util::getAway()) { 
		setAwayButton(false);
		Util::setAway(false);
	} else {
		setAwayButton(true);
		Util::setAway(true);
	}
	ClientManager::getInstance()->infoUpdated();
	return 0;
}

LRESULT MainFrame::onUpdate(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	UpdateDialog dlg;
	dlg.DoModal();
	return S_OK;
}

LRESULT MainFrame::onDisableSounds(WORD /*wNotifyCode*/, WORD /*wID*/, HWND hWndCtl, BOOL& /*bHandled*/) {
	if(hWndCtl != ctrlToolbar.m_hWnd) {
		ctrlToolbar.CheckButton(IDC_DISABLE_SOUNDS, !BOOLSETTING(SOUNDS_DISABLED));
	}
	SettingsManager::getInstance()->set(SettingsManager::SOUNDS_DISABLED, !BOOLSETTING(SOUNDS_DISABLED));
	return 0;
}

void MainFrame::on(WebServerListener::Setup) throw() {
	WSAAsyncSelect(WebServerManager::getInstance()->getServerSocket().getSock(), m_hWnd, WEBSERVER_SOCKET_MESSAGE, FD_ACCEPT);
}

void MainFrame::on(WebServerListener::ShutdownPC, int action) throw() {
	WinUtil::shutDown(action);
}

int MainFrame::FileListQueue::run() {
	setThreadPriority(Thread::LOW);

	while(true) {
		s.wait(15000);
		if(stop || fileLists.empty()) {
			break;
		}

		DirectoryListInfo* i;
		{
			Lock l(cs);
			i = fileLists.front();
			fileLists.pop_front();
		}
		if(Util::fileExists(Text::fromT(i->file))) {
			DirectoryListing* dl = new DirectoryListing(i->user);
			try {
				dl->loadFile(Text::fromT(i->file));
				ADLSearchManager::getInstance()->matchListing(*dl);
				ClientManager::getInstance()->checkCheating(i->user, dl);
			} catch(...) {
			}
			delete dl;
			if(RSXBOOLSETTING(DELETE_CHECKED_FILELISTS)) {
				File::deleteFile(Text::fromT(i->file));
			}
		}
		delete i;
	}
	stop = true;
	return 0;
}

LRESULT MainFrame::onDestroy(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled) {
	LogManager::getInstance()->removeListener(this);
	QueueManager::getInstance()->removeListener(this);
	TimerManager::getInstance()->removeListener(this);

	if(bTrayIcon) {
		updateTray(false);
	}
	bHandled = FALSE;
	return 0;
}

LRESULT MainFrame::onTrayLimiter(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	Util::setLimiter(!BOOLSETTING(THROTTLE_ENABLE));
	MainFrame::setLimiterButton(!BOOLSETTING(THROTTLE_ENABLE));
	
	ClientManager::getInstance()->infoUpdated();
	return 0;
}

LRESULT MainFrame::onLockToolbars(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	UISetCheck(IDC_LOCK_TOOLBARS, !BOOLSETTING(LOCK_TOOLBARS));
	SettingsManager::getInstance()->set(SettingsManager::LOCK_TOOLBARS, !BOOLSETTING(LOCK_TOOLBARS));
	toggleLockToolbars();
	return 0;
}

LRESULT MainFrame::onSwitchWindow(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	ctrlTab.SwitchWindow(wID - ID_SWINDOW_1);
	return 0;
}

LRESULT MainFrame::onContextMenu(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled) {
	if(reinterpret_cast<HWND>(wParam) == m_hWndToolBar) {
		POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };        // location of mouse click
		tbMenu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, m_hWnd);

		return TRUE; 
	}

	bHandled = FALSE;
	return FALSE;
}

void MainFrame::toggleTopmost() const {
	DWORD dwExStyle = (DWORD)GetWindowLong(GWL_EXSTYLE);
	CRect rc;
	GetWindowRect(rc);
	HWND order = (dwExStyle & WS_EX_TOPMOST) ? HWND_NOTOPMOST : HWND_TOPMOST;
	::SetWindowPos(m_hWnd, order, rc.left, rc.top, rc.Width(), rc.Height(), SWP_SHOWWINDOW);
}

void MainFrame::toggleLockToolbars() const {
	CReBarCtrl rbc = m_hWndToolBar;
	REBARBANDINFO rbi;
	rbi.cbSize = sizeof(rbi);
	rbi.fMask  = RBBIM_STYLE;
	int nCount  = rbc.GetBandCount();
	for (int i  = 0; i < nCount; i++) {
		rbc.GetBandInfo(i, &rbi);
		rbi.fStyle ^= RBBS_NOGRIPPER | RBBS_GRIPPERALWAYS;
		rbc.SetBandInfo(i, &rbi);
	}
}

LRESULT MainFrame::onChangePriority(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	switch(wID){
		case IDC_CHANGE_PRIO_IDLE:		RsxUtil::changeProcessPriority(RsxUtil::IDLE);			break;
		case IDC_CHANGE_PRIO_BELOW:		RsxUtil::changeProcessPriority(RsxUtil::BELOW_NORMAL);	break;
		case IDC_CHANGE_PRIO_NORMAL:	RsxUtil::changeProcessPriority(RsxUtil::NORMAL);		break;
		case IDC_CHANGE_PRIO_ABOVE:		RsxUtil::changeProcessPriority(RsxUtil::ABOVE_NORMAL);	break;
		case IDC_CHANGE_PRIO_HIGH:		RsxUtil::changeProcessPriority(RsxUtil::HIGH);			break;
		case IDC_CHANGE_PRIO_REALTIME:	RsxUtil::changeProcessPriority(RsxUtil::REALTIME);		break;
	}
	return 0;
}

void MainFrame::setDefPrioMenu() {
	switch(GetPriorityClass(GetCurrentProcess())) {
		case IDLE_PRIORITY_CLASS:			prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_IDLE);		break;
		case BELOW_NORMAL_PRIORITY_CLASS:	prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_BELOW);		break;
		case NORMAL_PRIORITY_CLASS:			prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_NORMAL);	break;
		case ABOVE_NORMAL_PRIORITY_CLASS:	prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_ABOVE);		break;
		case HIGH_PRIORITY_CLASS:			prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_HIGH);		break;
		case REALTIME_PRIORITY_CLASS:		prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_REALTIME);	break;
		default:							prioMenu.SetMenuDefaultItem(IDC_CHANGE_PRIO_NORMAL);	break;
	}
}
 //favs importer
LRESULT MainFrame::onImportFavorites(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/) {
	FileConverterDlg dlg;
	dlg.DoModal(m_hWnd);
	return 0;
}
/**
 * @file
 * $Id: MainFrm.cpp,v 1.20 2004/07/21 13:15:15 bigmuscle Exp
 */