-- Hubcommands.lua by Hungarista
-- Sends some predefined commands to the given hub on login
-- Requested by qwas
-- 2oo8.o6.o7.

tCommands = {
["myhub.com:1421"] = 
	{
	"!mycustomcommand",
	"!yetanothercommand",
	"!lastcommand",
	},
["examplehub.no-ip.org:411"] = 
	{
	"!examplecommand",
	"!nicecommand",
	},
["lastexample.no-ip.biz:327"] = 
	{
	"!justonecommand",
	},
}

-- The table above contains the hub's addresses and the command(s) you want to send
-- Even if you modify it, follow the structure. You have to specify the port every time, even if it's the default (411)
dcpp:setListener("raw","commands",
-- Set up a listener, which is called every time a message comes from the hub
-- The second parameter 'commands' is the name (rather: ID), with which we can shut down this later
-- with the following command: /lua dcpp:setListener("raw","commands")
function(hub,data)
-- This listener generates a function event, which parameter's are the hub the data came from and the data itself
	if data:sub(1,7) == "$OpList" then
		-- When we get the first $OpList, we are connected
		local hubaddress = hub:getAddress()
		-- hub:getAddress() returns with the hub's address and port
		if tCommands[hubaddress] and not tCommands[hubaddress]["bSent"] then
		-- If our table has a key with the hubaddress, and we haven't send it yet, we can send it's messages now
			for index,command in ipairs(tCommands[hubaddress]) do
			-- Iterate through it's table, command will be command you've added
				hub:sendChat(command)
				tCommands[hubaddress]["bSent"] = true
				-- Set the 'bSent' key to true to avoid sending on every $OpList command
			end -- close for
		end -- close if
	end -- close if
end) -- close function (don't forget closing ')' for listener!)

DC():PrintDebug(" *** Hubcommands.lua loaded")
-- Show if it's been successfully loaded