// @Prolog: #include "stdinc.h"
// @Prolog: #include "DCPlusPlus.h"
// @Prolog: #include "ResourceManager.h"
// @Strings: std::string dcpp::ResourceManager::strings[]
// @Names: std::string dcpp::ResourceManager::names[]

enum Strings { // @DontAdd
	ACCEPTED_DISCONNECTS, // "Accepted Disconnects"
	ACCEPTED_TIMEOUTS, // "Accepted Timeouts"
	ACTIVE, // "Active"
	ACTIVE_SEARCH_STRING, // "Enabled / Search String"
	ADD, // "Add"
	ADD_AS_SOURCE, // "Add as source"
	ADD_FINISHED_INSTANTLY, // "Add finished files to share instantly (if shared)"
	ADD_TO_FAVORITES, // "Add To Favorites"
	ADDED, // "Added"
	ADL_SEARCH, // "Automatic Directory Listing Search"
	ADLS_DESTINATION, // "Destination Directory"
	ADLS_DISCARD, // "Discard"
	ADLS_DOWNLOAD, // "Download Matches"
	ADLS_ENABLED, // "Enabled"
	ADLS_FULL_PATH, // "Full Path"
	ADLS_PROPERTIES, // "ADLSearch Properties"
	ADLS_SEARCH_STRING, // "Search String"
	ADLS_SIZE_MAX, // "Max FileSize"
	ADLS_SIZE_MIN, // "Min FileSize"
	ADLS_TYPE, // "Search Type"
	ADLS_UNITS, // "Size Type"
	ALL, // "All"
	ALL_3_USERS_OFFLINE, // "All 3 users offline"
	ALL_4_USERS_OFFLINE, // "All 4 users offline"
	ALL_DOWNLOAD_SLOTS_TAKEN, // "All download slots taken"
	ALL_FILE_SLOTS_TAKEN, // "All file slots taken"
	ALL_USERS_OFFLINE, // "All %d users offline"
	ALTERNATES_SEND, // "Searching TTH alternates for: "
	ANTI_PASSIVE_SEARCH, // "-- WARNING --\r\n-- You are in active mode, but have activated passive search. --\r\n-- Don't use passive search if you have search results without this option --\r\n-- because you don't get search result from passive clients !!! --\r\n-- Turn it off in settings => zK++ => Always use Passive Mode for Search --\r\n"
	ANY, // "Any"
	AT_LEAST, // "At least"
	AT_MOST, // "At most"
	AUDIO, // "Audio"
	AUTO, // "Auto"
	AUTO_CONNECT, // "Auto connect / Name"
	AUTO_GRANT, // "Auto grant slot / Nick"
	AUTOMATIC, // "Automatic"
	AVERAGE, // "Average/s: "
	AVERAGE_UPLOAD, // "Upload Speed"
	AWAY, // "Away Mode"
	AWAY_MODE_OFF, // "Away mode off"
	AWAY_MODE_ON, // "Away mode on: "
	LIMITER_OFF, // "Transfer limiter disabled"
	LIMITER_ON, // "Transfer limiter enabled"
	B, // "B"
	BACKGROUND_IMAGE, // "Background Image"
	BALLOON_POPUPS, // "Balloon Popups"
	BITZI_LOOKUP, // "Bitzi Lookup"
	BOTH_USERS_OFFLINE, // "Both users offline"
	BROWSE, // "Browse..."
	BROWSE_ACCEL, // "Browse..."
	BROWSE_FILE_LIST, // "Browse File List"
	BUMPED, // "Bumped"
	CANCEL, // "Cancel"
	CERTIFICATE_GENERATED, // "Generated new TLS certificate"
	CERTIFICATE_NOT_TRUSTED, // "Certificate not trusted, unable to connect"
	CERTIFICATE_GENERATION_FAILED, // "TLS disabled, failed to generate certificate: "
	CHEATING_DESCRIPTION, // "Cheating Description"
	CID, // "CID"
	CIPHER, // "Cipher"
	CLEAR, // "Clear"
	CLIENTID, // "Client"
	CLOSE, // "Close"
	CLOSE_CONNECTION, // "Close connection"
	COLLAPSE_ALL, // "Collapse All"
	COLOR_FAST, // "User with fireball"
	COLOR_OP, // "User is OP"
	COLOR_PASIVE, // "Passive user"
	COLOR_SERVER, // "User with server"
	COMMAND_TOO_LONG, // "Maximum command length exceeded"
	COMMENT, // "Comment"
	COMPRESSED, // "Compressed"
	COMPRESSION_ERROR, // "Error during compression"
	CONFIGURE, // "Configure"
	CONFIGURED_HUB_LISTS, // "Configured Public Hub Lists"
	CONNECT, // "Connect"
	CONNECT_ALL, // "Connect to all users"
	CONNECT_FAVUSER_HUB, // "Connect to hub"
	CONNECTED, // "Connected"
	CONNECTING, // "Connecting..."
	CONNECTING_FORCED, // "Connecting (forced)..."
	CONNECTING_TO, // "Connecting to "
	CONNECTING_TO_SERVER, // "Connecting to server"
	CONNECTION, // "Connection"
	CONNECTION_CLOSED, // "Connection closed"
	CONNECTION_ERROR, // "Connection error"
	CONNECTION_TIMEOUT, // "Connection timeout"
	CONTINUE_SEARCH, // "Continue Search"
	COPY, // "Copy"
	COPY_HUB, // "Copy address to clipboard"
	COPY_LINE, // "Copy actual line"
	COPY_MAGNET_LINK, // "Copy magnet link to clipboard"
	COPY_NICK, // "Copy nick"
	COPY_URL, // "Copy URL"
	CORAL, // "Use Coral network when downloading hub lists (improves reliability)"
	COULD_NOT_OPEN_TARGET_FILE, // "Could not open target file: "
	COUNT, // "Count"
	COUNTRY, // "Country"
	CREATING_HASH, // "Hashing"
	CURRENT_VERSION, // "Current version"
	DATA_RETRIEVED, // "Data retrieved"
	DECOMPRESSION_ERROR, // "Error during decompression"
	DEFAULT, // "Default"
	DESCRIPTION, // "Description"
	DESTINATION, // "Destination"
	DIRECTORY, // "Directory"
	DIRECTORY_ADD_ERROR, // "Directory or directory name already exists"
	DISABLE_SOUNDS, // "Disable Sounds"
	DISABLED, // "Disabled"
	DISCONNECT_ALL, // "Disconnect all users"
	DISCONNECT_USER, // "Disconnect user(s)"
	DISCONNECTED, // "Disconnected"
	DISCONNECTED_USER, // "Disconnected user leaving the hub: "
	DOCUMENT, // "Document"
	DONE, // "Done"
	DONT_ADD_SEGMENT_TEXT, // "Don't begin new segment if overall file speed is over"
	DONT_REMOVE_SLASH_PASSWORD, // "Don't remove /password before your password"
	DONT_SHARE_TEMP_DIRECTORY, // "The temporary download directory cannot be shared"
	DOWNLOAD, // "Download"
	DOWNLOAD_FAILED, // "Download failed: "
	DOWNLOAD_FINISHED_IDLE, // "Download finished, idle..."
	DOWNLOAD_QUEUE, // "Download queue"
	DOWNLOAD_STARTING, // "Download starting..."
	DOWNLOAD_TO, // "Download to..."
	DOWNLOAD_WHOLE_DIR, // "Download whole directory"
	DOWNLOAD_WHOLE_DIR_TO, // "Download whole directory to..."
	DOWNLOAD_WITH_PRIORITY, // "Download with priority..."
	DOWNLOADED, // "Downloaded"
	DOWNLOADED_BYTES, // "Downloaded %s (%.01f%%) in %s"
	DOWNLOADED_FROM, // " downloaded from "
	DOWNLOADED_PARTS, // "Downloaded parts"
	DOWNLOADING, // "Downloading..."
	DOWNLOADING_HUB_LIST, // "Downloading public hub list..."
	DOWNLOADING_LIST, // "Downloading list..."
	DU, // "Down/Up:"
	DUPLICATE_SOURCE, // "Duplicate source"
	EB, // "EB"
	EDIT_ACCEL, // "Edit"
	EMAIL, // "E-Mail"
	ENABLE_MULTI_SOURCE, // "Enable multi-source"
	ENTER_NICK, // "Please enter a nickname in the settings dialog!"
	ENTER_PASSWORD, // "Password"
	ENTER_PASSWORD_ZK, // "Please, enter a password"
	ENTER_SEARCH_STRING, // "Enter search string"
	ERROR_CREATING_HASH_DATA_FILE, // "Error creating hash data file: "
	ERROR_CREATING_REGISTRY_KEY_ADC, // "Error creating adc registry key"
	ERROR_CREATING_REGISTRY_KEY_DCHUB, // "Error creating dchub registry key"
	ERROR_CREATING_REGISTRY_KEY_MAGNET, // "Error creating magnet registry key"
	ERROR_HASHING, // "Error hashing "
	ERROR_SAVING_HASH, // "Error saving hash data: "
	ERRORS, // "Errors"
	EXACT_SHARED, // "Exact Share"
	EXACT_SIZE, // "Exact size"
	EXECUTABLE, // "Executable"
	EXPAND_ALL, // "Expand All"
	EXPANDED_RESULTS, // "Expand search results"
	EXTRA_HUB_SLOTS, // "Slot ratio"
	EXTRA_SLOTS_SET, // "Extra slots set"
	FAILED_TO_SHUTDOWN, // "Failed to shutdown!"
	FAILED_TO_LOAD_CERTIFICATE, // "Failed to load certificate file"
	FAILED_TO_LOAD_PRIVATE_KEY, // "Failed to load private key"
	FAV_JOIN_SHOWING_OFF, // "Join/part of favorite users showing off"
	FAV_JOIN_SHOWING_ON, // "Join/part of favorite users showing on"
	FAVORITE_DIR_NAME, // "Favorite name"
	FAVORITE_DIR_NAME_LONG, // "Under what name you see the directory"
	FAVORITE_HUB_ADDED, // "Favorite hub added"
	FAVORITE_HUB_ALREADY_EXISTS, // "Hub already exists as a favorite"
	FAVORITE_HUB_DOES_NOT_EXIST, // "This hub is not a favorite hub"
	FAVORITE_HUB_IDENTITY, // "Identification (leave blank for defaults)"
	FAVORITE_HUB_PROPERTIES, // "Favorite Hub Properties"
	FAVORITE_HUB_REMOVED, // "Favorite hub removed"
	FAVORITE_HUBS, // "Favorite Hubs"
	FAVORITE_USER_ADDED, // "Favorite user added"
	FAVORITE_USERS, // "Favorite Users"
	FAVUSER_ONLINE, // "Favorite user online"
	FILE, // "File"
	FILE_LIST, // "file list"
	FILE_LIST_DIFF, // "Subtract list"
	FILE_LIST_REFRESH_FAILED, // "File list refresh failed: "
	FILE_LIST_REFRESH_FINISHED, // "File list refresh finished"
	FILE_LIST_REFRESH_IN_PROGRESS, // "File list refresh in progress, please wait for it to finish before trying to refresh again"
	FILE_LIST_REFRESH_INITIATED, // "File list refresh initiated"
	FILE_NOT_AVAILABLE, // "File not available"
	FILE_TYPE, // "File type"
	FILE_WITH_DIFFERENT_SIZE, // "A file with a different size already exists in the queue"
	FILE_WITH_DIFFERENT_TTH, // "A file with diffent tth root already exists in the queue"
	FILENAME, // "Filename"
	FILES, // "Files"
	FILES_LEFT, // "files left"
	FILES_PER_HOUR, // "files/h"
	FILTER, // "Filter"
	FILTERED, // "Filtered"
	FIND, // "Find"
	FINISHED_DOWNLOAD, // "Download finished: %s"
	FINISHED_DOWNLOADS, // "Finished Downloads"
	FINISHED_UPLOAD, // "Upload finished: %s To: %s"
	FINISHED_UPLOADS, // "Finished Uploads"
	FOLDER, // "Folder"
	FORBIDDEN, // "Forbidden"
	FORCE_ATTEMPT, // "Force attempt"
	GB, // "GB"
	GENERATE_CERTIFICATES, // "Generate Certificates"
	GET_FILE_LIST, // "Get File List"
	GET_USER_RESPONSES, // "Get User Response"
	GO_TO_DIRECTORY, // "Go to directory"
	GRANT_EXTRA_SLOT, // "Grant extra slot (10 min)"
	GRANT_EXTRA_SLOT_DAY, // "Grant extra slot (day)"
	GRANT_EXTRA_SLOT_HOUR, // "Grant extra slot (hour)"
	GRANT_EXTRA_SLOT_WEEK, // "Grant extra slot (week)"
	GRANT_SLOTS_MENU, // "Extra Slots"
	GROUP_SEARCH_RESULTS, // "Group search results by TTH"
	HASH_DATABASE, // "Hash database"
	HASH_PROGRESS, // "Creating file index..."
	HASH_PROGRESS_BACKGROUND, // "Run in Background"
	HASH_PROGRESS_STATS, // "Statistics"
	HASH_PROGRESS_TEXT, // "Please wait while zK++ indexes your files (they won't be shared until they've been indexed)..."
	HASH_READ_FAILED, // "Unable to read hash data file"
	HASH_REBUILT, // "Hash database rebuilt"
	HASHING_FAILED, // "Hashing failed: "
	HASHING_FINISHED, // "Finished hashing: "
	HIBERNATE, // "Hibernate"
	HIGH, // "High"
	HIGHER, // "Higher"
	HIGHEST, // "Highest"
	HISTORY, // "History"
	HIT_COUNT, // "Hits"
	HIT_RATIO, // "Hit Ratio: "
	HITS, // "Hits: "
	HUB, // "Hub"
	HUB_ADDRESS, // "Hub Address"
	HUB_CONNECTED, // "Hub connected"
	HUB_DISCONNECTED, // "Hub disconnected"
	HUB_LIST, // "Hublist"
	HUB_LIST_DOWNLOADED, // "Hub list downloaded..."
	HUB_LIST_EDIT, // "Edit the hublist"
	HUB_LIST_LOADED_FROM_CACHE, // "Hub list loaded from cache..."
	HUB_NAME, // "Name"
	HUB_SEGMENTS, // "Hub / Segments"
	HUB_TOPIC, // "Hub Topic :"
	HUB_USERS, // "Users"
	HUBS, // "Hubs"
	CHATDBLCLICKACTION, // "Chat double click on user action"
	CHEATING_USER, // "Cheating user found"
	CHECK_0BYTE_SHARE, // "zero bytes real size"
	CHECK_FILELIST, // "Check File List"
	CHECK_FORBIDDEN, // "Shared forbidden file : %s"
	CHECK_INFLATED, // "filelist was inflated %s times"
	CHECK_MISMATCHED_SHARE_SIZE, // "Mismatched share size - "
	CHECK_ON_CONNECT, // "Check user on join"
	CHECK_SHOW_REAL_SHARE, // ", stated size = %[userSSshort], real size = %[userRSshort]"
	CHECKING_CLIENT, // "Checking client..."
	CHOOSE_FOLDER, // "Choose folder"
	IGNORE_TTH_SEARCHES, // "Ignore TTH searches"
	IGNORE_USER, // "Ignore User"
	IGNORED_MESSAGE, // "Ignored message: "
	INCOMPLETE_FAV_HUB, // "Hub address cannot be empty."
	INVALID_LISTNAME, // "Invalid file list name"
	INVALID_NUMBER_OF_SLOTS, // "Invalid number of slots"
	INVALID_SIZE, // "Invalid size"
	INVALID_TARGET_FILE, // "Invalid target file (missing directory, check default download directory setting)"
	INVALID_TREE, // "Full tree does not match TTH root"
	IP, // "Ip: "
	IP_BARE, // "Ip"
	ITEMS, // "Items"
	JOIN_SHOWING_OFF, // "Join/part showing off"
	JOIN_SHOWING_ON, // "Join/part showing on"
	JOINS, // "Joins: "
	KB, // "kB"
	KBPS, // "kB/s"
	KICK_USER, // "Kick User(s)"
	KICK_USER_FILE, // "Kick user(s) with filename"
	LARGER_TARGET_FILE_EXISTS, // "A file of equal or larger size already exists at the target location"
	LAST_HUB, // "Hub (last seen on if offline)"
	LAST_CHANGE, // "Last change: "
	LAST_SEEN, // "Time last seen"
	LATEST_VERSION, // "Latest version"
	LEFT, // "left"
	LEFT_COLOR, // "Left color"
	LIB_CRASH, // "Application ""%s"" caused an unhandled exception in zK++. Please uninstall it, upgrade it or use an alternate product."
	LIMIT, // "Upload Limit"
	LISTENER_FAILED, // "Listening socket failed (you need to restart zK++): "
	LOADED_FILE_LIST, // "File list loaded."
	LOADING, // "Loading zK++, please wait..."
	LOADING_FILE_LIST, // "Loading file list, this may take a while if the list is large."
	LOCK, // "Lock"
	LOG, // "Log"
	LOG_OFF, // "Log off"
	LOW, // "Low"
	LOWER, // "Lower"
	LOWEST, // "Lowest"
	MAGNET_ASK, // "Ask for Magnet action"
	MAGNET_DLG_FILE, // "Filename:"
	MAGNET_DLG_HASH, // "File Hash:"
	MAGNET_DLG_NOTHING, // "Do nothing"
	MAGNET_DLG_QUEUE, // "Add this file to your download queue"
	MAGNET_DLG_REMEMBER, // "Do the same action next time without asking"
	MAGNET_DLG_SEARCH, // "Start a search for this file"
	MAGNET_DLG_SIZE, // "File Size:"
	MAGNET_DLG_TEXT_BAD, // "A MAGNET link was given to zK++, but it didn't contain a valid file hash for use on the Direct Connect network.  No action will be taken."
	MAGNET_DLG_TEXT_GOOD, // "zK++ has detected a MAGNET link with a file hash that can be searched for on the Direct Connect network.  What would you like to do?"
	MAGNET_DLG_TITLE, // "MAGNET Link detected"
	MAGNET_HANDLER_DESC, // "Download files from the Direct Connect network"
	MAGNET_HANDLER_ROOT, // "zK++"
	MAGNET_SHELL_DESC, // "URL:MAGNET URI"
	MATCH_QUEUE, // "Match Queue"
	MATCHED_FILES, // "Matched %d file(s)"
	MAX_HUBS, // "Max Hubs"
	MAX_SEGMENTS_NUMBER, // "Max number of segments"
	MAX_SIZE, // "Max Size"
	MAX_USERS, // "Max Users"
	MAXHUBS, // "Max hubs"
	MAXUSERS, // "Max users"
	MB, // "MB"
	MBITSPS, // "MBits/s"
	MBPS, // "MB/s"
	MENU_ABOUT, // "About zK++"
	MENU_TOOL_INSTALL, // "Reinstall zK++"
	zK, // " Hot Tools "
	MENU_ZK_ONLINE, // "zK++ Online"
	MENU_ACTION, // " Action "
	MENU_BOOKMARK, // " Bookmark "
	MENU_CONNECTION, // " Connection "
	MENU_EDITION_CONTROL, // " Control Panel "
	MENU_LOOK, // " Search Engines "
	MENU_SITES, // "Servers"
	MENU_MANAGEMENT, // " Data Management "
	MENU_NOTES, // "Notepads"
	MENU_HOTZK, // "Operator Bots"
	MENU_HOTTOOLS, // "Hot Tools"
	MENU_PRIOS, // "CPU-RAM Priority"
	MENU_ADL_SEARCH, // "ADL Search"
	MENU_ARRANGE, // "Arrange Icons"
	MENU_CASCADE, // "Cascade"
	MENU_CDMDEBUG_MESSAGES, // "Message Debugger"
	MENU_CLEAR_ALL_HUB_MAINCHAT, // "Clear All Main Chats"
	MENU_CLOSE_ALL_DIR_LIST, // "Close All File List Windows"
	MENU_CLOSE_ALL_OFFLINE_PM, // "Close All Offline PM Windows"
	MENU_CLOSE_ALL_PM, // "Close All PM Windows"
	MENU_CLOSE_ALL_SEARCHFRAME, // "Close All Search Windows"
	MENU_CLOSE_DISCONNECTED, // "Close Disconnected Hubs"
	MENU_CLOSE_ALL_HUBS, // "Close All Hubs"
	MENU_CLOSE_HUBS_BELOW_X, // "Close Hubs Below 10 Users"
	MENU_CLOSE_HUBS_BELOW_L, // "Close Hubs Below 50 Users"
	MENU_CLOSE_HUBS_BELOW_C, // "Close Hubs Below 100 Users"
	MENU_CLOSE_HUBS_BELOW_CCL, // "Close Hubs Below 250 Users"
	MENU_CLOSE_HUBS_BELOW_D, // "Close Hubs Below 500 Users"
	MENU_CLOSE_HUBS_BELOW_M, // "Close Hubs Below 1000 Users"
	MENU_CLOSE_HUBS_BELOW_MD, // "Close Hubs Below 1500 Users"
	MENU_CLOSE_HUBS_BELOW_MM, // "Close Hubs Below 2000 Users"
	MENU_CLOSE_HUBS_EMPTY, // "Close Empty Hubs"
	MENU_DISCUSS, // "Forum"
	MENU_SERVER_TWO, // "CodePlex"
	//MENU_FEEDS, // "Studio Records"
	MENU_DWIZ, // "DigitaLWizarD"
	MENU_HUBBY, // "Official Hub"
	MENU_SERVER_THREE, // "OSDN"
	MENU_SERVER_FOUR, // "Studio Server"
	MENU_DOWNLOAD_QUEUE, // "Download Queue\tCtrl+D"
	MENU_EXIT, // "Close zK++"
	MENU_SERVER_ONE, // "SourceForge"
	MENU_FAV_HUBS, // "zK++ Network"
	MENU_FAVORITE_HUBS, // "Favorite Hubs\tCtrl+F"
	MENU_FAVORITE_USERS, // "Favorite Users\tCtrl+U"
	MENU_FILE, // "Files "
	MENU_FILE_RECENT_HUBS, // "Recent Hubs"
	MENU_FOLLOW_REDIRECT, // "Follow Last Redirect\tCtrl+T"
	MENU_HASH_PROGRESS, // "Indexing Progress"
	MENU_HELP, // " Full Help "
	MENU_HELP_GEOIPFILE, // "GeoIP Database Update"
	MENU_HELP_TRANSLATIONS, // "Translations"
	MENU_HOMEPAGE, // "Home Page"
	MENU_HORIZONTAL_TILE, // "Horizontal Tile"
	MENU_LOOKS, // "Online Research"
	MENU_MINIMIZE_ALL, // "Minimize All"
	MENU_NETWORK_STATISTICS, // "Network Statistics"
	MENU_NICK_CREATOR, // "NickName Creator"
	MENU_ASCII, // "ASCII Generator"
	MENU_TV, // "TV Database"
	MENU_ALL_MUSIC, // "Music Database"
	MENU_MOVIE, // "Movie Database"
	MENU_DNS_INTERCEPTOR, // "DNS Stuff"
	MENU_SEARCH_IP, // "Search IP"
	MENU_AVIPREVIEW, // "AVI Preview"
	MENU_CHANGELOG, // "Changelog"
	MENU_OPEN_CLONE, // "Open Clone"
	MENU_HUB_CHECK, // "Hublist Checker"
	MENU_PROXY_CHECK, // "DC Proxy Checker"
	MENU_HOSTNAME, // "Search Host / IP"
	MENU_SONGR, // "Songr"
	MENU_FAQ_BASIC1, // "zK  Essentials"
	MENU_FAQ_BASIC2, // "zK Quick Help"
	MENU_FAQ_BASIC3, // "DC Quick Help"
	MENU_LAG_WATCH, // "Lag Check Watch"
	MENU_AUDIO_PLAYER, // "Audio Player"
	MENU_WINAMP_CLASSIC, // "Winamp Classic"
	MENU_MPLAYER_CLASSIC, // "Media Player Classic"
	MENU_MASTER_BOT, // "Master Bot"
	MENU_DARK_FIGHTER, // "Dark Fighter"
	MENU_PASSWORD, // "Password Generator"
	MENU_NOTEPAD, //  "Notepad 1\tCtrl+N"
	MENU_NOTEPAD2, // "Notepad 2\tCtrl+O"
	MENU_NOTEPAD3, // "Notepad 3\tCtrl+T"
	MENU_NOTEPAD4, // "Notepad 4\tCtrl+K"
	MENU_NOTEPAD5, // "Notepad 5\tCtrl+M"
	MENU_OPEN_DOWNLOADS_DIR, // "Open Downloads Directory"
	MENU_OPEN_FILE_LIST, // "Open File List\tCtrl+L"
	MENU_OPEN_MATCH_ALL, // "Match Downloaded Lists"
	MENU_OPEN_OWN_LIST, // "Open Own List"
	MENU_PUBLIC_HUBS, // "Public Hubs\tCtrl+P"
	MENU_QUICK_CONNECT, // "Quick Connect\tCtrl+Q"
	MENU_RECONNECT, // "Reconnect Current Hub\tCtrl+R"
	MENU_REFRESH_FILE_LIST, // "Refresh File List\tCtrl+E"
	MENU_RESTORE_ALL, // "Restore All"
	MENU_SEARCH, // "Search\tCtrl+S  "
	MENU_SEARCH_SPY, // "Search Spy"
	MENU_SETTINGS, // "Settings"
	MENU_SHOW, // "Show zK++"
	MENU_STATUS_BAR, // "Status Bar\tCtrl+2"
	MENU_TOOLBAR, // "Toolbar\tCtrl+1"
	MENU_PLUGIN_VIEW, // "&Plugins\tCtrl+5"
	MENU_TRANSFER_VIEW, // "Transfers\tCtrl+3"
	MENU_TRANSFERS, // " Transfers "
	MENU_TTH, // "Get TTH for File"
	MENU_VERTICAL_TILE, // "Vertical Tile"
	MENU_VIEW, // " View "
	MENU_WINDOW, // " All Windows "
	MENUBAR, // "Menu Bar"
	MIN_SHARE, // "Min Share"
	MIN_SLOTS, // "Min Slots"
	MINIMUM_SEARCH_INTERVAL, // "Minimum search interval"
	MINSHARE, // "Min share"
	MINSLOTS, // "Min slots"
	MINUTES, // "Minutes"
	MODE, // "Mode"
	MOVE, // "Move/Rename"
	MOVE_DOWN, // "Move Down"
	MOVE_UP, // "Move Up"
	MULTILINE_CHAT_INPUT, // "Multiline input field in mainchat bar"
	MYNICK_IN_CHAT, // "My nick in mainchat"
	NAME, // "Name"
	NETWORK_STATISTICS, // "Network Statistics"
	NEW, // "New..."
	NEW_DISCONNECT, // "Remove user from queue, if speed is below"
	NEXT, // "Next"
	NICK, // "Nick"
	NICK_TAKEN, // "Your nick was already taken, please change to something else!"
	NICK_UNKNOWN, // " (Nick unknown)"
	NO, // "No"
	NO_CERTIFICATE_FILE_SET, // "TLS disabled, no certificate file set"
	NO_DIRECTORY_SPECIFIED, // "No directory specified"
	NO_DOWNLOADS_FROM_SELF, // "You're trying to download from yourself!"
	NO_ERRORS, // "No errors"
	NO_FREE_BLOCK, // "No free block"
	NO_LOG_FOR_HUB, // "Hub log doesn't exist"
	NO_LOG_FOR_USER, // "User log doesn't exist"
	NO_MATCHES, // "No matches"
	NO_NEEDED_PART, // "No needed part"
	NO_SLOTS_AVAILABLE, // "No slots available"
	NO_USERS, // "No users"
	NO_USERS_TO_DOWNLOAD_FROM, // "No users to download from"
	NOMEN, // "zK++ 0.74"
	NONE, // "None"
	NORMAL, // "Normal"
	NOT_LISTENING, // "Not listening for connections - please restart zK++"
	NOTEPAD, //  "Notepad 1"
	NOTEPAD2, // "Notepad 2"
	NOTEPAD3, // "Notepad 3"
	NOTEPAD4, // "Notepad 4"
	NOTEPAD5, // "Notepad 5"
	NUMBER_OF_SEGMENTS, // "segment(s)"
	OFFLINE, // "Offline"
	OK, // "OK"
	ONLINE, // "Online"
	ONLY_FREE_SLOTS, // "Only users with free slots"
	ONLY_TTH, // "Only results with TTH root"
	ONLY_WHERE_OP, // "Only where I'm op"
	OPEN, // "Open"
	OPEN_DOWNLOAD_PAGE, // "Open download page?"
	OPEN_FOLDER, // "Open folder"
	OPEN_HUB_LOG, // "Open Hub Log"
	OPEN_USER_LOG, // "Open User Log"
	OVERLAP_CHUNKS, // "Overlap slow chunks by faster user when file is going to be finished"
	OVERLAPPED_SLOW_SEGMENT, // "Overlapped by faster user"
	OWN_CERTIFICATE_FILE, // "Own certificate file"
	PARTS, // "Parts: "
	PARAM_EXISTS, // "Param with same name already exists!"
	PASSIVE_USER, // "Passive user"
	PASSWORD, // "Password"
	PATH, // "Path"
	PAUSE, // "Pause"
	PAUSE_SEARCH, // "Pause Search"
	PAUSED, // "Paused"
	PB, // "PB"
	PICTURE, // "Picture"
	PK, // "PK String"
	PLAY, // "Play"
	POPUP_DOWNLOAD_FAILED, // "Show popup on download failed"
	POPUP_DOWNLOAD_FINISHED, // "Show popup on download finished"
	POPUP_DOWNLOAD_START, // "Show popup on download begins"
	POPUP_FAVORITE_CONNECTED, // "Show popup on favorite user connected"
	POPUP_HUB_CONNECTED, // "Show popup on hub connected"
	POPUP_HUB_DISCONNECTED, // "Show popup on hub disconnected"
	POPUP_CHEATING_USER, // "Show popup on cheating user found"
	POPUP_NEW_PM, // "Show popup on new private message"
	POPUP_PM, // "Show popup on private message"
	POPUP_TYPE, // "Popup type"
	POPUP_UPLOAD_FINISHED, // "Show popup on upload finished"
	PORT, // "Port: "
	POWER_OFF, // "Power off"
	PRESS_FOLLOW, // "Press the follow redirect button to connect to "
	PREVIEW_MENU, // "Preview"
	PREVIOUS_FOLDERS, // "Previous folders"
	PRIORITY, // "Priority"
	PRIVATE_KEY_FILE, // "Private key file"
	PRIVATE_MESSAGE, // "Private message"
	PRIVATE_MESSAGE_FROM, // "Private message from "
	PROFILE_VERSION, // "Version"
	PROFILE_COUNT, // "Count"
	PROFILE_MESSAGE, // "Message"
	PROGRESS_BACK, // "Transfer progressbar - background"
	PROGRESS_COMPRESS, // "Transfer progressbar - decompressed part"
	PROGRESS_DONE, // "Queue progressbar - done chunks"
	PROGRESS_DOWNLOADED, // "Queue progressbar - downloaded bytes"
	PROGRESS_RUNNING, // "Queue progressbar - running chunks"
	PROGRESS_SEGMENT, // "Transfer progressbar - actual segment"
	PROGRESSBAR_ODC_STYLE, // "oDC Style"
	PROPERTIES, // "Properties"
	PUBLIC_HUBS, // "Public Hubs"
	PURGE, // "Purge"
	REGEXP_TESTER, // "RegExp Tester"
	REGEXP_MATCH, // "It's a match!"
	REGEXP_MISMATCH, // "It's not a match."
	REGEXP_INVALID, // "Invalid RegExp!"
	REGEXP, // "RegExp"
	QSEARCH_STR, // "Quick Search Here..."
	QUEUED, // "Queued: "
	QUICK_CONNECT, // "Quick Connect"
	RATING, // "Rating"
	RATIO, // "Ratio"
	READD_SOURCE, // "Readd source"
	REALLY_EXIT, // "Really Exit?"
	REALLY_REMOVE, // "Really Remove?"
	REASON, // "Reason"
	REBOOT, // "Reboot"
	RECENT_HUBS, // "Recent Hubs"
	REDIRECT_ALREADY_CONNECTED, // "Redirect request received to a hub that's already connected"
	REDIRECT_USER, // "Redirect User(s)"
	REFRESH, // "Refresh"
	REFRESH_USER_LIST, // "Refresh User List"
	RELIABILITY, // "Reliability"
	REQUESTING, // "Requesting"
	REMOVE, // "Remove"
	REMOVE_ALL, // "Remove all"
	REMOVE_EXTRA_SLOT, // "Remove extra slot"
	REMOVE_FROM_ALL, // "Remove user from queue"
	REMOVE_OFFLINE, // "Remove offline users"
	REMOVE_SOURCE, // "Remove source"
	RENAMED_TO, // " renamed to "
	REPORT, // "Report User"
	REPORT_ALTERNATES, // "Report auto search for alternates in status bar"
	RESUME, // "Resume"
	RETRIEVING_DATA, // "Retrieving data"
	RIGHT_COLOR, // "Right color"
	RUNNING, // "Running..."
	SEARCH, // "Search"
	SEARCH_FOR, // "Search for"
	SEARCH_FOR_ALTERNATES, // "Search for alternates"
	SEARCH_FOR_FILE, // "Search for file"
	SEARCH_IN_RESULTS, // "Search in results"
	SEARCH_OPTIONS, // "Search options"
	SEARCH_SPAM_FROM, // "Search spam detected from "
	SEARCH_SPY, // "Search Spy"
	SEARCH_STRING, // "Search String"
	SEARCHING_FOR, // "Searching for "
	SECONDS, // "Seconds"
	SEEK_BEYOND_END, // "Request to seek beyond the end of data"
	SEGMENT, // "Segment"
	SEGMENTS, // "Segments"
	SELECT_ALL, // "Select all"
	SELECT_USER_LIST, // "Select user in list"
	SEND_PRIVATE_MESSAGE, // "Send Private Message"
	SEND_PUBLIC_MESSAGE, // "Send Public Message"
	SEPARATOR, // "Separator"
	SERVER, // "Server"
	SET_PRIORITY, // "Set priority"
	SETCZDC_ALTERNATE_LIMITING, // "Use Alternate Limiting from"
	SETCZDC_BACK_COLOR, // "Back color"
	SETCZDC_BLACK_WHITE, // "Black & White"
	SETCZDC_BOLD, // "Bold Authors of messages in chat"
	SETCZDC_CZCHARS_DISABLE, // "Remove diacritic marks from Czech chars"
	SETCZDC_DEFAULT_STYLE, // "Default Styles"
	SETCZDC_DISCONNECTING_ENABLE, // "Enable slow downloads disconnecting"
	SETCZDC_DOWNLOAD_SPEED, // "Download Speed"
	SETCZDC_ENABLE_LIMITING, // "Limit Transfer Speeds"
	SETCZDC_ERROR_COLOR, // "Error color"
	SETCZDC_H_DOWN_SPEED, // "And whole file speed exceeds"
	SETCZDC_I_DOWN_SPEED, // "Disconnect download if speed is below"
	SETCZDC_MAGNET_URI_HANDLER, // "Install Magnet URI handler on startup"
	SETCZDC_MIN_FILE_SIZE, // "And file size is more than"
	SETCZDC_NOTE_SMALL_UP, // "* Small Uploads Slots => Slots for Filelist and Small Files."
	SETCZDC_NOTE_UPLOAD, // "*  Many hubs don't allow up limits."
	SETCZDC_NOTE_DOWNLOAD, // "*  If upload limit is set, you will may be easily kicked!"
	SETCZDC_PASSIVE_SEARCH, // "Always use passive mode for Search (Use only if you know what this doing !!!)"
	SETCZDC_PM_LINES, // "Lines from log on new PM"
	SETCZDC_PREVIEW, // "Preview"
	SETCZDC_PRIVATE_SOUND, // "Private Message Sound"
	SETCZDC_PROGRESSBAR_COLORS, // "Progressbar Colors"
	SETCZDC_PROGRESSBAR_TEXT, // "Progressbar Text Colors"
	SETCZDC_REMOVE_FORBIDDEN, // "Remove Forbidden (Unfinished Kazaa, Win MX, GetRight, eMule, zK++)"
	SETCZDC_SECONDARY_LIMITING, // "Secondary transfer limiter"
	SETCZDC_SLOW_DISCONNECT, // "Disconnecting Slow Downloads"
	SETCZDC_SMALL_FILES, // "Small file size"
	SETCZDC_SMALL_UP_SLOTS, // "Small Upload Slots"
	SETCZDC_STYLES, // "Available styles"
	SETCZDC_TEXT_COLOR, // "Text color"
	SETCZDC_TEXT_STYLE, // "Text style"
	SETCZDC_TIME_DOWN, // "More than"
	SETCZDC_TO, // "to"
	SETCZDC_TRANSFER_LIMITING, // "Transfer Rate Limiting"
	SETCZDC_UPLOAD, // "Upload"
	SETCZDC_UPLOAD_SPEED, // "Upload Speed"
	SETCZDC_WINAMP, // "Media Toolbar and Spam Settings"
	SETTINGS, // "Settings"
	SETTINGS_ADD_FOLDER, // "Add folder"
	SETTINGS_ADLS_BREAK_ON_FIRST, // "Break on first ADLSearch match"
	SETTINGS_ADVANCED, // "zK++"
	SETTINGS_ADVANCEDD, // "Flood Protection"
	SETTINGS_ADVANCED_SHOW_SHARE_CHECKED_USERS, // "Show share-checked users"
	SETTINGS_ADVANCED_SUPPRESS_MAIN_CHAT, // "Suppress main chat"
	SETTINGS_ADVANCED3, // "Client Manager"
	SETTINGS_ALLOW_UNTRUSTED_CLIENTS, // "Allow TLS connections to clients without trusted certificate"
	SETTINGS_ALLOW_UNTRUSTED_HUBS, // "Allow TLS connections to hubs without trusted certificate"
	SETTINGS_ANTI_FRAG, // "Use antifragmentation method for downloads"
	SETTINGS_APPEARANCE, // "CUSTOM STYLES"
	SETTINGS_ARGUMENT, // "Arguments"
	SETTINGS_AUTO_AWAY, // "Auto-away on minimize (and back on restore)"
	SETTINGS_AUTO_DROP_SEGMENTED_SOURCE, // "When segmented downloading only (more than 2 active sources)"
	SETTINGS_AUTO_FOLLOW, // "Automatically follow redirects"
	SETTINGS_AUTO_KICK, // "Automatically disconnect users who leave the hub"
	SETTINGS_AUTO_KICK_NO_FAVS, // "Don't automatically disconnect favorite users who leave the hub"
	SETTINGS_AUTO_OPEN, // "Auto-Open at Startup"
	SETTINGS_AUTO_PRIORITY_DEFAULT, // "Use Auto Priority by default"
	SETTINGS_AUTO_REFRESH_TIME, // "Auto refresh time"
	SETTINGS_AUTO_SEARCH, // "Automatically search for alternative TTH source every"
	SETTINGS_AUTO_SEARCH_AUTO_MATCH, // "Automatically match queue for auto search hits"
	SETTINGS_AUTO_SEARCH_LIMIT, // "Max sources for autosearch"
	SETTINGS_AUTO_SLOTS, // "Maximum auto opened"
	SETTINGS_AVIPREVIEW, // "File Preview"
	SETTINGS_BIND_ADDRESS, // "Bind Address"
	SETTINGS_BIND_ADDRESS_HELP, // "Network interface for all connections"
	SETTINGS_BOLD_OPTIONS, // "Tab Highlight on Content Change"
	SETTINGS_BWBOTH, // "Connection type (old DC++ method)"
	SETTINGS_BWSINGLE, // "Default (new DC++ method)"
	SETTINGS_CERTIFICATES, // "Security"
	SETTINGS_CLEAR_SEARCH, // "Clear search box after each search"
	SETTINGS_CLIENTS, // "Client Profiles"
	SETTINGS_COLOR_ALTERNATE, // "Search Alternate"
	SETTINGS_COLOR_BAD_CLIENT, // "Bad client"
	SETTINGS_COLOR_BAD_FILELIST, // "Bad filelist/fakeshare"
	SETTINGS_COLOR_CLIENT_CHECKED, // "Client checked"
	SETTINGS_COLOR_FAVORITE, // "Favorite"
	SETTINGS_COLOR_FILELIST_CHECKED, // "File list checked"
	SETTINGS_COLOR_FULL_CHECKED, // "Full checked"
	SETTINGS_COLOR_IGNORED, // "Ignored"
	SETTINGS_COLOR_NORMAL, // "Normal"
	SETTINGS_COLOR_RESERVED, // "Has reserved slot"
	SETTINGS_COLORS, // "Other Colors"
	SETTINGS_COMMAND, // "Command"
	SETTINGS_COMPRESS_TRANSFERS, // "Enable safe and compressed transfers"
	SETTINGS_CONFIGURE_HUB_LISTS, // "Configure Public Hub Lists"
	SETTINGS_CONFIRM_DIALOG_OPTIONS, // "Confirm Dialog Options"
	SETTINGS_CONFIRM_EXIT, // "Confirm application exit"
	SETTINGS_CONFIRM_HUB_REMOVAL, // "Confirm favorite hub removal"
	SETTINGS_CONFIRM_ITEM_REMOVAL, // "Confirm item removal in download queue"
	SETTINGS_CZDC, // "zK++"
	SETTINGS_CZDC_EXTRA_DOWNLOADS, // "Highest Priority Extra Download Slots"
	SETTINGS_DEBUG_COMMANDS, // "Debug commands"
	SETTINGS_DEFAULT_AWAY_MSG, // "Default Away Message"
	SETTINGS_DIRECT, // "Direct connection"
	SETTINGS_DIRECTORIES, // "Directories"
	SETTINGS_DISPLAY_CHEATS_IN_MAIN_CHAT, // "Display cheats in main chat"
	SETTINGS_DISPLAY_DC_UPDATE, // "Don't announce new zK++ versions (version.xml is still downloaded)"
	SETTINGS_DONT_DL_ALREADY_SHARED, // "Don't download files already in share"
	SETTINGS_DOWNCONN, // "Dwnld attempts/second"
	SETTINGS_DOWNLOAD_DIRECTORY, // "Default download directory"
	SETTINGS_DOWNLOAD_LIMITS, // "Limits"
	SETTINGS_DOWNLOADS, // "DOWNLOADS"
	SETTINGS_DOWNLOADS_MAX, // "Maximum simultaneous downloads (0 = infinite)"
	SETTINGS_DOWNLOADS_SPEED_PAUSE, // "No new downloads if speed exceeds (kB/s, 0 = disable)"
	SETTINGS_EXPAND_QUEUE, // "Automatically expand folders in Queue"
	SETTINGS_EXTENSIONS, // "Extensions"
	SETTINGS_EXTERNAL_IP, // "External / WAN IP"
	SETTINGS_FAKEDETECT, // "EVIL DESTROYER"
	SETTINGS_FAV_SHOW_JOINS, // "Only show joins / parts for favorite users"
	SETTINGS_FAVORITE_DIRS, // "Favorite Download Directories"
	SETTINGS_FAVORITE_DIRS_PAGE, // "Favorites"
	SETTINGS_FILE_NAME, // "Filename"
	SETTINGS_FILES_MAX, // "Maximum simultaneous files (0 = infinite)"
	SETTINGS_FILTER_MESSAGES, // "Filter kick and NMDC debug messages"
	SETTINGS_FILTER_ENTER, // "Activate search/userlist filter by pressing Enter"
	SETTINGS_FIREWALL_NAT, // "Firewall with manual port forwarding"
	SETTINGS_FIREWALL_PASSIVE, // "Firewall (passive, worst case)"
	SETTINGS_FIREWALL_UPNP, // "Firewall with UPnP (WinXP+ only)"
	SETTINGS_FORMAT, // "Format"
	SETTINGS_GENERAL, // "USER PROFILE"
	SETTINGS_GET_USER_COUNTRY, // "Get User Country"
	SETTINGS_HUB_USER_COMMANDS, // "Accept custom user commands from hub"
	SETTINGS_CHANGE, // "Change"
	SETTINGS_IGNORE_HUB_PMS, // "Ignore private messages from the hub"
	SETTINGS_IGNORE_BOT_PMS, // "Ignore private messages from bots"
	SETTINGS_INCOMING, // "Incoming Connection Settings"
	SETTINGS_KEEP_LISTS, // "Don't delete file lists when exiting"
	SETTINGS_LANGUAGE_FILE, // "Language File"
	SETTINGS_LIMIT, // "Speed Limiter"
	SETTINGS_LOG_DIR, // "Log directory"
	SETTINGS_LOG_DOWNLOADS, // "Log downloads"
	SETTINGS_LOG_FILELIST_TRANSFERS, // "Log filelist transfers"
	SETTINGS_LOG_MAIN_CHAT, // "Log main chat"
	SETTINGS_LOG_PRIVATE_CHAT, // "Log private chat"
	SETTINGS_LOG_STATUS_MESSAGES, // "Log status messages"
	SETTINGS_LOG_SYSTEM_MESSAGES, // "Log system messages"
	SETTINGS_LOG_UPLOADS, // "Log uploads"
	SETTINGS_LOGGING, // "Logging"
	SETTINGS_LOGS, // "Logs"
	SETTINGS_MAX_COMPRESS, // "Max compression level"
	SETTINGS_MAX_HASH_SPEED, // "Max hash speed"
	SETTINGS_MAX_TAB_ROWS, // "Max tab rows"
	SETTINGS_MINIMIZE_ON_STARTUP, // "Minimize at program startup"
	SETTINGS_MINIMIZE_TRAY, // "Minimize to tray"
	SETTINGS_MOUSE_OVER, // "Mouse Over"
	SETTINGS_NAME, // "Name"
	SETTINGS_NETWORK, // "Connection"
	SETTINGS_NO_AWAYMSG_TO_BOTS, // "Don't send the away message to bots"
	SETTINGS_NORMAL, // "Normal"
	SETTINGS_ODC_SHUTDOWNTIMEOUT, // "timeout"
	SETTINGS_ONLY_HASHED, // "Note: Files appear in the share only after they've been hashed!"
	SETTINGS_OPEN_NEW_WINDOW, // "Open new window when using /join"
	SETTINGS_OPERACOLORS, // "Progressbar"
	SETTINGS_OPTIONS, // "Options"
	SETTINGS_OUTGOING, // "Outgoing Connection Settings"
	SETTINGS_OVERRIDE, // "Don't allow hub/UPnP to override"
	SETTINGS_PERSONAL_INFORMATION, // "Essential Info"
	SETTINGS_SECONDARY_INFORMATION, // "Optional Info"
	SETTINGS_PM_BEEP, // "Make an annoying sound every time a private message is received"
	SETTINGS_PM_BEEP_OPEN, // "Make an annoying sound when a private message window is opened"
	SETTINGS_PM_HISTORY, // "PM history"
	SETTINGS_POPUNDER_FILELIST, // "Open new file list windows in the background"
	SETTINGS_POPUNDER_PM, // "Open new private message windows in the background"
	SETTINGS_POPUP_BOT_PMS, // "Open private messages from the hub in their own window"
	SETTINGS_POPUP_HUB_PMS, // "Open private messages from bots in their own window"
	SETTINGS_POPUP_PMS, // "Open private messages in their own window"
	SETTINGS_PORTS, // "Ports"
	SETTINGS_PRIO_AUTOPRIO, // "Priority Settings - has Higher Priority than Autopriority"
	SETTINGS_PRIO_HIGH, // "High prio max size"
	SETTINGS_PRIO_HIGHEST, // "Highest prio max size"
	SETTINGS_PRIO_LOW, // "Low prio max size"
	SETTINGS_PRIO_LOWEST, // "Set lowest prio for newly added files larger than Low prio size"
	SETTINGS_PRIO_NORMAL, // "Normal prio max size"
	SETTINGS_PROMPT_PASSWORD, // "Popup box to input password for hubs"
	SETTINGS_PUBLIC_HUB_LIST, // "Public Hubs List"
	SETTINGS_PUBLIC_HUB_LIST_HTTP_PROXY, // "HTTP Proxy (for hublist only)"
	SETTINGS_PUBLIC_HUB_LIST_URL, // "Public Hubs list URL"
	SETTINGS_QUEUE, // "Multi-Source"
	SETTINGS_RENAME_FOLDER, // "Rename"
	SETTINGS_REQUIRES_RESTART, // "Note: most of these options require that you restart zK++"
	SETTINGS_RESET, // "Reset"
	SETTINGS_SB_MAX_SOURCES, // "Max sources for match queue"
	SETTINGS_SEARCH_HISTORY, // "Search history"
	SETTINGS_SEGMENT, // "Segmented Downloading"
	SETTINGS_SELECT_COLOR, // "Select color"
	SETTINGS_SELECT_TEXT_FACE, // "Text style"
	SETTINGS_SELECT_WINDOW_COLOR, // "Window Color"
	SETTINGS_SEND_UNKNOWN_COMMANDS, // "Send unknown /commands to the hub"
	SETTINGS_SHARE_HIDDEN, // "Share hidden files"
	SETTINGS_SHARE_SIZE, // "Total size:"
	SETTINGS_SHARED_DIRECTORIES, // "Shared Directories"
	SETTINGS_SHOW_INFO_TIPS, // "Show InfoTips in lists"
	SETTINGS_SHOW_JOINS, // "Show joins / parts in chat by default"
	SETTINGS_SHOW_PROGRESS_BARS, // "Show progress bars for transfers (uses some CPU)"
	SETTINGS_SHOW_SHELL_MENU, // "Show shell menu in finished transfers"
	SETTINGS_SKIP_ZERO_BYTE, // "Skip zero-byte files"
	SETTINGS_SOCKS5, // "SOCKS5"
	SETTINGS_SOCKS5_IP, // "Socks IP"
	SETTINGS_SOCKS5_PORT, // "Port"
	SETTINGS_SOCKS5_RESOLVE, // "Use SOCKS5 server to resolve host names"
	SETTINGS_SOCKS5_USERNAME, // "Login"
	SETTINGS_SORT_FAVUSERS_FIRST, // "Sort favorite users first"
	SETTINGS_SOUND, // "Sounds"
	SETTINGS_SOUNDS, // "Sounds"
	SETTINGS_SPEEDS_NOT_ACCURATE, // "Note: because of changing download speeds, this is not 100% accurate..."
	SETTINGS_STATUS_IN_CHAT, // "View status messages in main chat"
	SETTINGS_TCP_PORT, // "TCP"
	SETTINGS_TLS_PORT, // "TLS"
	SETTINGS_TEXT_STYLES, // "Colors & Fonts"
	SETTINGS_TIME_STAMPS, // "Show timestamps in chat by default"
	SETTINGS_TIME_STAMPS_FORMAT, // "Set Timestamps"
	SETTINGS_TOGGLE_ACTIVE_WINDOW, // "Toggle window when selecting an active tab"
	SETTINGS_TOOLBAR, // "Toolbar"
	SETTINGS_TOOLBAR_ADD, // "Add --->"
	SETTINGS_TOOLBAR_IMAGE, // "Toolbar Images"
	SETTINGS_TOOLBAR_REMOVE, // "<--- Remove"
	SETTINGS_UDP_PORT, // "UDP Port"
	SETTINGS_UNFINISHED_DOWNLOAD_DIRECTORY, // "Unfinished downloads directory"
	SETTINGS_UPLOAD_LINE_SPEED, // "Max upload speed"
	SETTINGS_UPLOADS, // "USER PROFILE\\Sharing"
	SETTINGS_UPLOADS_MIN_SPEED, // "Open an extra slot if speed is below (0 = disable)"
	SETTINGS_UPLOADS_SLOTS, // "Upload Slots"
	SETTINGS_URL_HANDLER, // "Install URL handler on startup (to handle dchub:// links)"
	SETTINGS_USE_CTRL_FOR_LINE_HISTORY, // "Use CTRL for line history"
	SETTINGS_USE_EXTENSION_DOWNTO, // "Use file extension for Download to in search"
	SETTINGS_USE_OLD_SHARING_UI, // "Use old sharing user interface"
	SETTINGS_USE_SYSTEM_ICONS, // "Use system icons when browsing files (slows browsing down a bit)"
	SETTINGS_USE_TLS, // "Use TLS when remote client supports it"
	SETTINGS_USER_COLORS, // "User List"
	SETTINGS_USER_COMMANDS, // "User Commands"
	SETTINGS_USER_MENU, // "User Menu Items"
	SETTINGS_WEBSERVER, // "Enable Webserver"
	SETTINGS_WINDOWS, // "Windows"
	SETTINGS_WINDOWS_OPTIONS, // "Window Options"
	SETTINGS_WRITE_BUFFER, // "Write buffer size"
	SETTINGS_ZDC_PROGRESS_OVERRIDE, // "Bars"
	SETTINGS_ZDC_PROGRESS_OVERRIDE2, // "Texts"
	SHARED, // "Shared"
	SHARED_FILES, // "Shared Files"
	SHOW_POPUP_AWAY, // "Display popup in away mode only"
	SHOW_POPUP_MINIMIZED, // "Display popup when minimized only"
	SHOW_SPEED, // "Show speed"
	SHUTDOWN, // "Shutdown Computer"
	SHUTDOWN_ACTION, // "Shutdown action"
	SHUTDOWN_OFF, // "Shutdown sequence deactivated..."
	SHUTDOWN_ON, // "Shutdown sequence activated..."
	SIZE, // "Size"
	SIZE_EXACT, // "Exactly"
	SIZE_MIN, // "Min Size"
	SKIP_RENAME, // "New virtual name matches old name, skipping..."
	SLOT_GRANTED, // "Slot granted"
	SLOTS, // "Slots"
	SLOTS_SET, // "Slots set"
	SLOW_USER, // "Slow user"
	SMALL_FILE_SIZE_SET, // "Small file size set"
	SOCKS_AUTH_FAILED, // "Socks server authentication failed (bad login / password?)"
	SOCKS_AUTH_UNSUPPORTED, // "The socks server doesn't support login / password authentication"
	SOCKS_FAILED, // "The socks server failed establish a connection"
	SOCKS_NEEDS_AUTH, // "The socks server requires authentication"
	SOCKS_SETUP_ERROR, // "Failed to set up the socks server for UDP relay (check socks address and port)"
	SOUND_DOWNLOAD_BEGINS, // "Download begins"
	SOUND_DOWNLOAD_FINISHED, // "Download finished"
	SOUND_EXCEPTION, // "Unhandled Exception"
	SOUND_FAKER_FOUND, // "Faker found"
	SOUND_SOURCE_ADDED, // "Alternate source added"
	SOUND_TTH_INVALID, // "File is corrupted"
	SOUND_TYPING_NOTIFY, // "Typing sound"
	SOUND_UPLOAD_FINISHED, // "Upload finished"
	SOURCE_TOO_OLD, // "Remote client does not fully support TTH - cannot download"
	SOURCE_TYPE, // "Source Type"
	SPECIFY_SEARCH_STRING, // "Specify a search string"
	SPECIFY_SERVER, // "Specify a server to connect to"
	SPEED, // "Speed Info"
	STATUS, // "Status"
	STEALTH_MODE, // "Emulate DC++ in this hub"
	STORED_PASSWORD_SENT, // "Stored password sent..."
	STRING_NOT_FOUND, // "String not found: "
	SUPPORTS, // "Supports"
	SUSPEND, // "Suspend"
	TABS_ON_TOP, // "Tabs on top"
	TAG, // "Tag"
	TARGET_REMOVED, // "Target removed"
	TARGET_FILENAME_TOO_LONG, // "Target filename too long"
	TB, // "TB"
	TCP_PORT_BUSY, // "Unable to open TCP/TLS port. File transfers will not work correctly until you change settings or turn off any application that might be using the TCP/TLS port"
	TEXT_FAKEPERCENT, // "Percent fake share accepted"
	TEXT_MANUAL, // "Manual settings of number of segments"
	TIME, // "Time"
	TIME_LEFT, // "Time left"
	TIMESTAMP_HELP, // "\r\n- %a - Abbreviated weekday name\r\n- %A - Full weekday name\r\n- %b - Abbreviated month name\r\n- %B - Full month name\r\n- %c - Date and time representation appropriate for locale\r\n- %d - Day of month as decimal number (01 until 31)\r\n- %H - Hour in 24-hour format (00 until 23)\r\n- %I - Hour in 12-hour format (01 until 12)\r\n- %j - Day of year as decimal number (001 until 366)\r\n- %m - Month as decimal number (01 until 12)\r\n- %M - Minute as decimal number (00 until 59)\r\n- %p - Current locale's A.M./P.M. indicator for 12-hour clock\r\n- %S - Second as decimal number (00 until 59)\r\n- %U - Week of year as decimal number, with Sunday as first day of week (00 until 53)\r\n- %w - Weekday as decimal number (0 until 6; Sunday is 0)\r\n- %W - Week of year as decimal number, with Monday as first day of week (00 until 53)\r\n- %x - Date representation for current locale\r\n- %X - Time representation for current locale\r\n- %y - Year without century, as decimal number (00 until 99)\r\n- %Y - Year with century, as decimal number\r\n- %z, %Z - Either the time-zone name or time zone abbreviation, depending on registry settings; no characters if time zone is unknown\r\n- %% - Percent sign\r\n\r\nDefault: %H:%M:%S"
	TIMESTAMP_HELP_DESC, // "Timestamps Help"
	TIMESTAMPS_DISABLED, // "Timestamps disabled"
	TIMESTAMPS_ENABLED, // "Timestamps enabled"
	TOGGLE_QSEARCH, // "Quick Search\tCtrl+6"
	TOO_MUCH_DATA, // "More data was sent than was expected"
	TOTAL, // "Total: "
	TRANSFERLISTDBLCLICKACTION, // "Transferlist double click action"
	TRANSFERRED, // "Transferred"
	TRUSTED_CERTIFICATES_PATH, // "Trusted certificates path"
	TTH_ALREADY_SHARED, // "A file with the same hash already exists in your share"
	TTH_INCONSISTENCY, // "TTH Inconsistency"
	TTH_ROOT, // "TTH Root"
	TWO_COLORS, // "Two colors"
	TYPE, // "Type"
	//UC_SUBMENU, // "Place usercommands to submenu"
	UNABLE_TO_CREATE_THREAD, // "Unable to create thread"
	UNABLE_TO_OPEN_FILELIST, // "Unable to open filelist: "
	UNABLE_TO_RENAME, // "Unable to rename "
	UNABLE_TO_SEND_FILE, // "Unable to send file "
	UNIGNORE_USER, // "Unignore User"
	UNKNOWN, // "Unknown"
	UNKNOWN_COMMAND, // "Unknown command: "
	UNKNOWN_ERROR, // "Unknown error: 0x%x"
	UPDATE_CHECK, // "zK++ Update Center"
	UPLOAD_FINISHED_IDLE, // "Upload finished, idle..."
	UPLOAD_STARTING, // "Upload starting..."
	UPLOADED_BYTES, // "Uploaded %s (%.01f%%) in %s"
	UPLOADED_TO, // " uploaded to "
	UPNP_FAILED_TO_CREATE_MAPPINGS, // "Failed to create port mappings. Please set up your NAT yourself."
	UPNP_FAILED_TO_GET_EXTERNAL_IP, // "Failed to get external IP via  UPnP. Please set it yourself."
	UPNP_FAILED_TO_REMOVE_MAPPINGS, // "Failed to remove port mappings"
	USER, // "User"
	USER_CMD_COMMAND, // "Command"
	USER_CMD_CONTEXT, // "Context"
	USER_CMD_FILELIST_MENU, // "Filelist Menu"
	USER_CMD_HUB, // "Hub IP / DNS (empty = all, 'op' = where operator)"
	USER_CMD_HUB_MENU, // "Hub Menu"
	USER_CMD_CHAT, // "Chat"
	USER_CMD_ONCE, // "Send once per nick"
	USER_CMD_PARAMETERS, // "Parameters"
	USER_CMD_PM, // "PM"
	USER_CMD_PREVIEW, // "Text sent to hub"
	USER_CMD_RAW, // "Raw"
	USER_CMD_SEARCH_MENU, // "Search Menu"
	USER_CMD_TO, // "To"
	USER_CMD_TYPE, // "Command Type"
	USER_CMD_USER_MENU, // "User Menu"
	USER_CMD_WINDOW, // "Create / Modify Command"
	USER_DESCRIPTION, // "User Description"
	USER_OFFLINE, // "User offline"
	USER_ONLINE, // "Running... (user online)"
	USER_WENT_OFFLINE, // "User went offline"
	USER_WENT_ONLINE, // "User went online"
	USERINFO, // "Info User"
	USERLIST_ICONS, // "Userlist Icons"
	USERLISTDBLCLICKACTION, // "Userlist double click action"
	USERS, // "Users"
	USERS_ONLINE, // "Running... (%d of %d users online)"
	VERSION, // "Version"
	VIDEO, // "Video"
	VIEW_AS_TEXT, // "View as text"
	VIEW_SMALL_TOOLBAR, // "Small Toolbar"
	VIRTUAL_NAME, // "Virtual name"
	VIRTUAL_NAME_EXISTS, // "Virtual directory name already exists"
	VIRTUAL_NAME_LONG, // "Name under which the others see the directory"
	WAITING, // "Waiting..."
	WAITING_TIME, // "Waiting time"
	WAITING_TO_RETRY, // "Waiting to retry..."
	WAITING_USER_ONLINE, // "Waiting (User online)"
	WAITING_USERS, // "Upload Queue"
	WAITING_USERS_ONLINE, // "Waiting (%d of %d users online)"
	WEBSERVER, // "Webserver"
	WHATS_THIS, // "What's this?"
	WHO_IS, // "Whois "
	WINAMP_HELP, // "/winamp - Works with Winamp 1.x, 2.x, 5.x (no Winamp 3 support)\r\n- %[version]	Numerical Version (ex: 2.91)\r\n- %[state]	Playing state (ex: stopped/paused/playing)\r\n- %[title]		Window title from Winamp - if you want to change this for mp3s, Winamp > Pref > Input > MPEG > Title\r\n- %[rawtitle]	Window title from Winamp (if %[title] not working propertly)\r\n- %[percent]	Percentage (ex. 40%)\r\n- %[length]	Length in minutes:seconds (ex: 04:09)\r\n- %[elapsed]	Time elapsed in minutes:seconds (ex. 03:51)\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[bitrate]	Bitrate (ex. 128kbps)\r\n- %[sample]	Sample frequency (ex. 22kHz)\r\n- %[channels]	Number of channels (ex. stereo / mono)\r\n\r\nEmpty = Default String -> +me playing: %[title] at %[bitrate] <Winamp %[version]>\r\n\r\nNote about The KMPlayer:\r\nYou can use most of the features offered by /winamp command and all features of the media toolbar also with The KMPlayer.\r\nParameters that are known not to work (or return incorrect values) are %[version], %[bitrate], %[sample] and %[channels].\r\nIt's also very likely that you will need to use %[rawtitle] instead of %[title] to get the correct output."
	WINAMP_HELP_DESC, // "Winamp Help"
	WINAMP_BACK, // "Back"
	WINAMP_PLAY, // "Play"
	WINAMP_PAUSE, // "Pause"
	WINAMP_NEXT, // "Next"
	WINAMP_STOP, // "Stop"
	WINAMP_VOL_UP, // "Volume up"
	WINAMP_VOL_HALF, // "Volume 50% / Mute"
	WINAMP_VOL_DOWN, // "Volume down"
	TOGGLE_TOOLBAR, // "Media Toolbar\tCtrl+4"
	WINAMP_SPAM, // "Post media spam to main chat"
	WMP_HELP, // "/wmp - Works with Windows Media Player 9+\r\n- %[version]	Version of Windows Media Player\r\n- %[fullversion]	Full version of Windows Media Player\r\n- %[status]	Pre-formatted status string from Windows Media Player\r\n- %[title]		Name of the currently playing item\r\n- %[elapsed]	Time elapsed in (HH:)MM:SS\r\n- %[percent]	Time elapsed presented as percentage from total length\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[length]	Full length of the current item in (HH:)MM:SS\r\n- %[artist]	Name of the artist for the currently playing item\r\n- %[album]	Name of the album the current song is from\r\n- %[genre]	Genre of the current media\r\n- %[bitrate]	Bitrate for the playing media\r\n- %[year]	Year of album publication (no WMP9 support)\r\n- %[size]		Size of the currently playing file\r\n- %[rating]	Users rating, represented with *'s (if available)\r\n\r\nEmpty = Default String -> +me %[title] at %[bitrate] <Windows Media Player %[version]>"
	WMP_HELP_DESC, // "Windows Media Player Help"
	ITUNES_HELP, // "/itunes - For iTunes media spamming\r\n- %[version]	Numerical Version (ex: 7.0.2.16)\r\n- %[album]	Name of the album the current track is from\r\n- %[artist]	Artist of the current track\r\n- %[title]		Name of the currently playing track\r\n- %[genre]	Genre of the currently playing track\r\n- %[elapsed]	Time elapsed in minutes:seconds\r\n- %[percent]	Time elapsed presented as percentage from total length\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[length]	Total length of the current track\r\n- %[bitrate]	Bitrate for the playing track (kbps)\r\n- %[frequency]	Frequency for the currently playing track (kHz)\r\n- %[year]	Year of publication/recording of the current track\r\n- %[size]		Size of the currently playing file\r\n- %[state]	Current state of iTunes (playing/stopped)\r\n\r\nEmpty = Default String -> +me playing: %[title] at %[bitrate] <iTunes %[version]>"
	ITUNES_HELP_DESC, // "iTunes Help"
	MPC_HELP, // "/mpc - For Media Player Classic media spamming\r\n- %[filename]	Name of the file currently playing\r\n- %[title]		Name of the currently playing item (without file extension)\r\n- %[size]		Size of the file currently playing\r\n- %[state]	Current state of Media Player Classic (playing/paused/stopped)\r\n- %[elapsed]	Time elapsed in minutes:seconds\r\n- %[percent]	Time elapsed presented as percentage from total length\r\n- %[bar]		ASCII progress bar, 10 characters wide no including brackets (ex. [----|-----])\r\n- %[length]	Total length of the current file\r\n\r\nEmpty = Default String -> +me playing: %[title] <Media Player Classic>"
	MPC_HELP_DESC, // "Media Player Classic Help"
	NO_MEDIA_SPAM, // "Selected player doesn't support media spams"
	YES, // "Yes"

	STEALTHY_INDICATE_SPEEDS, // "Indicate Speeds (Stealthy Style)"
	SETTINGS_STATE, // "Save settings window state"
	SUPER_USER, // "Can bypass limiter"
	PROGRESSBAR_STEALTHY_STYLE, // "Stealthy Style"
	TICKS_SPEED_DOWN, // "5 ticks down speed:"
	TICKS_SPEED_UP, // "5 ticks up speed:"
	IP_IN_CHAT, // "Attempt to show users IP in chat"
	COUNTRY_IN_CHAT, // "Attempt to show users country in chat"

	USE_ANTIVIR, // "Check finished files for viruses"
	MENU_TOPMOST, // "Always on Top"
	LOCK_TOOLBARS, // "Lock Toolbars"
	INCOMING, // "incoming"
	OUTGOING, // "outgoing"
	BEGIN, // "Begin"
	END, // "End"

	// @DontAdd // page names
	SETTINGS_RSX, // "Client Extras"
	SETTINGS_PARAMS, // "Params"
	SETTINGS_FILTER_PAGE, // "Chat Filters"
	SETTINGS_IP_PAGE, // "IP"
	SETTINGS_USER_INFO_DETECTOR, // "User Info"
	SETTINGS_FILELIST_DETECTOR, // "Filelist Detection"
	SETTINGS_AUTOSEARCH, // "AutoSearch"
	SETTINGS_ACTION_RAW, // "Raw Commands"

	// @DontAdd // strings from settings page
	SETTINGS_FAV_USER_IS_PROTECTED_USER, // "Favorite users are protected"
	SETTINGS_USE_SEND_DELAYED_RAW, // "Use send delayed raw"
	SETTINGS_UNCHECK_CLIENT_PROTECTED_USER, // "Not check the client of the protected users"
	SETTINGS_UNCHECK_LIST_PROTECTED_USER, // "No protected users lists check"
	SETTINGS_CHECK_ALL_CLIENTS_BEFORE_FILELISTS, // "Detect all clients before downloading filelists"
	SETTINGS_DELETE_CHECKED_FILELISTS, // "Delete checked filelists"
	SETTINGS_GET_UPDATE_PROFILE, // "Check the new versions of client profile at startup"
	SETTINGS_IGNORE_PM_SPAMMERS, // "Ignore PM Flooder instead of kick"
	SETTINGS_PROTECT_PM_USERS, // "Protect user during PM session"
	SETTINGS_AUTO_START, // "Start zK++ at Windows starting"

	// @DontAdd // some random settings
	AUTOSEARCH_ENABLE, // "Enable search for forbidden files / TTH"
	AUTOSEARCH_ENABLE_TIME, // "Automatically search every"
	USE_FILTER_FAV, // "Use Chat Filter on connecting to new hubs"
	USE_HL_FAV, // "Use Highlight on connecting to new hubs"
	SETTINGS_EDIT_FOLDER, // "&Edit"
	MENU_RECONNECT_DISCONNECTED, // "Reconnect Disconnected Hubs"

	SETTINGS_LOG_WEBSERVER, // "Log webserver"
	SETTINGS_RAW_CMD_LOG, // "Log Raw Commands"
	SETTINGS_STARTUP_PRIORITY, // "Startup Priority:"
	SETTINGS_NOMINAL_BANDWIDTH, // "Nominal Bandwidth"

	SETTINGS_SHOW_CLIENT_NEW_VER, // "Notify on new Client Profile Version"
	SETTINGS_SHOW_USER_INFO_NEW_VER,  // "Notify on new User Info Profile Version"
	SETTINGS_SHOW_IPWATCH_NEW_VER,  // "Notify on new IP Watch Version"
	SETTINGS_USE_WILDCARDS_TO_PROTECT, // "Use Wildcards to match protected users"
	SETTINGS_UPDATE_PROFILE_CHEATS, // "Override Profile's Cheats during update"
	SETTINGS_UPDATE_PROFILE_COMMENTS, // "Override Profile's Comments during update"
	SETTINGS_SHOW_LUA_ERROR_MESSAGE, // "Show Lua Error Messages"

	SETTINGS_FSTRING, // "Line"
	SETTINGS_IPW_ACTION, // "Action"
	SETTINGS_IPW_IP, // "IP"
	SETTINGS_IPW_RAW, // "Raw"

	COLOR_PROTECTED, // "User is protected"
	PROTECTED, // "Protected"

	ACTION_EXISTS, // "This Action already exists"
	NO_NAME_SPECIFIED, // "No name was specified"
	RAW_ACTION, // "Action of the detector"
	RAW_EXISTS, // "This Raw already exists"
	UN_ACTION, // "No Action"
	SKIP_RENAME_ACTION, // "New identical name, cancelled action..."
	ACTION, // "Action"
	RAW, // "Raw"
	ADD_ACTION, // "Add / Rename an action"
	RENAME, // "Rename"
	FLASH_WINDOW_ON_NEW_PM, // "Flash window on PM only if it's from a new user"
	FLASH_WINDOW_ON_PM, // "Flash window on PM"

	SUPPORT, // "Support"
	INSTALL, // "Operator"
	INSTALL_INTRO, // "Welcome to zK++. Here you can choose which actions you would like that the program does automatically:"
	INSTALL_INFO, // "The client can be removed at any time from Windows \"Add or Remove Programs\"."
	INSTALL_NOTE, // "Thanks for using zK++. For updates, changes, news and further information, don't forget to visit us at our"
	INSTALL_START, // "Create shortcut on Start Menu"
	INSTALL_DESKTOP, // "Create shortcut on Desktop"
	INSTALL_QLAUNCH, // "Add shortcut on Quick Launch"
	INSTALL_FIREWALL, // "Add an exception to Windows Firewall"
	FIREWALL_QUESTION, // "Would you like to add an exception for zK++ to your Windows Firewall?"
	REALLY_RUN, // "This feature works better if zK++ is running under administrator rights. Continue?"
	FAKE_SHARE, // "Fake Share"

	SLEEP_TIME, // "Sleep Time"
	CHECK_DELAY, // "New user delay (in ms)"
	MAX_FILELISTS, // "Max file lists"
	MAX_TESTSURS, // "Max TestSURs"
	DISPLAY_CHEAT, // "Display cheat"

	S_INVALID, // "Invalid RegExp."
	S_MATCH, // "It's a match!"
	S_MISSMATCH, // "No match."
	REGEX_TESTER, // "RegExp tester"

	CLIENT_USER_INFO, // "User Info Detection"

	CP_NOW_UPDATED, // "Client profiles now updated."
	C_PROFILE_EXIST, // "Already exists, change name please"
	CLIENTS_DL_FAIL, // "Client profiles download failed."
	NEW_VERSION_PROFILE, // "New definition of profile available"

	UPDATED, // "Updated"
	FAILED, // "Failed"
	ALREADY_IGNORED, // "User is already in the list of ignored users!"
	IGNORED_USERS, // "Ignored Users"
	IGNORE_CLEAR, // "Clear"
	CLEAN_USER, // "Clean User"
	VERSION_TOO_OLD, // "Your zK++ client is too old, upgrade it with new version."
	LINE_EMPTY, // "Line must not be empty"
	HOST, // "Host"
	EXACT, // "Exact"
	CONTAINS, // "Contains"
	SETTINGS_VALUE, // "Value"

	IP_RANGE, // "IP Range"
	ISPDLG_CONFLICT, // "conflicts with an existing range: "
	ISPDLG_ENTER_ISP, // "Please enter an ISP"
	ISPDLG_INVAILD, // "Invalid IP range"
	ISPDLG_LOWER_THEN_FIRST, // "First IP must be lower than the second"
	ISPDLG_RANGE, // "This range"
	ISP_UPDATED, // "ISPs now updated."
	NOT_ADDED_ISP_LIST, // "Not added to ISP list"
	ISP, // "Isp"
	BAD_ISP, // "Bad"

	CONVERT_FAV, // "Import/Convert Favorites"
	ADL_POINTS, // "Points"
	ADL_OVERRIDE_POINTS_COLUMN, // "Override points"

	MENU_CHANGE_PRIO, // "CPU-RAM Priority"
	MENU_PRIO_NORMAL, // "Normal"
	MENU_PRIO_ABOVE, // "Above Normal"
	MENU_PRIO_BELOW, // "Below Normal"
	MENU_PRIO_HIGH, // "High"
	MENU_PRIO_IDLE, // "Idle"
	MENU_PRIO_REALTIME, // "Real Time"
	MENU_KICK, // "Special Kicks"
	MENU_DETECTION, // "Detection"
	MENU_PROTECT, // "User Protection"
	SET_PROTECTED, // "Set Protected"
	UNSET_PROTECTED, // "Unset Protected"

	FORBIDDEN_DIRS, // "Forbidden Directories"
	FORBIDDEN_FILES, // "Forbidden Files"
	FORBIDDEN_FULLPATHS, // "Forbidden Full Path"
	FORBIDDEN_TTHS, // "Forbidden TTHS"

	USE_REGEXP_OR_WC, // "Use RegExp and/or wildcards"
	SETTINGS_SKIPLIST_SHARE, // "Share Skiplist (wildcards supported, use semicolon to separate entries)"
	SETTINGS_SKIPLIST_DOWNLOAD, // "Download Skiplist (wildcards supported, use semicolon to separate entries)"
	PRIO_FILE, // "Priority Based on Filename"
	PRIO_FILE_HIGHEST, // "Highest:"
	PRIO_FILE_LOWEST, // "Lowest:"
	CHECK_SETTINGS, // "Check Connection"
	GET_IP, // "Get IP address"
	UPDATE_IP, // "Update IP on startup"

	SRCH_STR_ALR_EXIST, // "Search string already exists"
	SRCH_STR_ALR_EXIST_ERROR, // "Error!"

	SOUND_ACTIF_DESACTIF,  // "Enable / Disable the sound"

	PLUGIN_NOT_VALID, // "It's not a valid zK++ Plugin!"
	PLUGIN_LOAD_FAIL, // "Failed to load plugin!"
	PLUGIN_USING_OLD_API, // "Plugin is using too old API revision!"
	PLUGIN_ALREADY_LOADED, // "Plugin is already loaded!"

	// @DontAdd // FakeDetect page cheat's names
	ADL_RAW_LOW, // "Forbidden Files (1-499 points)"
	ADL_RAW_MEDIUM, // "Forbidden Files (500-4999 points)"
	ADL_RAW_HIGH, // "Forbidden Files (5000+ points)"
	SDL_RAW, // "Slow download"
	TIMEOUT_RAW, // "Connection timeout"
	DISCONNECT_RAW, // "TestSUR Disconnect"
	FAKE_SLOT_COUNT, // "Fake Slot count"
	FAKESHARE_RAW, // "Fake Share"
	LISTLEN_MISMATCH, // "ListLen mis-match"
	FILELIST_TOO_SMALL_BIG, // "FileList too small or big"
	FILELIST_NA, // "FileList Unavailable"
	NO_TTHF, // "No TTHF/ADCGET support"
	VERSION_MISMATCH, // "Version mis-match"
	FILELIST_VERSION_MISMATCH, // "FileList Version mis-match"
	RMDC_RAW, // "rmDC++"
	DCPP_EMULATION_RAW, // "DC++ Emulation"
	MYINFO_SPAM_KICK, // "$MyINFO Flood"
	CTM_SPAM_KICK, // "$ConnectToMe Flood"
	PM_SPAM_KICK, // "PM Flood"

	// @DontAdd // some cheats (make sure you're using params in proper way!
	TOO_LOW_DOWNSPD, // "too low download speed (%s)"
    EXTERNAL_PREVIEW, // "Preview text files in external program"
	LAST // @DontAdd
};

