/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private static byte[] bseed = null;
    private static final String STR_CONVERT = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_ ";

    public static void setSeed(String seed) {
        bseed = seed.getBytes();
    }

    private static Key makeKey(int key_bits) {
        byte[] key = new byte[key_bits / 8];
        int i = 0;
        while (i < key.length && i < bseed.length) {
            key[i] = (byte)(bseed[i] ^ i);
            ++i;
        }
        while (i < key.length) {
            key[i] = (byte)(i + 1);
            ++i;
        }
        return new SecretKeySpec(key, "AES");
    }

    public static Key makeKey(int key_bits, String seed) {
        Encryption.setSeed(seed);
        return Encryption.makeKey(key_bits);
    }

    public static byte[] encode(byte[] src, Key skey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, skey);
            return cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decode(byte[] src, Key skey) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, skey);
            return cipher.doFinal(src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] utoa(byte[] indata) {
        int pos = 0;
        byte[] outdata = new byte[indata.length * 2];
        int j = 0;
        int i = 0;
        while (i < indata.length) {
            int val = indata[i] & 0xFF;
            int high = val >> 4;
            int low = val & 0xF;
            outdata[j++] = (byte)STR_CONVERT.charAt(high + pos);
            outdata[j++] = (byte)STR_CONVERT.charAt(low + pos);
            pos = (pos + 16) % STR_CONVERT.length();
            ++i;
        }
        return outdata;
    }

    public static byte[] atou(byte[] indata) {
        int pos = 0;
        byte[] outdata = new byte[indata.length / 2];
        int i = 0;
        int j = 0;
        while (j < outdata.length) {
            int high = STR_CONVERT.indexOf(indata[i++]) - pos;
            int low = STR_CONVERT.indexOf(indata[i++]) - pos;
            outdata[j] = (byte)((high << 4) + low);
            pos = (pos + 16) % STR_CONVERT.length();
            ++j;
        }
        return outdata;
    }

    public static String encode(String input, Key skey) {
        return new String(Encryption.utoa(Encryption.encode(input.getBytes(), skey)));
    }

    public static String decode(String input, Key skey) {
        return new String(Encryption.decode(Encryption.atou(input.getBytes()), skey));
    }
}

