﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.IO;
using System.Diagnostics;
using System.Threading;
//using Tsukikage.Audio;

namespace FDK
{
	public unsafe class Cogg : SoundDecoder
	{
		static byte[] FOURCC = Encoding.ASCII.GetBytes( "SggO" );	// OggS の little endian

        //本当は使いたいけれど、「厳密な名前」が指定されてないため使用不可。ぐぬぬ...
        #region[ OggVorbis.dll ]
        //private Tsukikage.Audio.OggDecodeStream oggDecodeStream = null;
        //private int EnqueuedBufferSize;

        //public override int Open( string filename )
        //{
        //    try
        //    {
        //        oggDecodeStream = new OggDecodeStream( File.OpenRead( filename ) );

        //        return 1;
        //    }
        //    catch( Exception )
        //    {
        //        throw new NotImplementedException();
        //    }
        //}

        //public override int GetFormat( int nHandle, ref CWin32.WAVEFORMATEX wfx )
        //{
        //    return oggGetFormat( nHandle, ref wfx );
        //}

        //public override uint GetTotalPCMSize( int nHandle )
        //{
        //    EnqueuedBufferSize = (int)oggDecodeStream.Length;
        //    return (uint)oggDecodeStream.Length;
        //}

        //public override int Seek( int nHandle, uint dwPosition )
        //{
        //    return (int)oggDecodeStream.Seek( dwPosition, SeekOrigin.Current );
        //}

        //public override int Decode(int nHandle, IntPtr pDest, uint szDestSize, int bLoop)
        //{
        //    int BLOCK_SIZE = (int)szDestSize;
        //    int BUFFER_SIZE = BLOCK_SIZE * 4;
        //    while( this.EnqueuedBufferSize < BUFFER_SIZE )
        //    {
        //        byte[] buffer = new byte[BLOCK_SIZE];
        //        oggDecodeStream.Read(buffer, 0, BLOCK_SIZE);
        //    }

        //    if( this.EnqueuedBufferSize == BUFFER_SIZE )
        //        return 1;

        //    return 0;
        //}

        //public override void Close(int nHandle)
        //{
        //    oggDecodeStream.Close();
        //}
        #endregion

        #region[ SoundDecorder.dll ]

        #region [ SoundDecoder.dll インポート（ogg 関連）]
        //-----------------
        [DllImport( "SoundDecoder.dll" )]
        private static extern void oggClose( int nHandle );
        [DllImport( "SoundDecoder.dll" )]
        private static extern int oggDecode( int nHandle, IntPtr pDest, uint szDestSize, int bLoop );
        [DllImport( "SoundDecoder.dll" )]
        private static extern int oggGetFormat( int nHandle, ref CWin32.WAVEFORMATEX wfx );
        [DllImport( "SoundDecoder.dll" )]
        private static extern uint oggGetTotalPCMSize( int nHandle );
        [DllImport( "SoundDecoder.dll" )]
        private static extern int oggOpen( string fileName );
        [DllImport( "SoundDecoder.dll" )]
        private static extern int oggSeek( int nHandle, uint dwPosition );
        //-----------------
        #endregion


        public override int Open(string filename)
        {
            return oggOpen(filename);
        }
        public override int GetFormat(int nHandle, ref CWin32.WAVEFORMATEX wfx)
        {
            return oggGetFormat(nHandle, ref wfx);
        }
        public override uint GetTotalPCMSize(int nHandle)
        {
            return oggGetTotalPCMSize(nHandle);
        }
        public override int Seek(int nHandle, uint dwPosition)
        {
            return oggSeek(nHandle, dwPosition);
        }
        public override int Decode(int nHandle, IntPtr pDest, uint szDestSize, int bLoop)
        {
            return oggDecode(nHandle, pDest, szDestSize, bLoop);
        }

        public override void Close(int nHandle)
        {
            oggClose(nHandle);
        }
        #endregion

    }
}
