﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using SlimDX;
using FDK;

namespace DTXMania
{
	internal class CAct演奏パネル文字列 : CActivity
	{

		// コンストラクタ

		public CAct演奏パネル文字列()
		{
			base.b活性化してない = true;
			this.strパネル文字列 = "";
			this.Start();
		}
		
		
		// メソッド

		public void SetPanelString( string str )
		{
			this.strパネル文字列 = str;
			if( base.b活性化してる )
			{
				CDTXMania.tテクスチャの解放( ref this.txPanel );
				if( ( this.strパネル文字列 != null ) && ( this.strパネル文字列.Length > 0 ) )
				{
					Bitmap image = new Bitmap( 1, 1 );
					Graphics graphics = Graphics.FromImage( image );
					graphics.PageUnit = GraphicsUnit.Pixel;
					this.n文字列の長さdot = (int) graphics.MeasureString( this.strパネル文字列, this.ft表示用フォント ).Width;
					graphics.Dispose();
					try
					{
						Bitmap bitmap2 = new Bitmap( this.n文字列の長さdot, (int) this.ft表示用フォント.Size );
						graphics = Graphics.FromImage( bitmap2 );
						graphics.DrawString( this.strパネル文字列, this.ft表示用フォント, Brushes.White, (float) 0f, (float) 0f );
						graphics.Dispose();
						this.txPanel = new CTexture( CDTXMania.app.Device, bitmap2, CDTXMania.TextureFormat );
						this.txPanel.vc拡大縮小倍率 = new Vector3( 0.5f, 0.5f, 1f );
						bitmap2.Dispose();
					}
					catch( CTextureCreateFailedException )
					{
						Trace.TraceError( "パネル文字列テクスチャの生成に失敗しました。" );
						this.txPanel = null;
					}
					this.ct進行用 = new CCounter( 0, 3000, 3, CDTXMania.Timer );
				}
                if( !string.IsNullOrEmpty( CDTXMania.DTX.GENRE ) )
                {
                    string strGenre = CDTXMania.DTX.GENRE;
                    if( strGenre.Equals( "アニメ" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_anime.png" ) );
                    }
                    else if( strGenre.Equals( "J-POP" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_JPOP.png" ) );
                    }
                    else if( strGenre.Equals( "ゲームミュージック" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_game.png" ) );
                    }
                    else if( strGenre.Equals( "ナムコオリジナル" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_namco.png" ) );
                    }
                    else if( strGenre.Equals( "クラシック" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_classic.png" ) );
                    }
                    else if( strGenre.Equals( "どうよう" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_child.png" ) );
                    }
                    else if( strGenre.Equals( "バラエティ" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_variety.png" ) );
                    }
                    else if( strGenre.Equals( "ボーカロイド" ) )
                    {
                        this.txGENRE = CDTXMania.tテクスチャの生成( CSkin.Path( @"Graphics\7_Genre_vocaloid.png" ) );
                    }
                    else
                    {
                        Bitmap bmpDummy = new Bitmap( 1, 1 );
                        this.txGENRE = CDTXMania.tテクスチャの生成( bmpDummy, true );
                    }
                }


				this.Start();

                Bitmap bmpSongTitle = new Bitmap(1, 1);
                bmpSongTitle = pfMusicName.DrawPrivateFont( this.strパネル文字列, Color.White, Color.Black );
                //Bitmap bmpVTest = new Bitmap( 1, 1 );
                //bmpVTest = pf縦書きテスト.DrawPrivateFont( this.strパネル文字列, Color.White, Color.Black, true );
                this.txMusicName = CDTXMania.tテクスチャの生成( bmpSongTitle, false );
                Bitmap bmpDiff = new Bitmap(1, 1);
                switch( CDTXMania.stage選曲.n確定された曲の難易度 )
                {
                    case 0:
                        bmpDiff = pfMusicName.DrawPrivateFont( "かんたん 1 曲目", Color.White, Color.Black );
                        break;
                    case 1:
                        bmpDiff = pfMusicName.DrawPrivateFont( "ふつう 1 曲目", Color.White, Color.Black );
                        break;
                    case 2:
                        bmpDiff = pfMusicName.DrawPrivateFont( "むずかしい 1 曲目", Color.White, Color.Black );
                        break;
                    case 3:
                        bmpDiff = pfMusicName.DrawPrivateFont( "おに 1 曲目", Color.White, Color.Black );
                        break;
                    case 4:
                        bmpDiff = pfMusicName.DrawPrivateFont( "えでぃっと 1 曲目", Color.White, Color.Black );
                        break;
                    default:
                        bmpDiff = pfMusicName.DrawPrivateFont( "おに 1 曲目", Color.White, Color.Black );
                        break;
                }

                this.tx難易度とステージ数 = CDTXMania.tテクスチャの生成( bmpDiff, false );

			}
		}

		public void Stop()
		{
			this.bMute = true;
		}
		public void Start()
		{
			this.bMute = false;
		}


		// CActivity 実装

		public override void On活性化()
		{
			this.ft表示用フォント = new Font( "MS PGothic", 48f, FontStyle.Bold, GraphicsUnit.Pixel );
            if( !string.IsNullOrEmpty( CDTXMania.ConfigIni.strPrivateFontで使うフォント名 ) )
            {
                this.pfMusicName = new CPrivateFastFont( new FontFamily( CDTXMania.ConfigIni.strPrivateFontで使うフォント名 ), 30 );
                //this.pf縦書きテスト = new CPrivateFastFont( new FontFamily( CDTXMania.ConfigIni.strPrivateFontで使うフォント名 ), 22 );
            }
            else
                this.pfMusicName = new CPrivateFastFont( new FontFamily( "MS PGothic" ), 30 );

			this.n文字列の長さdot = 0;
			this.txPanel = null;
			this.ct進行用 = new CCounter();
			this.Start();
            this.bFirst = true;
			base.On活性化();
		}
		public override void On非活性化()
		{
			if( this.ft表示用フォント != null )
			{
				this.ft表示用フォント.Dispose();
				this.ft表示用フォント = null;
			}
			CDTXMania.tテクスチャの解放( ref this.txPanel );
			this.ct進行用 = null;
			base.On非活性化();
		}
		public override void OnManagedリソースの作成()
		{
			if( !base.b活性化してない )
			{
				this.SetPanelString( this.strパネル文字列 );


				base.OnManagedリソースの作成();
			}
		}
		public override void OnManagedリソースの解放()
		{
			if( !base.b活性化してない )
			{
				CDTXMania.tテクスチャの解放( ref this.txPanel );
				CDTXMania.tテクスチャの解放( ref this.txMusicName );
                CDTXMania.tテクスチャの解放( ref this.txGENRE );
				base.OnManagedリソースの解放();
			}
		}
		public override int On進行描画()
		{
			throw new InvalidOperationException( "t進行描画(x,y)のほうを使用してください。" );
		}
		public int t進行描画( int x, int y )
		{
			if( !base.b活性化してない && !this.bMute )
			{
				this.ct進行用.t進行Loop();
                if( this.bFirst )
                {
                    this.ct進行用.n現在の値 = 300;
                }

				float num = this.txPanel.vc拡大縮小倍率.X;
				Rectangle rectangle = new Rectangle( (int) ( ( (float) this.ct進行用.n現在の値 ) / num ), 0, (int) ( 408f / num ), (int) this.ft表示用フォント.Size );

                #region[ 透明度制御 ]
                if( this.ct進行用.n現在の値 < 255 )
                {
                    this.txMusicName.n透明度 = this.ct進行用.n現在の値;
                    if( this.txGENRE != null )
                        this.txGENRE.n透明度 = this.ct進行用.n現在の値;
                    this.tx難易度とステージ数.n透明度 = 255 - this.ct進行用.n現在の値;
                }
                else if( this.ct進行用.n現在の値 >= 255 && this.ct進行用.n現在の値 < 1245 )
                {
                    this.bFirst = false;
                    this.txMusicName.n透明度 = 255;
                    if( this.txGENRE != null )
                        this.txGENRE.n透明度 = 255;
                    this.tx難易度とステージ数.n透明度 = 0;
                }
                else if( this.ct進行用.n現在の値 >= 1245 && this.ct進行用.n現在の値 < 1500 )
                {
                    this.txMusicName.n透明度 = 255 - ( this.ct進行用.n現在の値 - 1245 );
                    if( this.txGENRE != null )
                        this.txGENRE.n透明度 = 255 - ( this.ct進行用.n現在の値 - 1245 );
                    this.tx難易度とステージ数.n透明度 = this.ct進行用.n現在の値 - 1245;
                }
                else if( this.ct進行用.n現在の値 >= 1500 && this.ct進行用.n現在の値 <= 3000 )
                {
                    this.txMusicName.n透明度 = 0;
                    if( this.txGENRE != null )
                        this.txGENRE.n透明度 = 0;
                    this.tx難易度とステージ数.n透明度 = 255;

                }
                #endregion

                if( this.txGENRE != null )
                    this.txGENRE.t2D描画( CDTXMania.app.Device, 1118, 69 );
                this.txMusicName.t2D描画( CDTXMania.app.Device, 1260 - this.txMusicName.szテクスチャサイズ.Width, 14 );
				this.tx難易度とステージ数.t2D描画( CDTXMania.app.Device, 1260 - this.tx難易度とステージ数.szテクスチャサイズ.Width, 14 );
                //CDTXMania.act文字コンソール.tPrint( 0, 0, C文字コンソール.Eフォント種別.白, this.ct進行用.n現在の値.ToString() );

				//this.txMusicName.t2D描画( CDTXMania.app.Device, 1250 - this.txMusicName.szテクスチャサイズ.Width, 14 );
			}
			return 0;
		}


		// その他

		#region [ private ]
		//-----------------
		private CCounter ct進行用;

		private Font ft表示用フォント;
		private int n文字列の長さdot;
		private string strパネル文字列;
		private CTexture txPanel;
		private bool bMute;
        private bool bFirst;

        private CTexture txMusicName;
        private CTexture tx難易度とステージ数;
        private CTexture txGENRE;
        private CPrivateFastFont pfMusicName;
        private CPrivateFastFont pf縦書きテスト;
		//-----------------
		#endregion
	}
}
