/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium.property;

import java.awt.CardLayout;
import java.awt.Frame;
import java.util.function.Supplier;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import mirrg.struct.hydrogen.Tuple;
import mirrg.swing.helium.DialogMirrg;
import mirrg.swing.helium.logging.HLog;
import mirrg.swing.helium.property.ManagerProperty;
import mirrg.swing.helium.property.Property;

public class DialogProperties
extends DialogMirrg {
    private Supplier<ManagerProperty> supplierManagerProperty;
    private JScrollPane scrollPane;
    private DefaultTableModel tableModel;

    public DialogProperties(Frame frame, Supplier<ManagerProperty> supplierManagerProperty) {
        super(frame, "\u30d7\u30ed\u30d1\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3");
        this.supplierManagerProperty = supplierManagerProperty;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30e1\u30cb\u30e5\u30fc(M)");
        menuBar.add(menu);
        menu.setMnemonic('M');
        JMenuItem menuItem = new JMenuItem("\u518d\u8aad\u307f\u8fbc\u307f(R)");
        menu.add(menuItem);
        menuItem.setMnemonic('R');
        menuItem.addActionListener(e -> this.refreshAll());
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
        this.refreshAll();
        this.onTick.add(this::refresh);
        this.setLayout(new CardLayout());
        this.enabledTick = true;
        this.msTick = 100;
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationByPlatform(true);
    }

    private ManagerProperty getManagerProperty() {
        return this.supplierManagerProperty.get();
    }

    private void refresh() {
        if (this.tableModel == null) {
            return;
        }
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            String id = (String)this.tableModel.getValueAt(row, 0);
            Property property = this.getManagerProperty().getProperty(id).orElse(null);
            if (property != null) {
                this.tableModel.setValueAt(property.getString(), row, 2);
                continue;
            }
            HLog.processExceptionWarning(new RuntimeException("found property id: " + id));
        }
        this.scrollPane.repaint();
    }

    private void refreshAll() {
        Tuple<JTable, DefaultTableModel> res = this.createTable();
        this.scrollPane.setViewportView(res.getX());
        this.tableModel = res.getY();
        this.scrollPane.repaint();
    }

    private Tuple<JTable, DefaultTableModel> createTable() {
        final DefaultTableModel tableModel = new DefaultTableModel(0, 4){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }
        };
        tableModel.setColumnIdentifiers(new Object[]{"ID", "\u540d\u79f0", "\u5024", "\u578b"});
        this.getManagerProperty().getProperties().forEach(property -> tableModel.addRow(new Object[]{property.id, property.name, property.getString(), property.getType()}));
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                for (int row = e.getFirstRow(); row <= e.getLastRow(); ++row) {
                    if (row == -1) continue;
                    String id = (String)tableModel.getValueAt(row, 0);
                    Property property = DialogProperties.this.getManagerProperty().getProperty(id).orElse(null);
                    String string = (String)tableModel.getValueAt(row, 2);
                    if (property != null) {
                        property.setString(string);
                        continue;
                    }
                    HLog.processExceptionWarning(new RuntimeException("found property id: " + id));
                }
            }
        });
        return new Tuple<JTable, DefaultTableModel>(new JTable(tableModel), tableModel);
    }
}

