/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium;

import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.JFrame;

public class FrameMirrg
extends JFrame {
    private ArrayList<Consumer<WindowEvent>> listenersOnInitialized = new ArrayList();
    private ArrayList<Consumer<ComponentEvent>> listenersOnShown = new ArrayList();
    private ArrayList<Consumer<ComponentEvent>> listenersOnHidden = new ArrayList();
    private ArrayList<Consumer<WindowEvent>> listenersOnDisposed = new ArrayList();
    private boolean visible = false;
    private volatile boolean isDisposed = false;

    public FrameMirrg() throws HeadlessException {
        this.initFrameMirrg();
    }

    public FrameMirrg(GraphicsConfiguration gc) {
        super(gc);
        this.initFrameMirrg();
    }

    public FrameMirrg(String title) throws HeadlessException {
        super(title);
        this.initFrameMirrg();
    }

    public FrameMirrg(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initFrameMirrg();
    }

    public void hookInitialized(Consumer<WindowEvent> listener) {
        this.listenersOnInitialized.add(listener);
    }

    public void hookShown(Consumer<ComponentEvent> listener) {
        this.listenersOnShown.add(listener);
    }

    public void hookHidden(Consumer<ComponentEvent> listener) {
        this.listenersOnHidden.add(listener);
    }

    public void hookDisposed(Consumer<WindowEvent> listener) {
        this.listenersOnDisposed.add(listener);
    }

    private void initFrameMirrg() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                FrameMirrg.this.visible = true;
                FrameMirrg.this.listenersOnShown.forEach(listener -> listener.accept(e));
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                FrameMirrg.this.visible = false;
                FrameMirrg.this.listenersOnHidden.forEach(listener -> listener.accept(e));
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
                FrameMirrg.this.listenersOnInitialized.forEach(listener -> listener.accept(e));
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (FrameMirrg.this.visible) {
                    FrameMirrg.this.listenersOnHidden.forEach(listener -> listener.accept(e));
                }
                FrameMirrg.this.listenersOnDisposed.forEach(listener -> listener.accept(e));
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        super.dispose();
    }

    public void prepareFrame() {
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationByPlatform(true);
    }
}

