/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.helium;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import mirrg.struct.hydrogen.Struct1;
import mirrg.struct.hydrogen.Tuple;
import mirrg.swing.helium.FrameMirrg;
import mirrg.swing.helium.GroupBuilder;
import mirrg.swing.helium.HSwing;
import mirrg.swing.helium.logging.EnumTypeLog;
import mirrg.swing.helium.logging.HLog;

public class FrameHTML
extends FrameMirrg {
    private LinkedList<Tuple<URL, Integer>> historyLeft = new LinkedList();
    private LinkedList<Tuple<URL, Integer>> historyRight = new LinkedList();
    private JButton button1;
    private JButton button2;
    private JTextField textField1;
    private JEditorPane editorPane1;
    private JScrollPane scrollPane1;

    public FrameHTML() {
        this.setTitle("HTML\u30d3\u30e5\u30fc\u30ef");
        this.button1 = new JButton("\u623b\u308b");
        this.button1.setToolTipText("\u53f3\u30af\u30ea\u30c3\u30af\uff1a\u30d7\u30eb\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\u8868\u793a");
        this.button1.addActionListener(e -> {
            if (!this.historyLeft.isEmpty()) {
                this.travelLeft(1);
            }
        });
        HSwing.hookPopup(this.button1, e -> {
            if (!this.historyLeft.isEmpty()) {
                JPopupMenu popupMenu = new JPopupMenu();
                for (int i = this.historyLeft.size() - 1; i >= 0; --i) {
                    Tuple<URL, Integer> entry = this.historyLeft.get(i);
                    JMenuItem menuItem = new JMenuItem(entry.getY().toString() + ": " + entry.getX().toString());
                    popupMenu.add(menuItem);
                    int i2 = i + 1;
                    menuItem.addActionListener(e2 -> this.travelLeft(i2));
                }
                popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                return true;
            }
            return false;
        });
        this.button2 = new JButton("\u9032\u3080");
        this.button2.setToolTipText("\u53f3\u30af\u30ea\u30c3\u30af\uff1a\u30d7\u30eb\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\u8868\u793a");
        this.button2.addActionListener(e -> {
            if (!this.historyRight.isEmpty()) {
                this.travelRight(1);
            }
        });
        HSwing.hookPopup(this.button2, e -> {
            if (!this.historyRight.isEmpty()) {
                JPopupMenu popupMenu = new JPopupMenu();
                for (int i = 0; i < this.historyRight.size(); ++i) {
                    Tuple<URL, Integer> entry = this.historyRight.get(i);
                    JMenuItem menuItem = new JMenuItem(entry.getY().toString() + ": " + entry.getX().toString());
                    popupMenu.add(menuItem);
                    int i2 = i + 1;
                    menuItem.addActionListener(e2 -> this.travelRight(i2));
                }
                popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                return true;
            }
            return false;
        });
        this.textField1 = new JTextField();
        this.textField1.addActionListener(e -> this.navigate(this.textField1.getText()));
        JButton button3 = new JButton("\u79fb\u52d5");
        button3.addActionListener(e -> this.navigate(this.textField1.getText()));
        JButton button4 = new JButton("\u66f4\u65b0");
        button4.addActionListener(e -> this.refresh());
        this.editorPane1 = new JEditorPane();
        this.editorPane1.setEditable(false);
        this.editorPane1.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.navigate(e.getURL());
            }
        });
        this.editorPane1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 116) {
                    FrameHTML.this.refresh();
                    return;
                }
                if (e.getKeyCode() == 8) {
                    if (!FrameHTML.this.historyLeft.isEmpty()) {
                        FrameHTML.this.travelLeft(1);
                    }
                    return;
                }
            }
        });
        this.scrollPane1 = new JScrollPane(this.editorPane1);
        this.scrollPane1.setPreferredSize(new Dimension(800, 800));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupBuilder.group(GroupBuilder.group(this.button1, this.button2, new JLabel("\u30a2\u30c9\u30ec\u30b9:"), this.textField1, button3, button4).align(GroupLayout.Alignment.CENTER), this.scrollPane1).apply(layout);
        this.historyChanged();
        HLog.log(EnumTypeLog.FINE, "HTML\u30d3\u30e5\u30fc\u30ef\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f");
        this.prepareFrame();
    }

    private void refresh() {
        Tuple<URL, Integer> now = this.getNow();
        ((HTMLDocument)this.editorPane1.getDocument()).getDocumentProperties().remove("stream");
        if (now != null) {
            this.setPage(now);
        }
    }

    private Tuple<URL, Integer> getNow() {
        URL page = this.editorPane1.getPage();
        return page == null ? null : new Tuple<URL, Integer>(page, this.scrollPane1.getVerticalScrollBar().getValue());
    }

    private void travelLeft(int times) {
        Tuple<URL, Integer> now = this.getNow();
        for (int i = 0; i < times; ++i) {
            this.historyRight.addFirst(now);
            now = this.historyLeft.removeLast();
        }
        this.historyChanged();
        this.setPage(now);
    }

    private void travelRight(int times) {
        Tuple<URL, Integer> now = this.getNow();
        for (int i = 0; i < times; ++i) {
            this.historyLeft.addLast(now);
            now = this.historyRight.removeFirst();
        }
        this.historyChanged();
        this.setPage(now);
    }

    private void setPage(Tuple<URL, Integer> url) {
        try {
            this.editorPane1.setPage(url.getX());
        }
        catch (IOException e2) {
            HLog.processExceptionWarning(e2);
            return;
        }
        this.textField1.setText(url.getX().toString());
        Struct1 listener = new Struct1();
        listener.x = e -> {
            this.editorPane1.removePropertyChangeListener("page", (PropertyChangeListener)struct1.x);
            this.scrollPane1.getVerticalScrollBar().setValue((Integer)url.getY());
        };
        this.editorPane1.addPropertyChangeListener("page", (PropertyChangeListener)listener.x);
        this.scrollPane1.getVerticalScrollBar().setValue(url.getY());
    }

    public void navigate(String url) {
        Tuple<URL, Integer> now = this.getNow();
        if (now != null) {
            this.historyLeft.addLast(now);
            this.historyChanged();
        }
        try {
            this.editorPane1.setPage(url);
        }
        catch (IOException e) {
            HLog.processExceptionWarning(e);
            return;
        }
        this.textField1.setText(url);
    }

    public void navigate(URL url) {
        Tuple<URL, Integer> now = this.getNow();
        if (now != null) {
            this.historyLeft.addLast(now);
            this.historyChanged();
        }
        try {
            this.editorPane1.setPage(url);
        }
        catch (IOException e) {
            HLog.processExceptionWarning(e);
            return;
        }
        this.textField1.setText(url.toString());
    }

    private void historyChanged() {
        this.button1.setEnabled(!this.historyLeft.isEmpty());
        this.button2.setEnabled(!this.historyRight.isEmpty());
    }
}

