/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;

public abstract class ToolCursorPutConnectionBase<E extends Entity>
extends ToolCursor {
    private E begin;
    private Point pointEnd;
    private E end;

    public ToolCursorPutConnectionBase(IFrameGameAlmandine frameGameAlmandine) {
        super(frameGameAlmandine);
        this.eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
            this.mouseMoved(e.mouseEvent);
            this.mouseDragged(e.mouseEvent);
        });
        this.eventManager.register(NitrogenEventMouse.Released.class, e -> {
            try {
                if (this.begin == null) {
                    return;
                }
                this.mouseDragged(e.mouseEvent);
                if (this.end == null) {
                    return;
                }
                if (this.begin == this.end) {
                    return;
                }
                this.add(this.begin, this.end);
            }
            finally {
                this.begin = null;
                this.pointEnd = null;
                this.end = null;
            }
        });
        this.eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> this.mouseDragged(e.mouseEvent));
        this.eventManager.register(NitrogenEventMouseMotion.Moved.class, e -> this.mouseMoved(e.mouseEvent));
        this.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
            if (this.begin == null) {
                return;
            }
            frameGameAlmandine.doTranslate(e.graphics, () -> {
                if (this.end != null) {
                    render.graphics.setColor(new Color(0xFF0000));
                    try {
                        Point pointBegin = ((Entity)this.begin).getPoint();
                        Point pointEnd = ((Entity)this.end).getPoint();
                        render.graphics.drawLine(pointBegin.x, pointBegin.y, pointEnd.x, pointEnd.y);
                    }
                    catch (IllegalEntityIdException e2) {
                        // empty catch block
                    }
                    try {
                        ((Entity)this.begin).drawHover(render.graphics);
                        ((Entity)this.end).drawHover(render.graphics);
                    }
                    catch (IllegalEntityIdException e2) {}
                } else if (this.pointEnd != null) {
                    render.graphics.setColor(new Color(0xFF0000));
                    try {
                        Point pointBegin = ((Entity)this.begin).getPoint();
                        render.graphics.drawLine(pointBegin.x, pointBegin.y, this.pointEnd.x, this.pointEnd.y);
                    }
                    catch (IllegalEntityIdException e2) {
                        // empty catch block
                    }
                    try {
                        ((Entity)this.begin).drawHover(render.graphics);
                    }
                    catch (IllegalEntityIdException e2) {}
                } else {
                    try {
                        ((Entity)this.begin).drawHover(render.graphics);
                    }
                    catch (IllegalEntityIdException illegalEntityIdException) {
                        // empty catch block
                    }
                }
            });
        });
    }

    public abstract Class<E> getClassEntity();

    public void mouseMoved(MouseEvent e) {
        this.begin = Factory.filterHover(Factory.filterClass(this.getFactory().getEntities(), this.getClassEntity()), this.getCoord(e)).stream().findFirst().orElse(null);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.begin == null) {
            return;
        }
        this.pointEnd = this.getCoord(e);
        this.end = Factory.filterHover(Factory.filterClass(this.getFactory().getEntities(), this.getClassEntity()), this.getCoord(e)).stream().findFirst().orElse(null);
    }

    protected abstract void add(E var1, E var2);
}

