/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;
import mirrg.simulation.cart.almandine.mods.vanilla.toolcursors.ModuleClickEntity;
import mirrg.swing.helium.logging.HLog;

public class ToolCursorPutCart
extends ToolCursor {
    public ToolCursorPutCart(IFrameGameAlmandine frameGameAlmandine) {
        super(frameGameAlmandine);
        new ModuleClickEntity<Entity>(frameGameAlmandine, button -> button == 1, (e, entity) -> {
            if (entity instanceof StationBase) {
                try {
                    this.getFactory().addLater(new Cart(this.getGame(), new Cart.PositionStation(entity.getId(), ((StationBase)entity).freeOrder()), 12, 5.0));
                }
                catch (IllegalEntityIdException e2) {
                    HLog.processExceptionWarning(e2);
                }
            } else if (entity instanceof RailBase) {
                try {
                    double position = ((RailBase)entity).getPosition(this.getCoord((MouseEvent)e));
                    this.getFactory().addLater(new Cart(this.getGame(), new Cart.PositionRail(entity.getId(), position, position > 0.5), 12, 5.0));
                }
                catch (IllegalEntityIdException e1) {
                    HLog.processException(e1);
                }
            } else {
                HLog.warning("\u4e0d\u6b63\u306a\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f: " + entity);
            }
        }, (factory, point) -> {
            Collector collector = Collectors.toCollection(() -> new ArrayList());
            return Factory.filterHover(factory.getEntities(), point).stream().filter(entity -> entity instanceof StationBase || entity instanceof RailBase).collect(collector);
        }).apply(this);
    }

    @Override
    public String getLocalizedName() {
        return "\u8a2d\u7f6e\uff1a\u8ca8\u8eca";
    }

    @Override
    public String getLocalizedDescription() {
        return "\u99c5\u307e\u305f\u306f\u30ec\u30fc\u30eb\u3092\u5de6\u30af\u30ea\u30c3\u30af";
    }
}

