/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.toolcursors;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.function.BiFunction;
import mirrg.applet.nitrogen.events.NitrogenEventMouse;
import mirrg.applet.nitrogen.events.NitrogenEventMouseMotion;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.gui.toolcursor.NitrogenEventToolCursor;
import mirrg.simulation.cart.almandine.gui.toolcursor.ToolCursor;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.AreaBase;

public class ToolCursorPutArea
extends ToolCursor {
    private Point begin;
    private Point end;

    public ToolCursorPutArea(IFrameGameAlmandine frameGameAlmandine, BiFunction<GameAlmandine, Bound, AreaBase> creator) {
        super(frameGameAlmandine);
        this.eventManager.register(NitrogenEventMouse.Pressed.class, e -> {
            this.begin = this.getCoord(e.mouseEvent);
            this.mouseDragged(e.mouseEvent);
        });
        this.eventManager.register(NitrogenEventMouse.Released.class, e -> {
            this.mouseDragged(e.mouseEvent);
            if (this.begin == null) {
                return;
            }
            if (this.end == null) {
                return;
            }
            Rectangle area = new Rectangle(Math.min(this.begin.x, this.end.x), Math.min(this.begin.y, this.end.y), Math.abs(this.end.x - this.begin.x), Math.abs(this.end.y - this.begin.y));
            this.begin = null;
            this.end = null;
            this.getFactory().addLater((Primary)creator.apply(this.getGame(), new Bound(area)));
        });
        this.eventManager.register(NitrogenEventMouseMotion.Dragged.class, e -> this.mouseDragged(e.mouseEvent));
        this.eventManager.register(NitrogenEventToolCursor.Render.class, e -> {
            if (this.begin == null) {
                return;
            }
            if (this.end == null) {
                return;
            }
            Rectangle area = new Rectangle(Math.min(this.begin.x, this.end.x), Math.min(this.begin.y, this.end.y), Math.abs(this.end.x - this.begin.x), Math.abs(this.end.y - this.begin.y));
            frameGameAlmandine.doTranslate(e.graphics, () -> {
                render.graphics.setColor(new Color(1079951715, true));
                render.graphics.fill(area);
                render.graphics.setColor(new Color(-799096477, true));
                render.graphics.draw(area);
            });
        });
    }

    public void mouseDragged(MouseEvent e) {
        this.end = this.getCoord(e);
    }

    @Override
    public String getLocalizedName() {
        return "\u8a2d\u7f6e\uff1a\u9818\u57df";
    }

    @Override
    public String getLocalizedDescription() {
        return "\u5de6\u30c9\u30e9\u30c3\u30b0\u3067\u914d\u7f6e";
    }
}

