/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stations;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.enchant.EnchantCartCover;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.StationBase;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.Cart;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.RailBase;
import mirrg.simulation.cart.almandine.mods.vanilla.stations.StationThrough;

public abstract class StationCoverBase
extends StationThrough {
    public String direction;
    public double amount;
    public double duration;

    @Deprecated
    public StationCoverBase() {
    }

    public StationCoverBase(GameAlmandine game, Point point, int radius, double duration) {
        super(game, point, radius);
        this.duration = duration;
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyDouble("Duration", "s", () -> this.duration, duration -> {
            if (duration < 0.0) {
                return false;
            }
            this.duration = duration;
            return true;
        });
        dialogProperty.addPropertyDouble("Amount", "s", () -> this.amount, amount -> {
            if (amount < 0.0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
        dialogProperty.addPropertyComboBox("Direction", Stream.of(StationBase.Direction.values()), () -> StationBase.Direction.valueOf(this.direction), direction -> {
            this.direction = direction.name();
            return true;
        });
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        Cart cart;
        if (this.direction == null) {
            this.direction = "UNDEFINED";
        }
        if ((cart = (Cart)this.getCartPrimary().orElse(null)) == null) {
            return;
        }
        StationBase.Direction direction2 = StationBase.Direction.valueOf(this.direction);
        if (direction2 == null || direction2 == StationBase.Direction.UNDEFINED) {
            this.processCart(deltaSecond, cart);
            return;
        }
        RailBase rail = this.getRail(direction2).orElse(null);
        if (rail == null) {
            super.tick(deltaSecond);
            return;
        }
        if (rail.getId() == ((Cart.PositionStation)cart.position).idRailFrom) {
            this.processCart(deltaSecond, cart);
            return;
        }
        super.tick(deltaSecond);
    }

    protected void processCart(double deltaSecond, Cart cart) throws IllegalEntityIdException {
        if (this.shouldAction(deltaSecond, cart)) {
            this.amount += deltaSecond;
            if (this.amount > this.duration) {
                this.amount = 0.0;
                this.action(deltaSecond, cart);
            }
        } else {
            super.tick(deltaSecond);
        }
    }

    protected abstract void action(double var1, Cart var3) throws IllegalEntityIdException;

    protected abstract boolean shouldAction(double var1, Cart var3) throws IllegalEntityIdException;

    @Override
    public void draw(Graphics2D graphics) {
        super.draw(graphics);
        int w = 40;
        graphics.setColor(new Color(0xE0E0E0));
        graphics.fill(new Rectangle2D.Double(this.x - w / 2, this.y - this.radius - 16, w, 10.0));
        graphics.setColor(new Color(this.getColor()));
        graphics.fill(new Rectangle2D.Double(this.x - w / 2, this.y - this.radius - 16, (double)w * (this.amount / this.duration), 10.0));
        this.drawMarkerDirection(graphics, this.direction, true);
    }

    protected Optional<EnchantCartCover> getCover(Cart cart) {
        return cart.enchants.stream().filter(enchent -> enchent instanceof EnchantCartCover).findFirst().map(enchant -> (EnchantCartCover)enchant);
    }
}

