/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.thermo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslabs.thermo.IStackSlabThermo;

public class StackSlabThermo
implements IStackSlab,
IStackSlabThermo {
    public int amount;
    public double temperature = 0.0;

    @Deprecated
    public StackSlabThermo() {
    }

    public StackSlabThermo(int amount, double temperature) {
        this.amount = amount;
        this.temperature = temperature;
    }

    @Override
    public IStackSlab tryPop(int amount) {
        if (this.amount < amount) {
            this.amount = 0;
            return new StackSlabThermo(this.amount, this.temperature);
        }
        this.amount -= amount;
        return new StackSlabThermo(amount, this.temperature);
    }

    @Override
    public void push(IStackSlab stack) {
        double temperature = stack instanceof IStackSlabThermo ? ((IStackSlabThermo)stack).getTemperatureMean() : 0.0;
        double at = (double)this.amount * this.temperature + (double)stack.getAmount() * temperature;
        this.amount += stack.getAmount();
        if (this.amount != 0) {
            this.temperature = at / (double)this.amount;
        }
        stack.clear();
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void clear() {
        this.amount = 0;
        this.temperature = 0.0;
    }

    @Override
    public void addProperty(Factory factory, IDialogProperty dialogProperty) {
        dialogProperty.addPropertyInt("Amount", "\u500b", () -> this.amount, amount -> {
            if (amount <= 0) {
                return false;
            }
            this.amount = amount;
            return true;
        });
        dialogProperty.addPropertyDouble("Temperature", "C", () -> this.temperature, temperature -> {
            this.temperature = temperature;
            return true;
        });
    }

    @Override
    public void renderGauge(Graphics2D graphics, Rectangle bound, int capacity) {
        double r = this.temperature / 1000.0;
        if (r < 0.0) {
            r = 0.0;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        graphics.setColor(new Color((float)r, 0.0f, 0.0f));
        int h = (int)(bound.getHeight() * (double)this.amount / (double)capacity);
        graphics.fillRect((int)bound.getMinX(), (int)bound.getMaxY() - h, (int)bound.getWidth(), h);
    }

    @Override
    public double getTemperatureMean() {
        return this.temperature;
    }

    @Override
    public void tick(Factory factory, double deltaSecond, Environment environment) {
        double temperatureEnvironment = environment.getDouble("temperature").orElse(25.0);
        double gap = this.temperature - temperatureEnvironment;
        double durationHeatHalfLife = environment.getDouble("durationHeatHalfLife").orElse(10800.0);
        if (durationHeatHalfLife == 0.0) {
            this.temperature = gap;
        } else {
            double ratio = Math.pow(0.5, deltaSecond / durationHeatHalfLife);
            this.temperature = temperatureEnvironment + (gap *= ratio);
        }
    }
}

