/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stackslab;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;

public class SlotSlab {
    public IStackSlab stack;
    public int capacity;

    @Deprecated
    public SlotSlab() {
    }

    public SlotSlab(int capacity) throws IllegalEntityIdException {
        this.capacity = capacity;
    }

    public IStackSlab tryPop(int amount) {
        if (this.stack == null) {
            return null;
        }
        IStackSlab stack2 = this.stack.tryPop(amount);
        if (this.stack.getAmount() == 0) {
            this.stack = null;
        }
        return stack2;
    }

    public void render(Graphics2D graphics, Rectangle bound) {
        graphics.setColor(new Color(128));
        graphics.fill(bound);
        bound = new Rectangle(bound);
        bound.grow(-2, -2);
        graphics.setColor(new Color(0xC0C0C0));
        graphics.fill(bound);
        if (this.stack != null) {
            this.stack.renderGauge(graphics, bound, this.capacity);
        }
    }

    public int tryPush(SlotSlab slot) {
        int amount = this.tryPush(slot.stack);
        if (slot.stack.getAmount() == 0) {
            slot.stack = null;
        }
        return amount;
    }

    public int tryPush(IStackSlab stack) {
        if (this.stack == null) {
            this.stack = stack.tryPop(0);
        }
        int amount = this.stack.getAmount() + stack.getAmount() > this.capacity ? this.capacity - this.stack.getAmount() : stack.getAmount();
        IStackSlab stackTransfer = stack.tryPop(amount);
        amount = stackTransfer.getAmount();
        this.stack.push(stackTransfer);
        return amount;
    }

    public void addProperty(Factory factory, IDialogProperty dialogProperty) {
        if (this.stack != null) {
            this.stack.addProperty(factory, dialogProperty);
            dialogProperty.addPropertyInt("Capacity", "\u500b", () -> this.capacity, capacity -> {
                if (capacity <= 0) {
                    return false;
                }
                this.capacity = capacity;
                return true;
            });
        }
    }

    public boolean isFull() {
        return this.stack == null ? 0 >= this.capacity : this.stack.getAmount() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.stack == null ? true : this.stack.getAmount() <= 0;
    }
}

