/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.stackslab;

import java.awt.Point;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.factory.Factory;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.Environment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.IStackSlab;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.RegistryProviderEnvironment;
import mirrg.simulation.cart.almandine.mods.vanilla.stackslab.SlotSlab;
import mirrg.swing.helium.property.PropertyString;

public class ManagerEnvironment {
    public static IStackSlab createStackSlab(GameAlmandine game, Point point, int amount, SlotSlab slotSlab) {
        Environment environment = ManagerEnvironment.getEnvironment(game, point);
        Stream<IProviderEnvironment> stream = ManagerEnvironment.getProviderEnvironments(game, point);
        return stream.map(providerEnvironment -> providerEnvironment.createStackSlab(amount, environment)).filter(stackSlab -> stackSlab != null).findFirst().get();
    }

    public static IProviderEnvironment getEnvironmentDefault(GameAlmandine game) {
        try {
            String id = ((PropertyString)game.managerProperty.getProperty((String)"stackslab.providerEnvironmentDefault").get()).value;
            return RegistryProviderEnvironment.instance.get(id).get();
        }
        catch (ClassCastException | NoSuchElementException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<IProviderEnvironment> getProviderEnvironments(GameAlmandine game, Point point) {
        return Stream.of(Factory.filterHover(game.factory.getEntities(), point).stream().filter(entity -> entity instanceof IProviderEnvironment).map(entity -> (IProviderEnvironment)((Object)entity)), Stream.of(ManagerEnvironment.getEnvironmentDefault(game))).flatMap(stream -> stream);
    }

    public static Environment getEnvironment(GameAlmandine game, Point point) {
        return ManagerEnvironment.getEnvironment(game, point, null);
    }

    public static Environment getEnvironment(GameAlmandine game, Point point, IProviderEnvironment providerEnvironment) {
        Environment environment = new Environment();
        ArrayList providerEnvironments = ManagerEnvironment.getProviderEnvironments(game, point).collect(Collectors.toCollection(ArrayList::new));
        for (int i = providerEnvironments.size() - 1; i >= 0; --i) {
            ((IProviderEnvironment)providerEnvironments.get(i)).getEnvironment(environment);
        }
        if (providerEnvironment != null) {
            providerEnvironment.getEnvironment(environment);
        }
        return environment;
    }
}

