/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.mods.vanilla.parts.Bound;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.IPrimaryMovable;
import mirrg.simulation.cart.almandine.mods.vanilla.primaries.IPrimaryResizable;

public abstract class PrimaryRectangleBase
extends Primary
implements IPrimaryMovable,
IPrimaryResizable {
    public Bound bound;

    @Deprecated
    public PrimaryRectangleBase() {
    }

    public PrimaryRectangleBase(GameAlmandine game, Bound bound) {
        super(game);
        this.bound = bound;
    }

    @Override
    public void move(int dx, int dy) {
        this.bound = this.bound.translate(dx, dy);
    }

    @Override
    public void resize(int width, int height) {
        this.bound = this.bound.resize(width, height);
    }

    @Override
    public void resizeOffset(int dw, int dh) {
        this.bound = this.bound.resize(this.bound.getWidth() + dw, this.bound.getHeight() + dh);
    }

    @Override
    public void draw(Graphics2D graphics) throws IllegalEntityIdException {
        this.drawBody(graphics);
    }

    @Override
    public void drawOverlay(Graphics2D graphics) throws IllegalEntityIdException {
        if (this.selected) {
            this.drawSelectMarker(graphics);
        }
    }

    @Override
    public void drawHover(Graphics2D graphics) {
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(8125570));
        graphics.draw(this.bound.grow(5).createShape());
        graphics.setStroke(stroke);
    }

    protected abstract void drawBody(Graphics2D var1) throws IllegalEntityIdException;

    protected void drawSelectMarker(Graphics2D graphics) {
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(255, 128, 0));
        graphics.draw(this.bound.grow(5).createShape());
        graphics.setStroke(stroke);
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyInt("X", "px", () -> this.bound.getX(), x -> {
            this.bound = new Bound(x, this.bound.getY(), this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        dialogProperty.addPropertyInt("Y", "px", () -> this.bound.getY(), y -> {
            this.bound = new Bound(this.bound.getX(), y, this.bound.getWidth(), this.bound.getHeight());
            return true;
        });
        dialogProperty.addPropertyInt("Width", "px", () -> this.bound.getWidth(), width -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), width, this.bound.getHeight());
            return true;
        });
        dialogProperty.addPropertyInt("Height", "px", () -> this.bound.getHeight(), height -> {
            this.bound = new Bound(this.bound.getX(), this.bound.getY(), this.bound.getWidth(), height);
            return true;
        });
    }

    @Override
    public boolean isContained(Rectangle rectangle) throws IllegalEntityIdException {
        return this.bound.contained(rectangle);
    }

    @Override
    public boolean isHover(int x, int y) {
        return this.bound.contains(x, y);
    }

    @Override
    public Point getPoint() throws IllegalEntityIdException {
        return this.bound.getCenter();
    }
}

