/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.mods.vanilla.primaries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.facroty.property.IDialogProperty;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.simulation.cart.almandine.mods.vanilla.HRender;

public abstract class PrimaryConnection<E extends Entity>
extends Primary {
    public int idBegin;
    public int idEnd;

    @Deprecated
    public PrimaryConnection() {
    }

    public PrimaryConnection(GameAlmandine game, E begin, E end) {
        super(game);
        this.idBegin = ((Entity)begin).getId();
        this.idEnd = ((Entity)end).getId();
    }

    protected E getEntity(int id) throws IllegalEntityIdException {
        return this.game.factory.getEntityOrThrow(id, this.getClassEntity());
    }

    public double getAngle() throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        return Math.atan2(pointEnd.y - pointBegin.y, pointEnd.x - pointBegin.x);
    }

    protected abstract Class<E> getClassEntity();

    @Override
    public boolean isContained(Rectangle rectangle) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        return rectangle.contains(pointBegin) && rectangle.contains(pointEnd);
    }

    @Override
    public boolean isHover(int x, int y) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        return new Line2D.Double(pointBegin, pointEnd).ptSegDist(x, y) < 5.0;
    }

    @Override
    public void drawHover(Graphics2D graphics) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(new Color(8125570));
        HRender.drawLine(graphics, pointBegin, pointEnd, 0.0, 4.5, 0.0, 1.0);
        graphics.setStroke(stroke);
    }

    @Override
    public void draw(Graphics2D graphics) throws IllegalEntityIdException {
        this.drawBody(graphics);
    }

    @Override
    public void drawOverlay(Graphics2D graphics) throws IllegalEntityIdException {
        if (this.selected) {
            this.drawSelectMarker(graphics);
        }
    }

    protected abstract void drawBody(Graphics2D var1) throws IllegalEntityIdException;

    protected void drawSelectMarker(Graphics2D graphics) throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        Stroke stroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(3.0f));
        graphics.setColor(new Color(255, 128, 0));
        HRender.drawLine(graphics, pointBegin, pointEnd, 0.0, 0.0, 0.0, 1.0);
        graphics.setStroke(stroke);
    }

    @Override
    protected void addProperty(IDialogProperty dialogProperty) {
        super.addProperty(dialogProperty);
        dialogProperty.addPropertyInt("IdBegin", "id", () -> this.idBegin, idBegin -> {
            if (!this.game.factory.getEntity(idBegin, this.getClassEntity()).isPresent()) {
                return false;
            }
            this.idBegin = idBegin;
            return true;
        });
        dialogProperty.addPropertyInt("IdEnd", "id", () -> this.idEnd, idEnd -> {
            if (!this.game.factory.getEntity(idEnd, this.getClassEntity()).isPresent()) {
                return false;
            }
            this.idEnd = idEnd;
            return true;
        });
    }

    @Override
    public Point getPoint() throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        return new Point((pointBegin.x + pointEnd.x) / 2, (pointBegin.y + pointEnd.y) / 2);
    }

    public Point2D.Double getPoint(double position) throws IllegalEntityIdException {
        Point2D.Double[] pointMargined = this.getPointMargined();
        Point2D.Double begin = pointMargined[0];
        Point2D.Double end = pointMargined[1];
        return new Point2D.Double(begin.x + (end.x - begin.x) * position, begin.y + (end.y - begin.y) * position);
    }

    public double getPosition(Point point) throws IllegalEntityIdException {
        return this.getPosition(point.x, point.y);
    }

    public double getPosition(double x, double y) throws IllegalEntityIdException {
        Point2D.Double[] pointMargined = this.getPointMargined();
        double x2 = pointMargined[1].x - pointMargined[0].x;
        double y2 = pointMargined[1].y - pointMargined[0].y;
        double anglePoint = Math.atan2(y -= pointMargined[0].y, x -= pointMargined[0].x);
        double angleConnection = Math.atan2(y2, x2);
        double lengthPoint = Math.sqrt(x * x + y * y);
        double lengthConnection = Math.sqrt(x2 * x2 + y2 * y2);
        double position = Math.cos(anglePoint -= angleConnection) * lengthPoint / lengthConnection;
        if (position <= 0.0) {
            return 0.0;
        }
        if (position >= 1.0) {
            return 1.0;
        }
        return position;
    }

    protected void drawMargined(Graphics2D graphics, Point begin, Point end, double ratioBegin, double ratioEnd) throws IllegalEntityIdException {
        HRender.drawLine(graphics, begin, end, this.getMarginBegin(), this.getMarginEnd(), 0.0, 1.0);
    }

    protected abstract double getMarginBegin() throws IllegalEntityIdException;

    protected abstract double getMarginEnd() throws IllegalEntityIdException;

    protected Point2D.Double[] getPointMargined() throws IllegalEntityIdException {
        Point pointBegin = ((Entity)this.getEntity(this.idBegin)).getPoint();
        Point pointEnd = ((Entity)this.getEntity(this.idEnd)).getPoint();
        double length = pointBegin.distance(pointEnd);
        Point pointDistance = new Point(pointEnd.x - pointBegin.x, pointEnd.y - pointBegin.y);
        double marginBegin = this.getMarginBegin();
        double marginEnd = this.getMarginEnd();
        double ratioBeginMargined = marginBegin / length;
        double ratioEndMargined = (length - marginEnd) / length;
        Point2D.Double pointBeginMargined = new Point2D.Double((double)pointBegin.x + (double)pointDistance.x * ratioBeginMargined, (double)pointBegin.y + (double)pointDistance.y * ratioBeginMargined);
        Point2D.Double pointEndMargined = new Point2D.Double((double)pointBegin.x + (double)pointDistance.x * ratioEndMargined, (double)pointBegin.y + (double)pointDistance.y * ratioEndMargined);
        return new Point2D.Double[]{pointBeginMargined, pointEndMargined};
    }

    @Override
    public void tick(double deltaSecond) throws IllegalEntityIdException {
        ((Entity)this.getEntity(this.idBegin)).getPoint();
        ((Entity)this.getEntity(this.idEnd)).getPoint();
    }
}

