/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.gui;

import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.struct.hydrogen.Tuple3;
import mirrg.swing.helium.DialogMirrg;
import mirrg.swing.helium.GroupBuilder;

public class DialogPrimaries
extends DialogMirrg {
    private IFrameGameAlmandine frameGameAlmandine;
    private JScrollPane scrollPane;
    private DefaultTableModel tableModel;
    private DefaultListSelectionModel listSelectionModel;
    private boolean cancelEventSelection = false;

    public DialogPrimaries(IFrameGameAlmandine frameGameAlmandine) {
        super((Frame)frameGameAlmandine.getFrame(), "\u30d7\u30e9\u30a4\u30de\u30ea\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3");
        this.frameGameAlmandine = frameGameAlmandine;
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
        this.refreshAll();
        this.onTick.add(this::refresh);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        GroupBuilder.group(GroupBuilder.group(this.scrollPane, GroupBuilder.group(this.button("\u66f4\u65b0", e -> this.refreshAll()), this.button("\u6700\u80cc\u9762\u3078", e -> iFrameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
            ArrayList<ArrayList<Primary>> listPrimaries = this.splitPrimaries(iFrameGameAlmandine.getGame().factory.primaries);
            ArrayList primaries = new ArrayList();
            primaries.addAll(listPrimaries.get(3));
            primaries.addAll(listPrimaries.get(0));
            primaries.addAll(listPrimaries.get(1));
            primaries.addAll(listPrimaries.get(2));
            iFrameGameAlmandine.getGame().factory.primaries = primaries;
        })), this.button("\u80cc\u9762\u3078", e -> iFrameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
            ArrayList<ArrayList<Primary>> listPrimaries = this.splitPrimaries(iFrameGameAlmandine.getGame().factory.primaries);
            ArrayList primaries = new ArrayList();
            primaries.addAll(listPrimaries.get(0));
            primaries.addAll(listPrimaries.get(3));
            primaries.addAll(listPrimaries.get(1));
            primaries.addAll(listPrimaries.get(2));
            iFrameGameAlmandine.getGame().factory.primaries = primaries;
        })), this.button("\u524d\u9762\u3078", e -> iFrameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
            ArrayList<ArrayList<Primary>> listPrimaries = this.splitPrimaries(iFrameGameAlmandine.getGame().factory.primaries);
            ArrayList primaries = new ArrayList();
            primaries.addAll(listPrimaries.get(0));
            primaries.addAll(listPrimaries.get(1));
            primaries.addAll(listPrimaries.get(3));
            primaries.addAll(listPrimaries.get(2));
            iFrameGameAlmandine.getGame().factory.primaries = primaries;
        })), this.button("\u6700\u524d\u9762\u3078", e -> iFrameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
            ArrayList<ArrayList<Primary>> listPrimaries = this.splitPrimaries(iFrameGameAlmandine.getGame().factory.primaries);
            ArrayList primaries = new ArrayList();
            primaries.addAll(listPrimaries.get(0));
            primaries.addAll(listPrimaries.get(1));
            primaries.addAll(listPrimaries.get(2));
            primaries.addAll(listPrimaries.get(3));
            iFrameGameAlmandine.getGame().factory.primaries = primaries;
        })), this.button("\u30d7\u30ed\u30d1\u30c6\u30a3", e -> iFrameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
            ArrayList<ArrayList<Primary>> listPrimaries = this.splitPrimaries(iFrameGameAlmandine.getGame().factory.primaries);
            listPrimaries.get(3).forEach(primary -> primary.openWindowProperty(frameGameAlmandine));
        })), Box.createVerticalGlue(), this.button("\u524a\u9664", e -> iFrameGameAlmandine.getGame().factory.hookEditPrimaries(() -> {
            ArrayList<ArrayList<Primary>> listPrimaries = this.splitPrimaries(iFrameGameAlmandine.getGame().factory.primaries);
            ArrayList primaries = new ArrayList();
            primaries.addAll(listPrimaries.get(0));
            primaries.addAll(listPrimaries.get(1));
            primaries.addAll(listPrimaries.get(2));
            iFrameGameAlmandine.getGame().factory.primaries = primaries;
        }))))).apply(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.setLayout(layout);
        this.enabledTick = true;
        this.msTick = 500;
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationByPlatform(true);
    }

    private ArrayList<ArrayList<Primary>> splitPrimaries(ArrayList<Primary> primaries) {
        int i;
        ArrayList<Primary> primariesForward = new ArrayList<Primary>();
        ArrayList<Primary> primariesBackward = new ArrayList<Primary>();
        ArrayList<Primary> primariesUnselected = new ArrayList<Primary>();
        ArrayList<Primary> primariesSelected = new ArrayList<Primary>();
        int indexFirst = -1;
        int indexLast = -1;
        for (i = 0; i < primaries.size(); ++i) {
            boolean selected = primaries.get((int)i).selected;
            if (!selected) continue;
            if (indexFirst == -1) {
                indexFirst = i;
            }
            indexLast = i;
        }
        for (i = 0; i < primaries.size(); ++i) {
            Primary primary = primaries.get(i);
            if (i < indexFirst - 1) {
                primariesForward.add(primary);
                continue;
            }
            if (i > indexLast + 1) {
                primariesBackward.add(primary);
                continue;
            }
            if (primary.selected) {
                primariesSelected.add(primary);
                continue;
            }
            primariesUnselected.add(primary);
        }
        ArrayList<ArrayList<Primary>> listPrimaries = new ArrayList<ArrayList<Primary>>();
        listPrimaries.add(primariesForward);
        listPrimaries.add(primariesUnselected);
        listPrimaries.add(primariesBackward);
        listPrimaries.add(primariesSelected);
        return listPrimaries;
    }

    private void refresh() {
        if (this.tableModel == null) {
            return;
        }
        this.addRows(this.tableModel, this.listSelectionModel);
        this.scrollPane.repaint();
    }

    private void addRows(DefaultTableModel tableModel, DefaultListSelectionModel listSelectionModel) {
        this.cancelEventSelection = true;
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
        ArrayList<Primary> primaries = this.frameGameAlmandine.getGame().factory.primaries;
        for (int row = 0; row < primaries.size(); ++row) {
            Point point;
            Primary primary = primaries.get(row);
            try {
                point = primary.getPoint();
            }
            catch (IllegalEntityIdException e1) {
                point = new Point(-9999, -9999);
            }
            tableModel.addRow(new Object[]{primary.getClass().getSimpleName(), point.x, point.y, primary.getId(), primary});
            if (!primary.selected) continue;
            listSelectionModel.addSelectionInterval(row, row);
        }
        this.cancelEventSelection = false;
    }

    private Tuple3<JTable, DefaultTableModel, DefaultListSelectionModel> createTable() {
        DefaultTableModel tableModel = new DefaultTableModel(0, 5){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.setColumnIdentifiers(new Object[]{"\u578b", "X", "Y", "ID", "\u7269\u4f53"});
        DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
        listSelectionModel.addListSelectionListener(this::selectionChanged);
        this.addRows(tableModel, listSelectionModel);
        JTable table = new JTable(tableModel);
        table.setSelectionModel(listSelectionModel);
        return new Tuple3<JTable, DefaultTableModel, DefaultListSelectionModel>(table, tableModel, listSelectionModel);
    }

    public void selectionChanged(ListSelectionEvent e) {
        if (this.cancelEventSelection) {
            return;
        }
        if (this.tableModel == null) {
            return;
        }
        if (this.listSelectionModel == null) {
            return;
        }
        for (int row = e.getFirstIndex(); row <= e.getLastIndex() && row < this.tableModel.getRowCount(); ++row) {
            Primary primary = (Primary)this.tableModel.getValueAt(row, 4);
            primary.selected = this.listSelectionModel.isSelectedIndex(row);
        }
    }

    private void refreshAll() {
        Tuple3<JTable, DefaultTableModel, DefaultListSelectionModel> res = this.createTable();
        this.scrollPane.setViewportView(res.getX());
        this.tableModel = res.getY();
        this.listSelectionModel = res.getZ();
        this.scrollPane.repaint();
    }

    private JButton button(String title, ActionListener listener) {
        JButton button = new JButton(title);
        button.addActionListener(listener);
        return button;
    }
}

