/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory;

import java.awt.Color;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import mirrg.simulation.cart.almandine.gui.FrameMain;
import mirrg.swing.helium.GroupBuilder;

public class FrameProperty
extends JDialog {
    protected ArrayList<GroupBuilder> groupBuilders = new ArrayList();
    protected ArrayList<Runnable> onTick = new ArrayList();

    public FrameProperty(FrameMain frameMain, final String name) {
        super((Frame)frameMain, "\u30d7\u30ed\u30d1\u30c6\u30a3: " + name);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                GroupLayout layout = new GroupLayout(FrameProperty.this.getContentPane());
                FrameProperty.this.groupBuilders.add(0, GroupBuilder.group(new JLabel(name)));
                GroupBuilder.group(FrameProperty.this.groupBuilders.toArray(new GroupBuilder[0])).apply(layout);
                layout.setAutoCreateGaps(true);
                layout.setAutoCreateContainerGaps(true);
                FrameProperty.this.setLayout(layout);
                Thread thread = new Thread(() -> {
                    while (FrameProperty.this.isVisible()) {
                        SwingUtilities.invokeLater(() -> FrameProperty.this.onTick.forEach(Runnable::run));
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            break;
                        }
                    }
                });
                thread.setDaemon(true);
                thread.start();
                FrameProperty.this.pack();
                Point mouse = MouseInfo.getPointerInfo().getLocation();
                mouse.translate(-FrameProperty.this.getWidth() / 2, -FrameProperty.this.getHeight() / 2);
                FrameProperty.this.setLocation(mouse);
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setDefaultCloseOperation(2);
    }

    public void addComponent(GroupBuilder groupBuilder) {
        this.groupBuilders.add(groupBuilder);
    }

    public void addPropertyInt(String name, IntSupplier getter, IntPredicate setter) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel((Number)0, null, null, (Number)1));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(10);
        this.onTick.add(() -> {
            if (!spinner.isFocusOwner()) {
                spinner.setValue(getter.getAsInt());
            }
        });
        spinner.addChangeListener(e -> {
            int value = ((Number)spinner.getValue()).intValue();
            if (setter.test(value)) {
                spinner.setBackground(Color.white);
            } else {
                spinner.setBackground(new Color(0xFFBABA));
            }
            spinner.setValue(value);
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), spinner));
    }

    public void addPropertyDouble(String name, DoubleSupplier getter, DoublePredicate setter) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(10);
        this.onTick.add(() -> {
            if (!spinner.isFocusOwner()) {
                spinner.setValue(getter.getAsDouble());
            }
        });
        spinner.addChangeListener(e -> {
            double value = ((Number)spinner.getValue()).doubleValue();
            if (setter.test(value)) {
                spinner.setBackground(Color.white);
            } else {
                spinner.setBackground(new Color(0xFFBABA));
            }
            spinner.setValue(value);
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), spinner));
    }

    public void addPropertyString(String name, Supplier<String> getter, Predicate<String> setter) {
        JTextField textField = new JTextField();
        textField.setColumns(10);
        this.onTick.add(() -> {
            if (!textField.isFocusOwner()) {
                textField.setText((String)getter.get());
            }
        });
        textField.addActionListener(e -> {
            if (setter.test(textField.getText())) {
                textField.setBackground(Color.white);
            } else {
                textField.setBackground(new Color(0xFFBABA));
            }
        });
        this.groupBuilders.add(GroupBuilder.group(new JLabel(name), textField));
    }

    public void addPropertyBoolean(String name, BooleanSupplier getter, Predicate<Boolean> setter) {
        JCheckBox checkBox = new JCheckBox(name);
        this.onTick.add(() -> {
            if (!checkBox.isFocusOwner()) {
                checkBox.setSelected(getter.getAsBoolean());
            }
        });
        checkBox.addActionListener(e -> {
            if (setter.test(checkBox.isSelected())) {
                checkBox.setBackground(Color.white);
            } else {
                checkBox.setBackground(new Color(0xFFBABA));
            }
        });
        this.groupBuilders.add(GroupBuilder.group(checkBox));
    }
}

