/*
 * Decompiled with CFR 0.152.
 */
package mirrg.simulation.cart.almandine.factory;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mirrg.simulation.cart.almandine.GameAlmandine;
import mirrg.simulation.cart.almandine.IFrameGameAlmandine;
import mirrg.simulation.cart.almandine.factory.Entity;
import mirrg.simulation.cart.almandine.factory.IllegalEntityIdException;
import mirrg.simulation.cart.almandine.factory.Part;
import mirrg.simulation.cart.almandine.factory.Primary;
import mirrg.swing.helium.logging.HLog;

public class Factory {
    public ArrayList<Primary> primaries = new ArrayList();
    @XStreamOmitField
    private Hashtable<Integer, Entity> hashIdToEntity;
    @XStreamOmitField
    private ArrayList<Runnable> listenersEditPrimaries;

    public void onLoad(GameAlmandine game) {
        this.primaries.forEach(primary -> primary.setFactoryAll(game));
        this.processEditPrimaries();
    }

    public void tick(double deltaSecond) {
        try {
            this.primaries.forEach(primary -> this.tick((Primary)primary, deltaSecond));
        }
        catch (ConcurrentModificationException e) {
            HLog.processExceptionWarning(e);
        }
    }

    public void processEditPrimaries() {
        this.getListenersEditPrimaries().forEach(Runnable::run);
        this.getListenersEditPrimaries().clear();
        this.cacheEntityIds();
    }

    private synchronized void cacheEntityIds() {
        this.hashIdToEntity = new Hashtable();
        this.getEntities().forEach(entity -> this.hashIdToEntity.put(entity.getId(), (Entity)entity));
    }

    private void tick(Primary primary, double deltaSecond) {
        try {
            primary.tick(deltaSecond);
        }
        catch (IllegalEntityIdException e) {
            this.hookEditPrimaries(() -> {
                this.primaries.remove(primary);
                HLog.processException(e, String.format("\u63a5\u7d9a\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u306e\u672b\u7aef\u304c\u524a\u9664\u3055\u308c\u307e\u3057\u305f\u3002\u63a5\u7d9a\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u3092\u524a\u9664\u3057\u307e\u3059: id=%s, class=%s", primary.getId(), primary.getClass().getSimpleName()), false);
            });
        }
    }

    public void tickSuperHighSpeed() {
        this.tick(this.getNextSuperHighSpeedDuration());
    }

    private double getNextSuperHighSpeedDuration() {
        return this.primaries.stream().mapToDouble(primary -> {
            try {
                return primary.getDurationVoid();
            }
            catch (Exception e) {
                return 1.0;
            }
        }).min().orElse(1.0);
    }

    private ArrayList<Runnable> getListenersEditPrimaries() {
        if (this.listenersEditPrimaries == null) {
            this.listenersEditPrimaries = new ArrayList();
        }
        return this.listenersEditPrimaries;
    }

    public void hookEditPrimaries(Runnable runnable) {
        this.getListenersEditPrimaries().add(runnable);
    }

    public void render(Graphics2D graphics, IFrameGameAlmandine frameGameAlmandine) {
        frameGameAlmandine.doTranslate(graphics, () -> {
            try {
                this.primaries.forEach(primary -> this.draw((Entity)primary, graphics));
                this.primaries.forEach(primary -> this.drawOverlay((Entity)primary, graphics));
            }
            catch (ConcurrentModificationException e) {
                HLog.processExceptionWarning(e);
            }
        });
    }

    private void draw(Entity entity, Graphics2D graphics) {
        try {
            entity.draw(graphics);
        }
        catch (IllegalEntityIdException illegalEntityIdException) {
            // empty catch block
        }
    }

    private void drawOverlay(Entity entity, Graphics2D graphics) {
        try {
            entity.drawOverlay(graphics);
        }
        catch (IllegalEntityIdException illegalEntityIdException) {
            // empty catch block
        }
    }

    public int freeId() {
        int id;
        while (this.getEntity(id = (int)(Math.random() * 1.0E8)).isPresent()) {
        }
        return id;
    }

    public void addLater(Primary primary) {
        this.hookEditPrimaries(() -> this.primaries.add(primary));
    }

    public void deleteLater(Primary primary) {
        this.hookEditPrimaries(() -> {
            if (this.primaries.contains(primary)) {
                this.primaries.remove(primary);
            } else {
                HLog.error("\u524a\u9664\u3067\u304d\u306a\u3044\u578b\u306e\u30d7\u30e9\u30a4\u30de\u30ea\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u3059: " + primary + "(" + primary.getClass() + ")");
            }
        });
    }

    public Stream<Entity> getEntities() {
        return this.primaries.stream().flatMap(primary -> Stream.of(Stream.of(primary), primary.getChildren().map(part -> part)).flatMap(stream -> stream));
    }

    @Deprecated
    public Stream<Primary> getPrimaries() {
        return this.primaries.stream();
    }

    public synchronized Optional<Entity> getEntity(int id) {
        return Optional.ofNullable(this.hashIdToEntity.get(id));
    }

    public synchronized Entity getEntityOrThrow(int id) throws IllegalEntityIdException {
        Entity entity = this.hashIdToEntity.get(id);
        if (entity == null) {
            throw new IllegalEntityIdException(id);
        }
        return entity;
    }

    public <T extends Entity> Optional<T> getEntity(int id, Class<T> classSuper) {
        Optional<Entity> optionalEntity = this.getEntity(id);
        if (!optionalEntity.isPresent()) {
            return Optional.empty();
        }
        Entity entity = optionalEntity.get();
        if (!classSuper.isInstance(entity)) {
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    public <T extends Entity> T getEntityOrThrow(int id, Class<T> classSuper) throws IllegalEntityIdException {
        Entity entity = this.getEntityOrThrow(id);
        if (!classSuper.isInstance(entity)) {
            throw new IllegalEntityIdException(id, entity.getClass(), classSuper);
        }
        return (T)entity;
    }

    public static <T extends Entity, C extends T> Stream<C> filterClass(Stream<T> stream, Class<C> classSuper) {
        return stream.filter(entity -> classSuper.isInstance(entity)).map(entity -> entity);
    }

    public static <T extends Entity> ArrayList<T> filterHover(Stream<T> stream, int x, int y) {
        ArrayList list = stream.filter(entity -> {
            try {
                return entity.isHover(x, y);
            }
            catch (IllegalEntityIdException e) {
                return false;
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(list);
        return list;
    }

    public static <T extends Entity> ArrayList<T> filterHover(Stream<T> stream, Point point) {
        return Factory.filterHover(stream, point.x, point.y);
    }

    public static <T extends Primary> Stream<T> filterSelected(Stream<T> stream) {
        return stream.filter(primary -> primary.selected);
    }

    public void resetSelection() {
        this.getPrimaries().forEach(primary -> {
            primary.selected = false;
        });
    }

    public Optional<Primary> getParent(Part part) {
        return this.getPrimaries().filter(primary -> primary.getChildren().anyMatch(part2 -> part2 == part)).findFirst();
    }
}

