/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen.samples;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;

class Game1 {
    protected Component parent;
    protected ArrayList<double[]> points;

    public Game1(Component parent) {
        this.parent = parent;
    }

    public void init() {
        this.points = new ArrayList();
        for (int i = 0; i < 200; ++i) {
            this.points.add(this.createPoint());
        }
    }

    protected double[] createPoint() {
        double theta = Math.random() * 2.0 * Math.PI;
        double speed = Math.random() * 0.01 + 0.005;
        return new double[]{0.5, 0.5, speed * Math.cos(theta), speed * Math.sin(theta)};
    }

    public void move() {
        for (int i = 0; i < this.points.size(); ++i) {
            double[] point = this.points.get(i);
            point[0] = point[0] + point[2];
            point[1] = point[1] + point[3];
            if (point[0] < 0.0) {
                this.points.set(i, this.createPoint());
                continue;
            }
            if (point[0] > 1.0) {
                this.points.set(i, this.createPoint());
                continue;
            }
            if (point[1] < 0.0) {
                this.points.set(i, this.createPoint());
                continue;
            }
            if (!(point[1] > 1.0)) continue;
            this.points.set(i, this.createPoint());
        }
    }

    public void paint(Graphics2D graphics) {
        int width = this.parent.getWidth();
        int height = this.parent.getHeight();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(Color.red);
        for (double[] point : this.points) {
            graphics.fillRect((int)(point[0] * (double)width) - 2, (int)(point[1] * (double)height) - 2, 5, 5);
        }
    }
}

