/*
 * Decompiled with CFR 0.152.
 */
package mirrg.applet.nitrogen;

import java.awt.Image;
import mirrg.applet.nitrogen.BackBuffer;
import mirrg.event.nitrogen.INitrogenEventManager;

public class TripleBuffer {
    private BackBuffer safety = new BackBuffer(1);
    private BackBuffer dirty = new BackBuffer(1);

    public void rebuffer(int width, int height) {
        this.safety.rebuffer(width, height);
        this.dirty.rebuffer(width, height);
    }

    public synchronized BackBuffer getBufferSafety() {
        return this.safety;
    }

    public synchronized BackBuffer getBufferDirty() {
        return this.dirty;
    }

    public synchronized int getWidth() {
        return this.dirty.getWidth();
    }

    public synchronized int getHeight() {
        return this.dirty.getHeight();
    }

    public synchronized void flip() {
        this.dirty.flip(this.safety);
    }

    public void copy() {
        this.safety.getGraphics().drawImage((Image)this.dirty.getBuffer(), 0, 0, null);
    }

    public void rollback() {
        this.rollback(0, 0);
    }

    public void rollback(int x, int y) {
        this.rollback(x, y, this.getWidth(), this.getHeight());
    }

    public void rollback(int x, int y, int width, int height) {
        this.dirty.getGraphics().drawImage(this.safety.getBuffer(), x, y, width, height, null);
    }

    public void subscribeEvent(INitrogenEventManager eventManager) {
        this.dirty.subscribeEvent(eventManager);
        this.safety.subscribeEvent(eventManager);
    }
}

