﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Forms;
using System.IO;

namespace WpfImage1
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            this.Title = "Waterlilies.jpg";
            bitmapSource = FormatConvertedBitmap("Waterlilies.jpg");

            ImageBrush myImageBrush = new ImageBrush(bitmapSource);
            MainCanvas.Width = bitmapSource.Width;
            MainCanvas.Height = bitmapSource.Height;
            MainCanvas.Background = myImageBrush;
            MainePanel.Children.Clear();
            MainePanel.Children.Add(MainCanvas);
        }
        private const string filter = "画像ファイル(*.bmp;*.jpeg;*.jpg;*.gif;*.png;*.tiff;*.tif)|*.bmp;*.jpeg;*.jpg;*.gif;*.png;*.tiff;*.tif|すべてのファイル(*.*)|*.*";

        private BitmapSource bitmapSource;
        private int stride;
        private byte[] pixels;

        void OpenCmdCanExecute(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        void OpenCmdExecuted(object target, ExecutedRoutedEventArgs e)
        {
            String command, targetobj;
            command = ((RoutedCommand)e.Command).Name;
            targetobj = ((FrameworkElement)target).Name;

            OpenFileDialog ofd = new OpenFileDialog();
            ofd.FileName = this.Title;
            ofd.Filter = filter;
            ofd.FilterIndex = 2;
            ofd.Title = "開くファイルを選択してください";
            ofd.RestoreDirectory = true;
            ofd.CheckFileExists = true;
            ofd.CheckPathExists = true;
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                bitmapSource = FormatConvertedBitmap(ofd.FileName);

            }
        }
        void SaveCmdCanExecute(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        void SaveCmdExecuted(object target, ExecutedRoutedEventArgs e)
        {
            SaveFileDialog sfd = new SaveFileDialog();
            sfd.FileName = this.Title;
            sfd.Filter = filter;
            sfd.FilterIndex = 2;
            sfd.Title = "保存ファイル名を選択してください";
            sfd.RestoreDirectory = true;
            sfd.CheckPathExists = true;
            if (sfd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                string ext = sfd.FileName.Split('.').Last().ToLower();
                Console.Write("SaveFileDialog: FileName=" + sfd.FileName);
                Console.WriteLine(" Ext=" + ext);
                if (ext.Equals("bmp"))
                {
                    FileStream stream = new FileStream(sfd.FileName, FileMode.Create);
                    BmpBitmapEncoder encoder = new BmpBitmapEncoder();
                    encoder.Frames.Add(BitmapFrame.Create(bitmapSource));
                    encoder.Save(stream);
                }
                else if (ext.Equals("jpg") || ext.Equals("jpeg"))
                {
                    FileStream stream = new FileStream(sfd.FileName, FileMode.Create);
                    JpegBitmapEncoder encoder = new JpegBitmapEncoder();
                    encoder.FlipHorizontal = false;
                    encoder.FlipVertical = false;
                    encoder.QualityLevel = 50;
                    encoder.Rotation = Rotation.Rotate0;
                    encoder.Frames.Add(BitmapFrame.Create(bitmapSource));
                    encoder.Save(stream);
                }
                else if (ext.Equals("png"))
                {
                    FileStream stream = new FileStream(sfd.FileName, FileMode.Create);
                    PngBitmapEncoder encoder = new PngBitmapEncoder();
                    encoder.Interlace = PngInterlaceOption.On;
                    encoder.Frames.Add(BitmapFrame.Create(bitmapSource));
                    encoder.Save(stream);             
                }
                else if (ext.Equals("gif"))
                {
                    FileStream stream = new FileStream(sfd.FileName, FileMode.Create);
                    GifBitmapEncoder encoder = new GifBitmapEncoder();
                    encoder.Frames.Add(BitmapFrame.Create(bitmapSource));
                    encoder.Save(stream);
                }
                else if (ext.Equals("tif") || ext.Equals("tiff"))
                {
                    FileStream stream = new FileStream(sfd.FileName, FileMode.Create);
                    TiffBitmapEncoder encoder = new TiffBitmapEncoder();
                    encoder.Compression = TiffCompressOption.Zip;
                    encoder.Frames.Add(BitmapFrame.Create(bitmapSource));
                    encoder.Save(stream);
                }
                else
                {
                    System.Windows.MessageBox.Show("! " + ext + " なんて、シランガナ");
                }
            }   
        }

        public BitmapSource FormatConvertedBitmap(string FileName)
        {
            BitmapImage myBitmapImage = new BitmapImage();
            myBitmapImage.BeginInit();
            myBitmapImage.UriSource = new Uri(FileName, UriKind.Relative);
            myBitmapImage.EndInit();
            Console.Write("OpenCmdExecuted: FileName =" + FileName);
            Console.Write(" size=[" + myBitmapImage.PixelWidth + "," + myBitmapImage.PixelHeight + "]");
            Console.Write(" Format=" + myBitmapImage.Format.ToString());
            Console.WriteLine(" BitsPerPixel=" + myBitmapImage.Format.BitsPerPixel);

            FormatConvertedBitmap newFormatedBitmapSource = new FormatConvertedBitmap();
            newFormatedBitmapSource.BeginInit();
            newFormatedBitmapSource.Source = myBitmapImage;
            newFormatedBitmapSource.DestinationFormat = PixelFormats.Bgr24;
            newFormatedBitmapSource.EndInit();
            
            return newFormatedBitmapSource;
        }
        public SetBitmap(BitmapSource bitmap){
                stride = bitmapSource.PixelWidth * bitmapSource.Format.BitsPerPixel / 8;
                pixels = new byte[bitmapSource.PixelHeight * stride];
                bitmapSource.CopyPixels(pixels, stride, 0);

                ImageBrush myImageBrush = new ImageBrush(bitmapSource);
                Canvas myCanvas = new Canvas();
                myCanvas.Width = bitmapSource.Width;
                myCanvas.Height = bitmapSource.Height;
                myCanvas.Background = myImageBrush;
                MainePanel.Children.Clear();
                MainePanel.Children.Add(myCanvas);
        }
        public BitmapSource getBitmapSource()
        {
            int width = 128;
            int height = width;
            int stride = width / 8;
            byte[] pixels = new byte[height * stride];

            // Define the image palette
            BitmapPalette myPalette = BitmapPalettes.Halftone256;

            // Creates a new empty image with the pre-defined palette
            BitmapSource image = BitmapSource.Create(
                width,
                height,
                96,
                96,
                PixelFormats.Indexed1,
                myPalette,
                pixels,
                stride);
            return image;
        }
    }
}
