#pragma once

#using <System.Drawing.dll>
using namespace System::Drawing;

ref class COpenGL
{
public:
	COpenGL(void);
	virtual ~COpenGL(void);

	bool attach_GL(System::Windows::Forms::PictureBox^ pbox);
	void detach_GL();
	void resizeScene(System::Windows::Forms::PictureBox^ pbox);
	void paintWindow(void);
	void increaseTick();
	void OnLButtonDown(Point point);
	void OnLButtonUp(Point point);
	void OnMouseMove(Point point);

private:
	void setPerspective(System::Windows::Forms::PictureBox^ pbox);
	int setPixelFormat(HDC hdc);
	void initializeScene(void);
	void renderScene(void);

private:
	System::Windows::Forms::PictureBox^ PictBox;
	HWND hWnd;
	HDC hdc;
	HGLRC hglrc;

	int tick;
	int mousestatus; /*0: normal 1:LbuttonDown 2:Dragging 3:LbuttonUp*/
	Point posDown, posDrag, posUp;
	double leye; double dip; double rot; //dip,rot[rad]
};

