#include "StdAfx.h"
#include <windows.h>
#include <GL/glu.h>
#include "OpenGL.h"

#pragma comment (lib, "OpenGL32.lib")
#pragma comment (lib, "GLU32.lib")
#pragma comment (lib, "user32.lib")
#pragma comment(lib, "gdi32.lib")

#include <math.h>

COpenGL::COpenGL(void)
{
	tick=0;
}


COpenGL::~COpenGL(void)
{
}

bool COpenGL::attach_GL(System::Windows::Forms::PictureBox^ pbox)
{
	if (!(hWnd=(HWND)(pbox->Handle).ToInt32())) {
		//0 (NULL) ȂsĂяo
		MessageBox(NULL, (LPCTSTR)("COpenGL::attach_GL called with 0 (NULL)"), NULL, MB_OK);
		return false;
	}

	if (!(hdc=GetDC(hWnd))) { 
		//GetDC(hWnd)ƃfoCXReLXg̃nhԂCs 0 (NULL) ԂB
		MessageBox(NULL, (LPCTSTR)("COpenGL::attach_GL GetDC(hWnd)"), NULL, MB_OK);
		return false;
	}

	wglMakeCurrent(NULL, NULL); //VS2010p̏dvȂ܂Ȃ@̈ʒuɒuȂwglCreateContext(hdc)s

	if (setPixelFormat(hdc)!=1)
		return false;

	if (!(hglrc = wglCreateContext(hdc))) {
		MessageBox(NULL, (LPCTSTR)("COpenGL::attach_GL wglCreateContext(hdc)"), NULL, MB_OK);
		return false;
	}

	if(!wglMakeCurrent(hdc, hglrc)) {
		MessageBox(NULL, (LPCTSTR)("COpenGL::attach_GL wglMakeCurrent(hdc, hglrc)"), NULL, MB_OK);
		return false;
	}

	setPerspective(pbox);

	initializeScene();

	return true;
}

void COpenGL::resizeScene( System::Windows::Forms::PictureBox^ pbox )
{
	setPerspective(pbox);
}

void COpenGL::setPerspective( System::Windows::Forms::PictureBox^ pbox )
{
	int width=pbox->Width;
	int height=pbox->Height;
	glViewport(0,0,width,height);
	glEnable(GL_DEPTH_TEST);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	const int angle=40;
	const int frontPlanePosZ=100;
	const int rearPlanePosZ=1300;
	gluPerspective(angle, (float)width/(float)height, frontPlanePosZ, rearPlanePosZ);
}

void COpenGL::detach_GL()
{
	wglMakeCurrent(NULL, NULL) ;
	if (hglrc) wglDeleteContext(hglrc);
	if (hdc) ReleaseDC(hWnd, hdc);
}

int COpenGL::setPixelFormat(HDC hdc)
{
	PIXELFORMATDESCRIPTOR pfd = { 
	    sizeof(PIXELFORMATDESCRIPTOR),    // size of this pfd 
	    1,                                // version number 
	    PFD_DRAW_TO_WINDOW |              // support window 
	    PFD_SUPPORT_OPENGL |              // support OpenGL 
	    PFD_DOUBLEBUFFER,                 // double buffered 
	    PFD_TYPE_RGBA,                    // RGBA type 
	    24,                               // 24-bit color depth 
	    0, 0, 0, 0, 0, 0,                 // color bits ignored 
	    0,                                // no alpha buffer 
	    0,                                // shift bit ignored 
	    0,                                // no accumulation buffer 
	    0, 0, 0, 0,                       // accum bits ignored 
	    32,                               // 32-bit z-buffer     
	    0,                                // no stencil buffer 
	    0,                                // no auxiliary buffer 
	    PFD_MAIN_PLANE,                   // main layer 
	    0,                                // reserved 
	    0, 0, 0                           // layer masks ignored 
	}; 
	int  iPixelFormat; 
 
	// get the device context's best, available pixel format match 
	if((iPixelFormat = ChoosePixelFormat(hdc, &pfd)) == 0) {
		MessageBox(NULL, (LPCTSTR)("ChoosePixelFormat Failed"), NULL, MB_OK);
		//MessageBox((LPCTSTR)("ChoosePixelFormat Failed"));
		return 0;
	}
	 
	// make that match the device context's current pixel format 
	if(SetPixelFormat(hdc, iPixelFormat, &pfd) == FALSE) {
		MessageBox(NULL, (LPCTSTR)("SetPixelFormat Failed"), NULL, MB_OK);
		//MessageBox((LPCTSTR)("SetPixelFormat Failed"));
		return 0;
	}

	return 1;
}

void COpenGL::initializeScene(void)
{
}

// COpenGL bZ[W nh@FormĂ΂
void COpenGL::increaseTick()
{
	tick++;
}

void COpenGL::paintWindow(void) 
{
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	double leye=700.0; double dip=0.65; double rot=0.5; //dip,rot[rad]
	double ly,lxz,lx,lz;
	ly=leye*sin(dip); lxz=leye*cos(dip);
	lx=lxz*sin(rot); lz=lxz*cos(rot);
	gluLookAt(lx,ly,lz, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	glClearColor(0,0,0.5,0);
	glClear(GL_COLOR_BUFFER_BIT);
	glClear(GL_DEPTH_BUFFER_BIT); // depth check

 	renderScene();//render here

	SwapBuffers(hdc);
}

void COpenGL::renderScene(void)
{
	glRotatef((float)tick,0,0,1);
	for (int i=0;i<8;i++) {
		glBegin(GL_QUADS);
		glColor3f(1, 0, -1);
		glVertex3f(100, 100, -150);
		glColor3f(0, 1, 0);
		glVertex3f(-100, 100, -150);
		glColor3f(0, 0, 1);
		glVertex3f(-100, -100, -150);
		glColor3f(0, 1, 1);
		glVertex3f(100, -100, -150);
		glEnd();
		glTranslatef(0,0,40);
	}
}
