package helloplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.cdt.codan.checkers.CodanCheckersActivator;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfileChangeListener;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.ListProblemPreference;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.AttributeUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

//implements IIndexProvider
public class Checker1 extends AbstractIndexAstChecker
// implements ICIndexChecker
	{
	/*
	 * memo
	 * co.jp.five.helloplugin.Checker1
	 * helloplugin.Checker1 cannot be cast to org.eclipse.cdt.codan.core.model.IChecker
	*/
	public static final String ER_NAME_RULE_VARIABLE_ID = "co.jp.five.plugin.VariableNameRule";
	public static final String ER_NAME_RULE_FUNCTION_ID = "co.jp.five.plugin.FunctionNameRule";
	public static final String PARAM_MACRO_ID = "macro";
	public static final String PARAM_PATTERN = "pattern";
	public static final String IGNORING_PATTERN = "ignoring";
	public static final String PARAM_SEQUENCE_LIST = "sequence";
	private static final String[] ATTRIBUTE_UNUSED = { "__unused__", "unused" };
	private HashMap<IBinding,IASTFunctionDefinition> functionDeclarations = new HashMap<IBinding, IASTFunctionDefinition>();
	private HashMap<IBinding,IASTSimpleDeclaration> variableDeclarations = new HashMap<IBinding, IASTSimpleDeclaration>();
	private HashMap<IBinding,IASTSimpleDeclaration> typeDeclarations = new HashMap<IBinding, IASTSimpleDeclaration>();
	public Checker1() {
	}

	IProblemProfileChangeListener profileChangeListener;
	private IIndex Index;

	// 設定で詳細を設定するときに使うっぽい
	public void initPreferences(IProblemWorkingCopy problem) {
		super.initPreferences(problem);
		addPreference(problem, "macro",
				Checker1Messages.EnablePreferences,
				Boolean.TRUE);
		addPreference(
				problem,
				IGNORING_PATTERN,
				Checker1Messages.IgnoringPatternDescription,
				"main");
		if (problem
				.getId()
				.equals(ER_NAME_RULE_VARIABLE_ID)) {
			addPreference(
					problem,
					PARAM_PATTERN,
					Checker1Messages.PrifixPatternDescription,
					"c?[csuvx]?[1248on][gla]_(str_|uni_|ptr_|ar_)*");
			ListProblemPreference pref = addListPreference(
					problem,
					PARAM_SEQUENCE_LIST,
					Checker1Messages.PreferencesDescription,	/*何をどう設定するかの説明*/
					Checker1Messages.CharacterSequence);
			for(String sequence :Checker1Messages.DefoultSequence.split(" ")){
				pref.addChildValue(sequence);
			}
		}else if(problem
				.getId()
				.equals(ER_NAME_RULE_FUNCTION_ID)) {
			this.
			addPreference(
					problem,
					PARAM_PATTERN,
					Checker1Messages.PrifixPatternDescription,
					"c?[csuvx]?[1248on][gla]_(str_|uni_|ptr_|ar_)*");
			ListProblemPreference pref = addListPreference(
					problem,
					PARAM_SEQUENCE_LIST,
					Checker1Messages.PreferencesDescription,	/*何をどう設定するかの説明*/
					Checker1Messages.CharacterSequence);
			for(String sequence :Checker1Messages.DefoultSequence.split(" ")){
				pref.addChildValue(sequence);
			}
		}
	}

	public boolean runInEditor() {

		List<IASTSimpleDeclaration> varDeclarators = new ArrayList<IASTSimpleDeclaration>();
		varDeclarators.addAll(this.variableDeclarations.values());
		for (IASTSimpleDeclaration declaration : varDeclarators) {
			IASTDeclSpecifier Spec = declaration.getDeclSpecifier();
			// Spec	CASTTypedefNameSpecifier  (id=12920)

			if(Spec instanceof ICASTTypedefNameSpecifier){
				ICASTTypedefNameSpecifier Specifier = (ICASTTypedefNameSpecifier) Spec;
				findType( Specifier.getName().getBinding());
			}
		}
		return true;
	}

	public void findType(IBinding b) {
		try {
			for (IIndexName indexName : Index.findDeclarations(b)) {
				IIndexFile f = indexName.getFile();
				CCorePlugin.log(" Specifier.getName().getBinding="
						+ b.toString() + " indexName.getFile ="
						+ f.getLocation().getURI().getPath());
				// ワークスペースのルートを取得して、プロジェクトのファイルのFileインスタンスを作成する。
				// IWorkspaceRoot root =
				// ResourcesPlugin.getWorkspace().getRoot();
				// IFile scopeFile = root.getFile(new
				// Path("/HelloCpp/src/a_sample.h"));
				// E:\my8\Documents\workspace\HelloCpp\src\a_sample.h

				// ちなみにgetFileに渡すPathは、プロジェクト名とリソース名を含んでいないと、以下のエラーになる。
				IPath p = new Path(f.getLocation().getURI().getPath());
				ICElement m = CoreModel.getDefault().create(p);
				// IResource m = this.getProject().findMember("a_sample.h");

				CCorePlugin.log(" Resource=" + m.toString());
				if (m instanceof ITranslationUnit) {
					// element TranslationUnit (id=12154)
					ITranslationUnit tu = (ITranslationUnit) m;
					// CxxModelsCache casche = new
					// CxxModelsCache((ITranslationUnit)celement);
					IASTTranslationUnit astu = tu.getAST();
					for (IASTPreprocessorIncludeStatement inc : astu
							.getIncludeDirectives()) {
						CCorePlugin.log("getIncludeDirectives=" + inc.getName()
								+ " @" + inc.getPath());

						IResource incFile = this.getProject().getFile(
								inc.getName().toString());
						ICElement e = CoreModel.getDefault().create(incFile);
						if (e != null) {
							CCorePlugin
									.log("new File ICElement=" + e.getPath());
						}
					}
					astu.accept(new ASTVisitor() {
						// Set the Boolean fields so that name and declaration
						// nodes call visit()
						{
							shouldVisitDeclarations = true;
						}

						// Perform the visit
						public int visit(IASTDeclaration declaration) {
							if (declaration instanceof IASTSimpleDeclaration) { // [0]
																				// CPPASTSimpleDeclaration
																				// (id=214)
								IASTSimpleDeclaration d = (IASTSimpleDeclaration) declaration;
								IASTDeclSpecifier s = d.getDeclSpecifier();
								if (s instanceof ICPPASTCompositeTypeSpecifier) {
									ICPPASTCompositeTypeSpecifier compositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier) s;
									if (compositeTypeSpecifier.getKey() == IASTCompositeTypeSpecifier.k_struct) {
										CCorePlugin.log(d.getDeclarators()[0]
												.getName() + "=struct");
									}
									if (compositeTypeSpecifier.getKey() == IASTCompositeTypeSpecifier.k_union) {
										CCorePlugin.log(d.getDeclarators()[0]
												.getName() + "=union");
									}
								}
							}
							return PROCESS_CONTINUE;
						};
					});
				}
			}
		} catch (OperationCanceledException | CoreException e) {
			e.printStackTrace();
		}
	}

	public void before(IResource resource) {
		if (resource instanceof ITranslationUnit) {
			// element TranslationUnit (id=12154)
			ITranslationUnit tu = (ITranslationUnit) resource;
			// CxxModelsCache casche = new
			// CxxModelsCache((ITranslationUnit)celement);
			IASTTranslationUnit ast= null;
			try {
				ast = tu.getAST();
			} catch (CoreException e1) {
				e1.printStackTrace();
			}
			for(ast.getIncludeDirectives()){
				!!!!
			}

		}

		// IFile scopeFile = root.getFile(new Path("/HelloCpp/src/a_sample.h"));
		IPath p = new Path("/HelloCpp/src/a_sample.h");
		ICElement m = CoreModel.getDefault().create(p);
		// IResource m = this.getProject().findMember("a_sample.h");

		CCorePlugin.log(" Resource=" + m.toString());
		if (m instanceof ITranslationUnit) {
			// element TranslationUnit (id=12154)
			ITranslationUnit tu = (ITranslationUnit) m;
			// CxxModelsCache casche = new
			// CxxModelsCache((ITranslationUnit)celement);
			IASTTranslationUnit astu = null;
			try {
				astu = tu.getAST();
			} catch (CoreException e1) {
				e1.printStackTrace();
			}
			astu.accept(new ASTVisitor() {
				// Set the Boolean fields so that name and declaration nodes
				// call visit()
				{
					shouldVisitDeclarations = true;
				}

				// Perform the visit
				public int visit(IASTDeclaration declaration) {
					if (declaration instanceof IASTSimpleDeclaration) { // [0]
																		// CPPASTSimpleDeclaration
						IASTSimpleDeclaration d = (IASTSimpleDeclaration) declaration;
						IASTDeclSpecifier s = d.getDeclSpecifier();
						if (s instanceof ICPPASTCompositeTypeSpecifier) {	// CPPASTCompositeTypeSpecifier->struct,union
							ICPPASTCompositeTypeSpecifier compositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier) s;
							if (compositeTypeSpecifier.getKey() == IASTCompositeTypeSpecifier.k_struct) {
								CCorePlugin.log("before "
										+ d.getDeclarators()[0].getName()
										+ "=struct");
							}
							if (compositeTypeSpecifier.getKey() == IASTCompositeTypeSpecifier.k_union) {
								CCorePlugin.log("before "
										+ d.getDeclarators()[0].getName()
										+ "=union");
							}
						}
					}
					return PROCESS_CONTINUE;
				};
			});
		}
	}

	public void processAst(IASTTranslationUnit ast) {
		clearCandidates();
		collectCandidates(ast);
		if (isAnyCandidate()) {
			reportProblems();
		}
	}
	private void clearCandidates() {
		this.functionDeclarations.clear();
		this.variableDeclarations.clear();
		this.typeDeclarations.clear();
	}
	private void collectCandidates(IASTTranslationUnit ast) {
		Index = ast.getIndex();
		try {
			IASTDeclaration Declarations[] = ast.getDeclarations();
			for (IASTDeclaration declaration : Declarations) {
				if((declaration instanceof IASTSimpleDeclaration)){
					IASTSimpleDeclaration simpleDeclaration =  ( (IASTSimpleDeclaration) declaration);
					IASTDeclarator[] declarators = simpleDeclaration.getDeclarators();
					for (IASTDeclarator decl : declarators) {
						if (!AttributeUtil.hasAttribute(decl, Checker1.ATTRIBUTE_UNUSED)) {
							IASTName astName = decl.getName();
							IBinding binding = astName.resolveBinding();
							String name = astName.toString();
							if (name != null) {
								// declSpecifier	CASTEnumerationSpecifier  (id=546)
								if(simpleDeclaration.getDeclSpecifier() instanceof IASTEnumerationSpecifier){
									// 未実装
								}else if(simpleDeclaration.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier)
									this.typeDeclarations.put(binding, simpleDeclaration);
								else
									this.variableDeclarations.put(binding, simpleDeclaration);
							}
						}
					}
					IASTDeclSpecifier spec = simpleDeclaration.getDeclSpecifier();
					if(spec instanceof ICASTTypedefNameSpecifier){
						ICASTTypedefNameSpecifier typedefNameSpecifier = (ICASTTypedefNameSpecifier)spec;
						IBinding b = typedefNameSpecifier.getName().getBinding();

						for(IIndexName index : ast.getIndex().findDeclarations(b)){
							String log = b.toString() + ": ";
								log += "getNodeLength:"+index.getNodeLength()+ ": ";
							if(index.couldBePolymorphicMethodCall())
								log += "couldBePolymorphicMethodCall ";
							if(index.isBaseSpecifier())
								log += "isBaseSpecifier ";
							if(index.isDeclaration())
								log += "isDeclaration ";
							if(index.isDefinition())
								log += "isDefinition ";
							if(index.isReference())
								log += "isReference ";
							if(index.isReadAccess())
								log += "isReadAccess ";
							if(index.isWriteAccess())
								log += "isReadAccess ";
							IIndexFile f = index.getFile();
							for(ICPPUsingDirective d :f.getUsingDirectives()){
								log += " UsingDirective " + d.toString();
							};

							 CCorePlugin.log(log);
						}

					}

				}
				if((declaration instanceof IASTFunctionDefinition)){
					IASTFunctionDefinition FunctionDefinition = (IASTFunctionDefinition) declaration;
					IASTFunctionDeclarator function = FunctionDefinition
							.getDeclarator();
					if (!AttributeUtil
						.hasAttribute(
								function,
								Checker1.ATTRIBUTE_UNUSED)) {
						IASTName astName = function.getName();
						IBinding binding = astName
								.resolveBinding();
						this.functionDeclarations.put(binding, FunctionDefinition);
					}
					IASTCompoundStatement body= (IASTCompoundStatement) ((IASTFunctionDefinition) declaration).getBody();
					IASTStatement statements[] = body.getStatements();
					for (IASTStatement statement : statements) {
						if((statement instanceof IASTDeclarationStatement)){
							// 宣言
							declaration = ((IASTDeclarationStatement)statement).getDeclaration();
							if((declaration instanceof IASTSimpleDeclaration)){
								IASTSimpleDeclaration simpleDeclaration =  ( (IASTSimpleDeclaration) declaration);
								IASTDeclarator[] declarators = simpleDeclaration.getDeclarators();
								for (IASTDeclarator decl : declarators) {
									if (!AttributeUtil.hasAttribute(decl, Checker1.ATTRIBUTE_UNUSED)) {
										IASTName astName = decl.getName();
										IBinding binding = astName.resolveBinding();
										String name = astName.toString();
										if (name != null) {
											// declSpecifier	CASTEnumerationSpecifier  (id=546)
											if(simpleDeclaration.getDeclSpecifier() instanceof IASTEnumerationSpecifier){
												// 未実装
											}else if(simpleDeclaration.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier)
												this.typeDeclarations.put(binding, simpleDeclaration);
											else
												this.variableDeclarations.put(binding, simpleDeclaration);
										}
									}
								}
							}						}
						if((statement instanceof IASTFunctionCallExpression)){
							// 関数呼び出し
						}
						if((statement instanceof IASTReturnStatement)){
							// ReturnStatement
						}
					}
				}
			}
		} catch (Exception e) {
			CodanCheckersActivator.log(e);
		}
	}
	private boolean isAnyCandidate() {
		return (!this.functionDeclarations.isEmpty())
				|| (!this.variableDeclarations.isEmpty());
	}
	private IASTName getAstName(IASTDeclarator decl) {
		IASTName astName = null;
		do {
			astName = decl.getName();
			if ((astName != null) && (astName.getSimpleID().length > 0)) {
				return astName;
			}
			decl = decl.getNestedDeclarator();
		} while (decl != null);
		return astName;
	}

	private IASTPointerOperator[] getPointer(IASTDeclSpecifier Spec){
		IASTNode node = Spec.getParent();
		if(node instanceof IASTSimpleDeclaration)
			return ((IASTSimpleDeclaration)node).getDeclarators()[0]
					.getPointerOperators();
		if(node instanceof IASTFunctionDefinition)
			return ((IASTFunctionDefinition)node).getDeclarator()
					.getPointerOperators();
		return null;
	}
	private String getSpecifier(IASTDeclSpecifier Spec){
		String description = "";
		if(getPointer(Spec).length != 0)
			description += " pointer";
		if(Spec.isVolatile())
			description += " volatile";
		if(Spec.isConst())
			description += " const";
		if(Spec.isRestrict())
			description += " restrict";

		int storageClass = Spec.getStorageClass();
		description += " storage" + Spec.getStorageClass();
		Boolean inFunction = false;
		for(IASTNode node = Spec.getParent().getParent();
				node != null;
				node = node.getParent()){
			if(node instanceof IASTFunctionDefinition){
				inFunction = true;
				description += " in Function";
				break;
			}
		}
		if(inFunction == true && (storageClass == 0))
			description += " auto";
		if(inFunction == false && (storageClass == 0))
			description += " global";
		if(storageClass == 3)
			description += " local";

		IASTNode parent = Spec.getParent();
		if(parent instanceof IASTSimpleDeclaration){
			for(IASTDeclarator declarator :((IASTSimpleDeclaration)parent).getDeclarators()){
				if(declarator instanceof IASTArrayDeclarator){
					description += " array";
					IASTArrayDeclarator a =(IASTArrayDeclarator )declarator;
					IASTPointerOperator pointer[] = a.getPointerOperators();
					if(pointer.length != 0){
						description += " pointer";
					}
				}
			}
		}
		if(Spec instanceof ICASTElaboratedTypeSpecifier){
			ICASTElaboratedTypeSpecifier Specifier = (ICASTElaboratedTypeSpecifier) Spec;
			String name = Specifier.getName().toString();
			List<IASTSimpleDeclaration> types = new ArrayList<IASTSimpleDeclaration>();
			types.addAll(this.typeDeclarations.values());
			for(IASTSimpleDeclaration d:types){
				IASTDeclSpecifier typeSpec = d.getDeclSpecifier();
				if(typeSpec instanceof IASTCompositeTypeSpecifier){
					IASTCompositeTypeSpecifier s = (IASTCompositeTypeSpecifier)typeSpec;
					if(s.getName().toString().equals(name)){
						Spec = s;
						break;
					}
				}
			}
		}
		if(Spec instanceof ICASTTypedefNameSpecifier){
			description += " typedef ";
			ICASTTypedefNameSpecifier Specifier = (ICASTTypedefNameSpecifier) Spec;
			IASTName astName = Specifier.getName();
			description += astName.toString();
			IBinding binding = astName.resolveBinding();
//			astName.accept(new ASTVisitor (){
//
//			}) ;

			IASTSimpleDeclaration d = this.typeDeclarations.get(binding);
			if(d != null){
				Spec = d.getDeclSpecifier();
			}
		}
		if(Spec instanceof IASTCompositeTypeSpecifier){
			IASTCompositeTypeSpecifier s = (IASTCompositeTypeSpecifier)Spec;
			if(s.getKey() == IASTCompositeTypeSpecifier.k_struct){
				description += " struct ";
			}
			if(s.getKey() == IASTCompositeTypeSpecifier.k_union){
				description += " union ";
			}
			description += s.getName().toString();
		}
		if(Spec instanceof IASTSimpleDeclSpecifier){
			IASTSimpleDeclSpecifier Specifier = (IASTSimpleDeclSpecifier) Spec;
			if(Specifier.isSigned())
				description += " signed";
			if(Specifier.isUnsigned())
				description += " unsigned";
			if(Specifier.isLong())
				description += " long";
			if(Specifier.isLongLong())
				description += " longlong";
			if(Specifier.isShort())
				description += " short";
			if(!Specifier.isSigned()
					&& !Specifier.isUnsigned()
					&& (Specifier.getType() == IASTSimpleDeclSpecifier.t_char))
				description += " text";
			if(Specifier.isImaginary())
				description += " imaginary";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_void)
				description += " void";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_char)
				description += " char";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_int)
				description += " int";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_float)
				description += " float";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_double)
				description += " double";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_bool)
				description += " bool";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_wchar_t)
				description += "wchar_t";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_typeof)
				description += "typeof";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_decltype)
				description += "decltype";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_auto)
				description += "t_auto";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_char16_t)
				description += "char16_t";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_char32_t)
				description += "char32_t";
			if(Specifier.getType() == IASTSimpleDeclSpecifier.t_int128)
				description += "int128";
		}
		String fullPathName = Spec.getContainingFilename();
		int beginIndex = fullPathName.lastIndexOf('\\') +1;
		int endIndex = fullPathName.lastIndexOf('.');
		String fileName = fullPathName.substring(beginIndex, endIndex);
		return  description + " :" + fileName;
	}
	private List<String[]> getSequence(IProblem problem){ // preferenceChangeListeners	null
		Object parameters[] = (Object[])getPreference(problem, PARAM_SEQUENCE_LIST);
		List<String[]> sequence = new ArrayList<String[]>();
		for(Object parameter :parameters){
			sequence.add( parameter.toString().split(","));
		}
		return sequence;
	}

	/* 接頭語を組み立てる
	 * spec内にsequence[n][1]を発見した場合、sequence[n][0]をprefixに追加
	 */
	private String getPrefix(List<String[]> sequence, String spec){
		String prefix = "";
		String []filename = spec.split(":")[1].split("_");
		for(String[]  param: sequence){
			if( 0<= spec.indexOf(" " + param[1])){
				prefix += param[0];
			}
			/*ファイル名に含まれる単語を組み立てる*/
			if(param[1].equals("filename") && param[2].equals("1")){
				prefix += filename[0] + "_";
			}
			if(param[1].equals("filename") && param[2].equals("2")){
				prefix += filename[1] + "_";
			}
		}
		return prefix;
	}
	public boolean isFilteredArg(String arg, String prefix, Pattern pattern, IProblem problem ) {
		int length = prefix.length();
		if(length > arg.length()) // 定義名が短いと
			return false; // ダメ
		String head = arg.substring(0, prefix.length());

		Pattern prefixPattern = Pattern.compile(prefix);

		if(!prefixPattern.matcher(head).find()){ // 接頭語が
			return false; // 一致しない
		}
		if (!pattern.matcher(head).find()){
			return false; // 一致しない
		}
		return true; // 問題なし
	}
	private void reportProblems() {
		IProblem VariableionProblem = getProblemById(ER_NAME_RULE_VARIABLE_ID, getFile());
		{
			String parameter = (String) getPreference(VariableionProblem, PARAM_PATTERN);
			Pattern pattern = Pattern.compile(parameter);
			List<String[]> varSequence = getSequence(VariableionProblem);
			List<IASTSimpleDeclaration> varDeclarators = new ArrayList<IASTSimpleDeclaration>();
			varDeclarators.addAll(this.variableDeclarations.values());
			for (IASTSimpleDeclaration declaration : varDeclarators) {
				for (IASTDeclarator declarator: declaration.getDeclarators()){
					IASTName astName = getAstName(declarator);
					if (astName != null) {
						String symbolName = new String(astName.getSimpleID());
						String description = getSpecifier(declaration.getDeclSpecifier());	// 宣言の仕様
						String prefix = getPrefix(varSequence, description); // 宣言によって導いた接頭語
						if(!this.isFilteredArg(symbolName, prefix, pattern, VariableionProblem)){
//							reportProblem( ER_NAME_RULE_VARIABLE_ID,
//									astName, new Object[] { symbolName, prefix,
//									description /*+ declarator.getFileLocation().getFileName()*/});
						}
					}
				}
			}
		}
		IProblem FunctionProblem = getProblemById(ER_NAME_RULE_FUNCTION_ID , getFile());
		{
			String parameter = (String) getPreference(FunctionProblem, PARAM_PATTERN);
			Pattern pattern = Pattern.compile(parameter);
			String IgnoringParameter = (String) getPreference(FunctionProblem, IGNORING_PATTERN);
			Pattern IgnoringPattern = Pattern.compile(IgnoringParameter);
			List<String[]> funcSequence = getSequence(FunctionProblem);
			List<IASTFunctionDefinition> funcDeclarators = new ArrayList<IASTFunctionDefinition>();
			funcDeclarators.addAll(this.functionDeclarations.values());
			for (IASTFunctionDefinition definition : funcDeclarators) {
				IASTName astName = getAstName(definition.getDeclarator());
				if (astName != null) {
					String symbolName = new String(astName.getSimpleID());
					String description = getSpecifier(definition.getDeclSpecifier());
					String prefix = getPrefix(funcSequence, description);
					if(!IgnoringPattern.matcher(symbolName).find() // 除外パターン？
							&& !this.isFilteredArg(symbolName, prefix, pattern, FunctionProblem)){
//						reportProblem(ER_NAME_RULE_FUNCTION_ID,
//								astName, new Object[] { symbolName, prefix, description });
					}
				}
			}
		}
	}



}