/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.OkeSoftChip;
import CarnageHack.OkeSoftChipPanel;
import CarnageHack.OkeSoftPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class OkeSoftPanelMouseEvent
extends MouseAdapter {
    OkeSoftPanel panel;
    OkeSoftChipPanel chippanel;
    boolean dragmode;
    boolean copymode;
    int sx;
    int sy;

    OkeSoftPanelMouseEvent(OkeSoftPanel p, OkeSoftChipPanel p2) {
        this.panel = p;
        this.chippanel = p2;
        this.dragmode = false;
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if ((e.getModifiers() & 0x10) != 0) {
            if (e.isControlDown()) {
                this.panel.delete_chip(x, y);
            } else if (e.isAltDown()) {
                OkeSoftChip chip = this.panel.get_chip(x, y);
                if (chip != null && !chip.get_id().equals("NONE")) {
                    this.panel.set_mouse_image(this.chippanel.get_chip(chip.get_id()));
                    this.dragmode = true;
                    this.copymode = true;
                    this.sx = x;
                    this.sy = y;
                }
            } else if (e.isShiftDown()) {
                OkeSoftChip chip = this.panel.get_chip(x, y);
                if (chip != null && !chip.get_id().equals("NONE")) {
                    this.panel.set_mouse_image(this.chippanel.get_chip(chip.get_id()));
                    this.dragmode = true;
                    this.copymode = false;
                    this.sx = x;
                    this.sy = y;
                }
            } else {
                String chipid = OkeSoftChipPanel.getLastActiveChip();
                OkeSoftChip chip = this.panel.get_chip(x, y);
                if (chipid != null && chipid.length() > 0 && (chip == null || chip.get_id().length() == 0 || chip.get_id().equals("NONE"))) {
                    this.panel.plot_chip(x, y, chipid);
                    this.panel.set_mouse_image(null);
                    this.panel.resetChipPanel();
                    this.panel.repaint();
                } else {
                    this.panel.edit_chip(x, y);
                }
            }
        } else if ((e.getModifiers() & 0xC) != 0) {
            if (e.isShiftDown()) {
                OkeSoftChip chip = this.panel.get_chip(x, y);
                if (chip != null && !chip.get_id().equals("NONE")) {
                    this.panel.set_mouse_image(this.chippanel.get_chip(chip.get_id()));
                    this.dragmode = true;
                    this.copymode = true;
                    this.sx = x;
                    this.sy = y;
                }
            } else {
                this.panel.edit_chip(x, y);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.dragmode) {
            this.panel.set_mouse_image(null);
            this.panel.resetChipPanel();
            this.dragmode = false;
            if (this.sx != x || this.sy != y) {
                if (this.copymode) {
                    this.panel.copy_chip(this.sx, this.sy, x, y);
                } else {
                    this.panel.move_chip(this.sx, this.sy, x, y);
                }
            }
            this.panel.repaint();
        }
    }
}

