/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHArrayList;
import CarnageHack.CHutil;
import CarnageHack.CarnageHack;
import CarnageHack.OkeHardArmor;
import CarnageHack.OkeHardCpu;
import CarnageHack.OkeHardData;
import CarnageHack.OkeHardEngine;
import CarnageHack.OkeHardFilter;
import CarnageHack.OkeHardFuelTank;
import CarnageHack.OkeHardInputFieldEvent;
import CarnageHack.OkeHardOption;
import CarnageHack.OkeHardPanelChoiceEvent;
import CarnageHack.OkeHardPanelChoiceReflect;
import CarnageHack.OkeHardPanelInputEvent;
import CarnageHack.OkeHardPanelInputReflect;
import CarnageHack.OkeHardWeapon;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public final class OkeHardPanel
extends Panel
implements ActionListener,
OkeHardPanelChoiceReflect,
OkeHardPanelInputReflect {
    private CHArrayList main_weapon_list;
    private CHArrayList sub_weapon_list;
    private CHArrayList cpu_list;
    private CHArrayList engine_list;
    private CHArrayList armor_list;
    private CHArrayList fueltank_list;
    private CHArrayList option_list;
    private final OkeHardData hardware;
    private int main_bullette_max;
    private int sub_bullette_max;
    private int cpu_stock;
    private int engine_stock;
    private int armor_stock;
    private int fueltank_stock;
    private int option_stock;
    private final Label main_weapon_status;
    private final Label sub_weapon_status;
    private final Label cpu_status;
    private final Label engine_status;
    private final Label armor_status;
    private final Label fueltank_status;
    private final Label option_status;
    private final Label total_weight;
    private final Button load_button;
    private final Button save_button;
    private static String datadir;
    private static final long serialVersionUID = 10L;

    OkeHardPanel(OkeHardData hd) {
        this.load_parts();
        this.hardware = hd == null ? new OkeHardData() : hd;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(layout);
        gbc.fill = 1;
        gbc.ipadx = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        Label label = new Label(CarnageHack.resource.getString("hardwareMAIN_WEAPON"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        Choice choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "MAINWEAPON"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.main_weapon_list);
        this.main_bullette_max = this.hardware.get_main_bullette();
        gbc.gridwidth = 0;
        gbc.anchor = 10;
        gbc.weightx = 0.0;
        this.main_weapon_status = new Label();
        layout.setConstraints(this.main_weapon_status, gbc);
        this.add(this.main_weapon_status);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        label = new Label(CarnageHack.resource.getString("hardwareBULLETTE"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        TextField text = new TextField(Integer.toString(this.main_bullette_max), 5);
        text.addActionListener(new OkeHardPanelInputEvent(this, "MAINBULLETTE"));
        text.addFocusListener(new OkeHardInputFieldEvent(this, true));
        layout.setConstraints(text, gbc);
        this.add(text);
        this.select_combo(choice, this.hardware.get_mainweapon().get_name());
        this.action("MAINWEAPON", this.hardware.get_mainweapon().get_name());
        this.update_weapon_status(true);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        label = new Label(CarnageHack.resource.getString("hardwareSUB_WEAPON"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "SUBWEAPON"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.sub_weapon_list);
        this.sub_bullette_max = this.hardware.get_sub_bullette();
        gbc.gridwidth = 0;
        gbc.anchor = 10;
        gbc.weightx = 0.0;
        this.sub_weapon_status = new Label();
        layout.setConstraints(this.sub_weapon_status, gbc);
        this.add(this.sub_weapon_status);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        label = new Label(CarnageHack.resource.getString("hardwareBULLETTE"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        text = new TextField(Integer.toString(this.sub_bullette_max), 5);
        text.addActionListener(new OkeHardPanelInputEvent(this, "SUBBULLETTE"));
        text.addFocusListener(new OkeHardInputFieldEvent(this, false));
        layout.setConstraints(text, gbc);
        this.add(text);
        this.select_combo(choice, this.hardware.get_subweapon().get_name());
        this.action("SUBWEAPON", this.hardware.get_subweapon().get_name());
        this.update_weapon_status(false);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        label = new Label(CarnageHack.resource.getString("hardwareCPU"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "CPU"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.cpu_list);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        this.cpu_status = new Label();
        layout.setConstraints(this.cpu_status, gbc);
        this.add(this.cpu_status);
        this.select_combo(choice, this.hardware.get_cpu().get_name());
        this.action("CPU", this.hardware.get_cpu().get_name());
        this.update_cpu_status();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        label = new Label(CarnageHack.resource.getString("hardwareENGINE"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "ENGINE"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.engine_list);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        this.engine_status = new Label();
        layout.setConstraints(this.engine_status, gbc);
        this.add(this.engine_status);
        this.select_combo(choice, this.hardware.get_engine().get_name());
        this.action("ENGINE", this.hardware.get_engine().get_name());
        this.update_engine_status();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        label = new Label(CarnageHack.resource.getString("hardwareARMOR"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "ARMOR"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.armor_list);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        this.armor_status = new Label();
        layout.setConstraints(this.armor_status, gbc);
        this.add(this.armor_status);
        this.select_combo(choice, this.hardware.get_armor().get_name());
        this.action("ARMOR", this.hardware.get_armor().get_name());
        this.update_armor_status();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        label = new Label(CarnageHack.resource.getString("hardwareFUELTANK"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "FUELTANK"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.fueltank_list);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        this.fueltank_status = new Label();
        layout.setConstraints(this.fueltank_status, gbc);
        this.add(this.fueltank_status);
        this.select_combo(choice, this.hardware.get_fueltank().get_name());
        this.action("FUELTANK", this.hardware.get_fueltank().get_name());
        this.update_fueltank_status();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        label = new Label(CarnageHack.resource.getString("hardwareOPTION"));
        layout.setConstraints(label, gbc);
        this.add(label);
        gbc.anchor = 17;
        choice = new Choice();
        choice.addItemListener(new OkeHardPanelChoiceEvent(this, "OPTION"));
        layout.setConstraints(choice, gbc);
        this.add(choice);
        this.set_combo(choice, this.option_list);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        this.option_status = new Label();
        layout.setConstraints(this.option_status, gbc);
        this.add(this.option_status);
        this.select_combo(choice, this.hardware.get_option().get_name());
        this.action("OPTION", this.hardware.get_option().get_name());
        this.update_option_status();
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        Panel dummy = new Panel();
        layout.setConstraints(dummy, gbc);
        this.add(dummy);
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        this.load_button = new Button(CarnageHack.resource.getString("hardwareLOAD"));
        this.load_button.setActionCommand("LOAD");
        this.load_button.addActionListener(this);
        layout.setConstraints(this.load_button, gbc);
        this.add(this.load_button);
        this.save_button = new Button(CarnageHack.resource.getString("hardwareSAVE"));
        this.save_button.setActionCommand("SAVE");
        this.save_button.addActionListener(this);
        layout.setConstraints(this.save_button, gbc);
        this.add(this.save_button);
        this.total_weight = new Label();
        layout.setConstraints(this.total_weight, gbc);
        this.add(this.total_weight);
        this.update_total_weight();
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        dummy = new Panel();
        layout.setConstraints(dummy, gbc);
        this.add(dummy);
        dummy = new Panel();
        layout.setConstraints(dummy, gbc);
        this.add(dummy);
    }

    void update_weapon_status(boolean bmain) {
        Label label;
        int maxb;
        OkeHardWeapon w;
        if (bmain) {
            w = this.hardware.get_mainweapon();
            maxb = this.main_bullette_max;
            label = this.main_weapon_status;
        } else {
            w = this.hardware.get_subweapon();
            maxb = this.sub_bullette_max;
            label = this.sub_weapon_status;
        }
        String wk = CarnageHack.resource.getString("hardwareSTOCK") + Integer.toString(maxb) + " ";
        switch (w.get_type()) {
            case 0: {
                wk = wk + CarnageHack.resource.getString("hardwareASSAULT");
                break;
            }
            case 1: {
                wk = wk + CarnageHack.resource.getString("hardwareLASER");
                break;
            }
            case 2: {
                wk = wk + CarnageHack.resource.getString("hardwareSHOTGUN");
                break;
            }
            case 10: {
                wk = wk + CarnageHack.resource.getString("hardwareMISSILE");
                break;
            }
            case 11: {
                wk = wk + CarnageHack.resource.getString("hardwareROCKET");
                break;
            }
            default: {
                wk = wk + CarnageHack.resource.getString("hardwareUNKNOWN");
            }
        }
        wk = wk + CarnageHack.resource.getString("hardwareMAXRANGE") + w.get_max_range() + CarnageHack.resource.getString("hardwareHITRATE") + w.get_base_rate() + CarnageHack.resource.getString("hardwareFIREPOWER") + w.get_damage() + CarnageHack.resource.getString("hardwareWEIGHT") + w.get_weight();
        label.setText(wk);
    }

    void update_cpu_status() {
        OkeHardCpu p = this.hardware.get_cpu();
        this.cpu_status.setText(CarnageHack.resource.getString("hardwareSTOCK") + this.cpu_stock + CarnageHack.resource.getString("hardwareSPEED") + p.get_speed() + CarnageHack.resource.getString("hardwareWEIGHT") + p.get_weight());
    }

    void update_engine_status() {
        OkeHardEngine p = this.hardware.get_engine();
        this.engine_status.setText(CarnageHack.resource.getString("hardwareSTOCK") + this.engine_stock + CarnageHack.resource.getString("hardwareMAXWEIGHT") + p.get_max_weight() + CarnageHack.resource.getString("hardwareFULEPERSEC") + p.get_fuelpersec() + CarnageHack.resource.getString("hardwareWEIGHT") + p.get_weight());
    }

    void update_armor_status() {
        OkeHardArmor p = this.hardware.get_armor();
        this.armor_status.setText(CarnageHack.resource.getString("hardwareSTOCK") + this.armor_stock + CarnageHack.resource.getString("hardwareARMORRATE") + p.get_armor() + CarnageHack.resource.getString("hardwareWEIGHT") + p.get_weight());
    }

    void update_fueltank_status() {
        OkeHardFuelTank p = this.hardware.get_fueltank();
        this.fueltank_status.setText(CarnageHack.resource.getString("hardwareSTOCK") + this.fueltank_stock + CarnageHack.resource.getString("hardwareFUEL") + p.get_fuel() + CarnageHack.resource.getString("hardwareWEIGHT") + p.get_weight());
    }

    void update_option_status() {
        String[] option_type = new String[]{"NONE", "COOLER", "JAMMER", "REPAIR", "DESTRUCT"};
        OkeHardOption p = this.hardware.get_option();
        this.option_status.setText(CarnageHack.resource.getString("hardwareSTOCK") + this.option_stock + " " + option_type[p.get_type()] + CarnageHack.resource.getString("hardwareEFFECT") + p.get_effect() + CarnageHack.resource.getString("hardwareWEIGHT") + p.get_weight());
    }

    public void update_total_weight() {
        if (this.total_weight != null) {
            int ncurrent = this.hardware.get_total_weight();
            int nmaxweight = this.hardware.get_engine().get_max_weight();
            int nspeed = (int)(10.0 * ((double)ncurrent / (double)nmaxweight)) + 1;
            String wk = CarnageHack.resource.getString("hardwareTOTALWEIGHT") + ncurrent + "/" + nmaxweight;
            wk = wk + "(" + CarnageHack.resource.getString("hardwareMOBILTY") + nspeed + ")";
            this.total_weight.setText(wk);
        }
    }

    void select_combo(Choice choice, String name) {
        choice.select(name);
    }

    void set_combo(Choice choice, CHArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            String wk = (String)list.get(i);
            String[] field = CHutil.split(wk, ':', 2);
            wk = field[1];
            field = CHutil.split(wk, ',');
            choice.add(field[0]);
        }
    }

    String search_list(CHArrayList list, String s) {
        for (int i = 0; i < list.size(); ++i) {
            String wk = (String)list.get(i);
            String[] field = CHutil.split(wk, ':', 2);
            wk = field[1];
            if (!(field = CHutil.split(wk, ','))[0].equals(s)) continue;
            return (String)list.get(i);
        }
        return null;
    }

    private void load_parts() {
        this.main_weapon_list = new CHArrayList();
        this.sub_weapon_list = new CHArrayList();
        this.cpu_list = new CHArrayList();
        this.engine_list = new CHArrayList();
        this.armor_list = new CHArrayList();
        this.fueltank_list = new CHArrayList();
        this.option_list = new CHArrayList();
        this.main_weapon_list.add("200:" + CarnageHack.main_weapon_list.get(0));
        this.sub_weapon_list.add("20:" + CarnageHack.sub_weapon_list.get(0));
        this.cpu_list.add("1:" + CarnageHack.cpu_list.get(0));
        this.engine_list.add("1:" + CarnageHack.engine_list.get(0));
        this.armor_list.add("1:" + CarnageHack.armor_list.get(0));
        this.fueltank_list.add("1:" + CarnageHack.fueltank_list.get(0));
        this.option_list.add("1:" + CarnageHack.option_list.get(0));
        for (int i = 0; i < CarnageHack.parts.size(); ++i) {
            String[] field = CHutil.split((String)CarnageHack.parts.get(i), ':', 2);
            if (field[0].equals("M")) {
                this.main_weapon_list.add(field[1]);
                continue;
            }
            if (field[0].equals("S")) {
                this.sub_weapon_list.add(field[1]);
                continue;
            }
            if (field[0].equals("C")) {
                this.cpu_list.add(field[1]);
                continue;
            }
            if (field[0].equals("E")) {
                this.engine_list.add(field[1]);
                continue;
            }
            if (field[0].equals("A")) {
                this.armor_list.add(field[1]);
                continue;
            }
            if (field[0].equals("F")) {
                this.fueltank_list.add(field[1]);
                continue;
            }
            if (!field[0].equals("O")) continue;
            this.option_list.add(field[1]);
        }
    }

    public void action(String s, String item) {
        String wk;
        if (s.equals("MAINWEAPON")) {
            String wk2 = this.search_list(this.main_weapon_list, item);
            if (wk2 != null) {
                String[] field = CHutil.split(wk2, ':', 2);
                try {
                    this.main_bullette_max = Integer.parseInt(field[0]);
                }
                catch (NumberFormatException ex) {
                    this.main_bullette_max = 0;
                }
                this.hardware.get_mainweapon().load(field[1]);
                this.update_weapon_status(true);
            } else {
                this.main_bullette_max = 0;
            }
        } else if (s.equals("SUBWEAPON")) {
            String wk3 = this.search_list(this.sub_weapon_list, item);
            if (wk3 != null) {
                String[] field = CHutil.split(wk3, ':', 2);
                try {
                    this.sub_bullette_max = Integer.parseInt(field[0]);
                }
                catch (NumberFormatException ex) {
                    this.sub_bullette_max = 0;
                }
                this.hardware.get_subweapon().load(field[1]);
                this.update_weapon_status(false);
            } else {
                this.sub_bullette_max = 0;
            }
        } else if (s.equals("CPU")) {
            String wk4 = this.search_list(this.cpu_list, item);
            if (wk4 != null) {
                String[] field = CHutil.split(wk4, ':', 2);
                try {
                    this.cpu_stock = Integer.parseInt(field[0]);
                }
                catch (NumberFormatException ex) {
                    this.cpu_stock = 0;
                }
                this.hardware.get_cpu().load(field[1]);
                this.update_cpu_status();
            }
        } else if (s.equals("ENGINE")) {
            String wk5 = this.search_list(this.engine_list, item);
            if (wk5 != null) {
                String[] field = CHutil.split(wk5, ':', 2);
                try {
                    this.engine_stock = Integer.parseInt(field[0]);
                }
                catch (NumberFormatException ex) {
                    this.engine_stock = 0;
                }
                this.hardware.get_engine().load(field[1]);
                this.update_engine_status();
            }
        } else if (s.equals("ARMOR")) {
            String wk6 = this.search_list(this.armor_list, item);
            if (wk6 != null) {
                String[] field = CHutil.split(wk6, ':', 2);
                try {
                    this.armor_stock = Integer.parseInt(field[0]);
                }
                catch (NumberFormatException ex) {
                    this.armor_stock = 0;
                }
                this.hardware.get_armor().load(field[1]);
                this.update_armor_status();
            }
        } else if (s.equals("FUELTANK")) {
            String wk7 = this.search_list(this.fueltank_list, item);
            if (wk7 != null) {
                String[] field = CHutil.split(wk7, ':', 2);
                try {
                    this.fueltank_stock = Integer.parseInt(field[0]);
                }
                catch (NumberFormatException ex) {
                    this.fueltank_stock = 0;
                }
                this.hardware.get_fueltank().load(field[1]);
                this.update_fueltank_status();
            }
        } else if (s.equals("OPTION") && (wk = this.search_list(this.option_list, item)) != null) {
            String[] field = CHutil.split(wk, ':', 2);
            try {
                this.option_stock = Integer.parseInt(field[0]);
            }
            catch (NumberFormatException ex) {
                this.option_stock = 0;
            }
            this.hardware.get_option().load(field[1]);
            this.update_option_status();
        }
        this.update_total_weight();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    public void action(TextField text, String cmd) {
        if (cmd.equals("MAINBULLETTE")) {
            String wk = text.getText();
            if (wk != null) {
                int n;
                try {
                    n = Integer.parseInt(wk);
                }
                catch (NumberFormatException ex) {
                    n = 0;
                }
                if (n < 0 || n > this.main_bullette_max) {
                    n = 0;
                    text.setText(Integer.toString(n));
                }
                this.hardware.set_main_bullette(n);
            } else {
                this.hardware.set_main_bullette(0);
            }
        } else if (cmd.equals("SUBBULLETTE")) {
            String wk = text.getText();
            if (wk != null) {
                int n;
                try {
                    n = Integer.parseInt(wk);
                }
                catch (NumberFormatException ex) {
                    n = 0;
                }
                if (n < 0 || n > this.sub_bullette_max) {
                    n = 0;
                    text.setText(Integer.toString(n));
                }
                this.hardware.set_sub_bullette(n);
            } else {
                this.hardware.set_sub_bullette(0);
            }
        }
        this.update_total_weight();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("LOAD")) {
            this.load();
        } else if (cmd.equals("SAVE")) {
            this.save();
        }
    }

    public void save() {
        FileDialog fd = new FileDialog(CarnageHack.getFrame(), CarnageHack.resource.getString("titleSAVEHARDWARE"), 1);
        fd.setDirectory(datadir);
        fd.setFilenameFilter(new OkeHardFilter(true));
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname != null) {
            datadir = fd.getDirectory();
            this.hardware.save(datadir + fname);
        }
    }

    public void load() {
        FileDialog fd = new FileDialog(CarnageHack.getFrame(), CarnageHack.resource.getString("titleLOADHARDWARE"), 0);
        fd.setDirectory(datadir);
        fd.setFilenameFilter(new OkeHardFilter(true));
        fd.setVisible(true);
        String fname = fd.getFile();
        if (fname != null) {
            datadir = fd.getDirectory();
            this.hardware.load(datadir + fname);
            this.select_combo((Choice)this.getComponent(1), this.hardware.get_mainweapon().get_name());
            this.action("MAINWEAPON", this.hardware.get_mainweapon().get_name());
            ((TextField)this.getComponent(4)).setText(Integer.toString(this.hardware.get_main_bullette()));
            this.select_combo((Choice)this.getComponent(6), this.hardware.get_subweapon().get_name());
            this.action("SUBWEAPON", this.hardware.get_subweapon().get_name());
            ((TextField)this.getComponent(9)).setText(Integer.toString(this.hardware.get_sub_bullette()));
            this.select_combo((Choice)this.getComponent(11), this.hardware.get_cpu().get_name());
            this.action("CPU", this.hardware.get_cpu().get_name());
            this.select_combo((Choice)this.getComponent(14), this.hardware.get_engine().get_name());
            this.action("ENGINE", this.hardware.get_engine().get_name());
            this.select_combo((Choice)this.getComponent(17), this.hardware.get_armor().get_name());
            this.action("ARMOR", this.hardware.get_armor().get_name());
            this.select_combo((Choice)this.getComponent(20), this.hardware.get_fueltank().get_name());
            this.action("FUELTANK", this.hardware.get_fueltank().get_name());
            this.select_combo((Choice)this.getComponent(23), this.hardware.get_option().get_name());
            this.action("OPTION", this.hardware.get_option().get_name());
        }
    }

    public OkeHardData get_hardware() {
        return this.hardware;
    }

    public int get_main_bullette_max() {
        return this.main_bullette_max;
    }

    public int get_sub_bullette_max() {
        return this.sub_bullette_max;
    }

    public static void setDataDir(String s) {
        datadir = s;
    }

    public static String getDataDir() {
        return datadir;
    }
}

