/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHArrayList;
import CarnageHack.CHutil;
import CarnageHack.CarnageHack;
import CarnageHack.DungeonFloor;
import CarnageHack.OkeBullette;
import CarnageHack.OkeDungeon;
import CarnageHack.OkeHardData;
import CarnageHack.OkeHardWeapon;
import CarnageHack.OkeSoftChip;
import CarnageHack.OkeSoftData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class Oke {
    public static final int BACKPACKMAX = 26;
    public static final int STATUS_NORMAL = 0;
    public static final int STATUS_MOVE = 1;
    public static final int STATUS_TURN = 2;
    public static final int STATUS_GET = 3;
    public static final int STATUS_STAIRS = 4;
    public static final int STATUS_BEFOREFIRE = 5;
    public static final int STATUS_FIRENOW = 6;
    public static final int STATUS_ENDFIRE = 7;
    public static final int STATUS_FIGHT = 8;
    public static final int STATUS_PRONE = 9;
    public static final int STATUS_BEFOREJUMP = 10;
    public static final int STATUS_JUMPNOW = 11;
    public static final int STATUS_ENDJUMP = 12;
    public static final int STATUS_DAMAGED = 99;
    public static final int STATUS_DESTRUCT = 100;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_MOVE = 1;
    public static final int ACTION_TURN = 2;
    public static final int ACTION_FIRE = 3;
    public static final int ACTION_FIGHT = 4;
    public static final int ACTION_JUMP = 5;
    public static final int ACTION_PRONE = 6;
    public static final int ACTION_SELFDESTRUCT = 7;
    public static final int ACTION_GET = 8;
    public static final int ACTION_STAIRS = 9;
    public static final int DIRECTION_N = 0;
    public static final int DIRECTION_NE = 1;
    public static final int DIRECTION_E = 2;
    public static final int DIRECTION_SE = 3;
    public static final int DIRECTION_S = 4;
    public static final int DIRECTION_SW = 5;
    public static final int DIRECTION_W = 6;
    public static final int DIRECTION_NW = 7;
    public static final int DIRECTION_MAX = 7;
    public static final int MOVE_FORWARD = 0;
    public static final int MOVE_BACKWARD = 1;
    public static final int MOVE_RIGHT = 2;
    public static final int MOVE_LEFT = 3;
    public static final int IFF_ENEMY = 0;
    public static final int IFF_FRIEND = 1;
    public static final int OPTION_NO_USE = 0;
    public static final int OPTION_USE = 1;
    public static final int TURN_LEFT = 0;
    public static final int TURN_RIGHT = 1;
    public static final int DAMAGE_NONE = -1;
    public static final int DAMAGE_ASSALUT = 0;
    public static final int DAMAGE_LASER = 1;
    public static final int DAMAGE_SHOTGUN = 2;
    public static final int DAMAGE_MISSILE = 10;
    public static final int DAMAGE_ROCKET = 11;
    public static final int DAMAGE_FIGHT = 99;
    public static final int DAMAGE_HEAT = 100;
    public static final int DAMAGE_DESTRUCT = 101;
    public static final int[] move_degree = new int[]{0, 180, 90, -90};
    public static final int[][] move_deltax = new int[][]{{0, 0, 1, -1}, {1, -1, 1, -1}, {1, -1, 0, 0}, {1, -1, -1, 1}, {0, 0, -1, 1}, {-1, 1, -1, 1}, {-1, 1, 0, 0}, {-1, 1, 1, -1}};
    public static final int[][] move_deltay = new int[][]{{-1, 1, 0, 0}, {-1, 1, 1, -1}, {0, 0, 1, -1}, {1, -1, 1, -1}, {1, -1, 0, 0}, {1, -1, -1, 1}, {0, 0, -1, 1}, {-1, 1, -1, 1}};
    OkeSoftData software;
    OkeSoftData software1;
    OkeSoftData software2;
    int current_software;
    OkeHardData hardware;
    int floor;
    int x;
    int y;
    int deg;
    int turn_rate;
    int max_hp;
    int hp;
    int[] bullette = new int[2];
    int fuel;
    int tempture;
    CHArrayList backpack;
    int status;
    int action;
    int action_param;
    Oke action_target;
    long deltax;
    long deltay;
    long subx;
    long suby;
    int ntimer;
    int chipx;
    int chipy;
    int speed_count;
    int speed;
    Oke target;
    int param;
    int iff;
    int[] counter = new int[6];
    int total_weight;
    int max_weight;
    int option_status;
    boolean dead;
    int dead_timer;
    Oke lastattacker;
    int lastdamage;
    int destroycount;
    ArrayList<ChipTrace> traceList;

    Oke(int f, int n, OkeHardData h, OkeSoftData s, OkeSoftData s2) {
        this.hp = this.max_hp = n;
        this.iff = f;
        this.dead = false;
        this.dead_timer = 0;
        this.software1 = s;
        this.software2 = s2;
        this.software = this.software1;
        this.current_software = 1;
        this.hardware = h;
        this.bullette[0] = this.hardware.get_main_bullette();
        this.bullette[1] = this.hardware.get_sub_bullette();
        this.status = 0;
        this.action = 0;
        this.option_status = 0;
        this.lastdamage = -1;
        this.destroycount = 0;
        this.chipx = 0;
        this.chipy = 0;
        this.turn_rate = 1;
        this.speed_count = 0;
        this.tempture = 0;
        this.recalc_speed();
        this.backpack = new CHArrayList();
        this.fuel = this.hardware.get_fueltank().get_fuel();
        this.traceList = new ArrayList();
    }

    Oke(BufferedReader r) {
        this.software1 = new OkeSoftData();
        this.software2 = new OkeSoftData();
        this.software = this.software1;
        this.hardware = new OkeHardData();
        this.backpack = new CHArrayList();
        try {
            String wk = r.readLine();
            String[] field = CHutil.split(wk, ',');
            this.x = Integer.parseInt(field[0]);
            this.y = Integer.parseInt(field[1]);
            this.floor = Integer.parseInt(field[2]);
            this.deg = Integer.parseInt(field[3]) * 45;
            this.iff = Integer.parseInt(field[4]);
            this.hp = Integer.parseInt(field[5]);
            this.max_hp = Integer.parseInt(field[6]);
            this.fuel = Integer.parseInt(field[7]);
            this.bullette[0] = Integer.parseInt(field[8]);
            this.bullette[1] = Integer.parseInt(field[9]);
            int nmax = Integer.parseInt(field[10]);
            this.hardware.load(r);
            this.software1.load(r);
            this.software2.load(r);
            for (int i = 0; i < nmax; ++i) {
                wk = r.readLine();
                this.backpack.add(wk);
            }
        }
        catch (IOException e) {
            System.out.println("fail load OKE");
            System.out.println(e.toString());
        }
        catch (NumberFormatException e) {
            System.out.println("fail load OKE");
            System.out.println(e.toString());
        }
        this.dead = false;
        this.dead_timer = 0;
        this.status = 0;
        this.action = 0;
        this.option_status = 0;
        this.chipx = 0;
        this.chipy = 0;
        this.turn_rate = 1;
        this.speed_count = 0;
        this.tempture = 0;
        this.recalc_speed();
        this.traceList = new ArrayList();
    }

    public void reborn(int f) {
        this.iff = f;
        this.hp = this.max_hp;
        this.fuel = this.hardware.get_fueltank().get_fuel();
    }

    private void recalc_speed() {
        this.total_weight = this.hardware.get_total_weight(this.bullette[0], this.bullette[1]);
        this.max_weight = this.hardware.get_engine().get_max_weight();
        double r = (double)this.total_weight / (double)this.max_weight;
        this.speed = (int)(10.0 * r) + 1;
    }

    public void exec(OkeDungeon dungeon) {
        int nspeed = this.hardware.get_cpu().get_speed();
        if (this.hp == 0 || this.software == null) {
            return;
        }
        this.traceList.clear();
        for (int i = 0; i < nspeed; ++i) {
            int narrow;
            OkeSoftChip chip = this.software.get(this.chipx, this.chipy);
            ChipTrace tr = new ChipTrace(this.chipx, this.chipy, false);
            if (chip == null || chip.nullchip()) {
                this.traceList.add(tr);
                if (this.chipx == 0 && this.chipy == 0) {
                    this.action = 7;
                    return;
                }
                this.chipx = 0;
                this.chipy = 0;
                continue;
            }
            if (!chip.exec(dungeon, this)) {
                narrow = chip.get_green_arrow();
                tr.set_branch(false);
            } else {
                narrow = chip.get_red_arrow();
                tr.set_branch(true);
            }
            this.traceList.add(tr);
            if (this.chipx == -1 && this.chipy == -1) {
                this.chipx = 0;
                this.chipy = 0;
                continue;
            }
            if (narrow == 0) {
                this.action = 7;
                return;
            }
            this.chipx += OkeSoftChip.deltax_table[narrow];
            this.chipy += OkeSoftChip.deltay_table[narrow];
        }
        if (this.option_status == 1) {
            switch (this.hardware.get_option().get_type()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.fuel > 0) {
                        --this.fuel;
                        break;
                    }
                    this.option_status = 0;
                    break;
                }
                case 3: {
                    this.add_tempture(this.hardware.get_option().get_effect() / 10);
                    this.add_hp(this.hardware.get_option().get_effect());
                    break;
                }
                case 4: {
                    this.action = 7;
                }
            }
        }
    }

    public void doaction(OkeDungeon dungeon) {
        if (this.action == 7) {
            this.status = 100;
            return;
        }
        if (this.hp == 0) {
            return;
        }
        if (this.fuel > 0) {
            switch (this.action) {
                case 0: {
                    if (this.status != 1 && this.status != 2) break;
                    this.status = 0;
                    break;
                }
                case 1: {
                    if (this.status != 0 && this.status != 1 && this.status != 2) break;
                    this.status = 1;
                    this.param = this.action_param;
                    break;
                }
                case 2: {
                    if (this.status != 0 && this.status != 1 && this.status != 2) break;
                    this.status = 2;
                    this.param = this.action_param;
                    break;
                }
                case 3: {
                    if (this.status != 0 && this.status != 1 && this.status != 12 && this.status != 3) break;
                    this.status = 5;
                    this.ntimer = 3;
                    this.action = 0;
                    this.target = this.action_target;
                    this.param = this.action_param;
                    break;
                }
                case 4: {
                    if (this.status != 0 && this.status != 1 && this.status != 2 && this.status != 3 && this.status != 7 && this.status != 12) break;
                    this.status = 8;
                    this.ntimer = 10;
                    this.action = 0;
                    break;
                }
                case 5: {
                    if (this.status >= 10) break;
                    this.status = 10;
                    this.ntimer = 2;
                    this.action = 0;
                    this.param = this.action_param;
                    break;
                }
                case 6: {
                    if (this.status >= 9) break;
                    this.status = 9;
                    this.action = 0;
                    this.ntimer = 10;
                    break;
                }
                case 8: {
                    if (this.status != 0 && this.status != 1 && this.status != 2) break;
                    this.status = 3;
                    this.ntimer = 20;
                    this.action = 0;
                    break;
                }
                case 9: {
                    if (this.status != 0 && this.status != 1 && this.status != 2) break;
                    this.status = 4;
                    this.ntimer = 20;
                    this.action = 0;
                }
            }
        } else if (this.action == 3 && (this.status == 0 || this.status == 1 || this.status == 12 || this.status == 3)) {
            this.status = 5;
            this.ntimer = 3;
            this.action = 0;
            this.target = this.action_target;
            this.param = this.action_param;
        }
    }

    void get_item_task(OkeDungeon dungeon, int dx, int dy) {
        DungeonFloor df = dungeon.get_floor(this.floor);
        if (dungeon.is_hige(dx, dy, this.floor)) {
            dungeon.get_hige();
        } else if (df.isitem(dx, dy)) {
            String[] field;
            String wk;
            int i;
            CHArrayList itemlist = df.delitem(dx, dy);
            for (i = 0; i < itemlist.size(); ++i) {
                wk = (String)itemlist.get(i);
                field = CHutil.split(wk, ':', 3);
                System.out.print(this);
                System.out.println(" = found item [" + wk + "]");
                if (field[0].equals("+")) {
                    int nr = CarnageHack.dice100();
                    if (nr < 5) {
                        this.bullette[0] = this.hardware.get_main_bullette();
                        this.bullette[1] = this.hardware.get_sub_bullette();
                        this.hp = this.max_hp;
                        this.fuel = this.hardware.get_fueltank().get_fuel();
                    } else if (nr < 45) {
                        this.hp += this.max_hp / 2;
                        if (this.hp > this.max_hp) {
                            this.hp = this.max_hp;
                        }
                    } else if (nr < 65) {
                        this.bullette[0] = this.hardware.get_main_bullette();
                    } else if (nr < 75) {
                        this.bullette[1] = this.hardware.get_sub_bullette();
                    } else if (nr < 90) {
                        this.fuel = this.hardware.get_fueltank().get_fuel();
                    } else {
                        this.hp = this.max_hp;
                    }
                } else if (!this.add_backpack(field[0], field[2], Integer.parseInt(field[1]))) break;
                itemlist.remove(i);
                --i;
            }
            for (i = 0; i < itemlist.size(); ++i) {
                wk = (String)itemlist.get(i);
                field = CHutil.split(wk, ':', 3);
                df.additem(dx, dy, field[0], field[2], Integer.parseInt(field[1]));
            }
            this.status = 0;
        }
    }

    boolean updown_stairs_task(OkeDungeon dungeon) {
        DungeonFloor df = dungeon.get_floor(this.floor);
        if (df.get_up_stairsx() == this.x && df.get_up_stairsy() == this.y) {
            if (this.iff == 1) {
                dungeon.prev_floor();
            } else if (this.floor > 0) {
                --this.floor;
                df = dungeon.get_floor(this.floor);
                this.x = df.get_down_stairsx();
                this.y = df.get_down_stairsy();
            }
            this.action = 0;
            this.status = 0;
            return true;
        }
        if (df.get_down_stairsx() == this.x && df.get_down_stairsy() == this.y) {
            if (this.iff == 1) {
                dungeon.next_floor();
            } else {
                df = dungeon.get_floor(this.floor + 1);
                if (df != null) {
                    this.x = df.get_up_stairsx();
                    this.y = df.get_up_stairsy();
                    ++this.floor;
                }
            }
            this.action = 0;
            this.status = 0;
            return true;
        }
        return false;
    }

    public void movement(OkeDungeon dungeon) {
        block44: {
            if (this.hp == 0) {
                if (!this.dead) {
                    if (this.dead_timer > 0) {
                        --this.dead_timer;
                    } else {
                        this.dead = true;
                    }
                }
                return;
            }
            switch (this.status) {
                case 0: 
                case 2: {
                    this.deltax = 0L;
                    this.deltay = 0L;
                    break;
                }
                case 1: {
                    this.deltax = CHutil.sin(this.deg + move_degree[this.param]);
                    this.deltay = -CHutil.cos(this.deg + move_degree[this.param]);
                    break;
                }
                case 5: {
                    this.deltax = 0L;
                    this.deltay = 0L;
                    if (this.ntimer > 0) {
                        --this.ntimer;
                    }
                    if (this.ntimer != 0) break;
                    this.status = 6;
                    this.ntimer = 10;
                    break;
                }
                case 6: {
                    if (this.ntimer > 0) {
                        --this.ntimer;
                    }
                    if (this.ntimer == 5) {
                        int nweapon = this.param & 1;
                        int ncount = this.param >> 1;
                        OkeHardWeapon w = nweapon == 0 ? this.hardware.get_mainweapon() : this.hardware.get_subweapon();
                        if (this.bullette[nweapon] > 0) {
                            int n = nweapon;
                            this.bullette[n] = this.bullette[n] - 1;
                            this.recalc_speed();
                            this.add_tempture(w.get_heat());
                            dungeon.addBullette(new OkeBullette(this, w, this.target));
                        }
                        if (ncount <= 0) break;
                        this.param = (--ncount << 1) + nweapon;
                        break;
                    }
                    if (this.ntimer != 0) break;
                    int ncount = this.param >> 1;
                    if (ncount > 0) {
                        this.ntimer = 6;
                        break;
                    }
                    this.status = 7;
                    this.ntimer = 10;
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    this.deltax = CHutil.sin(this.deg + move_degree[0]);
                    this.deltay = -CHutil.cos(this.deg + move_degree[0]);
                    if (this.ntimer > 0) {
                        --this.ntimer;
                    }
                    if (this.ntimer != 0) break;
                    this.status = 0;
                    break;
                }
                case 10: {
                    this.deltax = 0L;
                    this.deltay = 0L;
                    if (this.ntimer > 0) {
                        --this.ntimer;
                    }
                    if (this.ntimer != 0) break;
                    this.status = 11;
                    this.ntimer = 10;
                    break;
                }
                case 11: {
                    this.deltax = CHutil.sin(this.deg + move_degree[this.param]);
                    this.deltay = -CHutil.cos(this.deg + move_degree[this.param]);
                    if (this.ntimer > 0) {
                        --this.ntimer;
                    }
                    if (this.ntimer != 0) break;
                    this.ntimer = 10;
                    this.status = 12;
                    break;
                }
                case 7: 
                case 9: 
                case 12: 
                case 99: {
                    if (this.ntimer > 0) {
                        --this.ntimer;
                    }
                    if (this.ntimer != 0) break;
                    this.status = 0;
                    break;
                }
                case 100: {
                    this.hp = 0;
                    this.lastdamage = 101;
                    this.lastattacker = this;
                    this.dead_timer = 30;
                }
            }
            if (this.fuel == 0 && this.status != 99) {
                this.deltax = 0L;
                this.deltay = 0L;
                this.subx = 0L;
                this.suby = 0L;
            }
            this.speed_count = this.speed_count > 0 ? --this.speed_count : this.speed;
            if (this.status == 2) {
                if (this.param == 0) {
                    this.deg -= this.turn_rate;
                    if (this.deg < 0) {
                        this.deg += 360;
                    }
                } else {
                    this.deg += this.turn_rate;
                    if (this.deg >= 360) {
                        this.deg -= 360;
                    }
                }
            }
            if (this.speed_count != this.speed) break block44;
            this.option_status = 0;
            if (this.status == 3) {
                int dx = this.x + move_deltax[this.get_direction()][0];
                int dy = this.y + move_deltay[this.get_direction()][0];
                this.get_item_task(dungeon, dx, dy);
                if (this.status == 3) {
                    this.get_item_task(dungeon, this.x, this.y);
                }
            }
            if (this.deltax != 0L || this.deltay != 0L) {
                boolean ismove = false;
                int move_count = 1;
                if (this.status == 11 || this.status == 99) {
                    // empty if block
                }
                while (true) {
                    int n = ++move_count;
                    --move_count;
                    if (n <= 0) break block44;
                    int org_x = this.x++;
                    int org_y = this.y;
                    this.subx += this.deltax;
                    this.suby += this.deltay;
                    if (this.subx >= 10000L) {
                        this.subx -= 10000L;
                        ismove = true;
                    } else if (this.subx <= -10000L) {
                        this.subx += 10000L;
                        --this.x;
                        ismove = true;
                    }
                    if (this.suby >= 10000L) {
                        this.suby -= 10000L;
                        ++this.y;
                        ismove = true;
                    } else if (this.suby <= -10000L) {
                        this.suby += 10000L;
                        --this.y;
                        ismove = true;
                    }
                    if (!ismove) continue;
                    if (dungeon.get_floor(this.floor).iswall(this.x, this.y)) {
                        this.x = org_x;
                        this.y = org_y;
                        continue;
                    }
                    this.target = dungeon.collision_oke(this);
                    if (this.target != null) {
                        this.x = org_x;
                        this.y = org_y;
                        this.subx = 0L;
                        this.suby = 0L;
                        if (this.status != 8) break block44;
                        int firepower = 100 - this.hardware.get_armor().get_armor();
                        if (firepower <= 0) {
                            firepower = 1;
                        }
                        this.target.dec_hp(firepower *= 10, this, 99);
                        break block44;
                    }
                    if (this.status == 4 && this.updown_stairs_task(dungeon)) break;
                }
                this.deltax = 0L;
                this.deltay = 0L;
                this.subx = 0L;
                this.suby = 0L;
            }
        }
    }

    public void use_option() {
        this.option_status = 1;
    }

    public int get_option_status() {
        return this.option_status;
    }

    public int get_status() {
        return this.status;
    }

    public void set_status(int n) {
        this.status = n;
    }

    public int get_action() {
        return this.action;
    }

    public void set_action(int n) {
        this.action = n;
        this.action_param = 0;
    }

    public void set_action(int n, int m) {
        this.action = n;
        this.action_param = m;
    }

    public void set_target(Oke p) {
        this.action_target = p;
    }

    public int get_bullette(int n) {
        return this.bullette[n];
    }

    public void set_bullette(int n, int m) {
        this.bullette[n] = m;
    }

    public int get_hp() {
        return this.hp;
    }

    public int get_max_hp() {
        return this.max_hp;
    }

    public void add_hp(int n) {
        this.hp += n;
        if (this.hp > this.max_hp) {
            this.hp = this.max_hp;
        }
    }

    public void dec_hp(int n, Oke p, int reason) {
        n -= n * this.hardware.get_armor().get_armor() / 100;
        if (this.status == 9) {
            n /= 2;
        }
        if (n < 0) {
            n = 1;
        }
        this.hp -= n;
        if (this.hp < 0) {
            this.hp = 0;
            this.dead_timer = 30;
        }
        this.lastattacker = p;
        this.lastdamage = reason;
        this.status = 99;
        this.ntimer = n / 50 + 1;
        this.deltax = CHutil.sin(this.deg + 180);
        this.deltay = -CHutil.cos(this.deg + 180);
    }

    public int get_fuel() {
        return this.fuel;
    }

    public void dec_fuel() {
        this.fuel -= this.hardware.get_engine().get_fuelpersec();
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    public int get_tempture() {
        return this.tempture;
    }

    public void add_tempture(int n) {
        this.tempture += n;
        if (this.tempture > 1000) {
            this.tempture = 1000;
        }
    }

    public void cool_tempture() {
        int m;
        if (this.tempture == 0) {
            return;
        }
        int n = 10;
        if (this.option_status == 1 && this.hardware.get_option().get_type() == 1 && (m = this.hardware.get_option().get_effect()) > 0) {
            n += n * m / 100;
        }
        if ((m = this.hardware.get_armor().get_armor()) > 0) {
            n -= m / 5;
        }
        if (n < 1) {
            n = 1;
        }
        this.tempture -= n;
        if (this.tempture < 0) {
            this.tempture = 0;
        }
        if (this.tempture > 80) {
            this.hp -= this.tempture - 80;
            this.lastattacker = this;
            this.lastdamage = 100;
            if (this.hp < 0) {
                this.hp = 0;
                this.dead_timer = 30;
            }
        }
    }

    public int get_floor() {
        return this.floor;
    }

    public void set_floor(int n) {
        this.floor = n;
    }

    public int get_x() {
        return this.x;
    }

    public void set_x(int n) {
        this.x = n;
    }

    public int get_y() {
        return this.y;
    }

    public void set_y(int n) {
        this.y = n;
    }

    public int get_direction() {
        return this.deg / 45;
    }

    public int get_degree() {
        return this.deg;
    }

    public void set_direction(int n) {
        this.deg = n * 45;
    }

    public void set_degree(int n) {
        this.deg = n;
        while (this.deg < 0 || this.deg >= 360) {
            if (this.deg < 0) {
                this.deg = 360;
                continue;
            }
            if (this.deg < 360) continue;
            this.deg -= 360;
        }
    }

    public int get_iff() {
        return this.iff;
    }

    public int get_reason() {
        return this.lastdamage;
    }

    public Oke get_attacker() {
        return this.lastattacker;
    }

    public void inc_destroycount() {
        ++this.destroycount;
    }

    public int get_destroycount() {
        return this.destroycount;
    }

    public boolean isdead() {
        return this.dead;
    }

    public int get_backpack_count() {
        return this.backpack.size();
    }

    public boolean add_backpack(String t, String name, int count) {
        for (int i = 0; i < this.backpack.size(); ++i) {
            String[] field = CHutil.split((String)this.backpack.get(i), ':', 3);
            if (!field[2].equals(name)) continue;
            int n = Integer.parseInt(field[1]);
            this.backpack.set(i, field[0] + ":" + (n += count) + ":" + field[2]);
            return true;
        }
        if (this.backpack.size() < 26) {
            this.backpack.add(t + ":" + count + ":" + name);
            return true;
        }
        return false;
    }

    public boolean remove_backpack(int n, int count) {
        String wk = this.get_backpack(n);
        if (wk != null) {
            String[] field = CHutil.split(wk, ':', 3);
            int nwk = Integer.parseInt(field[1]);
            nwk = count == -1 ? 0 : (nwk -= count);
            if (nwk < 0) {
                return false;
            }
            if (nwk == 0) {
                this.backpack.remove(n);
            } else {
                this.backpack.set(n, field[0] + ":" + nwk + ":" + field[2]);
            }
            return true;
        }
        return false;
    }

    public String get_backpack(int n) {
        if (n < this.backpack.size()) {
            return (String)this.backpack.get(n);
        }
        return null;
    }

    public boolean collision(int tx, int ty, int tfloor) {
        return this.floor == tfloor && this.x == tx && this.y == ty;
    }

    public int get_counter(String s) {
        String wk = "ABCDEF";
        int n = wk.indexOf(s.charAt(0));
        if (n != -1) {
            return this.counter[n];
        }
        return 0;
    }

    public void set_counter(String s, int value) {
        String wk = "ABCDEF";
        int n = wk.indexOf(s.charAt(0));
        if (n != -1) {
            this.counter[n] = value;
        }
    }

    public int get_speed() {
        return this.speed;
    }

    public int get_total_weight() {
        return this.total_weight;
    }

    public int get_max_weight() {
        return this.max_weight;
    }

    OkeHardData get_hardware() {
        return this.hardware;
    }

    OkeSoftData get_software() {
        return this.software;
    }

    public boolean save(PrintWriter w) {
        try {
            System.out.print("save ");
            System.out.println(this);
            int nmax = this.backpack.size();
            String wk = this.x + "," + this.y + "," + this.floor + "," + this.get_direction() + "," + this.iff + "," + this.hp + "," + this.max_hp + "," + this.fuel + "," + this.bullette[0] + "," + this.bullette[1] + "," + nmax;
            w.println(wk);
            System.out.println(wk);
            System.out.println("save hardware");
            this.hardware.save(w);
            System.out.println("save software1");
            if (this.software1 != null) {
                this.software1.save(w);
            } else {
                w.println("7,7");
                w.println("=END=");
            }
            System.out.println("save software2");
            if (this.software2 != null) {
                this.software2.save(w);
            } else {
                w.println("7,7");
                w.println("=END=");
            }
            System.out.println("save backpack");
            for (int i = 0; i < nmax; ++i) {
                wk = (String)this.backpack.get(i);
                w.println(wk);
            }
            System.out.println("success");
            return true;
        }
        catch (Exception e) {
            System.out.println("fail save OKE");
            return false;
        }
    }

    public void change_software() {
        this.chipx = -1;
        this.chipy = -1;
        if (this.current_software == 1) {
            this.software = null;
            this.software = this.software2;
            this.current_software = 2;
        } else {
            this.software = null;
            this.software = this.software1;
            this.current_software = 1;
        }
    }

    public int get_current_software() {
        return this.current_software;
    }

    public int get_status_param() {
        return this.param;
    }

    public int get_chipx() {
        return this.chipx;
    }

    public int get_chipy() {
        return this.chipy;
    }

    public ChipTrace[] get_trace() {
        ChipTrace[] dummy = new ChipTrace[1];
        ChipTrace[] ret = this.traceList.toArray(dummy);
        return ret;
    }

    public class ChipTrace
    implements Cloneable {
        int chipx;
        int chipy;
        boolean bbranch;

        ChipTrace() {
            this.chipx = -1;
            this.chipy = -1;
            this.bbranch = false;
        }

        ChipTrace(int x, int y, boolean b) {
            this.chipx = x;
            this.chipy = y;
            this.bbranch = b;
        }

        public String toString() {
            StringBuilder retstr = new StringBuilder();
            retstr.append(this.chipx);
            retstr.append(',');
            retstr.append(this.chipy);
            retstr.append(',');
            retstr.append(this.bbranch ? "RED" : "GREEN");
            return retstr.toString();
        }

        protected Object clone() throws CloneNotSupportedException {
            ChipTrace s = (ChipTrace)super.clone();
            s.chipx = this.chipx;
            s.chipy = this.chipy;
            s.bbranch = this.bbranch;
            return s;
        }

        public void set_position(int x, int y) {
            this.chipx = x;
            this.chipy = y;
        }

        public int get_position_x() {
            return this.chipx;
        }

        public int get_position_y() {
            return this.chipy;
        }

        public void set_branch(boolean b) {
            this.bbranch = b;
        }

        public boolean get_branch() {
            return this.bbranch;
        }
    }
}

