/***********************************************************************/
/*                                                                     */
/*  FILE        :mtu3Start.c                                           */
/*  DATE        :Thu, Jul 06, 2015                                     */
/*  DESCRIPTION :MTU3 Driver                                           */
/*  CPU TYPE    :RX63N                                                 */
/*                                                                     */
// PC7 ɏo͂܂.
// pulsWidth == 825 
//           == 1125 S
//			 == 1350 E
/***********************************************************************/

#include "iodefine.h"

void mtu3_init(void)
{
    /* PC7MTIOC3Aɐݒ */
    MPC.PWPR.BIT.B0WI = 0;      // s@\I
    MPC.PWPR.BIT.PFSWE = 1;     // @veNg
    MPC.PC7PFS.BIT.PSEL = 0x01; // PC7MTIOC3Aɐ
    MPC.PWPR.BIT.PFSWE = 0;     // s@\I
    MPC.PWPR.BIT.B0WI = 1;      // @veNgݒ
    PORTC.PMR.BIT.B7 = 1;       // PC7͎Ӌ@\ƂĎgp

    SYSTEM.PRCR.WORD = 0xA502;  // veNg
    MSTP(MTU) = 0;              // MTU (MTU0`MTU5)̃Xgbvԉ
    SYSTEM.PRCR.WORD = 0xA500;  // veNgݒ
    
    /* MTU3TCNT~ */
    MTU.TSTR.BIT.CST3 = 0;

    /* TCNTNA */
    MTU3.TCNT = 0x0000;

    /* JE^NbNƃJE^NAv̐ݒ */
    // GR-SAKURAł́AOUq 12MHz, 
    // PLLCR.STC=16(16{), PLLCR.PLIDIV=0(1), SCKCR.PCKB=2(4)
    // AMTUPCLK 12*16/4 = 48MHz
//    MTU3.TCR.BIT.TPSC = 0;  // JE^NbN: PCLK/1 = 48MHz
    MTU3.TCR.BIT.TPSC = 3;  // JE^NbN: PCLK/64 = 750Khz
    MTU3.TCR.BIT.CKEG = 0;  // オGbWŃJEg
    MTU3.TCR.BIT.CCLR = 1;  // TGRÃRyA}b`TCNTNA

    /* PWM[h1 */
    MTU3.TMDR.BYTE = 0x02;
    
    /* g`o̓x̑I */
    MTU3.TIORH.BIT.IOA = 1; // Ԃ0o RyA}b`0o
    MTU3.TIORH.BIT.IOB = 2; // f[eBRyA}b`1o

    /* ƃf[eB[̐ݒ */
    						// GRA 20msɂ
    						// 20ms ́@50Hz   750KHz / 50 = 15000
    MTU3.TGRA = 15000;      
}
void mtu3_Start(int pulsWidth)
{
    			          // f[eB[  1100us ɂ
						  //  750KHz / (100000/1100)  = 825 
						  //  750KHz / (100000/1400)  = 1050
						  //  750KHz / (100000/1500)  = 1125
						  //  750KHz / (100000/1800)  = 1350
						
	MTU3.TGRB = (15000-pulsWidth);    
    /* MTU3TCNTJn */
    MTU.TSTR.BIT.CST3 = 1;
}
void mtu3_Stop(void)
{
    /* MTU3TCNT~ */
    MTU.TSTR.BIT.CST3 = 0;
}

