/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 *  Copyright (C) 2008-2010 by Witz Corporation, JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

/*
 *  J[l̃^[Qbgˑ`iFRK-RX62Npj
 */

/*
 *  ̃CN[ht@ĆCkernel.hŃCN[hD̃t@
 *  C璼ڃCN[h邱Ƃ͂ȂD̃t@CCN[h
 *  OɁCt_stddef.hCN[ĥŁCɈˑĂ
 *  D
 */

#ifdef TOPPERS_KERNEL_IMPL_H

#ifndef TOPPERS_TARGET_KERNEL_H
#define TOPPERS_TARGET_KERNEL_H


#if defined __GNUC__
#endif

/*
 *  vZbTŋʂȒ`
 */
//#include "rx_rxc/prc_kernel.h"

/*
 *  ItO, IPL擾邽߂̃}N`
 */
#define PSW_I_MASK		( 0x00010000UL )
#define PSW_IPL_MASK	( 0x07000000UL )

/*
 *  T|[g@\̒`
 */
#define	TOPPERS_TARGET_SUPPORT_GET_UTM		/* get_utmT|[g */


/*
 *  ^CeBbN̒`
 */
#define	TIC_NUME		( 1U )		/* ^CeBbN̎̕q */
#define	TIC_DENO		( 1U )		/* ^CeBbN̎̕ */




/*
 *  NMIׂĂ݂̊̋֎~
 */
#if defined __GNUC__
static inline void disint( void )
{
	__asm__("clrpsw	i");
}
#else
#pragma inline_asm	disint
static void
disint( void )
{
	clrpsw	i
}
#endif

/*
 *  NMIׂĂ݂̊̋
 */
#if defined __GNUC__
static inline void enaint( void )
{
	__asm__("setpsw	i");
}
#else
#pragma inline_asm	enaint
static void
enaint( void )
{
	setpsw	i
}
#endif
/*
 *  CPUbNԂւ̈ڍs
 *
 *  IPMin[hEFÅݗDx}XNjCsaved_iipmɕۑCJ[
 *  lǗÔׂ̂Ă̊ݗv}XNliTIPM_LOCKj
 *  ɐݒ肷D܂Clock_flagTRUEɂD
 *
 *  IPMCŏTIPM_LOCKƓ荂ꍇɂ́C
 *  saved_iipmɕۑ݂̂ŁCTIPM_LOCKɂ͐ݒ肵ȂD́Cf
 *  ̊ݗDx}XNCTIPM_LOCKƓ荂xɐݒ
 *  ĂԂɂD
 *
 *  ̊֐́CCPUbNԁilock_flagTRUȄԁjŌĂ΂邱Ƃ
 *  Ȃ̂Ƒz肵ĂD
 */
#if defined __GNUC__
static inline
#else
#pragma inline  (x_lock_cpu)
static 
#endif
void x_lock_cpu( void ) 
{	
	disint();
}

#define t_lock_cpu()	x_lock_cpu()
#define i_lock_cpu()	x_lock_cpu()


/*
 *  CPUbNԂ̉
 *
 *  lock_flagFALSEɂCIPMin[hEFÅݗDx}XNjC
 *  saved_iipmɕۑlɖ߂D
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjł̂݌Ă΂
 *  ̂Ƒz肵ĂD
 */
#if defined __GNUC__
static inline
#else
#pragma inline (x_unlock_cpu)
static 
#endif
void x_unlock_cpu( void )
{
	enaint();
}

#define t_unlock_cpu()	x_unlock_cpu()
#define i_unlock_cpu()	x_unlock_cpu()

/*
 *  ftHg̔^XNReLXgp̃X^bN̈̒`
 *
 *  X^bNTCYύXꍇ, sectrx.inc_DEFAULT_ISTACK
 *  ẍʒuɂ.blkb߂̃TCY, ȉDEFAULT_ISTKSZ
 *  TCY킹ēlɕύX邱.
 */
extern uint32_t	DEFAULT_ISTACK[];
#define DEFAULT_ISTKSZ		( 0x500U )
#define DEFAULT_ISTK		( (void *)&DEFAULT_ISTACK[0] )

#if defined __GNUC__
static inline
#else
#pragma inline (idle_loop)
static  
#endif
void idle_loop(void)
{
	t_unlock_cpu();
	t_lock_cpu();
}


/*
 *  vZbTXe[^XWX^(PSW)̌ݒl̓Ǐo
 */
#if defined __GNUC__
#else
#pragma inline_asm	current_psw
static uint32_t
current_psw( void )
{
	mvfc	psw, r1
}
#endif
/*
 *  CPUbNԂ̎Q
 */
#if defined __GNUC__
static inline
#else
#pragma inline (x_sense_lock)
static  
#endif
bool_t
x_sense_lock( void )
{
	return (( bool_t )(( current_psw() & PSW_I_MASK) == 0 ));
}

#define t_sense_lock()	x_sense_lock()
#define i_sense_lock()	x_sense_lock()


/*
 *  ReLXg̎Q
 *
 *  RXł́C݂̖߂悪^XNǂ𔻒f邽߂ intnest
 *  gpĂDpăReLXg𔻒fD
 */
#if defined __GNUC__
static inline
#else
#pragma inline (sense_context) 
static 
#endif
bool_t sense_context( void )
{
	/*  lXgJE^0Ȃ^XNReLXg  */
	return ( intnest > 0U );
}



#endif /* TOPPERS_TARGET_KERNEL_H */
#endif