package com.sample;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Set;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

// http://www.javainthebox.net/laboratory/J2SE1.5/MonitoringAndManagement/JMX/JMX2.html
// http://www.02.246.ne.jp/~torutk/javahow2/commandline.html
public class Main {
	private int port = 6712;
	private String sp = "\t";
	
	public static void main(String[] args) {
		Main m = new Main();
		m.display();
	}
	
	private void display(){
		try {
			JMXConnector jmxc = JMXConnectorFactory.connect(new JMXServiceURL(
					"service:jmx:rmi:///jndi/rmi://:" + port + "/jmxrmi"));
			MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();

			// IuWFNǧ
			ObjectName objname = new ObjectName("*:*");
			Set<ObjectName> objnames = mbsc.queryNames(objname, null);

			for (final Iterator i = objnames.iterator(); i.hasNext();) {
				ObjectName name = (ObjectName) i.next();
				showMBeanInfo(mbsc, name);
			}
		} catch (MalformedObjectNameException e) {
			e.printStackTrace();
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private void showMBeanInfo(MBeanServerConnection mbsc, ObjectName name) {
		try {
			MBeanInfo info = mbsc.getMBeanInfo(name);
//			String description = info.getDescription();
//			System.out.println("Description: " + description);

			showMBeanAttributeInfo(name, info);
			// showMBeanConstructorInfo(info);
			// showMBeanOperationInfo(info);
			// showMBeanNotificationInfo(info);

		} catch (ReflectionException ex) {
			ex.printStackTrace();
		} catch (InstanceNotFoundException ex) {
			ex.printStackTrace();
		} catch (IOException ex) {
			ex.printStackTrace();
		} catch (javax.management.IntrospectionException e) {
			e.printStackTrace();
		}
	}

	private void showMBeanAttributeInfo(ObjectName name, MBeanInfo info) {
//		System.out.println(name);
//		String description = info.getDescription();
//		System.out.println("Description: " + description);

		MBeanAttributeInfo[] attributes = info.getAttributes();

		if (attributes.length > 0) {
//			System.out.println("Attributes:");
			for (MBeanAttributeInfo attribute : attributes) {
				print(name.toString(), false);
//				String description = info.getDescription();
//				System.out.println("Description: " + description);

				print(attribute.getName(), false);
				print(attribute.getDescription(), false);
				print(attribute.getType(), false);
				if (attribute.isReadable()) {
					if (attribute.isWritable()) {
						print("RW", true);
					} else {
						print("RO", true);
					}
				} else {
					if (attribute.isWritable()) {
						print("WO", true);
					}
					else {
						print("", true);						
					}
				}
			}
		}
	}
	
	private void print(String val, boolean isLast){
		System.out.print(val);
		if (isLast){
			System.out.println("");
		}
		else {
			System.out.print(sp);			
		}
			
	}
}
