/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.Main;
import chexaformation.MatchDataPanel;
import chexaformation.TeamListPanel;
import chexaformation.TeamPanel;
import chexaformation.cheFile;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class mainForm
extends JFrame {
    private JButton editMatchData;
    private TeamListPanel mainPanel;
    private JButton makeMatchData;
    private JButton openTeam;

    public mainForm() {
        this.initComponents();
    }

    public TeamListPanel get_teamlist() {
        return this.mainPanel;
    }

    private void initComponents() {
        this.openTeam = new JButton();
        this.makeMatchData = new JButton();
        this.editMatchData = new JButton();
        this.mainPanel = new TeamListPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("CHEXA Team formation Version 2.0");
        this.setCursor(new Cursor(0));
        this.openTeam.setFont(new Font("Monospaced", 0, 12));
        ResourceBundle bundle = ResourceBundle.getBundle("chexaformation/resource");
        this.openTeam.setText(bundle.getString("makeTeam"));
        this.openTeam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainForm.this.openTeamActionPerformed(evt);
            }
        });
        this.makeMatchData.setFont(new Font("Monospaced", 0, 12));
        this.makeMatchData.setText(bundle.getString("makeMatchData"));
        this.makeMatchData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainForm.this.makeMatchDataActionPerformed(evt);
            }
        });
        this.editMatchData.setFont(new Font("Monospaced", 0, 12));
        this.editMatchData.setText(bundle.getString("editMatchData"));
        this.editMatchData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                mainForm.this.editMatchDataActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.openTeam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.makeMatchData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editMatchData).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.mainPanel, -1, 416, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openTeam).addComponent(this.makeMatchData).addComponent(this.editMatchData)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainPanel, -1, 398, Short.MAX_VALUE)));
        this.pack();
    }

    private void openTeamActionPerformed(ActionEvent evt) {
        JDialog dlg = new JDialog(this, ResourceBundle.getBundle("chexaformation/resource").getString("titleTeamWindow"), false);
        dlg.add(new TeamPanel());
        dlg.pack();
        Point pos = this.getLocation();
        pos.x += this.getWidth();
        dlg.setLocation(pos);
        dlg.setVisible(true);
    }

    private void makeMatchDataActionPerformed(ActionEvent evt) {
        byte[] matchdata = new byte[336];
        cheFile che = null;
        try {
            InputStream ifs = this.getClass().getResourceAsStream("match.bin");
            if (ifs.read(matchdata) == matchdata.length) {
                che = new cheFile(matchdata);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(mainForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (che != null) {
            JDialog dlg = new JDialog(this, ResourceBundle.getBundle("chexaformation/resource").getString("titleMatchWindow"), false);
            che.set_match_name("\u30de\u30c3\u30c1\u30c7\u30fc\u30bf");
            MatchDataPanel panel = new MatchDataPanel(che);
            dlg.add(panel);
            dlg.pack();
            Point pos = this.getLocation();
            pos.x += this.getWidth();
            dlg.setLocation(pos);
            panel.update_title();
            dlg.setVisible(true);
        }
    }

    private void editMatchDataActionPerformed(ActionEvent evt) {
        JFileChooser fdlg = new JFileChooser(Main.cheMatchDataDir);
        String filterTitle = ResourceBundle.getBundle("chexaformation/resource").getString("filterTitleCHE");
        FileNameExtensionFilter ffilter = new FileNameExtensionFilter(filterTitle, "CHE");
        fdlg.setFileFilter(ffilter);
        int nret = fdlg.showOpenDialog(this.getRootPane().getParent());
        if (nret == 0) {
            File ifile = fdlg.getSelectedFile();
            cheFile che = new cheFile(ifile.getAbsolutePath());
            Main.cheMatchDataDir = ifile.getParent();
            if (che.load()) {
                if (!che.is_teamfile()) {
                    JDialog dlg = new JDialog(this, ResourceBundle.getBundle("chexaformation/resource").getString("titleMatchWindow"), false);
                    MatchDataPanel panel = new MatchDataPanel(che);
                    dlg.add(panel);
                    dlg.pack();
                    Point pos = this.getLocation();
                    pos.x += this.getWidth();
                    dlg.setLocation(pos);
                    panel.update_title();
                    dlg.setVisible(true);
                } else {
                    Main.mesg_box(this, ResourceBundle.getBundle("chexaformation/resource").getString("loadCHE"), ResourceBundle.getBundle("chexaformation/resource").getString("errNotMatchData"), ifile.getAbsolutePath());
                }
            } else {
                Main.mesg_box(this, ResourceBundle.getBundle("chexaformation/resource").getString("loadCHE"), ResourceBundle.getBundle("chexaformation/resource").getString("faileReadCHE"), ifile.getAbsolutePath());
            }
        }
    }
}

